/* Written by Dave Stampe, December 1993 */

/* Contains user render routines which, in combination
// with colormap.c and the video driver, allow you to
// customize the renderer for almost any hardware

// reset_screen() added for VR-386 release. 9/1/94 by Dave Stampe

/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/


#include <stdio.h>
#include <dos.h>
#include <stdlib.h>

#include "f3dkitd.h"

#include "vr_api.h"
#include "pcdevice.h"	// register_render_start,end


struct Screeninfo *screeninfo;  // ptr to data in video driver


WORD current_video_page = 0;     // current video page
WORD current_orientation = 0;    // flip flags of current page


	// these set system colors
WORD screen_clear_color = 0;
WORD sky_color = 3;
WORD ground_color = 5;
WORD highlight_color = 15;

	// call before world file is loaded to set defaults

void preset_default_colors()
{
  if (screeninfo->colors==256)  // 256 color std palette
    {
      screen_clear_color = 3;  // std palette
      sky_color = 3;           // defaults
      ground_color = 0x88;
      highlight_color = 15;
    }
  else                      // monochrome std palette
    {
      screen_clear_color = 10;
      sky_color = 10;
      ground_color = 5;
      highlight_color = 15;
    }

  set_skycolor(sky_color);	 // simple horizon on/off
  set_groundcolor(ground_color);
}


/********************************************************/
/* USER ROUTINES CALLED BY THE RENDERING LIBRARY        */
/* KEEP THIS AS FAST AS POSSIBLE: SOME MAY BE           */
/* CALLED UP TO 1000 TIMES PER SCREEN!                  */
/********************************************************/


/* USER ROUTINE TO SETUP FOR POLY DRAWING - CALLED ONCE PER FRAME */
void user_setup_blitter()
{
	setup_hdwe(0);
}

/* USER ROUTINE TO RECOVER AFTER POLY DRAWING: ONCE PER FRAME */

void user_reset_blitter()
{
	reset_hdwe();
}





static int x1, y1;	// used for outlining polys

static void vlineto(int x, int y, int color)
{
	vgaline(x,y,x1,y1,color);
	x1 = x;
	y1 = y;
}

/* CALLED FROM RENDERER TO DRAW POLYS, LINES, POINTS */
/* <color> was created by colormap.c: modify it to   */
/* do your own special color modes/effects!          */

void user_render_poly(WORD number, WORD *pcoords, SURFACE color, COORD maxz)
{
  int i;

  if(number > 20) return;	// sanity check

  if (number == 1)                           // dot
    {
      vgapoint(pcoords[0], pcoords[1], color);
      return;
    }

  if (number == 2)
    {
      vgaline(pcoords[0],pcoords[1],pcoords[2],pcoords[3],color);
      return;
    }

  switch (color & 0x3000)
    {
      case 0x0000: 	// normal polygon
      case 0x1000:
	  fastpoly(number, pcoords, color&0x0FFF);
	  break;
      case 0x2000:	// metallic polygon
	  m_fastpoly(number, pcoords, color&0x0FFF, 0xFF, 0x00);
	  break;
      case 0x3000:	// pseudo-glass polygon
	  m_fastpoly(number, pcoords, color&0x0FFF, 0xAA, 0xFF);
	  break;
    }

  if (color & 0x8000) 		// highlighted: outline poly
    {
      x1 = pcoords[0];
      y1 = pcoords[1];
      for (i = 1; i < number; ++i)
	   vlineto(pcoords[i+i], pcoords[i+i+1], highlight_color);
      vlineto(pcoords[0], pcoords[1], highlight_color);
    }
}



/////////////////////////////////////////////////////////////
////// THESE ROUTINES ARE CALLED BY USER INTERFACE ROUTINES
////// TO DRAW MENUS, TEXT, ETC ETC


	/* USER ROUTINE TO DRAW TEXT BOXES */
void user_box(int x1, int y1, int x2, int y2, int color)
{
  int av[8];

  setup_hdwe(0);

  if (x1 < screeninfo->xmin) x1 = screeninfo->xmin;   // clip
  if (x2 < screeninfo->xmin) x2 = screeninfo->xmin;
  if (y1 < screeninfo->ymin) y1 = screeninfo->ymin;
  if (y2 < screeninfo->ymin) y2 = screeninfo->ymin;
  if (x1 > screeninfo->xmax) x1 = screeninfo->xmax;
  if (x2 > screeninfo->xmax) x2 = screeninfo->xmax;
  if (y1 > screeninfo->ymax) y1 = screeninfo->ymax;
  if (y2 > screeninfo->ymax) y2 = screeninfo->ymax;

  av[0] = x1;     // copy to vertex array
  av[1] = y1;
  av[2] = x1;
  av[3] = y2;
  av[4] = x2;
  av[5] = y2;
  av[6] = x2;
  av[7] = y1;

  fastpoly(4, &av[0], color);   // draw filled poly

  reset_hdwe();
}


				// draws a line on the screen (current page)
void user_draw_line(int x1, int y1, int x2, int y2, int color)
{
  setup_hdwe(0);
  vgaline(x1, y1, x2, y2, color);
  reset_hdwe();
}



			// draws a box outline on the screen (current page)
void user_draw_box(int left, int top, int right, int bottom, int color)
{
  setup_hdwe(0);
  vgaline(left, top, right, top, color);
  vgaline(right, top, right, bottom, color);
  vgaline(right, bottom, left, bottom, color);
  vgaline(left, bottom, left, top, color);
  reset_hdwe();
}


		/* USER ROUTINE TO DRAW TEXT */
void user_text(WORD x, WORD y, WORD color, char *string)
{
  printxyr(x, y, color, string, current_orientation);
}


/////////////////////////////////////////////////////////////////
/// USER VIDEO MODE SUPPORT ROUTINES:
///
/// NEVER CHANGE MOST OF THESE UNLESS YOU NEED
/// MORE THAN THE VIDEO DRIVERS CAN DO


		 /* enter and setup graphics screen */
void enter_graphics(unsigned vdmode, int bw)
{
  int i;

  set_gmode(vdmode);
  set_vpage(0);
  set_drawpage(0);
  clr_page(0,0);

  screeninfo = screen_data();  // sets up screen data

  load_DAC_colors(NULL, screeninfo->colors, bw, 0);
}


void exit_graphics() /* exit and restore text screen */
{
  exit_gmode();
}


void clear_display(WORD pge)  // clear full video page
{
  if(pge<screeninfo->pages)
      clr_page(pge,screen_clear_color);
}


void reset_screens()  // clears all of video page(s)
{		      // use when areas outside viewports may change
  int i,j;
  BOOL was_visible = cursor_hide();
  j = current_video_page;

  for (i = 0; i < screeninfo->pages; ++i)
    {
      current_video_page = i;
      cursor_hide();
      clear_display(i);
      cursor_show();        // cursor background refresh
      cursor_hide();
    }
  current_video_page = j;
  if(was_visible) cursor_show();
}


void shadowprint(WORD x, WORD y, WORD color, char *t)
{
  int bk = (color>8) ? 0 : 15; 	// shadow color

  if(current_orientation & XFLIP)
    {
      user_text(x,y,bk,t);
      user_text(x-1,y+1,color,t);
    }
  else
    {
      user_text(x,y,bk,t);
      user_text(x+1,y+1,color,t);
    }
}



