
	TITLE	VDRINTE - Interface to BIN loadable video drivers.

	COMMENT	$


/*
 This code is part of the VR-386 project, created by Dave Stampe.
 VR-386 is a desendent of REND386, created by Dave Stampe and
 Bernie Roehl.  Almost all the code has been rewritten by Dave
 Stampre for VR-386.

 Copyright (c) 1994 by Dave Stampe:
 May be freely used to write software for release into the public domain
 or for educational use; all commercial endeavours MUST contact Dave Stampe
 (dstampe@psych.toronto.edu) for permission to incorporate any part of
 this software or source code into their products!  Usually there is no
 charge for under 50-100 items for low-cost or shareware products, and terms
 are reasonable.  Any royalties are used for development, so equipment is
 often acceptable payment.

 ATTRIBUTION:  If you use any part of this source code or the libraries
 in your projects, you must give attribution to VR-386 and Dave Stampe,
 and any other authors in your documentation, source code, and at startup
 of your program.  Let's keep the freeware ball rolling!

 DEVELOPMENT: VR-386 is a effort to develop the process started by
 REND386, improving programmer access by rewriting the code and supplying
 a standard API.  If you write improvements, add new functions rather
 than rewriting current functions.  This will make it possible to
 include you improved code in the next API release.  YOU can help advance
 VR-386.  Comments on the API are welcome.

 CONTACT: dstampe@psych.toronto.edu
*/

		$



		.MODEL large
		.CODE

		.386

public	_screen_data     ; the C callable stubs
public	_vsync
public	_setup_hdwe
public	_reset_hdwe
public	_clr_page
public	_copy_page
public	_copy_block
public	_clr_block
public	_fastpoly
public	_m_fastpoly
public	_set_gmode
public	_set_drawpage
public	_exit_gmode
public	_set_vpage
public	_clipline
public	_set_clip_rect
public	_printxyr
public	_erase_cursor
public	_draw_cursor
public	_vgaline
public	_vgapoint
public	_load_DAC_colors
public	_read_DAC_colors
public	_VGA_select
public	_read_video_line
public	_set_video_segment
public	_write_video_line
public	_vd_spare_4
public	_vd_spare_5
public	_vd_spare_6
public	_vd_spare_7
public	_vd_spare_8

_screen_data:
	mov	ax,18
	jmp	nonreentrant
_vsync:
	mov	ax,20
	jmp	reentrant
_setup_hdwe:
	mov	ax,22
	jmp	nonreentrant
_reset_hdwe:
	mov	ax,24
	jmp	nonreentrant
_clr_page:
	mov	ax,26
	jmp	nonreentrant
_copy_page:
	mov	ax,28
	jmp	nonreentrant
_clr_block:
	mov	ax,30
	jmp	nonreentrant
_copy_block:
	mov	ax,32
	jmp	nonreentrant
_fastpoly:
	mov	ax,34
	jmp	nonreentrant
_m_fastpoly:
	mov	ax,36
	jmp	nonreentrant
_set_gmode:
	mov	ax,38
	jmp	nonreentrant
_exit_gmode:
	mov	ax,40
	jmp	nonreentrant
_set_drawpage:
	mov	ax,42
	jmp	nonreentrant
_set_vpage:
	mov	ax,44
	jmp	reentrant
_vgaline:
	mov	ax,46
	jmp	nonreentrant
_vgapoint:
	mov	ax,48
	jmp	nonreentrant
_set_clip_rect:
	mov	ax,50
	jmp	nonreentrant
_clipline:
	mov	ax,52
	jmp	nonreentrant
_printxyr:
	mov	ax,54
	jmp	nonreentrant
_draw_cursor:
	mov	ax,56
	jmp	nonreentrant
_erase_cursor:
	mov	ax,58
	jmp	nonreentrant
_load_DAC_colors:
	mov	ax,60
	jmp	nonreentrant
_read_DAC_colors:
	mov	ax,62
	jmp	nonreentrant
_VGA_select:
	mov	ax,64
	jmp	reentrant
_read_video_line:
	mov	ax,66
	jmp	nonreentrant
_set_video_segment:
	mov	ax,68
	jmp	nonreentrant
_write_video_line:
	mov	ax,70
	jmp	nonreentrant
_vd_spare_4:
	mov	ax,72
	jmp	nonreentrant
_vd_spare_5:
	mov	ax,74
	jmp	nonreentrant
_vd_spare_6:
	mov	ax,76
	jmp	nonreentrant
_vd_spare_7:
	mov	ax,78
	jmp	nonreentrant
_vd_spare_8:
	mov	ax,80
	jmp	nonreentrant

extrn _v_driver_pointer

nonreentrant:
	push	bp
	push	ds
	mov	  bp,sp
	mov	  dx,ss                  ; save stack seg
	mov	  es,dx
	lds   bx,DWORD PTR _v_driver_pointer  ; get routine address
	push	ds                     ; new stack seg
	pop	  ss                     ; all int's disabled till next instr..
	mov	  sp,2000                ; stack internal to driver
	push	dx                     ; push old stack seg (bp=old stack ptr)
	push	DWORD PTR es:[bp+24]   ; up to 20 bytes of arguments
	push	DWORD PTR es:[bp+20]   ; copy adds 1 uS, but needed
	push	DWORD PTR es:[bp+16]   ; to keep ints from crashing
	push	DWORD PTR es:[bp+12]
	push	DWORD PTR es:[bp+8]
	push	cs                            ; push default return
	push	offset nrtnh
	push	ds
	add   bx,ax                           ; push as call address
	push	ds:[bx]
	retf                                ; "call"

nrtnh:
	add	sp,20
	pop	ss                              ; restore stack
	mov	sp,bp
	pop	ds
	pop	bp
	retf                                ; exit

reentrant:
	push	bp
	push	ds
	mov	bp,sp
	push	DWORD PTR ss:[bp+24]   ; up to 20 bytes of arguments
	push	DWORD PTR ss:[bp+20]   ; copy adds 1 uS, but needed
	push	DWORD PTR ss:[bp+16]   ; to keep ints from crashing
	push	DWORD PTR ss:[bp+12]
	push	DWORD PTR ss:[bp+8]
	push	cs                              ; push default return
	push	offset rtnh
	lds	bx,DWORD PTR _v_driver_pointer  ; get routine address
	push	ds
	add	bx,ax                           ; push as call address
	push	ds:[bx]
	retf                                    ; "call"

rtnh:	mov	sp,bp
	pop	ds
	pop	bp
	retf                                    ; exit


	end
