/* REND386 video driver main module */
/* this module: 320x200, 16 color mono*/
/* full screen driver */

/* Copyright 1993 by Dave Stampe */

// see FX3DKIT.C for better documentation



//*********** DEFINES FROM ASSEMBLY MODULES
extern void far load_color(int color);
extern void far xprintc(int c);
extern void far xrprintc(int c);

extern void far vsync();                /* pause till vert. retrace */

extern void far set_vmode(int mode);    /* set video mode */
extern void far set_vpage(int page);    /* set video page */

void far set_clip_rect(int l, int t, int r, int b);  /* only affects lines */

#define PUT 0		/* defines of VGA write modes */
#define AND 1           /* for use with setup_hdwe()  */
#define OR  2
#define XOR 3

extern void far setup_hdwe(int mode);  /* setup VGA for bunch of line */
				       /* or poly draws: once per set */

extern void far reset_hdwe();  /* reset VGA to BIOS state after drawing */

			 /* clear video page to solid color: 10 mS */
			 /* returns -1 if bad page #		 */
extern int far clr_page(int page, int color);

			/* copy one page to another for use as */
			/* background: 21 mS per call          */
			/* returns -1 if bad page #            */
extern int far copy_page(int source, int dest);

			/* fast VGA line draw: about 15600 24-pixel */
			/* vectors/sec (horizontal much faster)     */
extern void far vgaline(int x1, int y1, int x2, int y2, int color);

			/* does C-S clipping and draws line   */
extern void far clipline(int x1, int y1, int x2, int y2, int color);

void far set_gmode();              /* enters 320x200x16 mode, clears screen */
void far exit_gmode();             /* exits to text mode */

int far set_drawpage(int page);		/* set page for drawing on (0-7)   */

			 /* set displayed page: uses BIOS   */
			 /* call, so DON'T use in interrupt */
			 /* routines! If WAIT is 1, will    */
			 /* sync with vert. retrace (pause) */
int far set_vidpage(int page, int wait);

void far rest_8x8(int buffer, int address);
int  far save_8x8(int x, int y, int buffer);

			/* print text in foreground only-- */
			/* reversed = 1 for right-to-left  */
			/* with x now right side of text   */
void far printxyr(int x, int y, int color, char far *pstring, int reversed);

			/* draw "+" cursor on screen      */
			/* save s screen under cursor 	  */
void far draw_cursor(int x, int y, int color, int savebuff);

				 /* restores 8x8 area saved when   */
void far erase_cursor(int savebuff); /* cursor was drawn               */

			/* copy any byte-aligned rectangle  */
			/* this is evey 4 pixels for Y mode */
			/* but every 8 for 16-color mode    */
			/* x coords (left) are truncated to */
			/* left byte boundary: x size is    */
			/* bumped up to next full byte count */
extern int far copy_block(int spage, int sx, int sy,  /* source */
		      int dpage, int dx, int dy,  /* dest   */
		      int xs, int ys);            /* # lines, pixels */

			/* clear any byte-aligned block       */
			/* 15-30% slower than full page clear */
			/* left edge rounded down, right edge */
			/* rounded up to nearest byte boundary */
extern int far clear_block(int left, int top, int right, int bottom,
		       int page, int color);

unsigned int dpaddr = 0;        /* video write base */

unsigned long l_hold, r_hold;   /* used to hold old x data for edge */

int x1clipl, x2clipl, y1clipl, y2clipl;

int xcpline = 0;                  /* line 0 to 199     */
int xcpcol = 0;                   /* column 0 to 39 (char width) */

int l_clip = 0;     	  /* clipping rectangle for polys and lines */
int r_clip = 319;         /* max. 0,319,0,199			  */
int t_clip = 0;
int b_clip = 199;

struct Screeninfo {
	int xmin, ymin, xmax, ymax, xcent, ycent, colors, pages, bw;
	long aspect;
	char id[80];
	};

struct Screeninfo scrdat = {
		0, 0, 319, 200, 160, 100, 16, 8, 0,
		65536L/1.25,
		"REND386 320x200 16-color driver, by Dave Stampe"
						 };



/************* GRAPHICS MODE CONTROL SUPPORT **************/

struct Screeninfo far * far screen_data()
{
 return (struct Screeninfo far *)&scrdat;
}

void far set_gmode()		/* enters 320x200x256 mode, clears screen */
{                               /* may take arg in ext. VGA modes */
 set_vmode(0x0D);
}

void far exit_gmode()		/* exits to text mode */
{
 set_vmode(0x03);
}


extern int far set_drawpage(int page);      /* set page for drawing */


int far set_vidpage(int page, int wait)  /* set visible page, wait for vsync */
{
 if(page>=scrdat.pages) return(-1);
 set_vpage(page);
 if(wait) vsync();
}


/******************* LINE DRAWING SUPPORT ***************/

void far set_clip_rect(int l, int t, int r, int b)
{
 l_clip = l;
 r_clip = r;
 t_clip = t;
 b_clip = b;
}


void far clipline(int x1, int y1, int x2, int y2, int color)
{
 x1clipl = x1;
 x2clipl = x2;
 y1clipl = y1;
 y2clipl = y2;

 if (clipper()==-1) return;
 vgaline(x1, y1, x2, y2, color);
 return;
}


/********************* g-MODE TEXT PRINT SUPPORT ***************/

void fxprints(char far *pstring)
{
 int i,c;

 c = 1;
 i = 0;

 while(c != 0)
  {
   c = pstring[i];
   i++;
   switch (c)
    {
     case 0: break;

     case '\n' :
      {
       if(xcpline<192) xcpline++;
	xcpcol = 0;
       if(xcpline>192) xcpline = 192;
      }

     case '\r':
      {
       xcpcol = 0;
       break;
      }

     case '\t':
      {
       if((xcpcol&56)==0)
	{
	 fxprints("        ");
	}
       while((xcpcol&56)!=0)
	{
	 fxprints(" ");
	}
       break;
      }

     default:
      {
       xprintc(c);
       xcpcol+=8;
       if(xcpcol>312) fxprints("\n");
       break;
      }
    }
   if(xcpcol>312) fxprints("\n");
  }
}

/***************** MIRROR TEXT PRINT SUPPORT ***************/

void rxprints(char far *pstring)
{
 int i,c;

 c = 1;
 i = 0;

 while(c != 0)
  {
   c = pstring[i];
   i++;
   switch (c)
    {
     case 0: break;

     case '\n' :
      {
       if(xcpline<192) xcpline++;
	xcpcol = 319;
       if(xcpline>192) xcpline = 192;
      }

     case '\r':
      {
       xcpcol = 319;
       break;
      }

     case '\t':
      {
       if((xcpcol&56)==0)
	{
	 rxprints("        ");
	}
       while((xcpcol&56)!=0)
	{
	 rxprints(" ");
	}
       break;
      }

     default:
      {
       xrprintc(c);
       xcpcol-=8;
       if(xcpcol<7) rxprints("\n");
       break;
      }
    }
   if(xcpcol<7) rxprints("\n");
  }
}



void far printxyr(int x, int y, int color, char far *pstring, int reversed)
{
 setup_hdwe(0);
 xcpline = y;
 xcpcol = x;
 load_color(color);
 if(reversed) rxprints(pstring); else fxprints(pstring);
 reset_hdwe();
}


/*************** CURSOR STUFF ************/

int savadr[8];

void far draw_cursor(int x, int y, int color, int savebuff)
{
 int xx = x-3;
 int yy = y-3;

 if(xx<0)xx = 0;
 if(yy<0)yy = 0;

 setup_hdwe(0);
 savadr[savebuff] = save_8x8(xx,yy,savebuff);
 if(color<0)
  {
   vgaline(xx,yy,x+3,y+3,-color);
   vgaline(xx,y+3,x+3,yy,-color);
   color = 0;
  }
 vgaline(xx,y,x+3,y,color);
 vgaline(x,yy,x,y+3,color);
 reset_hdwe(0);
}


void far erase_cursor(int savebuff)
{
 setup_hdwe(0);
 rest_8x8(savebuff, savadr[savebuff]);
 reset_hdwe();
}


char default_palette[48] =
      {
	0, 4, 4,
	4, 7, 6,
	8, 10, 8,
	12, 13, 10,
	16, 16, 12,
	20, 19, 14,
	24, 22, 16,
	28, 25, 18,
	32, 28, 20,
	36, 31, 22,
	40, 34, 24,
	44, 37, 26,
	48, 40, 28,
	52, 43, 30,
	56, 46, 32,
	60, 49, 34
      };




void far load_DAC(char far *pal, int n, int first);
void far load_DAC_colors( char far *pal, int n, int bw, int first)
{
 int i;

 if(pal==0)
  {
   pal = &default_palette[0];
   first = 0;
   n = 16;
  }
 if(bw)
  {
   for(i=0;i<n;i++)
   pal[i+i+i] = pal[i+i+i+1] = pal[i+i+i+2] =
	   ((pal[i+i+i]*3)+(pal[i+i+i+1]*8)+(pal[i+i+i+2]*5))/16;
  }
 load_DAC(pal, n, first);
}


void far read_DAC(char far *pal, int n, int first);
void far read_DAC_colors( char far *pal, int n, int first)
{
 int i;

 if(n>scrdat.colors) n = scrdat.colors;
 read_DAC(pal, n, first);
}


VGA_select() {}  // STUB


extern void far get_line(char far *buff, int line, int count);

unsigned far read_video_line(char far *buff, int line)
{
  reset_hdwe();
  if(buff!=0)
	get_line(buff, line, scrdat.xmax-scrdat.xmin+1);
  reset_hdwe();
  return scrdat.xmax-scrdat.xmin+1;
}


extern void far put_line(char far *buff, int line, int count);

unsigned far write_video_line(char far *buff, int line)
{
  reset_hdwe();
  if(buff!=0)
	put_line(buff, line, scrdat.xmax-scrdat.xmin+1);
  reset_hdwe();
  return scrdat.xmax-scrdat.xmin+1;
}
