 ; includes for video drivers
 ; this is linked in the gsppt.asm file in the code seg
 ; this file: for 320x200 16-color driver

_vid_bypitch_	dw	40	; bytes per line
_vid_wdpitch_	dw	20	; words per line

_vid_pglines_	dw	200	; lines per page
_vid_pgbytes_ 	dw	8000	; bytes per page
_vid_pgwords_	dw	4000	; words per page

_vid_npages_	dw	8

_vid_pagetable_	dw	00000h	; offset of video pages
		dw      02000h
		dw	04000h
		dw	06000h
		dw	08000h
		dw	0A000h
		dw	0C000h
		dw	0E000h

_vid_curstable_	dw      01F80h	; cursor save areas
		dw	03F80h	; for 8x8 area (24 by)
		dw	05F80h
		dw	07F80h
		dw	09F80h
		dw	0BF80h
		dw	0DF80h
		dw	0FF80h

_vid_colortable_  dw	0FF00h	; color table : NOT USED FOR 16 COLOR

_vid_segment_   dw 0A000h	; so we can change in PM

_video_defined_ equ 1	; so we don't declare extrns

  public	_vid_bypitch_
  public	_vid_wdpitch_
  public	_vid_pglines_
  public	_vid_pgbytes_
  public	_vid_pgwords_
  public	_vid_npages_
  public	_vid_pagetable_
  public	_vid_curstable_
  public 	_vid_colortable_
  public 	_vid_segment_

include videfs.inc
