	TITLE   GSXSPPT - 640x200x256 mode support

	COMMENT $

		Written  by Dave Stampe
		Copyright (c) 1993
		Not for commercial use, so get permission
		before marketing code using this stuff!

		$

include vdmodel.inc	; sets memory model

		.DATA

dloffset        dw      0
vashift         dw      0

		.CODE vdriver
		.386


include vdefsvga.inc    ; defines constants, tables


  PUBLIC _vid_char_table_

_vid_char_table_        dd ?    ; is seen as chartable


extrn _setup_hdwe
extrn _reset_hdwe

 ;
 ; void _set_vmode(int mode)    /* enters video mode thru BIOS */
 ;                              /* mode: clear if MSB not 0    */
 ;                              /* mode 14h = X-mode           */

		PUBLIC  _set_vmode

_set_vmode      proc    far

	.386
	push    bp
	mov     bp,sp

	mov     ax,0013h       ; get small character table
	int     10h

	xor     bx,bx
	mov     es,bx
	mov     bx,43h*4
	mov     eax,es:[bx]
	mov     DWORD PTR chartable,eax

	mov     ax,WORD PTR [bp+6]  ; xxss xtbd mmmm mmmm
				    ; ss = bits to shift adr right
	cmp     al,3                ; b = mask bottom
	jnz     domode              ; d = drop down 40 lines
	mov     ah,0                ; t = switch to 400-line from 350-line
	int     10h                 ; m = mode
	pop     bp
	ret

domode: push    si
	push    di
	push    cx
	push    dx

	mov     dx,ax        ; unpack address divisor
	mov     si,dx
	shr     dx,12
	mov     WORD PTR vashift,dx

	mov     dx,0         ; compute shift-down offset (if any)
	test    ax,0100h
	jz      nodown
	mov     dx,41*160
	mov     cx,WORD PTR vashift
	shr     dx,cl
nodown:
	mov     WORD PTR dloffset,dx

	mov     ah,0            ; set 256-color mode
	int     10h

	mov     dx,03c4h        ; convert to X-mode addressing
	mov     ax,0604h        ; chain mode off
	out     dx,ax

	mov     dx,03d4h
	mov     ax,0014h        ; doubleword off
	out     dx,ax
	mov     ax,0E317h       ; byte mode on
	out     dx,ax

	test    si,0700h    ; any vertical reprogramming?
	jz      nochange
	mov     ax,0e11h    ; unlock CRTC
	out     dx,ax
	mov     di,0c712h

	test    si,0100h    ; offset display?
	jz      nodownl
	mov     ax,02816h   ; offset by 41 lines to get away from top of screen
	out     dx,ax
	mov     di,0f012h
nodownl:
	test    si,0200h    ; mask off bottom?
	jz      noclipb
	mov     ax,01d07h   ; set for 200 line display
	out     dx,ax
	mov     ax,di
	out     dx,ax
noclipb:
	test    si,0400h    ; in comb. with others, set 400 line mode
	jz      no400
	mov     ax,9c10h
	out     dx,ax
	mov     ax,9615h
	out     dx,ax

	mov     dx,03cch
	in      al,dx       ; read misc. register
	mov     dx,03c2h
	and     al,7Fh      ; set VS polartity for V scaling
	out     dx,al
	mov     dx,03c4h
no400:
	mov     ax,8e11h    ; relock CRTC
	out     dx,ax
nochange:
	call    far ptr _reset_hdwe

	mov     ax,WORD PTR[bp+6]
	test    al,080h
	jnz     dontclear

	mov     ax,0f02h
	out     dx,ax           ; clear all planes at once
	mov     ax,videoseg
	mov     es,ax
	xor     di,di
	mov     cx,0ffffh
	xor     ax,ax
	rep     stosb

	mov     di,0ff00h       ; setup latch color table
	mov     cx,100h
	xor     al,al
ctloop: stosb
	inc     al
	loop    ctloop


dontclear:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vmode      endp



 ;
 ; void _set_vpage(int page)    /* sets video page */
 ;

		PUBLIC  _set_vpage

_set_vpage      proc    far

	push    bp
	mov     bp,sp
	push    si
	push    di
	push    cx
	push    dx

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jae     badpage

	mov     bx,ax
	add     bx,bx
	mov     ax,pageoff[bx]

	mov     cx,WORD PTR vashift
	shr     ax,cl                   ; /2 for ATI cards
	sub     ax,WORD PTR dloffset    ; offset for vert. pos'n

	mov     bh,ah
	mov     ah,al           ; page # -> address
	mov     al,0dh
	mov     bl,0ch

	mov     dx,03d4h        ; set CRTC address
	out     dx,ax
	mov     ax,bx
	out     dx,ax
badpage:
	pop     dx
	pop     cx
	pop     di
	pop     si
	pop     bp
	ret

_set_vpage      endp


 ;
 ; void _set_drawpage(int page)    /* sets drawing page */
 ;

	extrn   _dpaddr         ; page base address
	PUBLIC  _set_drawpage

_set_drawpage   proc    far

	push    bp
	mov     bp,sp

	mov     al,BYTE PTR [bp+6]
	xor     ah,ah
	cmp     ax,npages               ; check page #
	jl      okpage
	mov     ax,-1
	pop     bp
	ret
okpage:
	mov     bx,ax
	add     bx,bx
	mov     bx,pageoff[bx]
	mov     _dpaddr,bx
	xor     ax,ax
	pop     bp
	ret

_set_drawpage   endp




		end



		end

