;*      VRSERVER.ASM
;*
;* Vertical Retrace Interrupt Server for Borland C and Pascal
;*
;* PUBLIC DOMAIN by Petteri Kangaslampi 1994
;*
;* Revisions:
;*      1.0     somewhere 1993  PK      First version
;*      1.1     23-Mar-1994     PK      Cleared up and partly rewritten
;*

IDEAL                                   ; IDEAL mode - Borland TASM only
MODEL   LARGE,C



FRAMETIME = 975                 ; Time between two interrupts is 97.5%
                                ; of total frame time - the interrupt comes
                                ; somewhat _before_ the Vertical Retrace
                                ; actually starts.





MACRO	WaitNextVR		; wait for NEXT Vertical Retrace
LOCAL	w1, w2

	mov	dx,03DAh
w1:     in      al,dx           ; wait for a non-retrace period
	test	al,8
	jnz	w1

w2:	in	al,dx
        test    al,8            ; wait for retrace
	jz	w2
ENDM





DATASEG



OldTmr	DD	?		; pointer to old timer interrupt
TmrVal	DW	?		; count to the timer chip
DOSTmrCnt DW    ?               ; counter used in calling the old timer

PreVRFunct DD	?		; pointer to the routine to be called
				;  BEFORE the Vertical Retrace
VRFunct	DD	?		; routine to be called IN the VR




CODESEG



PUBLIC	InitVRServer, SyncVRServer, RemoveVRServer



PROC NOLANGUAGE Timer           ; the actual timer routine

        sti                             ; enable interrupts

	push	ax
	push	bx
	push	cx
	push	dx
	push	si			; save normal 8086 registers
	push	di
	push	bp
	push	ds
	push	es

	mov	al,20h			; send End Of Interrupt signal
        out     20h,al                  ; to PIC

	mov	dx,@data		; point DS to proper data segment
	mov	ds,dx

	mov	dx,03DAh
@@wnvr: in      al,dx                   ; wait until we are _not_ in a
        test    al,8                    ; retrace (just to make sure...)
	jnz	@@wnvr

        call    [dword PreVRFunct]      ; call the Pre-VR function


        mov     bx,[TmrVal]             ; count for timer chip

	mov	dx,03DAh
@@wvr:  in      al,dx                   ; wait for the retrace
	test	al,8
	jz	@@wvr

        mov     al,30h                  ; counter mode 0 - interrupt on
        out     43h,al                  ; terminal count
	mov	al,bl
	out	40h,al			; set timer count and restart timer
	mov	al,bh
	out	40h,al


        call    [dword VRFunct]         ; call the VR function


	clc

	mov	ax,[TmrVal]
        add     [DOSTmrCnt],ax          ; add timer count to DOS timer count
        jnc     @@noDOSTmr              ; if carry set (count 65536), call
                                        ; DOS timer
	pushf
	call	[dword OldTmr]		; call old timer

@@noDOSTmr:
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si			; restore saved registers
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	iret
ENDP




PROC	InitVRServer	FAR	PPreVRFunct : DWORD, PVRFunct : DWORD

	push	ds

        mov     ax,3508h                ; save old interrupt 8 vector
	int	21h
        mov     [word OldTmr],bx
	mov	[word OldTmr+2],es

	mov	ax,seg Timer
	mov	ds,ax
        mov     dx,offset Timer         ; set new timer interrupt
	mov	ax,2508h
	int	21h

	pop	ds

	mov	ax,[word PPreVRFunct]
        mov     [word PreVRFunct],ax    ; set pointer to Pre-VR function
	mov	ax,[word PPreVRFunct+2]
	mov	[word PreVRFunct+2],ax

	mov	ax,[word PVRFunct]
        mov     [word VRFunct],ax       ; set pointer to VR function
	mov	ax,[word PVRFunct+2]
	mov	[word VRFunct+2],ax

        call    SyncVRServer C          ; synchronize timer to display refresh

	ret
ENDP




PROC	SyncVRServer	FAR

        cli                             ; disable interrupts for maximum
                                        ; accuracy
@@read:
	WaitNextVR			; wait for next Vertical Retrace

	mov	al,36h
	out	43h,al
        xor     al,al                   ; reset the timer
	out	40h,al
	out	40h,al


        WaitNextVR                      ; wait for next Vertical Retrace

	xor	al,al
	out	43h,al
	in	al,40h
	mov	ah,al
	in	al,40h			; read timer count - time between
        xchg    al,ah                   ; two Vertical Retraces
	neg	ax
	mov	[TmrVal],ax


        WaitNextVR                      ; wait for next Vertical Retrace

	mov	al,36h
	out	43h,al
	xor	al,al			; reset timer again
	out	40h,al
	out	40h,al


        WaitNextVR                      ; wait...

	xor	al,al
	out	43h,al
	in	al,40h
        mov     ah,al                   ; and read the timer count again
        in      al,40h
	xchg	al,ah
	neg	ax

	mov	dx,ax

	sub	dx,[TmrVal]
        cmp     dx,2                    ; If the difference between the two
        jg      @@read                  ; values read was >2, read again.
        cmp     dx,-2
	jl	@@read

        mov     bx,FRAMETIME            ; Time between two interrupts is
        mul     bx                      ; FRAMETIME/10 % of the total time
        mov     bx,1000                 ; between two Vertical Retraces.
	div	bx

	shr	ax,1
        mov     [TmrVal],ax             ; timer chip count

	mov	bx,[TmrVal]

        WaitNextVR                      ; wait for Vertical Retrace

        mov     al,30h                  ; counter mode 0 - interrupt on
        out     43h,al                  ; terminal count
        mov     al,bl                   ; Restart timer with the new speed
        out     40h,al                  ; right after the beginning of the
        mov     al,bh                   ; Retrace.
	out	40h,al

        mov     [DOSTmrCnt],0           ; count used in calling the old timer

        mov     al,20h                  ; send EOI signal to the PIC
	out	20h,al

	sti				; enable ints

	ret
ENDP



PROC	RemoveVRServer	FAR

        cli                             ; disable interrupts

        mov     al,36h                  ; DOS default timer mode
	out	43h,al
        xor     al,al                   ; set timer count to 65536 - 18.2Hz
        mov     al,0FFh                 ; (DOS default)
        out     40h,al
	out	40h,al

        push    ds
	mov	ax,2508h
	mov	dx,[word OldTmr]	; restore old timer int
	mov	ds,[word OldTmr+2]
	int	21h
        pop     ds

        mov     al,20h                  ; send EOI signal to PIC
	out	20h,al

        mov     al,36h                  ; DOS default timer mode
	out	43h,al
        xor     al,al                   ; set timer count to 65536 - 18.2Hz
        mov     al,0FFh                 ; (DOS default)
        out     40h,al
	out	40h,al

        sti                             ; enable interrupts

	ret
ENDP




END
