/*      VRSERVER.H
 *
 * Function definitions for VRServer
 *
 * PUBLIC DOMAIN by Petteri Kangaslampi 1994
*/

#ifndef __VRSERVER_H
#define __VRSERVER_H


#ifdef __cplusplus
extern "C" {
#endif


/****************************************************************************\
*
* Function:     void InitVRServer(void (*PreVRFunct)(), void (*VRFunt)());
*
* Description:  Initializes the VRServer and synchronizes it to the screen
*               refresh
*
* Input:        void (*PreVRFunct)()    Pointer to the routine that will be
*                                       called just before the Retrace. This
*                                       routine should not take more time
*                                       than a couple of raster lines and
*                                       should only do things that absolutely
*                                       have to be done before the Retrace,
*                                       eg. set the screen start address.
*               void (*VRFunct)()       Pointer to the routine that will be
*                                       called just after the Retrace has
*                                       started. This can take more time
*                                       than PreVRFunct() and can be used
*                                       for, for example, setting the RGB
*                                       palette etc.
*
\****************************************************************************/

void InitVRServer(void (*PreVRFunct)(), void (*VRFunct)());



/****************************************************************************\
*
* Function:     void SyncVRServer(void);
*
* Description:  Synchronizes the VRServer to the screen refresh. Must be
*               called if the display refresh rate changes, eg. if the
*               mode is changed.
*
\****************************************************************************/

void SyncVRServer(void);




/****************************************************************************\
*
* Function:     void RemoveVRServer(void);
*
* Description:  Uninitializes the VRServer and restores the old Timer
*               interrupt and rate.
*
\****************************************************************************/

void RemoveVRServer(void);



#ifdef __cplusplus
}
#endif



#endif
