(9636)  Thu 7 Apr 94 16:22
By: Bas van Gaalen
To: all
Re: mode-x-hardware-scroll
St:
------------------------------------------------------------
@MSGID: 2:285/213.8 da46268c
Howdy all!

For all who missed Jens' (I believe it was his) hardwarescrolling routines in
mode-x, including Simon Kissel. Here's my own version for 320x400x256 mode-x.

I was just expirimenting with it (don't worry, my monitor didn't blow up, so
I'm quite sure yours won't either). As you may notice I commented some things
in the 'vga320x400' procedure. Can someone explain what those things do
exactly, because I can't notice any difference with or without them.
And what values are possible for the '$e3' at the '25mhz clock'-part?
I suppose it may be harmfull if you change that value at-ramdom?
And how can one set other mode-x resolution, like 320x200 and all the other
exotic resulutions like in the xlibpas-unit?

--- cut here ---

{$g+}
program mode_x;
{ Mode-x stunts, by Bas van Gaalen, Holland, PD }
uses crt;
const
  width:word=0;
  heigth:word=0;
  bytesperline:word=0;
var
  x,y:word;

procedure setpal(col,r,g,b:byte); assembler;
asm
  mov dx,03c8h
  mov al,col
  out dx,al
  inc dx
  mov al,r
  out dx,al
  mov al,g
  out dx,al
  mov al,b
  out dx,al
end;

procedure settextmode; assembler;
asm
  mov ax,3
  int 10h
end;

procedure vga320x400; assembler;
asm
  mov ax,0013h
  int 10h
  mov dx,03c4h
  mov ax,0604h     { index 4: memory-use }
  out dx,ax
  mov ax,0f02h     { index 2: bit 0-3, all planes }
  out dx,ax

  mov cx,320*200   { 400/2 (word) = 200 lines }
  mov es,sega000
  xor ax,ax
  mov di,ax
  rep stosw        { clear screen }

  mov dx,03c2h
  mov al,0e3h      { 25mhz clock }
  out dx,al

  mov dx,03d4h
  mov ax,4009h     { index 9: 400 lines }
  out dx,ax

  (*
  mov ax,0014h     { index 14: bit 6=0: normal addresses }
  out dx,ax
  *)
  (*
  mov ax,0e317h    { index 17: misc settings }
  out dx,ax
  *)

  mov width,320
  mov heigth,400
  mov bytesperline,80
end;

procedure putpixel(x,y:word; col:byte); assembler;
asm
  mov dx,03c4h
  mov al,2
  out dx,al
  inc dx

  mov cx,[x]
  and cx,3
  mov al,1
  shl al,cl
  out dx,al

  mov es,sega000
  mov ax,[y]
  mov dx,bytesperline
  mul dx

  mov dx,[x]
  shr dx,2

  add ax,dx
  mov di,ax

  mov al,[col]
  mov [es:di],al
end;

procedure setaddress(ad:word); assembler;
asm
  mov dx,3dah      { retrace }
 @vert1:
  in al,dx
  test al,8
  jz @vert1
 @vert2:
  in al,dx
  test al,8
  jnz @vert2

  mov dx,03d4h
  mov al,0dh
  cli
  out dx,al
  inc dx
  mov ax,[ad]      { mov al,lo_byte_of_starting_offset }
  out dx,al
  dec dx
  mov al,0ch
  out dx,al
  inc dx
  mov ax,[ad]      { mov al,hi_byte_of_starting_offset }
  xchg ah,al
  out dx,al
  sti
end;

begin
  { install 320x400x256 mode-x }
  vga320x400;

  { set palette }
  for x:=1 to 255 do setpal(x,255-x div 4,255-x div 4,30);

  { draw onscreen part }
  for x:=0 to width-1 do
    for y:=0 to heigth-1 do
      putpixel(x,y,(x+y) mod 255);

  { draw offscreen part }
  for x:=0 to width-1 do
    for y:=0 to heigth-1 do
      putpixel(x,400+y,(x-y) mod 255);

  for y:=0 to 400 do setaddress(y*80); { scroll up }
  for x:=0 to 80 do setaddress(y*80+x); { scroll left }
  for x:=79 downto 0 do setaddress(y*80+x); { scroll right }
  for y:=399 downto 0 do setaddress(y*80); { scroll down }
  for x:=0 to 199 do begin { switch pages }
    setaddress(heigth*bytesperline);
    setaddress(0);
  end;

  repeat until keypressed; while keypressed do readkey;
  settextmode;
end.

--- cut here ---
 _    _
|_]  | _
|__].|__].

--- GEcho 1.02+
 * Origin: F'req CR at 2:285/20 for a RA-Caller Maintenance prg. (2:285/213.8)

@PATH: 285/213 20 25
