;----------------------------------------------------------------------------:
; SILVERMOON																 :
;																			 :
; INCLUDE File for VGA constants and useful macros							 :
;----------------------------------------------------------------------------:


;----------------------------------------------------------------------------:
; Colour VGA register equates												 :
;----------------------------------------------------------------------------:


; I/O ports for accessing VGA

Miscellaneous_Output_Write_Port EQU 03c2h
Miscellaneous_Output_Read_Port	EQU 03cch
Input_Status_0_Port 			EQU 03c2h
Input_Status_1_Port 			EQU 03dah
Sequencer_Address_Port			EQU 03c4h
Sequencer_Data_Port 			EQU 03c5h
CRTC_Address_Port				EQU 03d4h
CRTC_Data_Port					EQU 03d5h
Graphics_Address_Port			EQU 03ceh
Graphics_Data_Port				EQU 03cfh
Attribute_Address_Write_Port	EQU 03c0h
Attribute_Address_Read_Port 	EQU 03c1h   
PEL_Address_Write_Mode_Port 	EQU 03c8h
PEL_Address_Read_Mode_Port		EQU 03c7h
PEL_Data_Port					EQU 03c9h
DAC_State_Port					EQU 03c7h
PEL_Mask_Port					EQU 03c6h


; Addresses of sequencer registers

Reset					EQU 0
Clocking_Mode			EQU 1
Map_Mask				EQU 2
Character_Map_Select	EQU 3
Memory_Mode 			EQU 4

; Addresses of CRTC registers

Horizontal_Total			EQU 0
Horizontal_Display_End		EQU 1
Start_Horizontal_Blanking	EQU 2
End_Horizontal_Blanking 	EQU 3
Start_Horizontal_Retrace	EQU 4
End_Horizontal_Retrace		EQU 5
Vertical_Total				EQU 6
Overflow					EQU 7
Preset_Row_Scan 			EQU 8
Max_Scan_Line				EQU 9
Cursor_Start				EQU 10
Cursor_End					EQU 11
Start_Address_High			EQU 12
Start_Address_Low			EQU 13
Cursor_Location_High		EQU 14
Cursor_Location_Low 		EQU 15
Vertical_Retrace_Start		EQU 16
Vertical_Retrace_End		EQU 17
Vertical_Display_End		EQU 18
;Offset 					EQU 19
Underline_Location			EQU 20
Start_Vertical_Blanking 	EQU 21
End_Vertical_Blanking		EQU 22
Mode_Control				EQU 23
Line_Compare				EQU 24

; Addresses of Graphics registers

Set_Reset				EQU 0
Enable_Set_Reset		EQU 1
Colour_Compare			EQU 2
Data_Rotate 			EQU 3
Read_Map_Select 		EQU 4
Mode					EQU 5
Miscellaneous			EQU 6
Colour_Dont_Care		EQU 7
Bit_Mask				EQU 8

; Addresses of Attribute registers

Palette 					EQU 0
Attribute_Mode_Control		EQU 010h
Overscan_Colour 			EQU 011h
Colour_Plane_Enable 		EQU 012h
Horizontal_Pixel_Panning	EQU 013h
Colour_Select				EQU 014h

MACRO	Wait_for_Vertical_Retrace
		LOCAL	VR_Wait
		PUSH	AX
		PUSH	DX
VR_Wait:
		MOV 	DX,Input_Status_1_Port			; hang around for vblank tick
		IN		AL,DX
		TEST	AL,8
		JZ		SHORT VR_Wait
		POP 	DX
		POP 	AX
ENDM

;----------------------------------------------------------------------------:
; Screen Resolution 														 :
;----------------------------------------------------------------------------:


VGA_X_Resolution EQU 320
VGA_Y_Resolution EQU 200




