'===================================================================
' CHEM2DKB.BAS
' By Dan Farmer
' November, 1990
' Generates DKB script for molecular models generated by CHEM.EXE, a
' public domain software package by Larry Puhl"
' Updated to DKB 2.11 by Aaron A. Collins 05/01/91
'====================================================================

'          ---  FORMAT A NUMERIC STRING
DEF FNFMT$ (A#)
	FORM$="-####.###"
	STATIC SIGN, S$, P, A$, DEC, W$, F$, WF$, FF$, PAD$, ADD$
'
	SIGN = SGN(A#)
	A# = ABS(A#)

'          ---  SEPARATE WHOLE AND FRACTIONAL PARTS OF NUMBER
	W$ = MID$(STR$(INT(A#)), 2)
	IF W$ = "" THEN W$ = "0"
	S$ = STR$(1 + A#)
	P = INSTR(S$, ".")
	IF P = 0 THEN
		F$ = ""
	   ELSE F$ = MID$(S$, P + 1)
	END IF

'          ---  SEPARATE WHOLE AND FRACTION FORMAT STRINGS
	DEC = INSTR(FORM$, ".")
	IF DEC = 0 THEN
		WF$ = FORM$: FF$ = ""
	   ELSE WF$ = LEFT$(FORM$, DEC - 1)
		FF$ = MID$(FORM$, DEC + 1)
	END IF

	ADD$ = "": PAD$ = " "

'          ---  ADD SIGN CHARACTER
	IF LEFT$(WF$, 1) = "-" THEN
		WF$ = MID$(WF$, 2)
		IF SIGN = -1 THEN
			ADD$ = ADD$ + "-"
		   ELSE ADD$ = ADD$ + " "
		END IF
	END IF
    
'          ---  HANDLE NUMERIC OVERFLOW AND UNDERFLOW
	IF LEN(W$) > LEN(WF$) THEN W$ = "%" + RIGHT$(W$, LEN(WF$) - 1)
	IF LEN(F$) > LEN(FF$) THEN F$ = LEFT$(F$, LEN(FF$))
'          ---  FORMAT THE NUMBER STRING
	IF DEC > 0 THEN W$ = W$ + "." + F$ + STRING$(LEN(FF$) - LEN(F$), "0")
	FNFMT$ = ADD$ + W$
END DEF

DIM BUFF$(4)
DIM COLORTAB$(16)
COLORTAB$(00)="Black"
COLORTAB$(01)="Blue"
COLORTAB$(02)="Green"
COLORTAB$(03)="Cyan"
COLORTAB$(04)="Red"
COLORTAB$(05)="Magenta"
COLORTAB$(06)="Brown"
COLORTAB$(07)="LightGray"
COLORTAB$(08)="Gray"
COLORTAB$(09)="LightBlue"
COLORTAB$(10)="LimeGreen"
COLORTAB$(11)="Turquoise"
COLORTAB$(12)="Pink"
COLORTAB$(13)="Plum"
COLORTAB$(14)="Yellow"
COLORTAB$(14)="White"

INFILE$=COMMAND$
IF COMMAND$="" THEN
    PRINT "CHEM2DKB.EXE infile[.dat]"
    PRINT "    Converts CHEM.EXE Version 2.0 data file to DKB datafile."
    PRINT "    Output file uses root name of input file, adds .DKB extension."
    PRINT
    END
END IF
ADOT=INSTR(INFILE$,".")
IF ADOT > 0 THEN                                 ' IF AN EXTENSION SPECIFIED
    ROOTNAME$=LEFT$(INFILE$,ADOT-1)              ' GET ROOT FILENAME
ELSE
    ROOTNAME$=INFILE$
    INFILE$=ROOTNAME$+".DAT"                     ' RE-CREATE IN FILENAME
END IF
OUTFILE$=ROOTNAME$+".DKB"                        ' CREATE OUTPUT FROM ROOT

OPEN INFILE$ FOR INPUT AS #1
OPEN OUTFILE$ FOR OUTPUT AS #2

PRINT "Reading "; INFILE$
PRINT "Writing "; OUTFILE$

WHILE NOT EOF(1)
    INPUT #1, A$
    IF LEFT$(A$,13) = "chemical_name" THEN
	TITLE$=MID$(A$,16,LEN(A$)-2)
        GOSUB WRITE.HEADER
    ELSEIF LEFT$(A$,12)="atomlocation" THEN
        GOSUB WRITE.ATOM
    END IF
WEND
GOSUB WRITE.FOOTER

CLOSE #1: CLOSE #2
PRINT "CHEM2DKB Finished."
END

WRITE.HEADER:
    PRINT #2, "{
    PRINT #2, "DKB 2.11 Data file for ";TITLE$
    PRINT #2, "Generated from CHEM.EXE Version 2.0 data file by CHEM2DKB.EXE"
    PRINT #2, "    CHEM.EXE by Larry Puhl"
    PRINT #2, "    CHEM2DKB by Dan Farmer
    PRINT #2, "    Updated to DKB 2.11 by Aaron A. Collins"
    PRINT #2, "}"
    PRINT #2, ""
    PRINT #2, "INCLUDE "+CHR$(34)+"shapes.dat"+CHR$(34)
    PRINT #2, "INCLUDE "+CHR$(34)+"colors.dat"+CHR$(34)
    PRINT #2, "INCLUDE "+CHR$(34)+"textures.dat"+CHR$(34)
    PRINT #2, ""
    PRINT #2, "VIEW_POINT"
    PRINT #2, "    LOCATION <0.0  0.0  -10.0>     {Z may need modification}"
    PRINT #2, "    DIRECTION <0.0 0.0  2.0>"
    PRINT #2, "    UP  <0.0  1.0  0.0>"
    PRINT #2, "    RIGHT <1.33333 0.0 0.0>"
    PRINT #2, "    LOOK_AT <0.0  0.0  0.0>"
    PRINT #2, "END_VIEW_POINT"
    PRINT #2,

    PRINT #2, "OBJECT"
    PRINT #2, "    SPHERE <0.0  0.0  0.0>  2.0 END_SPHERE"
    PRINT #2, "    TRANSLATE <500.0  500.0  -100.0> {Z may need modification}"
    PRINT #2, "    TEXTURE"
    PRINT #2, "        COLOUR White"
    PRINT #2, "        AMBIENT 1.0"
    PRINT #2, "        DIFFUSE 0.0"
    PRINT #2, "    END_TEXTURE"
    PRINT #2, "    LIGHT_SOURCE"
    PRINT #2, "    COLOUR White"
    PRINT #2, "END_OBJECT"
    PRINT #2,

    PRINT #2, "OBJECT"
    PRINT #2, "    SPHERE <0.0  0.0  0.0>  2.0 END_SPHERE"
    PRINT #2, "    TRANSLATE <-500.0  50.0  -1000.0> {Z may need modification}"
    PRINT #2, "    TEXTURE"
    PRINT #2, "        COLOUR DimGrey"
    PRINT #2, "        AMBIENT 1.0"
    PRINT #2, "        DIFFUSE 0.0"
    PRINT #2, "    END_TEXTURE"
    PRINT #2, "    LIGHT_SOURCE"
    PRINT #2, "    COLOUR DimGrey"
    PRINT #2, "END_OBJECT"
    PRINT #2,

    PRINT #2,
    PRINT #2,"COMPOSITE"
RETURN
WRITE.ATOM:
    FOR I = 1 TO 4
        INPUT #1,B$                              ' READ X,Y,Z ,& R
        BUFF$(I)=B$                              ' SAVE FOR MASSAGING
	NEXT I
    FOR I=1 TO 4                                 ' READ UP TO COLOR CODE
        INPUT #1,B$
    NEXT I
    '***  B$ SHOULD NOW HOLD AN EGA COLOR NUMBER AND A RIGHT PAREN
    COLOR$=COLORTAB$(VAL(B$))



    '*** GET X,Y,Z VALUES & CONVERT TO ANGSTROM UNITS (DIVIDE BY 1300)
    X=VAL(MID$(BUFF$(1),3))/1300                  ' STRIP LEADING "l("
    Y=VAL(BUFF$(2))/1300
    Z=VAL(BUFF$(3))/1300

    '*** RADIUS: (ALREADY IN ANGSTROM UNITS)
    R=VAL(BUFF$(4))

	'*** CONVERT TO FORMATTED STRINGS
    X$=FNFMT$(X) : Y$=FNFMT$(Y) : Z$=FNFMT$(Z) : R$=FNFMT$(R)

    PRINT #2, "    OBJECT"
	PRINT #2, "        SPHERE <"; X$;" "; Y$;" "; Z$" ";; "> ";R$;" END_SPHERE"
    PRINT #2, "        TEXTURE"
	PRINT #2, "            COLOUR " ; COLOR$
    PRINT #2, "            AMBIENT 0.3"
    PRINT #2, "            DIFFUSE 0.7"
    PRINT #2, "            PHONG 1.0"
    PRINT #2, "            PHONGSIZE 40.0"
    PRINT #2, "        END_TEXTURE"
	PRINT #2, "        COLOUR " ; COLOR$
    PRINT #2, "    END_OBJECT"
RETURN

WRITE.FOOTER:
    PRINT #2,"TRANSLATE <0.0  0.0  0.0>"
    PRINT #2,"ROTATE    <0.0  0.0  0.0>"
    PRINT #2,"END_COMPOSITE"
RETURN
