// serial.h
// C functions prototypes for routines in serial.c
#ifndef SERIAL_DEFINES
#define SERIAL_DEFINES
  
int com_install(int portnum, int tx_size, int rx_size);
void com_deinstall(int portnum);
void com_set_speed(int portnum, long speed);
void com_set_parity(int portnum, enum par_code parity, int stop_bits);
void com_lower_dtr(int portnum);
void com_raise_dtr(int portnum);
void com_pulse_rts(int portnum);
void com_tx(int portnum, char c);
void com_tx_string(int portnum, char *s);
int  com_tx_ready(int portnum);
int  com_tx_empty(int portnum);
unsigned char com_rx(int portnum);
int  com_rx_empty(int portnum);
int com_rx_count(int portnum);
void com_flush_tx(int portnum);
void com_flush_rx(int portnum);
int  com_carrier(int portnum);
int com_cts(int portnum);
int com_modem_stat(int portnum);
  
// *********************************
enum par_code  { COM_NONE, COM_EVEN, COM_ODD, COM_ZERO, COM_ONE };
// *********************************
  
// Modem status register bits
  
#define DCTS    0x01                    /* Delta clear to send */
#define DDSR    0x02                    /* Delta data set ready */
#define TERI    0x04                    /* Trailing edge ring indicator */
#define DRLSD   0x08                    /* Delta Rx line signal detect */
#define CTS     0x10                    /* Clear to send */
#define DSR     0x20                    /* Data set ready */
#define RI      0x40                    /* Ring indicator */
#define RLSD    0x80                    /* Receive line signal detect */
  
// Line control register bits
  
#define DATA5   0x00        /* 5 Data bits */
#define DATA6   0x01        /* 6 Data bits */
#define DATA7   0x02        /* 7 Data bits */
#define DATA8   0x03        /* 8 Data bits */
  
#define STOP1   0x00        /* 1 Stop bit */
#define STOP2   0x04        /* 2 Stop bits */
  
#define NOPAR   0x00        /* No parity */
#define ODDPAR  0x08        /* Odd parity */
#define EVNPAR  0x18        /* Even parity */
#define STKPAR  0x28        /* Stick parity */
#define ZROPAR  0x38        /* Zero parity */
  
// *********************************
#endif // SERIAL_DEFINES
