/* Header file for user-interface routines */
  
/* Written by Bernie Roehl, January 1992 (broehl@sunee.waterloo.edu) */
  
/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */
  
typedef struct {
   int x, y, buttons;
   int cenx, ceny;
   int xrange, yrange;
   long scale; /* maximum acceptable returned value for X and Y */
   int port;  /* port number, 0 or 1; -1 means 'unused' */
} joystick_data;
  
extern int joystick_check(void);
extern void joystick_init(joystick_data *joy, int port);
extern int joystick_read(joystick_data *joystick);
extern void joystick_quit(void);
extern void joystick_setscale(joystick_data *joy, int value);
extern void joystick_scale(joystick_data *joy, int dir);
extern void neatbox(int w, int h, int *x, int *y);
extern void poptext(char *text[]);
extern void popmsg(char *msg);
extern unsigned askfor(char *prompt, char *buff, int n);
extern int menu(char *text[]);

extern unsigned getkey(void);
extern void disp_palette(void);
extern void save_it(OBJECT *obj);
extern void do_key(unsigned c);
extern void do_joy(joystick_data *joy);
extern void select_tree(SEGMENT *s);
extern void count_tree(SEGMENT *s, int *nsegs, int *nverts, int *npolys);

extern void ptpoly(int count, int *pcoords, int color);
extern void background(int page, int top, int bot, int color);
extern void reflection(int page, int top, int bot, int step);
extern void reset_screens(void);
extern void screen_refresh(VIEW *current_view);
extern void user_setup_blitter(void);
extern void user_reset_blitter(void);
extern void user_box(int x1, int y1, int x2, int y2, int color);
extern void user_text(int x, int y, int color, char *string);
extern void user_render_poly(int number, int *pcoords, unsigned color, long maxz);
  
extern int head_update(int recenter);
extern void init_body_links(void);
extern void body_centric_map(VIEW *body, VIEW *v);

extern void preset_default_colors(void);
extern void set_colors(int bw);
extern int user_poly_color(POLY *p, int pcolor);

extern void cursor_move(int x, int y);  /* move cursor if visible */
extern int cursor_hide(void);               /* erase cursor */
extern int cursor_forget(void);             /* will be erased by redraw: ignore it! */
extern void cursor_show(int page);      /* redisplay cursor */

extern int check_key(unsigned key);
extern int check_controls(int x, int y, unsigned buttons);

/* End of userint.h */
