/* Example of use of 3D routines to rotate tetrahedron  on X,Y,Z axes */
/* Make using 
   make make3dex.mak */
/* Written by Nigel Salt */

#include <3d.h>
#include <graph.h>

double dmatA[4][4];
matrix matA={4,4,&dmatA[0][0]};

double dmatB[4][4];
matrix matB={4,4,&dmatB[0][0]};

double dmatC[4][4];
matrix matC={4,4,&dmatC[0][0]};

double dmatD[4][4];
matrix matD={4,4,&dmatD[0][0]};

double dmatE[4][4];
matrix matE={4,4,&dmatE[0][0]};

double dmatF[4][4];
matrix matF={4,4,&dmatF[0][0]};

double dmatG[4][4];
matrix matG={4,4,&dmatG[0][0]};

double dmatH[4][4];
matrix matH={4,4,&dmatH[0][0]};

double dmatI[4][4];
matrix matI={4,4,&dmatI[0][0]};

double dmatJ[4][4];
matrix matJ={4,4,&dmatJ[0][0]};

double tetrap[5][3]=
{
  0,1,0,
  -1,0,1,
  1,0,1,
  -1,0,-1,
  1,0,-1,
};
int tetral[8][2]=
{
  0,1,
  0,2,
  0,3,
  0,4,
  1,2,
  1,3,
  4,3,
  4,2
};
object tetra=
{
  5,8,&tetrap[0][0],&tetral[0][0]
};

double tetrap2[5][3];
int tetral2[8][2];
object tetra2=
{
  5,8,&tetrap2[0][0],&tetral2[0][0]
};

main()
{
  int i,j,k;
  char buff[80];
  init3d();
  scale3(&matA,50,50,50);
  objtran(&tetra,&matA);

  for (j=0;j<3;j++)
    {
    rot3(&matA,pi/16,j);
    _settextposition(30,0);
    sprintf(buff,"%c ROT",'X'+j);
    _outtext(buff);
    for (i=0;i<50;i++)
      {
      _setcolor(i%15+1);
      objdraw(&tetra);
      objcop(&tetra,&tetra2);
      objtran(&tetra,&matA);
      for (k=0;k<32000;k++);
      _setcolor(0);
      objdraw(&tetra2);
      }
    }
  _setvideomode(_DEFAULTMODE);
}

wait()
{
 _settextposition(30,0);
 _outtext("PRESS KEY");
 getch();
 _clearscreen(_GCLEARSCREEN);
}
