/****************************************************************************/
/*                   inmos.c                                                */
/*                                                                          */
/*  This module implements the Transputer specific routines for POV-Ray.    */
/*                                                                          */
/*  for Persistence of Vision Raytracer                                     */
/*  Copyright 1992 Parham Data Products and POV-Team                        */
/*  ----------------------------------------------------------------------  */
/*  Copying, distribution and legal info is in the file povlegal.doc which  */
/*  should be distributed with this file. If povlegal.doc is not available  */
/*  or for more info please contact:                                        */
/*                                                                          */
/*       Drew Wells [POV-Team Leader]                                       */
/*       CIS: 73767,1244  Internet: 73767.1244@compuserve.com               */
/*       Phone: (213) 254-4041                                              */
/*                                                                          */
/*       Wayne Parham [President, Parham Data]                              */
/*       Phone: (918) 492-7221                                              */
/*                                                                          */
/* This program is based on the popular DKB raytracer version 2.12.         */
/* DKBTrace was originally written by David K. Buck.                        */
/* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.  */
/*                                                                          */
/****************************************************************************/

#include <stdarg.h>
#include <time.h>
#include "frame.h"
#include "povproto.h"

/* Transputer Heap Management                                               */
/*                                                                          */
/* Modify to reflect actual amount of Transputer RAM                        */
/*                                                                          */
/* extern void *_heapend;       <-      Pointer to End of Memory            */
/*                                                                          */
/* void Config_Transputer_RAM()                                             */
/*    {                                 1Mb - 0x80100000   2Mb - 0x80200000 */
/*    _heapend = (void *) 0x8yy00000;   4Mb - 0x80400000   8Mb - 0x80800000 */
/*    }                                16Mb - 0x81000000  32Mb - 0x82000000 */

extern void *_heapend;

void Config_Transputer_RAM()
   {
   _heapend = (void *) 0x80201000;
   }

/*                                                                          */
/* ANSI Standard psuedo-random number generator                             */
/*                                                                          */

#if !__STDC__

static unsigned long int next = 1;

int rand()
   {
   next = next * 1103515245L + 12345L;
   return ((int) (next / 0x10000L) & 0x7FFF);
   }

void srand(seed)
   unsigned int seed;
   {
   next = seed;
   }

#endif

/*                                                                          */
/* Miscellaneous (and as of yet, undefined) Functions                       */
/*                                                                          */

void display_init(width, height)
int width, height;
   {
   }

void display_finished()
   {
   }

void display_close()
   {
   }

void display_plot(x, y, Red, Green, Blue)
   int x, y;
   char Red, Green, Blue;
   {
   }

void Print_Credits()
  {
  fprintf (stderr,"       Persistence of Vision Raytracer Ver 1.0%s\n",COMPILER_VER);
  fprintf (stderr,"ͻ\n");
  fprintf (stderr,"ĺ\n");
  fprintf (stderr,"  Copyright (c) 1992  POV-Team                                          \n");
  fprintf (stderr,"  POV-Ray is based on DKBTrace 2.12 by David K. Buck & Aaron A. Collins.\n");
  fprintf (stderr,"                                                                        \n");
  fprintf (stderr,"                         T800 Transputer POV-Ray                        \n");
  fprintf (stderr,"                                                                        \n");  
  fprintf (stderr,"                     for the Parham Data Products 8401                  \n");  
  fprintf (stderr,"                and other Inmos B004 compatible Processors              \n");  
  fprintf (stderr,"ĺ\n");
  fprintf (stderr,"  Contributing Authors: (Alphabetically)                                \n");
  fprintf (stderr,"ĺ\n");
  fprintf (stderr,"  Steve A. Bennett   David K. Buck      Aaron A. Collins                \n");
  fprintf (stderr,"  Alexander Enzmann  Dan Farmer         Girish T. Hagan                 \n");
  fprintf (stderr,"  Douglas Muir       Bill Pulver        Robert Skinner                  \n");
  fprintf (stderr,"  Scott Taylor       Drew Wells         Chris Young                     \n");
  fprintf (stderr,"  -  Other contributors listed in the documentation.  -                 \n");
  fprintf (stderr,"ͼ\n");
  }  

