/*
 *
 * cnvdat.c
 * 09/05/91 -- CdW
 * A quickie program to convert all uppercase keywords to lowercase.
 * Converts INCLUDE to #include.
 * Converts DECLARE to #declare.
 * Adds the tokenizer keyword case_sensitive_opt to top of file.
 * Should work as a base for more sophisticated conversions.
 *
 */

#include <stdio.h>
#include <string.h>

#define FALSE 0
#define TRUE 1
#define MAX_STRING_INDEX 41
char String[MAX_STRING_INDEX];
int String_Index;

int Read_Write_Symbol (FILE *Data_File);
void Begin_String();
void Stuff_Character (int c);
void End_String ();
void Convert_String();

main()
{ 
 int c;  
  fprintf(stderr,"DKBTrace to PV-Ray Ver 0.5 BETA Upper to Lower Converter\n");
  fprintf(stderr,"--------------------------------------------------------\n");
  fprintf(stderr,"Converting all uppercase keywords to lower...\n");
  
 /* fprintf(stdout,"#case_sensitive_opt // Normally default, but let's be sure.\n");*/
  fprintf(stdout,"// Persistence of Vision Raytracer\n");
  while(TRUE)
  {
    c = getc(stdin);
    if(c==EOF){
      fprintf(stderr,"End of File\n");
      break; 
    }
    if(isalpha(c) || c == '_' ){
      ungetc(c,stdin);
      if (Read_Write_Symbol(stdin) == FALSE)
        break;
     }
    else
     putc(c,stdout);
  }
}   
   
/* Read in a symbol from the input file.  Check to see if it is a reserved
   word.  If it is, write out the appropriate token.  Otherwise, write the
   symbol out to the Symbol file and write out an IDENTIFIER token. An
   Identifier token is a token whose token number is greater than the
   highest reserved word. */

int Read_Write_Symbol (Data_File)
  FILE *Data_File;
  {
  register int c, Symbol_Id;
  
  Begin_String();
  while (TRUE)
    {
    c = getc(Data_File);
    if (c == EOF)
      {
      fprintf(stderr, "Unexpected end of file");
      return (FALSE);
      }

    if (isalpha(c) || isdigit(c) || c == (int) '_')
      Stuff_Character (c);
    else
      {
      ungetc (c, Data_File);
      break;
      }
    }
  End_String(Data_File);
  
  /* If symbol is all uppercase convert it to lower */
  Convert_String();
  if(!strcmp(String,"include") || !strcmp(String,"declare")) 
    putc('#',stdout);
  if(!strcmp(String,"Red") || !strcmp(String,"Green") || !strcmp(String,"Blue"))
    putc('C',stdout);   
  if(!strcmp(String,"Sphere"))
    putc('Q',stdout);   
  
  fputs(String,stdout);
   
  return (TRUE);
  }

void Begin_String()
  {
  String_Index = 0;
  }

void Stuff_Character (c)
  int c;
  {
  if (String_Index < MAX_STRING_INDEX)
    {
    String [String_Index++] = (char) c;
    if (String_Index >= MAX_STRING_INDEX)
      {
      String [String_Index-1] = '\0';
      fprintf(stderr, "String too long  %s",String);
      }
    }
  }
void End_String ()
  {
  Stuff_Character ((int) '\0');
  }

/* If symbol is all uppercase convert it to lower */
void Convert_String()
{
  char *tmpstr;    
  
  tmpstr = String;
 
/* check for any lower case*/ 
  while(*tmpstr)
    if(islower(*tmpstr++))
      return;
/* cnv all upper to lower */ 
 tmpstr = String;
  while(*tmpstr)
    *tmpstr++ = tolower(*tmpstr);
}

  
