/****************************************************************************
*                prioq.c
*
*  This module implements a priority queue using a heap.
*
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/

#include "frame.h"
#include "pvproto.h"

#define NUMBER_OF_PRIOQS 32
#define NUMBER_OF_INTERSECTIONS 32

PRIOQ *prioqs;

void pq_init ()
   {
   register int i;
   PRIOQ *new_pq;

   prioqs = NULL;

   for (i = 0 ; i < NUMBER_OF_PRIOQS; i++)
      {
      if ((new_pq = (PRIOQ *) malloc (sizeof (PRIOQ))) == NULL) {
         fprintf (stderr, "\nCannot allocate queues");
         exit(1);
         }
      
      new_pq -> next_pq = prioqs;
      prioqs = new_pq;

      if ((new_pq -> queue = (INTERSECTION *)
            malloc (NUMBER_OF_INTERSECTIONS * sizeof (INTERSECTION))) == NULL) {
         fprintf (stderr, "\nCannot allocate queue entries");
         exit(1);
         }
      }
   }

PRIOQ *pq_alloc()
   {
   PRIOQ *allocated_queue;

   if (prioqs == NULL) {
      fprintf (stderr, "\nOut of prioqs");
      exit(1);
      }

   allocated_queue = prioqs;
   prioqs = allocated_queue -> next_pq;
   return (allocated_queue);
   }

void pq_free (pq)
   PRIOQ *pq;
   {
   pq -> next_pq = prioqs;
   prioqs = pq;
   }

PRIOQ *pq_new (index_size)
   int index_size;
   {
   PRIOQ *pq;

   if (index_size > 256)
      return (NULL);

   if ((pq = pq_alloc()) == NULL)
      return (NULL);

   pq -> queue_size = index_size;
   pq -> current_entry = 0;
   return (pq);
   }

void pq_balance(q, entry_pos1)
   PRIOQ *q;
   unsigned int entry_pos1;
   {
   register INTERSECTION *entry1, *entry2;
   INTERSECTION temp_entry;
   register unsigned int entry_pos2;

   entry1 = &q->queue[entry_pos1];

   if ((entry_pos1 * 2 < q->queue_size)
       && (entry_pos1 * 2 <= q -> current_entry))
      {
      if ((entry_pos1*2+1 > q->current_entry) ||
          (q->queue[entry_pos1*2].Depth < q->queue[entry_pos1*2+1].Depth))
         entry_pos2 = entry_pos1*2;
      else
         entry_pos2 = entry_pos1*2+1;

      entry2 = &q->queue[entry_pos2];

      if (entry1->Depth > entry2->Depth) {
         temp_entry = *entry1;
         *entry1 = *entry2;
         *entry2 = temp_entry;
         pq_balance (q, entry_pos2);
         }
      }

   if (entry_pos1 / 2 >= 1 )
      {
      entry_pos2 = entry_pos1 / 2;
      entry2 = &q->queue[entry_pos2];
      if (entry1->Depth < entry2->Depth) {
         temp_entry = *entry1;
         *entry1 = *entry2;
         *entry2 = temp_entry;
         pq_balance (q, entry_pos2);
         }
      }
   }

void pq_add (q, queue_entry)
   PRIOQ *q;
   INTERSECTION *queue_entry;
   {
   q -> current_entry++;
   if (q -> current_entry >= q -> queue_size)
      q -> current_entry--;

   q -> queue [q -> current_entry] = *queue_entry;
   pq_balance (q, q -> current_entry);
   }

INTERSECTION *pq_get_highest(q)
   PRIOQ *q;
   {
   if (q -> current_entry >= 1)
      return (&(q -> queue[1]));
   else
      return (NULL);
   }

int pq_is_empty(q)
   PRIOQ *q;
   {
   if (q -> current_entry < 1)
      return (TRUE);
   else
      return (FALSE);
   }

void pq_delete_highest (q)
   PRIOQ *q;
   {
   q -> queue[1] = q -> queue[q -> current_entry--];
   pq_balance (q, 1);
   }
