/****************************************************************************
*                ray.c
*
*  This module implements the code pertaining to rays.
*
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/



#include "frame.h"
#include "vector.h"
#include "pvproto.h"

#define Mix(a,b,c) { \
   (a).x = (b).x * (c).y; \
   (a).y = (b).x * (c).z; \
   (a).z = (b).y * (c).z; }

void Make_Ray(r)
   RAY *r;
   {
   VECTOR Temp_Init_Dir;

   VSquareTerms (r -> Initial_2, r -> Initial);
   VSquareTerms (r -> Direction_2, r -> Direction);
   VEvaluate (r -> Initial_Direction, r -> Initial, r -> Direction);
   Mix (r -> Mixed_Initial_Initial, r -> Initial, r -> Initial);
   Mix (r -> Mixed_Dir_Dir, r -> Direction, r -> Direction);
   Mix (Temp_Init_Dir, r -> Initial, r -> Direction);
   Mix (r -> Mixed_Init_Dir, r -> Direction, r -> Initial);
   VAdd (r -> Mixed_Init_Dir, r -> Mixed_Init_Dir, Temp_Init_Dir);
   r -> Quadric_Constants_Cached = TRUE;
   }

void Initialize_Ray_Containers (Ray)
   RAY *Ray;
   {
   Ray -> Containing_Index = -1;
   }

void Copy_Ray_Containers (Dest_Ray, Source_Ray)
   RAY *Dest_Ray, *Source_Ray;
   {
   register int i;
   
   if ((Dest_Ray -> Containing_Index = Source_Ray -> Containing_Index)
         >= MAX_CONTAINING_OBJECTS) {
      fprintf (stderr, "ERROR - Containing Index too high\n");
      close_all();
      exit (1);
      }

   for (i = 0 ; i < MAX_CONTAINING_OBJECTS ; i++) {
      Dest_Ray -> Containing_Textures[i] = Source_Ray -> Containing_Textures[i];
      Dest_Ray -> Containing_IORs[i] = Source_Ray -> Containing_IORs[i];
      }
   }

void Ray_Enter (ray, texture)
   RAY *ray;
   TEXTURE *texture;
   {
   register int index;

   if ((index = ++(ray -> Containing_Index)) >= MAX_CONTAINING_OBJECTS) {
      fprintf (stderr, "Too many nested refracting objects\n");
      close_all();
      exit(1);
      }

   ray -> Containing_Textures [index] = texture;
   ray -> Containing_IORs [index] = texture->Object_Index_Of_Refraction;
   }

void Ray_Exit (ray)
   RAY *ray;
   {
   if (--(ray -> Containing_Index) < -1) {
      fprintf (stderr, "Too many exits from refractions\n");
      close_all();
      exit(1);
      }
   }
