/****************************************************************************
*                txtbump.c
*
*  This module implements solid texturing functions that perturb the surface
*  normal to create a bumpy effect. 
*  
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/
/*
   Some texture ideas garnered from SIGGRAPH '85 Volume 19 Number 3, 
   "An Image Synthesizer" By Ken Perlin.
   Further Ideas Garnered from "The RenderMan Companion" (Addison Wesley)
*/

#include "frame.h"
#include "vector.h"
#include "pvproto.h"
#include "texture.h"

extern unsigned short crctab[256];

void ripples (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   register int i;
   VECTOR point;
   register DBL length, scalar, index;

   if (Options & DEBUGGING)
      printf ("ripples %g %g %g", x, y, z);

   for (i = 0 ; i < NUMBER_OF_WAVES ; i++) {
      point.x = x;
      point.y = y;
      point.z = z;
      VSub (point, point, Wave_Sources[i]);
      VDot (length, point, point);
      if (length == 0.0)
         length = 1.0;

      length = sqrt(length);
      index = length*Texture->Frequency
                    + Texture -> Phase;
      scalar = cycloidal (index) * Texture -> Bump_Amount;

      if (Options & DEBUGGING)
         printf (" index %g scalar %g length %g\n", index, scalar, length);
      
      VScale (point, point, scalar/length/(DBL)NUMBER_OF_WAVES);
      VAdd (*normal, *normal, point);
      }
   VNormalize (*normal, *normal);
   }

void waves (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   register int i;
   VECTOR point;
   register DBL length, scalar, index, sinValue ;

   if (Options & DEBUGGING)
      printf ("waves %g %g %g\n", x, y, z);

   for (i = 0 ; i < NUMBER_OF_WAVES ; i++) {
      point.x = x;
      point.y = y;
      point.z = z;
      VSub (point, point, Wave_Sources[i]);
      VDot (length, point, point);
      if (length == 0.0)
         length = 1.0;

      length = sqrt(length);
      index = (length * Texture -> Frequency * frequency[i])
                   + Texture -> Phase;
      sinValue = cycloidal (index);

      scalar =  sinValue * Texture -> Bump_Amount /
                  frequency[i];
      VScale (point, point, scalar/length/(DBL)NUMBER_OF_WAVES);
      VAdd (*normal, *normal, point);
      }
   VNormalize (*normal, *normal);
   }


void bumps (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   VECTOR bump_turb;

   if (Texture -> Bump_Amount == 0.0)
      return;                            /* why are we here?? */

   if (Options & DEBUGGING)
      printf ("bumps %g %g %g\n", x, y, z);

   DNoise (&bump_turb, x, y, z);         /* Get Normal Displacement Val. */
   VScale(bump_turb, bump_turb, Texture->Bump_Amount);
   VAdd (*normal, *normal, bump_turb);   /* displace "normal" */
   VNormalize (*normal, *normal);        /* normalize normal! */
   return;
   }

/*
   dents is similar to bumps, but uses noise() to control the amount of
   dnoise() perturbation of the object normal...
*/

void dents (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   VECTOR stucco_turb;
   DBL noise;

   if (Texture -> Bump_Amount == 0.0)
      return;                           /* why are we here?? */

   noise = Noise (x, y, z);

   noise =  noise * noise * noise * Texture->Bump_Amount;

   if (Options & DEBUGGING)
      printf ("dents %g %g %g noise %g\n", x, y, z, noise);

   DNoise (&stucco_turb, x, y, z);       /* Get Normal Displacement Val. */
	
   VScale (stucco_turb, stucco_turb, noise);
   VAdd (*normal, *normal, stucco_turb); /* displace "normal" */
   VNormalize (*normal, *normal);        /* normalize normal! */
   return;
   }




/*
   Ideas garnered from the April 89 Byte Graphics Supplement on RenderMan,
   refined from "The RenderMan Companion, by Steve Upstill of Pixar, (C) 1990
   Addison-Wesley.
*/


/*
   wrinkles - This is my implementation of the dented() routine, using
   a surface iterative fractal derived from DTurbulence.  This is a 3-D vers.
   (thanks to DNoise()...) of the usual version using the singular Noise()...
   Seems to look a lot like wrinkles, however... (hmmm)
*/

void wrinkles (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   register int i;
   register DBL scale = 1.0;
   VECTOR result, value;

   if (Texture -> Bump_Amount == 0.0)
      return;                                /* why are we here?? */

   if (Options & DEBUGGING)
      printf ("wrinkles %g %g %g\n", x, y, z);

   result.x = 0.0;
   result.y = 0.0;
   result.z = 0.0;

   for (i = 0; i < 10 ; scale *= 2.0, i++)
      {
      DNoise(&value, x * scale, y * scale, z * scale);   /* * scale,*/
      result.x += FABS (value.x / scale);
      result.y += FABS (value.y / scale);
      result.z += FABS (value.z / scale);
      }

   VScale(result, result, Texture->Bump_Amount);
   VAdd (*normal, *normal, result);             /* displace "normal" */
   VNormalize (*normal, *normal);               /* normalize normal! */
   return;
   }
