/****************************************************************************
*                txttest.c
*
*  This module implements "fill-in-the-blank" pre-programmed texture 
*  functions for easy modification and testing. Create new textures here.
*  
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/
/*
   Some texture ideas garnered from SIGGRAPH '85 Volume 19 Number 3, 
   "An Image Synthesizer" By Ken Perlin.
   Further Ideas Garnered from "The RenderMan Companion" (Addison Wesley)
*/

#include "frame.h"
#include "vector.h"
#include "pvproto.h"
#include "texture.h"

/* Test new textures in the routines that follow */

/* The painted routines take an x,y,z point on an object and a pointer to the*/
/* object's texture description and return the color at that point           */
/* Similar routines are granite, agate, marble. See txtcolor.c for examples. */ 

void painted1 (x, y, z, Texture, colour)
   DBL x, y, z;
   TEXTURE *Texture;
   COLOUR *colour;
   {
   /* YOUR NAME HERE */
   VECTOR Colour_Vector;   
   
   if (Options & DEBUGGING)
      printf ("painted1 %g %g %g\n", x, y, z);
    
   DNoise(&Colour_Vector,x,y,z);
   colour ->Red += Colour_Vector.x;
   colour ->Green += Colour_Vector.y;
   colour ->Blue += Colour_Vector.z;
   return;
   }
void painted2 (x, y, z, Texture, colour)
   DBL x, y, z;
   TEXTURE *Texture;
   COLOUR *colour;
   {
   int brkindx;
   DBL turb;
   VECTOR TextureTurbulence;
   COLOUR Colour1, Colour2;
   
/* You could change the parser to take two colors after PAINTED2,           */
/* but since the colormap is already parsed it's easier to use it during    */
/* testing. If the texture works out right you can change the parser later. */
    if (Texture -> Colour_Map != NULL)
      {
      Compute_Colour (&Colour1, Texture->Colour_Map, 0.1);
      Compute_Colour (&Colour2, Texture->Colour_Map, 0.9);
      }
    else
      {
      Make_Colour (&Colour1, 1.0, 1.0, 1.0);
      Colour1.Alpha = 0.0;
      Make_Colour (&Colour2, 0.0, 1.0, 0.0);
      Colour2.Alpha = 0.0;
      }
      
   
   if ((turb = Texture->Turbulence) != 0.0)
      {
      DTurbulence (&TextureTurbulence, x, y, z);
      x += TextureTurbulence.x * turb;
      y += TextureTurbulence.y * turb;
      z += TextureTurbulence.z * turb;
      }
   
   brkindx = (int) FLOOR(x) + (int) FLOOR(z);

   if (Options & DEBUGGING)
      printf ("checker %g %g %g\n", x, y, z);

   if (brkindx & 1){
      colour->Red = Colour1.Red;
      colour->Green = Colour1.Green;
      colour->Blue = Colour1.Blue;
      colour->Alpha = Colour1.Alpha;
      }
   else{
      colour->Red = Colour2.Red;
      colour->Green = Colour2.Green;
      colour->Blue = Colour2.Blue;
      colour->Alpha = Colour2.Alpha;
    }
   return;
   
   ;
   }
void painted3 (x, y, z, Texture, colour)
   DBL x, y, z;
   TEXTURE *Texture;
   COLOUR *colour;
   {
   /* YOUR NAME HERE */
   ;
   }

/* The bumpy routines take a point on an object,  a pointer to the          */
/* object's texture description and the surface normal at that point and    */
/* return a peturb surface normal to create the illusion that the surface   */
/* has been displaced.                                                      */
/* Similar routines are ripples, dents, bumps. See txtbump.c for examples.  */ 

void bumpy1 (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   /* YOUR NAME HERE */
   
   }

void bumpy2 (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   /* YOUR NAME HERE */
   ;
   }
void bumpy3 (x, y, z, Texture, normal)
   DBL x, y, z;
   TEXTURE *Texture;
   VECTOR *normal;
   {
   ;
   }





































                                                                           
