/****************************************************************************
*                viewpnt.c
*
*  This module implements methods for managing the viewpoint.
*
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/

#include "frame.h"
#include "vector.h"
#include "pvproto.h"

METHODS Viewpoint_Methods =
   { NULL, NULL, NULL, NULL, Copy_Viewpoint,
     Translate_Viewpoint, Rotate_Viewpoint,
     Scale_Viewpoint, NULL};

void *Copy_Viewpoint (Object)
   OBJECT *Object;
   {
   VIEWPOINT *Viewpoint = (VIEWPOINT *) Object;
   VIEWPOINT *New_Viewpoint;

   New_Viewpoint = Get_Viewpoint();

   New_Viewpoint -> Location = Viewpoint -> Location;
   New_Viewpoint -> Direction = Viewpoint -> Direction;
   New_Viewpoint -> Right = Viewpoint -> Right;
   New_Viewpoint -> Up = Viewpoint -> Up;
   return (New_Viewpoint);
   }

void Translate_Viewpoint (Object, Vector)
   OBJECT *Object;
   VECTOR *Vector;
   {
   VAdd (((VIEWPOINT *) Object) -> Location, 
         ((VIEWPOINT *) Object) -> Location,
         *Vector);
   }

void Rotate_Viewpoint (Object, Vector)
   OBJECT *Object;
   VECTOR *Vector;
   {
   TRANSFORMATION Transformation;
   VIEWPOINT *Viewpoint = (VIEWPOINT *) Object;

   Get_Rotation_Transformation(&Transformation, Vector);
   MTransformVector (&(Viewpoint -> Location),
                     &(Viewpoint -> Location), &Transformation);

   MTransformVector (&(Viewpoint -> Direction),
                     &(Viewpoint -> Direction), &Transformation);

   MTransformVector (&(Viewpoint -> Up),
                     &(Viewpoint -> Up), &Transformation);

   MTransformVector (&(Viewpoint -> Right),
                     &(Viewpoint -> Right), &Transformation);
   }

void Scale_Viewpoint (Object, Vector)
   OBJECT *Object;
   VECTOR *Vector;
   {
   TRANSFORMATION Transformation;
   VIEWPOINT *Viewpoint = (VIEWPOINT *) Object;

   Get_Scaling_Transformation(&Transformation, Vector);
   MTransformVector (&(Viewpoint -> Location),
                     &(Viewpoint -> Location), &Transformation);

   MTransformVector (&(Viewpoint -> Direction),
                     &(Viewpoint -> Direction), &Transformation);

   MTransformVector (&(Viewpoint -> Up),
                     &(Viewpoint -> Up), &Transformation);

   MTransformVector (&(Viewpoint -> Right),
                     &(Viewpoint -> Right), &Transformation);
   }
