# Makefile for Persistence of Vision Raytracer 
# This file is released to the public domain.
#
#
# MAKE Macros and Such...
#

#***************************************************************
#*
#*                      Amiga Options
#*
#***************************************************************

# Uncomment for Amiga Lattice C for IEEE w/o coprocessor
CFLAGS	= -cusrft -fi -m0 -q5w5e -b0 -O -v

# Uncomment for Amiga Lattice C with 68881
#CFLAGS	= -cusrft -f8 -m2 -q5w5e -b0 -O -v

# Flags for debugging
#CFLAGS	= -cusrft -q5w5e -d5

LIBSIEEE	= lib:lcmieee.lib lib:lcnb.lib lib:amiga.lib
LIBS881	= lib:lcm881.lib lib:lcnb.lib lib:amiga.lib

OBJ	= o
MACHINE_OBJ	= amiga.$(OBJ)

PVOBJS = pvray.$(OBJ) render.$(OBJ) tokenize.$(OBJ) parse.$(OBJ) \
	  objects.$(OBJ) spheres.$(OBJ) quadrics.$(OBJ) lighting.$(OBJ) \
	  prioq.$(OBJ) texture.$(OBJ) matrices.$(OBJ) csg.$(OBJ)  hfield.$(OBJ)\
	  txtcolor.$(OBJ) txtbump.$(OBJ) txtmap.$(OBJ) txttest.$(OBJ) \
	  colour.$(OBJ) viewpnt.$(OBJ) ray.$(OBJ) planes.$(OBJ) iff.$(OBJ) \
	  gif.$(OBJ) gifdecod.$(OBJ) triangle.$(OBJ) raw.$(OBJ) dump.$(OBJ) \
	  targa.$(OBJ) poly.$(OBJ) bezier.$(OBJ) vect.$(OBJ) $(MACHINE_OBJ)


#  Amiga Linkage...
#
 pvrayieee: $(PVOBJS)
            blink <with <
            from lib:c.o $(PVOBJS) LIB $(LIBSIEEE) to pvrayieee
            <
                                                          
 pvray881: $(PVOBJS)
           blink <with <
           from lib:c.o $(PVOBJS) LIB $(LIBS881) to pvray881
           <
                                                          




pvray.$(OBJ) : pvray.c pvproto.h frame.h vector.h config.h

tokenize.$(OBJ) : tokenize.c pvproto.h frame.h config.h

parse.$(OBJ) : parse.c pvproto.h frame.h config.h

render.$(OBJ) : render.c pvproto.h frame.h vector.h config.h

lighting.$(OBJ) : lighting.c pvproto.h frame.h vector.h config.h

prioq.$(OBJ) : prioq.c pvproto.h frame.h config.h

texture.$(OBJ) : texture.c pvproto.h frame.h vector.h config.h texture.h

txtcolor.$(OBJ) : txtcolor.c pvproto.h frame.h vector.h config.h texture.h

txtbump.$(OBJ) : txtbump.c pvproto.h frame.h vector.h config.h texture.h

txtmap.$(OBJ) : txtmap.c pvproto.h frame.h vector.h config.h texture.h

txttest.$(OBJ) : txttest.c pvproto.h frame.h vector.h config.h texture.h

objects.$(OBJ) : objects.c pvproto.h frame.h vector.h config.h

spheres.$(OBJ) : spheres.c pvproto.h frame.h vector.h config.h

planes.$(OBJ) : planes.c pvproto.h frame.h vector.h config.h

quadrics.$(OBJ) : quadrics.c pvproto.h frame.h vector.h config.h

hfield.$(OBJ) : hfield.c pvproto.h frame.h vector.h config.h

poly.$(OBJ) : poly.c pvproto.h frame.h vector.h config.h

bezier.$(OBJ) : bezier.c pvproto.h frame.h vector.h config.h

vect.$(OBJ) : vect.c pvproto.h frame.h config.h

matrices.$(OBJ) : matrices.c pvproto.h frame.h vector.h config.h

csg.$(OBJ) : csg.c pvproto.h frame.h vector.h config.h

colour.$(OBJ) : colour.c pvproto.h frame.h config.h

viewpnt.$(OBJ) : viewpnt.c pvproto.h frame.h vector.h config.h

ray.$(OBJ) : ray.c pvproto.h frame.h vector.h config.h

iff.$(OBJ) : iff.c pvproto.h frame.h config.h

gif.$(OBJ) : gif.c pvproto.h frame.h config.h

gifdecod.$(OBJ) : gifdecod.c pvproto.h frame.h config.h

raw.$(OBJ) :	raw.c pvproto.h frame.h config.h

triangle.$(OBJ) : triangle.c pvproto.h frame.h vector.h config.h

amiga.$(OBJ) :	amiga.c pvproto.h frame.h config.h

dump.$(OBJ) :	dump.c pvproto.h frame.h config.h
