/****************************************************************************
*                   amigaconf.h
*
*  This module contains Amiga-specific defines, types, and other declarations.
*  Rename to config.h when compiling for Amiga.
*  from Persistence of Vision Raytracer 
*  Copyright 1991 Persistence of Vision Team
*---------------------------------------------------------------------------
*                       *IMPORTANT!*
*  This copyrighted software is freely distributable. The source and/or
* object code may be copied or uploaded to communications services so long as
* this notice remains at the top of each file.
* 
*  If any changes are made to the program, you must clearly indicate in the
* documentation and in the program startup message who it was who made the
* changes. The documentation should also describe what those changes were.
* 
*  This software may not be included in whole or in part into any commercial
* package without the express written consent of the PV-Team. It may,
* however, be included in other freely distributed software so long as proper
* credit for the software is given. No more than five dollars U.S. ($5) can
* be charged for the copying of this software and the media it is provided on,
* i.e. a shareware distribution company may only charge five U.S dollars or
* less for providing this software.
* 
*  This software is provided as is without any guarantees or warranty.
* Although the authors have attempted to find and correct any bugs in the
* software, they are not responsible for any damage caused by the use of the
* software. The authors are under no obligation to provide service,
* corrections, or upgrades to this package.
*-----------------------------------------------------------------------------
*  Despite all the legal stuff above, if you have any problems with the
* program the PV-Team would like to hear about them. Also, if you have any
* comments, questions or enhancements, please contact the PV-Team on the
* Compuserve Online Service in the COMART forum message section 16 (!GO
* COMART). The CIS COMART forum is devoted to computer generated artwork like
* raytracing, animation and fractals. For more information regarding the PV
* team see the file PVINF.TXT. For more information on Compuserve call
* (in the U.S.) 1-800-848-8990.
* 
*       Drew Wells
*       PV-Team Leader
*       CIS: 73767,1244
* 
* 
*  This program is based on the popular DKB raytracer version 2.12 written by
* David Buck, a PV-Team member.
*  (David Buck CIS: 70521,1371 Internet: dbuck@ccs.carleton.ca)
* 
*****************************************************************************/


/* The following defines may be added when porting to other systems or
   other compilers.  The defaults are shown here:


   #define PARAMS(x) x                   - use 'x' for ANSI, '()' for non ANSI
   #define EPSILON 1.0e-5                - a small value used for quartics
   #define FILE_NAME_LENGTH 150          - default file name length
   #define DBL double                    - floating point precision
   #define HUGE_VAL 1.0e+17              - a really big number
   #define MAXPOW 32			 - Highest power polynomial allowed
   #define DBL_FORMAT_STRING "%lf"       - the string to use for scanfs of doubles
   #define DEFAULT_OUTPUT_FORMAT  'd'    - the default +f format
   #define TEST_ABORT                    - code to test for ^C or abort
                                           (called on each pixel)
   #define RED_RAW_FILE_EXTENSION ".red" - for +fr, this is the extension for the
                                           red file
   #define GREEN_RAW_FILE_EXTENSION ".grn"  - ditto for the green file
   #define BLUE_RAW_FILE_EXTENSION ".blu"   - ditto again for the blue file
   #define STARTUP_PVRAY             - first executable statement of main
                                           (useful for initialization)
   #define PRINT_OTHER_CREDITS           - used for people who extend the machine specific module
                                           (put your own printf's here)
   #define FINISH_PVRAY              - last statement before exiting normally
   #define FILENAME_SEPARATOR "/"        - the character that separates names
                                           in a path.
   #define setvbuf(w,x,y,z)              - some systems don't understand setvbuf.
                                           If not, just define it away - it's
                                           not critical to the raytracer.  It
                                           just buffers disk accesses.
*/

/* For the Amiga, we can use ANSI prototype definitions. */
#include <dos.h>

#define ACOS acos
#define SQRT sqrt
#define POW pow
#define COS cos
#define SIN sin
#define EPSILON 1.0e-5

#define PARAMS(x) x
void main (int, char**);
void exit(int);
void *malloc(int);
void free(void *);

extern int _bufsiz;

int amiga_close_all(void);

extern char *getenv PARAMS((char *str));
void amiga_init_PVRAY PARAMS((void));
#define STARTUP_PVRAY amiga_init_PVRAY();
#define TEST_ABORT chkabort();

/* defines for special binary (raw, uncooked) modes of fopen() */
#define READ_FILE_STRING "rb"
#define WRITE_FILE_STRING "wb"
#define APPEND_FILE_STRING "ab"

/* defines for machine-specific PaletteOption settings */
#define NORMAL '0'
#define GREY   'G'


/* Trace Timer Macro */
#define START_TIME time(&tstart);     /* Defined for most "flavors" of C */
#define STOP_TIME  time(&tstop);
#define TIME_ELAPSED (tstop - tstart);        /* Not supported in some versions         */
                                              /* of C. Can be replaced with:            */ 
/* #define TIME_ELAPSED difftime (tstop, tstart);                                       */
                                              /* in some cases. If time is completely   */
                                              /* unsupported define them as 0.          */
