# Makefile for Persistence of Vision Raytracer 
# This file is released to the public domain.
#
#
# MAKE Macros and Such...
#


#***************************************************************
#*
#*                      IBM Options
#*
#***************************************************************

# Note for the IBM Version:
# Uses system environment variable LIB for the linker's .LIB file path.
# (Example:  Set LIB=C:\LIB)  if you change this the two .LNK files will also
# need to be changed as well.  The system environment variable CMODEL also
# may be defined for the memory model of the compiler.  PV-Ray requires
# the "Large" memory model.  (Example Set CMODEL=l)  If you don't want to
# use the DOS environment variables, uncomment the following two lines:

CMODEL	=l
LIB	=d:\tc\lib

CC	=tcc
OBJ	=obj
MACHINE_OBJ	= ibm.$(OBJ)

# Uncomment Turbo Link for Symbolic Debugging, or use DOS/MS-LINK for
# faster .EXE execution speed (shame on you, Borland, for no FARCALL!...)
# Note: you also must use a -v in the CFLAGS rather than -v- if you want
# to use the symbolic debugging facilities of Turbo-Debug.

TLINK	=tlink /l/v
#TLINK	=link /EXEPACK /PACKCODE /FARCALL
#
# IBM (Turbo-MAKE, actually) Specific MAKE Directives:
#
#
# Uncomment This for No Numeric Data Processor Extension (No Math Co)
#LINKFLAGS=$(LIB)\emu+$(LIB)\math$(CMODEL)+$(LIB)\c$(CMODEL);
#
# Uncomment This for NDP Extension (80x87 Co-Processor) Support
LINKFLAGS=$(LIB)\fp87+$(LIB)\math$(CMODEL)+$(LIB)\c$(CMODEL);
#

# Uncomment for 8086/8088 instruction set usage
#
#CFLAGS	=-m$(CMODEL) -r -K -G -O -Z -d -c -v- -k- -N- -DTURBOC


# Uncomment for 80186/80268 (incl. V20!) instruction set usage
#
CFLAGS	=-m$(CMODEL) -1 -f287 -a -r -K -G -O -Z -d -c -v- -k- -N- -DTURBOC

# Turbo-MAKE's implicit rules for making a .OBJ file from a .C file...
#
.c.obj :
 $(CC) $(CFLAGS) $*

# Generic "Unix" MAKE's implicit rules for making an .OBJ file from a .C file
#
#*.obj : *.c
# $(CC) $(CFLAGS) $*


#***************************************************************
#*
#*                          Common  Stuff
#*
#***************************************************************

PVOBJS = pvray.$(OBJ) render.$(OBJ) tokenize.$(OBJ) parse.$(OBJ) \
	  objects.$(OBJ) spheres.$(OBJ) quadrics.$(OBJ) lighting.$(OBJ) \
	  prioq.$(OBJ) texture.$(OBJ) matrices.$(OBJ) csg.$(OBJ) hfield.$(OBJ) \
	  txtcolor.$(OBJ) txtbump.$(OBJ) txtmap.$(OBJ) txttest.$(OBJ) \
	  colour.$(OBJ) viewpnt.$(OBJ) ray.$(OBJ) planes.$(OBJ) iff.$(OBJ) \
	  gif.$(OBJ) gifdecod.$(OBJ) triangle.$(OBJ) raw.$(OBJ) dump.$(OBJ) \
	  targa.$(OBJ) poly.$(OBJ) bezier.$(OBJ) vect.$(OBJ) $(MACHINE_OBJ)


# IBM Linkage...
#
pvray.exe : $(PVOBJS)
	$(TLINK) @ibmtc.lnk

#pvno87.exe.exe : $(PVOBJS)
#$(TLINK) @ibmtc.lnk

#
# Specific module/header dependencies for PV-Ray:
#

pvray.$(OBJ) : pvray.c pvproto.h frame.h vector.h config.h

tokenize.$(OBJ) : tokenize.c pvproto.h frame.h config.h

parse.$(OBJ) : parse.c pvproto.h frame.h config.h

render.$(OBJ) : render.c pvproto.h frame.h vector.h config.h

lighting.$(OBJ) : lighting.c pvproto.h frame.h vector.h config.h

prioq.$(OBJ) : prioq.c pvproto.h frame.h config.h

texture.$(OBJ) : texture.c pvproto.h frame.h vector.h config.h texture.h

txtcolor.$(OBJ) : txtcolor.c pvproto.h frame.h vector.h config.h texture.h

txtbump.$(OBJ) : txtbump.c pvproto.h frame.h vector.h config.h texture.h

txtmap.$(OBJ) : txtmap.c pvproto.h frame.h vector.h config.h texture.h

txttest.$(OBJ) : txttest.c pvproto.h frame.h vector.h config.h texture.h

objects.$(OBJ) : objects.c pvproto.h frame.h vector.h config.h

spheres.$(OBJ) : spheres.c pvproto.h frame.h vector.h config.h

planes.$(OBJ) : planes.c pvproto.h frame.h vector.h config.h

quadrics.$(OBJ) : quadrics.c pvproto.h frame.h vector.h config.h

hfield.$(OBJ) : hfield.c pvproto.h frame.h vector.h config.h

poly.$(OBJ) : poly.c pvproto.h frame.h vector.h config.h

bezier.$(OBJ) : bezier.c pvproto.h frame.h vector.h config.h

vect.$(OBJ) : vect.c pvproto.h frame.h config.h

matrices.$(OBJ) : matrices.c pvproto.h frame.h vector.h config.h

csg.$(OBJ) : csg.c pvproto.h frame.h vector.h config.h

colour.$(OBJ) : colour.c pvproto.h frame.h config.h

viewpnt.$(OBJ) : viewpnt.c pvproto.h frame.h vector.h config.h

ray.$(OBJ) : ray.c pvproto.h frame.h vector.h config.h

iff.$(OBJ) : iff.c pvproto.h frame.h config.h

gif.$(OBJ) : gif.c pvproto.h frame.h config.h

gifdecod.$(OBJ) : gifdecod.c pvproto.h frame.h config.h

raw.$(OBJ) :	raw.c pvproto.h frame.h config.h

triangle.$(OBJ) : triangle.c pvproto.h frame.h vector.h config.h

ibm.$(OBJ) :	ibm.c pvproto.h frame.h config.h
