# IBM Makefile for Persistence of Vision Raytracer
# This file is released to the public domain.
#
# Note for the IBM Version:
# Uses system environment variable LIB for the linker's .LIB file path.
# (Example:  Set LIB=C:\LIB)  if you change this the two .LNK files will also
# need to be changed as well.  The system environment variable CMODEL also
# may be defined for the memory model of the compiler.  PV-Ray requires
# the "Large" memory model.  (Example Set CMODEL=l)  If you don't want to
# use the DOS environment variables, uncomment the following two lines:
#
#
# MAKE Macros and Such...
#

CMODEL	=l
#LIB	=c:\lib
CC	=wccp
OBJ	=obj
MACHINE_OBJ	= ibm.$(OBJ)

LINKER	=tlink

# Uncomment for 8086/8088 instruction set usage
#
#CFLAGS	=-m$(CMODEL) -fpi -d2 -s -zc

# Uncomment for 80186/80268 (incl. V20!) instruction set usage	[/Gmsr2]
#
CFLAGS	=-m$(CMODEL) -7 -2 -d2 -s -zc

# If you have OS/2 to compile under, fix directory name and add this option
# to CFLAGS above...
#
# /B2 C:\msc\c2l.exe
#

# MS's NMAKE implicit rules for making an .OBJ file from a .C file...
#
# The second command converts debugging info from Watcom's to Turbo Debugger's
#
.c.obj :
	$(CC) $(CFLAGS) -oxat $*.c
	w2td $*.obj

# The option:
#
# /Oaxz
#
# Is purported by Microsoft to produce the fastest possible code.  In fact it
# will break the RGB->HSV->RGB routines in IBM.C, if using the 8087 emulator.
# So, for IBM.C we are using:
#
# /Ogiltaz
#
# This optimization string works for IBM.C and should then have worked for all
# files, but, somehow, it BREAKS the compiler! (Internal compiler error C1001
# on TEXTURE.C!!)  Oh, well...
#

PVOBJS = pvray.$(OBJ) render.$(OBJ) tokenize.$(OBJ) parse.$(OBJ) \
	  objects.$(OBJ) spheres.$(OBJ) quadrics.$(OBJ) lighting.$(OBJ) \
	  prioq.$(OBJ) texture.$(OBJ) matrices.$(OBJ) csg.$(OBJ) hfield.$(OBJ) \
	  colour.$(OBJ) viewpnt.$(OBJ) ray.$(OBJ) planes.$(OBJ) iff.$(OBJ) \
	  gif.$(OBJ) gifdecod.$(OBJ) triangle.$(OBJ) raw.$(OBJ) dump.$(OBJ) \
	  targa.$(OBJ) poly.$(OBJ) bezier.$(OBJ) vect.$(OBJ) $(MACHINE_OBJ)

# PV-Ray Specific Dependencies
#
pvray.exe : $(PVOBJS)
	$(LINKER) @ibmwat.lnk

pvray.$(OBJ) : pvray.c pvproto.h frame.h vector.h config.h

tokenize.$(OBJ) : tokenize.c pvproto.h frame.h config.h

parse.$(OBJ) : parse.c pvproto.h frame.h config.h

render.$(OBJ) : render.c pvproto.h frame.h vector.h config.h

lighting.$(OBJ) : lighting.c pvproto.h frame.h vector.h config.h

prioq.$(OBJ) : prioq.c pvproto.h frame.h config.h

texture.$(OBJ) : texture.c pvproto.h frame.h vector.h config.h texture.h

txtcolor.$(OBJ) : txtcolor.c pvproto.h frame.h vector.h config.h texture.h

txtbump.$(OBJ) : txtbump.c pvproto.h frame.h vector.h config.h texture.h

txtmap.$(OBJ) : txtmap.c pvproto.h frame.h vector.h config.h texture.h

txttest.$(OBJ) : txttest.c pvproto.h frame.h vector.h config.h texture.h

objects.$(OBJ) : objects.c pvproto.h frame.h vector.h config.h

spheres.$(OBJ) : spheres.c pvproto.h frame.h vector.h config.h

planes.$(OBJ) : planes.c pvproto.h frame.h vector.h config.h

hfield.$(OBJ) : hfield.c pvproto.h frame.h vector.h config.h

quadrics.$(OBJ) : quadrics.c pvproto.h frame.h vector.h config.h

poly.$(OBJ) : poly.c pvproto.h frame.h vector.h config.h

bezier.$(OBJ) : bezier.c pvproto.h frame.h vector.h config.h

vect.$(OBJ) : vect.c pvproto.h frame.h config.h

matrices.$(OBJ) : matrices.c pvproto.h frame.h vector.h config.h

csg.$(OBJ) : csg.c pvproto.h frame.h vector.h config.h

colour.$(OBJ) : colour.c pvproto.h frame.h config.h

viewpnt.$(OBJ) : viewpnt.c pvproto.h frame.h vector.h config.h

ray.$(OBJ) : ray.c pvproto.h frame.h vector.h config.h

iff.$(OBJ) : iff.c pvproto.h frame.h config.h

gif.$(OBJ) : gif.c pvproto.h frame.h config.h

gifdecod.$(OBJ) : gifdecod.c pvproto.h frame.h config.h

raw.$(OBJ) : raw.c pvproto.h frame.h config.h

dump.$(OBJ) : dump.c pvproto.h frame.h config.h

targa.$(OBJ) : targa.c pvproto.h frame.h config.h

triangle.$(OBJ) : triangle.c pvproto.h frame.h vector.h config.h

ibm.$(OBJ) : ibm.c pvproto.h frame.h config.h
