# Makefile for Persistence of Vision Raytracer 
# This file is released to the public domain.
#
#
# MAKE Macros and Such...
#

#***************************************************************
#*
#*                      UNIX Makefile
#*
#***************************************************************

# The exact options may depend on your compiler.  Feel free to modify
# these as required.
OBJ	= o
MACHINE_OBJ	= unix.$(OBJ)
CFLAGS=		-c -O
LFLAGS =	-o pvray -O

# Make's implicit rules for making a .o file from a .c file...
#
.c.o :
	$(CC) $(CFLAGS) $*.c


PVOBJS = pvray.$(OBJ) render.$(OBJ) tokenize.$(OBJ) parse.$(OBJ) \
	  objects.$(OBJ) spheres.$(OBJ) quadrics.$(OBJ) lighting.$(OBJ) \
	  prioq.$(OBJ) texture.$(OBJ) matrices.$(OBJ) csg.$(OBJ) hfield.$(OBJ)\
	  txtcolor.$(OBJ) txtbump.$(OBJ) txtmap.$(OBJ) txttest.$(OBJ) \
	  colour.$(OBJ) viewpnt.$(OBJ) ray.$(OBJ) planes.$(OBJ) iff.$(OBJ) \
	  gif.$(OBJ) gifdecod.$(OBJ) triangle.$(OBJ) raw.$(OBJ) dump.$(OBJ) \
	  targa.$(OBJ) poly.$(OBJ) bezier.$(OBJ) vect.$(OBJ) $(MACHINE_OBJ)


pvray:	$(PVOBJS)
	cc $(LFLAGS) $(PVOBJS) -lm

pvray.$(OBJ) : pvray.c pvproto.h frame.h vector.h config.h

tokenize.$(OBJ) : tokenize.c pvproto.h frame.h config.h

parse.$(OBJ) : parse.c pvproto.h frame.h config.h

render.$(OBJ) : render.c pvproto.h frame.h vector.h config.h

lighting.$(OBJ) : lighting.c pvproto.h frame.h vector.h config.h

prioq.$(OBJ) : prioq.c pvproto.h frame.h config.h

texture.$(OBJ) : texture.c pvproto.h frame.h vector.h config.h texture.h

txtcolor.$(OBJ) : txtcolor.c pvproto.h frame.h vector.h config.h texture.h

txtbump.$(OBJ) : txtbump.c pvproto.h frame.h vector.h config.h texture.h

txtmap.$(OBJ) : txtmap.c pvproto.h frame.h vector.h config.h texture.h

txttest.$(OBJ) : txttest.c pvproto.h frame.h vector.h config.h texture.h

objects.$(OBJ) : objects.c pvproto.h frame.h vector.h config.h

spheres.$(OBJ) : spheres.c pvproto.h frame.h vector.h config.h

planes.$(OBJ) : planes.c pvproto.h frame.h vector.h config.h

poly.$(OBJ) : poly.c pvproto.h frame.h vector.h config.h

hfield.$(OBJ) : hfield.c pvproto.h frame.h vector.h config.h

bezier.$(OBJ) : bezier.c pvproto.h frame.h vector.h config.h

vect.$(OBJ) : vect.c pvproto.h frame.h config.h

quadrics.$(OBJ) : quadrics.c pvproto.h frame.h vector.h config.h

matrices.$(OBJ) : matrices.c pvproto.h frame.h vector.h config.h

csg.$(OBJ) : csg.c pvproto.h frame.h vector.h config.h

colour.$(OBJ) : colour.c pvproto.h frame.h config.h

viewpnt.$(OBJ) : viewpnt.c pvproto.h frame.h vector.h config.h

ray.$(OBJ) : ray.c pvproto.h frame.h vector.h config.h

iff.$(OBJ) : iff.c pvproto.h frame.h config.h

gif.$(OBJ) : gif.c pvproto.h frame.h config.h

gifdecod.$(OBJ) : gifdecod.c pvproto.h frame.h config.h

raw.$(OBJ) :	raw.c pvproto.h frame.h config.h

triangle.$(OBJ) : triangle.c pvproto.h frame.h vector.h config.h

amiga.$(OBJ) :	amiga.c pvproto.h frame.h config.h

dump.$(OBJ) :	dump.c pvproto.h frame.h config.h
