/*  Tweaked mode 256 color demo program for Turbo C */
/*      By: Thomas Design             */
/*      Oct 13, 1989                  */

#include <math.h>
#include <graphics.h>
#include <alloc.h>
#include <stdlib.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include "TWK256.H"
#include "TWKDET.H"
#include "VGAEXTRA.H"

#define   TRUE         1
#define   FALSE        0

#define   TOPHIT       0
#define   LEFTHIT      1
#define   BOTTOMHIT    2
#define   RIGHTHIT     3

typedef struct {
  int   xl;                          /* rectangle structure type */
  int   yl;
  int   xr;
  int   yr;
 } rect;

typedef struct {                       /* point structure type */
  int   x;
  int   y;
 } point;

  int    g_driver,  g_mode, g_error;
  int    Bwide0, Btall0;
  int    Iwide0, Itall0;
  int    Iwide1, Itall1;
  int    Iwide2, Itall2;
  int    Iwide3, Itall3;
  int    Iwide4, Itall4;
  int    Delay;
  int    BallXmag =  4;                /* magnitude of ball X component */
  int    BallYmag = -4;                /* magnitude of ball Y component */
  rect   Image0;
  rect   Image1;
  rect   Image2;
  rect   Image3;
  rect   Image4;
  rect   ImageP0,ImageP1,ImageP2,ImageP3,ImageP4;
  rect   BallOldLoc;                   /* current location of ball */
  rect   BallNewLoc;                   /* new position of ball */
  rect   PlayField0;
  rect   PlayField1;
  rect   PlayField2;
  rect   PlayField3;
  rect   PlayField4;
  DACarray Palette_Array;              /* create array to hold DAC values */
  char  *BackPtr0;
  char  *ImagePtr0;
  char  *ImagePtr1;
  char  *ImagePtr2;
  char  *ImagePtr3;
  char  *ImagePtr4;

  char  *ImageB0Ptr0,*ImageB1Ptr0;
  char  *ImageB0Ptr1,*ImageB1Ptr1;
  char  *ImageB0Ptr2,*ImageB1Ptr2;
  char  *ImageB0Ptr3,*ImageB1Ptr3;
  char  *ImageB0Ptr4,*ImageB1Ptr4;

  char   BFileName[20];
  char   MFileName[20];

  void      interrupt (*OldVector)();  /* 32 bit pointer to old timer tic vector */
  unsigned  ImageDelay = 0;            /* incremented by 10*18.2 times/sec timer */

/*---------------------------Install-Interrupt-Vector-------------*/
void InstallTimer(void interrupt (*faddr)())
{
    OldVector = getvect(0x1c);         /* get old timer tic vector */
    setvect(0x1c,faddr);               /* set old timer tic vector to C routine */
}

/*---------------------------Remove--Interrupt-Vector-------------*/
void RemoveTimer(void)
{
    setvect(0x1c,OldVector);           /* reload old timer tic vector */
}

/*------------------- 10 times 18.2/sec clock tic -----------------------*/
void interrupt TimerTic(void)
{
    ++ImageDelay;
}

int c_break(void)
{
    restorecrtmode();
    RemoveTimer();
    printf("Program terminated.\n");
    exit(2);
    return(0);
}

/*----------------- Coordinate manipulation routines -----------------------*/
void SetPoint(point *PointPtr,int X,int Y)
{
    PointPtr -> x = X;
    PointPtr -> y = Y;
}

void DupPoint(point *Point1Ptr,point *Point2Ptr)
{
    memcpy(Point1Ptr,Point2Ptr,sizeof(point));
}

int PntRect(point *PointPtr,rect *RectPtr)
{
    if ((PointPtr->x > RectPtr->xl) && (PointPtr->x < RectPtr->xr))
         if ((PointPtr->y > RectPtr->yl) && (PointPtr->y < RectPtr->yr))
              return(TRUE);
    return(FALSE);
}

int RectBounceRect(rect *SourcePtr,rect *TargetPtr)
{
  int temp;
    if (SourcePtr->xr <= TargetPtr->xl) temp = LEFTHIT;
    if (SourcePtr->xl >= TargetPtr->xr) temp = RIGHTHIT;
    if (SourcePtr->yl >= TargetPtr->yr) temp = BOTTOMHIT;
    if (SourcePtr->yr <= TargetPtr->yl) temp = TOPHIT;
    return(temp);
}

int RectIntersectRect(rect *SourcePtr,rect *TargetPtr)
{
    if ((SourcePtr->xr >= TargetPtr->xl) && (SourcePtr->xl <= TargetPtr->xr))
        if ((SourcePtr->yr >= TargetPtr->yl) && (SourcePtr->yl <= TargetPtr->yr))
             return(TRUE);
    return(FALSE);
}

int RectInsideRect(rect *SourcePtr,rect *TargetPtr)
{
    if ((SourcePtr->xr <= TargetPtr->xr) && (SourcePtr->xl >= TargetPtr->xl))
        if ((SourcePtr->yr <= TargetPtr->yr) && (SourcePtr->yl >= TargetPtr->yl))
             return(TRUE);
    return(FALSE);
}

void SetRect(rect *RectPtr,int X1,int Y1,int X2,int Y2)
{
    RectPtr -> xl = X1;
    RectPtr -> yl = Y1;
    RectPtr -> xr = X2;
    RectPtr -> yr = Y2;
}

void DupRect(rect *Rect1Ptr,rect *Rect2Ptr)
{
    memcpy(Rect2Ptr,Rect1Ptr,sizeof(rect));
}

void Read_Pal(char *FileName)
{
  FILE  *PaletteFile;
    PaletteFile = fopen(FileName,"rb");
    if (PaletteFile == NULL) {
       restorecrtmode();
       printf("Unable to open image palette.\n");
       exit(1);
    }
    fread(Palette_Array,1,256*3,PaletteFile);
    fclose(PaletteFile);
    dacpalette(Palette_Array);
}

unsigned Read_Image(char *FileName,char **ImagePtr, int *Iwide,int *Itall)
{
  FILE  *ImageFile;
  unsigned  Image_Size;
  unsigned  Image_Width;
  unsigned  Image_Height;
  long ImagePos;
    ImageFile = fopen(FileName,"rb");
    if (ImageFile == NULL) {
       restorecrtmode();
       printf("Unable to open image!\n");
       exit(1);
    }
    ImagePos = ftell(ImageFile);
    fread(&Image_Width,1,sizeof(int),ImageFile);
    fread(&Image_Height,1,sizeof(int),ImageFile);
    *Iwide = (getmaxx() / 2) - (Image_Width / 2);
    *Itall = (getmaxy() / 2) - (Image_Height / 2);
    Image_Size = imagesize(0,0,Image_Width,Image_Height);
    *ImagePtr   = malloc(Image_Size);
    if (*ImagePtr == NULL) {
       restorecrtmode();
       printf("Unable to allocate enough memory for image!\n");
       exit(1);
    }
    fseek(ImageFile,ImagePos,SEEK_SET);
    fread(*ImagePtr,1,Image_Size,ImageFile);
    fclose(ImageFile);
    return(Image_Size);
}

void Get_Image_Data(void)
{
  char Temp[20];
  unsigned Isize;
    strcpy(Temp,BFileName);
    strcat(Temp,".pal");
    Read_Pal(Temp);
    strcpy(Temp,BFileName);
    strcat(Temp,".0");
    Read_Image(Temp,&BackPtr0,&Bwide0,&Btall0);
    strcpy(Temp,MFileName);
    strcat(Temp,".0");
    Isize = Read_Image(Temp,&ImagePtr0,&Iwide0,&Itall0);
    SetRect(&Image0,Iwide0,Itall0,Iwide0+ImagePtr0[0],Itall0+ImagePtr0[2]);
    ImageB0Ptr0 = malloc(Isize);
    ImageB1Ptr0 = malloc(Isize);
    if ((ImageB0Ptr0 == NULL) || (ImageB1Ptr0 == NULL)) {
       restorecrtmode();
       printf("Unable to allocate enough memory for image!\n");
       exit(1);
    }
    strcpy(Temp,MFileName);
    strcat(Temp,".1");
    Isize = Read_Image(Temp,&ImagePtr1,&Iwide1,&Itall1);
    SetRect(&Image1,Iwide1,Itall1,Iwide1+ImagePtr1[0],Itall1+ImagePtr1[2]);
    ImageB0Ptr1 = malloc(Isize);
    ImageB1Ptr1 = malloc(Isize);
    if ((ImageB0Ptr1 == NULL) || (ImageB1Ptr1 == NULL)) {
       restorecrtmode();
       printf("Unable to allocate enough memory for image!\n");
       exit(1);
    }
    strcpy(Temp,MFileName);
    strcat(Temp,".2");
    Isize = Read_Image(Temp,&ImagePtr2,&Iwide2,&Itall2);
    SetRect(&Image2,Iwide2,Itall2,Iwide2+ImagePtr2[0],Itall2+ImagePtr2[2]);
    ImageB0Ptr2 = malloc(Isize);
    ImageB1Ptr2 = malloc(Isize);
    if ((ImageB0Ptr2 == NULL) || (ImageB1Ptr2 == NULL)) {
       restorecrtmode();
       printf("Unable to allocate enough memory for image!\n");
       exit(1);
    }
    strcpy(Temp,MFileName);
    strcat(Temp,".3");
    Isize = Read_Image(Temp,&ImagePtr3,&Iwide3,&Itall3);
    SetRect(&Image3,Iwide3,Itall3,Iwide3+ImagePtr3[0],Itall3+ImagePtr3[2]);
    ImageB0Ptr3 = malloc(Isize);
    ImageB1Ptr3 = malloc(Isize);
    if ((ImageB0Ptr3 == NULL) || (ImageB1Ptr3 == NULL)) {
       restorecrtmode();
       printf("Unable to allocate enough memory for image!\n");
       exit(1);
    }
    strcpy(Temp,MFileName);
    strcat(Temp,".4");
    Isize = Read_Image(Temp,&ImagePtr4,&Iwide4,&Itall4);
    SetRect(&Image4,Iwide4,Itall4,Iwide4+ImagePtr4[0],Itall4+ImagePtr4[2]);
    ImageB0Ptr4 = malloc(Isize);
    ImageB1Ptr4 = malloc(Isize);
    if ((ImageB0Ptr4 == NULL) || (ImageB1Ptr4 == NULL)) {
       restorecrtmode();
       printf("Unable to allocate enough memory for image!\n");
       exit(1);
    }
}

void Display_Images(void)
{
  int  Vpage;
  int  Xmov,Ymov;
    Get_Image_Data();                  /* get palette and images */
    setactivepage(0);
    setvisualpage(0);
    putimage(Bwide0,Btall0,BackPtr0,COPY_PUT);
    setactivepage(1);
    putimage(Bwide0,Btall0,BackPtr0,COPY_PUT);
    setactivepage(2);
    putimage(Bwide0,Btall0,BackPtr0,COPY_PUT);
    setactivepage(3);
    putimage(Bwide0,Btall0,BackPtr0,COPY_PUT);
    free(BackPtr0);
    setactivepage(0);
    Vpage = 0;
    Xmov = -1;
    Ymov = +1;
    while (!kbhit()) {
        ImageDelay = 0;
        getimage(Image0.xl,Image0.yl,Image0.xr,Image0.yr,ImageB0Ptr0);
        putimage(Image0.xl,Image0.yl,ImagePtr0,NOT_PUT);
        setactivepage(1);
        getimage(Image0.xl,Image0.yl,Image0.xr,Image0.yr,ImageB1Ptr0);
        putimage(Image0.xl,Image0.yl,ImagePtr0,NOT_PUT);
        do { } while (ImageDelay < Delay);
        ImageDelay = 0;
        setvisualpage(1);
        setactivepage(0);
        putimage(Image0.xl,Image0.yl,ImageB0Ptr0,COPY_PUT);

    }
    free(ImagePtr0); free(ImageB0Ptr0); free(ImageB1Ptr0);
    free(ImagePtr1); free(ImageB0Ptr1); free(ImageB1Ptr1);
    free(ImagePtr2); free(ImageB0Ptr2); free(ImageB1Ptr2);
    free(ImagePtr3); free(ImageB0Ptr3); free(ImageB1Ptr3);
    free(ImagePtr4); free(ImageB0Ptr4); free(ImageB1Ptr4);
    getch();
}

void main(int argc,char *argv[])
{
    if ((argc != 3) && (argc != 4)) {
       printf("Format is: 3dmovie Bfile Mfile delay\n");
       printf("\t Bfile  - background image (no extension)\n");
       printf("\t Mfile  - moving image (no extension)\n");
       printf("\t delay    (2 to 15)\n");
       exit(1);
    }
    strcpy(BFileName,argv[1]);
    if (strchr(BFileName,'.') != NULL) {
       printf("Don't include the extension!\n");
       exit(1);
    }
    strcpy(MFileName,argv[2]);
    if (strchr(MFileName,'.') != NULL) {
       printf("Don't include the extension!\n");
       exit(1);
    }
    if (argc == 4) Delay = atoi(argv[3]); else Delay = 3;
    if ((Delay < 2) || (Delay > 15)) {
       printf("Invalid delay time: range = 2 to 15\n");
       exit(1);
    }
    ctrlbrk(c_break);
    InstallTimer(TimerTic);
    installuserdriver("TWK256",DetectTWK256);
    registerbgidriver(TWK256_driver);
    g_driver = DETECT;                 /* must have this line to use User Driver */
    initgraph(&g_driver,&g_mode,"");
    g_error = graphresult();
    if (g_error != 0) {
       printf("%s \n",grapherrormsg(g_error));
       exit(1);
    }
    Display_Images();
    RemoveTimer();
    restorecrtmode();
}
