/*  Tweaked mode 256 color demo program for Turbo C */
/*      By: Thomas Design             */
/*      Oct 13, 1989                  */

#include <math.h>
#include <graphics.h>
#include <alloc.h>
#include <stdlib.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include "TWK256.H"
#include "TWKDET.H"
#include "VGAEXTRA.H"

  int    g_driver,  g_mode, g_error;
  int    BaseIndex,ShiftIndex;
  DACarray PalBase;             /* create array to hold DAC values */
  DACarray PalShift;            /* create array to hold DAC values */

  unsigned ImageSize0;
  unsigned ImageSize1;
  unsigned ImageSize2;
  unsigned ImageSize3;
  unsigned ImageSize4;

  char  *ImagePtr0;
  char  *ImagePtr1;
  char  *ImagePtr2;
  char  *ImagePtr3;
  char  *ImagePtr4;

  char   BFileName[20];
  char   SFileName[20];

  char   Ifile0[20];
  char   Ifile1[20];
  char   Ifile2[20];
  char   Ifile3[20];
  char   Ifile4[20];

void Read_Pal(DACarray *Pal,char *FileName)
{
  FILE  *PaletteFile;
    PaletteFile = fopen(FileName,"rb");
    if (PaletteFile == NULL) {
       printf("Unable to open image palette.\n");
       exit(1);
    }
    fread(Pal,1,256*3,PaletteFile);
    fclose(PaletteFile);
}

void Write_Pal(DACarray *Pal,char *FileName)
{
  FILE  *PaletteFile;
    PaletteFile = fopen(FileName,"wb");
    if (PaletteFile == NULL) {
       printf("Unable to open image palette.\n");
       exit(1);
    }
    fwrite(Pal,1,256*3,PaletteFile);
    fclose(PaletteFile);
}

void Read_Image(char *FileName,char **ImagePtr,unsigned *Isize)
{
  FILE  *ImageFile;
  unsigned  Image_Size;
  unsigned  Image_Width;
  unsigned  Image_Height;
  long ImagePos;
    ImageFile = fopen(FileName,"rb");
    if (ImageFile == NULL) {
       printf("Unable to open image!\n");
       exit(1);
    }
    ImagePos = ftell(ImageFile);
    fread(&Image_Width,1,sizeof(int),ImageFile);
    fread(&Image_Height,1,sizeof(int),ImageFile);
    Image_Width++;
    Image_Height++;
    Image_Size = (Image_Width * Image_Height) + 4;
    *Isize = Image_Size;
    *ImagePtr   = malloc(Image_Size);
    if (*ImagePtr == NULL) {
       printf("Unable to allocate enough memory for image!\n");
       exit(1);
    }
    fseek(ImageFile,ImagePos,SEEK_SET);
    fread(*ImagePtr,1,Image_Size,ImageFile);
    fclose(ImageFile);
}

void Write_Image(char *FileName,char **ImagePtr,unsigned Isize)
{
  FILE  *ImageFile;
    ImageFile = fopen(FileName,"wb");
    if (ImageFile == NULL) {
       printf("Unable to open image!\n");
       exit(1);
    }
    fwrite(*ImagePtr,1,Isize,ImageFile);
    fclose(ImageFile);
}

void Get_Image_Data(void)
{
  char Temp[20];
    strcpy(Temp,BFileName);
    strcat(Temp,".pal");
    Read_Pal(PalBase,Temp);
    strcpy(Temp,SFileName);
    strcat(Temp,".pal");
    Read_Pal(PalShift,Temp);
    strcpy(Ifile0,SFileName);
    strcat(Ifile0,".0");
    Read_Image(Ifile0,&ImagePtr0,&ImageSize0);
    strcpy(Ifile1,SFileName);
    strcat(Ifile1,".1");
    Read_Image(Ifile1,&ImagePtr1,&ImageSize1);
    strcpy(Ifile2,SFileName);
    strcat(Ifile2,".2");
    Read_Image(Ifile2,&ImagePtr2,&ImageSize2);
    strcpy(Ifile3,SFileName);
    strcat(Ifile3,".3");
    Read_Image(Ifile3,&ImagePtr3,&ImageSize3);
    strcpy(Ifile4,SFileName);
    strcat(Ifile4,".4");
    Read_Image(Ifile4,&ImagePtr4,&ImageSize4);
}

void Find_PalEnd(int *Bindex,int *Sindex)
{
  int x;
    for (x=0;x<256;x++) {
        if (PalBase[x][red] == 0x3f)
          if (PalBase[x][grn] == 0x3f)
            if (PalBase[x][blu] == 0x3f) {
               printf("Base palette index ends at: %d\n",x);
               *Bindex = x;
               break;
        }
    }
    for (x=0;x<256;x++) {
        if (PalShift[x][red] == 0x3f)
          if (PalShift[x][grn] == 0x3f)
            if (PalShift[x][blu] == 0x3f) {
               printf("Shift palette index ends at: %d\n",x);
               *Sindex = x;
               break;
        }
    }
}

void Shift_Palette(void)
{
  int x;
    for (x=0;x<ShiftIndex;x++) {       /* move shift pal. into base pal. */
        PalBase[x+BaseIndex][red] = PalShift[x][red];
        PalBase[x+BaseIndex][grn] = PalShift[x][grn];
        PalBase[x+BaseIndex][blu] = PalShift[x][blu];
    }
}

void Shift_Image(int Isize,char **ImagePtr)
{
  unsigned x;
  char *Iptr;
    Iptr = *ImagePtr;
    for (x=4;x<Isize;x++)        /* move image data up to correct palette entry */
        Iptr[x] = Iptr[x] + BaseIndex;
}

void Build_Images(void)
{
  char Temp[20];
    Get_Image_Data();                  /* get palette and images */
    Find_PalEnd(&BaseIndex,&ShiftIndex); /* get palettes ending index */
    if ((BaseIndex+ShiftIndex) > 255) {
       printf("\tError: can't combine, palette > 256\n");
       exit(1);
    }
    printf("\tCombined palette yields %d colors.\n",BaseIndex+ShiftIndex);
    printf("Shifting palette\n");
    Shift_Palette();                   /* move shift palette to base ending index */
    printf("Shifting file %s\n",Ifile0);
    Shift_Image(ImageSize0,&ImagePtr0); /* move images: shift.* up to correct pal values */
    Write_Image(Ifile0,&ImagePtr0,ImageSize0);
    printf("Shifting file %s\n",Ifile1);
    Shift_Image(ImageSize1,&ImagePtr1); /* move images: shift.* up to correct pal values */
    Write_Image(Ifile1,&ImagePtr1,ImageSize1);
    printf("Shifting file %s\n",Ifile2);
    Shift_Image(ImageSize2,&ImagePtr2); /* move images: shift.* up to correct pal values */
    Write_Image(Ifile2,&ImagePtr2,ImageSize2);
    printf("Shifting file %s\n",Ifile3);
    Shift_Image(ImageSize3,&ImagePtr3); /* move images: shift.* up to correct pal values */
    Write_Image(Ifile3,&ImagePtr3,ImageSize3);
    printf("Shifting file %s\n",Ifile4);
    Shift_Image(ImageSize4,&ImagePtr4); /* move images: shift.* up to correct pal values */
    Write_Image(Ifile4,&ImagePtr4,ImageSize4);
    strcpy(Temp,BFileName);
    strcat(Temp,".pal");
    printf("Writing palette file %s\n",Temp);
    Write_Pal(PalBase,Temp);
    free(ImagePtr0);
    free(ImagePtr1);
    free(ImagePtr2);
    free(ImagePtr3);
    free(ImagePtr4);
}

void main(int argc,char *argv[])
{
    if (argc != 3) {
       printf("Format is: Moviebld Basepal Shiftpal\n");
       printf("\t Basepal  - base palette file\n");
       printf("\t Shiftpal - palette to insert into base pal.\n");
       exit(1);
    }
    strcpy(BFileName,argv[1]);
    if (strchr(BFileName,'.') != NULL) {
       printf("Don't include the extension!\n");
       exit(1);
    }
    strcpy(SFileName,argv[2]);
    if (strchr(SFileName,'.') != NULL) {
       printf("Don't include the extension!\n");
       exit(1);
    }
    Build_Images();
}
