/**************************************************/
/*     Qrtpost.exe  Raw image data post-processor */
/*                  Written by:  Markham Thomas   */
/*                  Jan 10, 1989                  */
/**************************************************/

#define   MAXXRES        800      /* set max horiz coord expected */
#include <graphics.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "VGAEXTRA.H"
#include "VID256.H"
#include "VID7DET.H"

DACarray Pal_Array;               /* create array to hold DAC values */
RGB Color;

  int TOLERANCE = 15;
  int xres, yres, scanline;
  unsigned char r[MAXXRES], g[MAXXRES], b[MAXXRES];
  FILE *in;
  int Array_Last;
  int g_driver, g_mode;

/****************** Clean up palette array and init graphics *************/
void Initialize()
{
  int x;
    for (x=0;x<256;x++) {              /* insure we start with 0's */
        Pal_Array[x][red]    = 0;
        Pal_Array[x][grn]    = 0;
        Pal_Array[x][blu]    = 0;
    }
    Array_Last = 1;                    /* set flag for starting DAC register */
    installuserdriver("VID256",DetectVID256);   /* becomes g_driver = 134 */
    registerbgidriver(VID256_driver);
}

/****************** since we only support 256 colors: reduce color count ****/
void Compare_RGB(DACarray Array,RGB *Colors,int *Index)
{
  int x;
  int temp;
    temp = -1;
    x = 0;
    do {
        if ((Array[x][red] <= Colors->Red) & ((Array[x][red]+TOLERANCE) >= Colors->Red)) {
           if ((Array[x][grn] <= Colors->Green) & ((Array[x][grn]+TOLERANCE) >= Colors->Green)) {
              if ((Array[x][blu] <= Colors->Blue) & ((Array[x][blu]+TOLERANCE) >= Colors->Blue)) temp = x;
           }
        }
        x = ++x;
    } while ((x<256) && (temp == -1));
    if (temp == -1) {
       Array[Array_Last][red] = Colors->Red;
       Array[Array_Last][grn] = Colors->Green;
       Array[Array_Last][blu] = Colors->Blue;
       temp = Array_Last;
       Array_Last = ++Array_Last;
       if (Array_Last > 256) {
          dacpalette(Pal_Array);
          outtextxy(2,10,"\nPalette array index exceeded 256.\n");
          getch();
          restorecrtmode();
          exit(1);
       }
    }
    *Index = temp;
}

void main(argc,argv)
  int argc;
  char *argv[];
{
  int index;
  int rgbindex;
  int y1;
  if (argc != 3) {
    printf("Ray trace postprocessor by: Markham Thomas\n");
    printf("Usage: qrtpost nn FILE.RAW\n");
    printf("  (where nn is color tolerance)\n");
    exit(1);
  }
  /* open files */
  TOLERANCE = atoi(argv[1]);
  if ((in = fopen(argv[2],"rb"))==NULL) {
    printf("Couldn't open file %s\n",argv[2]);
    exit(1);
  }
  Initialize();
  xres = yres = 0;
  fread(&xres,sizeof(int),1,in);
  fread(&yres,sizeof(int),1,in);
  switch (xres) {
       case 320 : break;
       case 640 : break;
       case 800 : break;
       default  : {
                  printf("Xres is invalid!\n");
                  exit(1);
       }
  }
  printf("QRT image post-processor by:  Markham Thomas\n");
  printf("  Image file resolution is: %d  by  %d\n",xres,yres);
  printf("  If get message about Palette array > 256, change TOLERANCE\n");
  printf(" >>>>> press any key to start image display <<<<<\n");
  getch();
  g_driver = DETECT;
  if (xres == 320) {
     initgraph(&g_driver,&g_mode,"");
     setgraphmode(VID320x200);
  }
  if (xres == 640) {
     printf("Warning: This mode is only supported on 512k ram VGA's\n");
     printf("  **** press any key to continue **** or CNTRL-C to break\n");
     getch();
     initgraph(&g_driver,&g_mode,"");
     if (g_driver == 134) setgraphmode(VID640x480);
  }
  if (xres == 800) {
     printf("Warning: This mode is only supported on Designer VGA!\n");
     printf("  **** press any key to continue **** or CNTRL-C to break\n");
     getch();
     initgraph(&g_driver,&g_mode,"");
     if (g_driver == 134) setgraphmode(VID800x600);
     else {
          restorecrtmode();
          printf("800x600 by 256 only supported on Tseng Labs bases chipsets\n");
          exit(1);
     }
  }
  y1 = 0;
  while (!feof(in)) {
    fread(&scanline,sizeof(int),1,in);
    if (scanline >= yres) {
      restorecrtmode();
      printf("Faulty data file.\n");
      exit(1);
    }
    fread(&r[0],sizeof(char),xres,in);
    fread(&g[0],sizeof(char),xres,in);
    fread(&b[0],sizeof(char),xres,in);
    for (index=0;index<xres;index++) {
        Color.Red   = (r[index] & 0xff);
        Color.Green = (g[index] & 0xff);
        Color.Blue  = (b[index] & 0xff);
        Compare_RGB(Pal_Array,&Color,&rgbindex);
        putpixel(index,y1,rgbindex);
    }
    y1 = ++y1;
    if (y1 > getmaxy()) break;
  }
  dacpalette(Pal_Array);
  getch();
  restorecrtmode();
  fclose(in);                                 /* close files */
  printf("The last DAC color entry used in the image was %d.\n",Array_Last);
  if (Array_Last < 240)
      printf(" >> Adjust TOLERANCE to achieve better utilization of color set\n");
}
