/*  QrtPost is a post processor for QRT on the HP Vectra
  It reads in the QRT file, and spits it out
  as a 256 color bitmap.
*/

#define MAXXRES 640      /* max x resolution */

#include <stdio.h>
#include <process.h>

void          vga_320x200(void);
void          vga_640x480(void);
void          vga_800x600(void);
void          vga_textmode(void);
void          vga_pset(int,int,int);
int           vga_pget(int,int);
int           vga_getmaxx(void);
int           vga_getmaxy(void);
void          vga_palette_array(char *);
void          vga_palette_reg(int,int,int,int);
void          vga_line(int,int,int,int,int);
void          vga_fill_screen(int);
void          vga_fill_rectangle(int,int,int,int,int);
void          vga_box(int,int,int,int,int);
int           Init_Mouse(void);
void          Read_Mouse(int *,int *,int *);
void          Move_Mouse(int ,int );
void          Mouse_Range(int ,int ,int ,int );
void          Mouse_On(void);
void          Mouse_Off(void);
void          Display_Mouse(int ,int );

typedef struct {                       /* RGB structure type */
  char   Red;                          /* red component */
  char   Green;                        /* green component */
  char   Blue;                         /* blue component */
 } RGB;

RGB Pal_Array[256];                /* create array to hold DAC values */
RGB Color;

  int xres, yres, scanline;
  unsigned char r[MAXXRES], g[MAXXRES], b[MAXXRES];
  FILE *in, *out;
  int Array_Last;

void Initialize()
{
  int x;
    for (x=0;x<256;x++) {
        Pal_Array[x].Red     = 0;
        Pal_Array[x].Green   = 0;
        Pal_Array[x].Blue    = 0;
    }
    Array_Last = 1;
/*    vga_640x480(); */
}

void Compare_RGB(RGB *Array,RGB *Colors,int *Index)
{
  int x;
  int temp;
    temp = -1;
    x = 0;
    do {
        if ((Array[x].Red <= Colors->Red) & ((Array[x].Red+3) >= Colors->Red)) {
           if ((Array[x].Green <= Colors->Green) & ((Array[x].Green+3) >= Colors->Green)) {
              if ((Array[x].Blue <= Colors->Blue) & ((Array[x].Blue+3) >= Colors->Blue)) temp = x;
           }
        }
        x = ++x;
    } while ((x<256) && (temp == -1));
    if (temp == -1) {
       Array[Array_Last].Red   = Colors->Red;
       Array[Array_Last].Green = Colors->Green;
       Array[Array_Last].Blue  = Colors->Blue;
       temp = Array_Last;
       Array_Last = ++Array_Last;
       if (Array_Last > 256) {
          printf("\nPalette array index exceeded 256.\n");
          exit(1);
       }
    }
    *Index = temp;
}

void main(argc,argv)
  int argc;
  char *argv[];
{
  int index;
  int rgbindex;
  int y1;
  if (argc != 3) {
    printf("Usage: %s InFile OutFile\n",argv[0]);
    exit(1);
  }
  /* open files */
  if ((in = fopen(argv[1],"rb"))==NULL) {
    printf("Couldn't open file %s\n",argv[1]);
    exit(1);
  }
  if ((out = fopen(argv[2],"w"))==NULL) {
    printf("Couldn't open file %s\n",argv[2]);
    exit(1);
  }
  Initialize();
  xres = yres = 0;
  fread(&xres,sizeof(int),1,in);
  fread(&yres,sizeof(int),1,in);
  y1 = 0;
  while (!feof(in)) {
    fread(&scanline,sizeof(int),1,in);
/*    printf("\nScanline %x\n",scanline); */
    if (scanline >= yres) {
      printf("Faulty data file.\n");
      exit(1);
    }
    fread(&r[0],sizeof(char),xres,in);
    fread(&g[0],sizeof(char),xres,in);
    fread(&b[0],sizeof(char),xres,in);
    for (index=0;index<xres;index++) {
        Color.Red   = (r[index] & 0xff) >> 2;
        Color.Green = (g[index] & 0xff) >> 2;
        Color.Blue  = (b[index] & 0xff) >> 2;
        Compare_RGB(Pal_Array,&Color,&rgbindex);
if (rgbindex != 0) printf("%d ",rgbindex);
/*        vga_pset(index,y1,rgbindex); */
    }
    y1 = ++y1;
  }
for (index=0;index<xres;index++)
    printf("r %x  g %x  b %x \n",Pal_Array[index].Red,Pal_Array[index].Green,
              Pal_Array[index].Blue);
/*  vga_palette_array(Pal_Array); */
  getch();
/*  vga_textmode();                   */
  fclose(in);                                 /* close files */
  fclose(out);
}

