/* RAYTRACE.C */

/* Ur en artikel av Daniel Lyke i Dr Dobb's Journal september 90 */
/* Modifierad till Turbo C och BGI */


#include <graphics.h>
#include <math.h>
#include <dos.h>

#define WIDTH 640
#define HEIGHT 350
#define QUIT_OUT (!kbhit())

plot(x,y,c)
int x,y,c;
{
putpixel(x,y,c);
}

typedef struct S_RAY
{
     double dx, dy, dz; /* Direction vector */
     double ox, oy, oz; /* Origin */
}RAY;

typedef struct S_PLANE
{
     double nx, ny, nz; /* Vector normal (perpendicular) to plane */
     double px, py, pz; /* Point to plane */
}PLANE;

typedef struct S_SPHERE
{
     double cx, cy, cz; /* Center of radius */
     double r2; /* Radius squared */
}SPHERE;

typedef struct S_VECTOR
{
     double dx, dy, dz; /* Three dimensional vector */
}VECTOR;

double sphere_intersect(RAY, SPHERE);
double plane_intersect(RAY, PLANE);
void reflect(VECTOR *, VECTOR *, VECTOR *);
double sphere_intersect(RAY ray, SPHERE sphere)
{
     double a, b, c, t1, t2, t3, close, farther;
     a = ray.dx * ray.dx + ray.dy * ray.dy + ray.dz * ray.dz;
     close = farther = -1.0;
     if(a)
	  {
	  b = 2.0 * ((ray.ox - sphere.cx) * ray.dx
	    + (ray.oy - sphere.cy) * ray.dy
	    + (ray.oz - sphere.cz) * ray.dz);
	  c = (ray.ox - sphere.cx) * (ray.ox - sphere.cx)
	    + (ray.oy - sphere.cy) * (ray.oy - sphere.cy)
	    + (ray.oz - sphere.cz) * (ray.oz - sphere.cz) - sphere.r2;
	  t1 = b * b - 4.0 * a * c;
	  if(t1 > 0)
	       {
	       t2 = sqrt(t1);
	       t3 = 2.0 * a;
	       close = -(b + t2) / t3;
	       farther = -(b - t2) / t3;
	       }
	  }
     return (double)((close < farther) ? close : farther);
} /*----- End: sphere_intersect() -----*/

double plane_intersect(RAY ray, PLANE plane)
{
     double p1, p2, p3;
     p1 = plane.px * plane.ny + plane.py * plane.ny + plane.pz * plane.pz;
     p2 = ray.ox * plane.nx + ray.oy * plane.ny + ray.oz * plane.nz;
     p3 = ray.dx * plane.nx + ray.dy * plane.ny + ray.dz * plane.nz;
     return (double)((p1-p2)/p3);
} /*----- End: plane_intersect() -----*/

void reflect(VECTOR *normal, VECTOR *incident, VECTOR *r)
{
     double ndotn, idotn;
     ndotn = (normal->dx * normal->dx +
		    normal->dy * normal->dy +
		    normal->dz * normal->dz);
     idotn = (normal->dx * incident->dx +
		    normal->dy * incident->dy +
		    normal->dz * incident->dz);
     r->dx = incident->dx - (2.0 * (idotn) / ndotn) * normal->dx;
     r->dy = incident->dy - (2.0 * (idotn) / ndotn) * normal->dy;
     r->dz = incident->dz - (2.0 * (idotn) / ndotn) * normal->dz;
} /*----- End: reflect() -----*/

int plane_pattern(int x, int y, int light)
{
     return ((x + 16384) % 8) ^ ((y + 16384) % 8) + 8 * light;
} /*----- End: plane_pattern() -----*/

int trace(int x, int y)
{
     static PLANE plane = { 0.0, 1.0, 0.001, -8.0, 0.0, 0.0};
     static SPHERE sphere = { 0.0, 0.0, 5.0, 9.0 };
     VECTOR v1, v2, v3;
     RAY ray;
     double t1, t2, time;
     ray.ox = 0.0;	 /* Set the ray origin to the eye */
     ray.oy = 0.0;
     ray.oz = 0.0;
     ray.dz = 1.0;	 /* Set the direction through the pixel */
     ray.dy = -((double)y - (double)HEIGHT / 2.0) / 100;
     ray.dx = ((double)x - (double)WIDTH / 2.0) / 120;
     t1 = sphere_intersect(ray,sphere);
     t2 = plane_intersect(ray,plane);
     if(t1 > 0.0 && (t2 < 0.0 || t2 > t1)) /* Circle in fore */
	  {
	  v1.dx = ray.dx; v1.dy = ray.dy; v1.dz = ray.dz;
	  v2.dx = ((ray.dx * t1 + ray.ox) - sphere.cx);
	  v2.dy = ((ray.dy * t1 + ray.oy) - sphere.cy);
	  v2.dz = ((ray.dz * t1 + ray.oz) - sphere.cz);
	  reflect(&v2,&v1,&v3);
	  ray.ox += ray.dx * t1; ray.oy += ray.dy * t1; ray.oz += ray.dz * t1;
	  ray.dx = v3.dx; ray.dy = v3.dy; ray.dz = v3.dz;
	  t2 = plane_intersect(ray,plane);
	  if(t2 > 0.0)
	       {
	       return plane_pattern((int)(t2 * ray.dz + ray.oz),(int)(t2 *
					ray.dx + ray.ox),0);
	       }
	  else
	       {
	       return 1;
	       }
	  }
     else if(t2 > 0.0)
	  {
	  return plane_pattern((int)(t2 * ray.dz +ray.oz),(int)(t2 *
					ray.dx + ray.ox),1);
	  }
     return 0;
} /*----- End: trace() -----*/

draw()
{
     int x,y;
     for(x=0;x< WIDTH && QUIT_OUT; x++)
     	  {
	  for(y = 0; y < HEIGHT; y++)
	       {
	       plot(x,y,trace(x,y));
	       }
	  }
} /*----- End: draw() -----*/

main()
{
     bgi_init_all();
     draw();
     while(QUIT_OUT);
     getch();
     closegraph();
}


bgi_init_all(void)
{
     int  grdriver = EGA;
     int  grmode = EGAHI;

     initgraph (&grdriver, &grmode, "");
			 /* OBS Antar att egavga.bgi finns i samma katalog */
}
