
# line 22 "input_yacc.y"
#include <stdio.h>
#include "constants.h"
#include "typedefs.h"
#include "funcdefs.h"
#include "texture.h"
#include "atmosphere.h"

char yyfilename[BUFSIZ];
int Npoints=0, CurXSize, CurYSize, CurZSize;
Object	*LastObj = (Object *)0;
ObjList *CurObj, *ListTmp;
Surface *stmp;
Texture *CurText;
TransInfo *CurTrans = (TransInfo *)0, CurITrans;
PointList *Polypoints, *Point;
extern FILE *yyin;
extern Object *World;
extern int WorldXSize, WorldYSize, WorldZSize, nlight, Xres, Yres, maxlevel;
extern int yylineno, Jittered, JitSamples, pixel_div;
extern int ResolutionSet, ContrastSet, SamplesSet, CutoffSet;
extern int AdaptiveSet, JitteredSet;
extern double hfov, vfov, RedContrast, GreenContrast, BlueContrast;
extern double TreeCutoff, aperture, focaldist;
extern Vector eyep, lookp, up;
extern char outfilename[];
extern Color background;
extern SurfaceList *Surfaces;
extern Light light[];
extern Fog *GlobalFog;
extern Mist *GlobalMist;

# line 53 "input_yacc.y"
typedef union  {
	char *c;
	int i;
	double d;
	Vector v;
	Color col;
	struct Texture *text;
} YYSTYPE;
# define tINT 257
# define tFLOAT 258
# define tSTRING 259
# define tADAPTIVE 260
# define tAPERTURE 261
# define tBACKGROUND 262
# define tBLOTCH 263
# define tBOX 264
# define tBUMP 265
# define tCONE 266
# define tCYL 267
# define tDIRECTIONAL 268
# define tENDDEF 269
# define tEXTENDED 270
# define tEYEP 271
# define tFBM 272
# define tFBMBUMP 273
# define tFOCALDIST 274
# define tFOG 275
# define tFOV 276
# define tGRID 277
# define tHEIGHTFIELD 278
# define tJITTERED 279
# define tLIGHT 280
# define tLIST 281
# define tLOOKP 282
# define tMARBLE 283
# define tMAXDEPTH 284
# define tMIST 285
# define tOBJECT 286
# define tOUTFILE 287
# define tPLANE 288
# define tPOINT 289
# define tPOLY 290
# define tROTATE 291
# define tSAMPLES 292
# define tSCALE 293
# define tSCREEN 294
# define tSPHERE 295
# define tSTARTDEF 296
# define tSUPERQ 297
# define tSURFACE 298
# define tRESOLUTION 299
# define tTHRESH 300
# define tTRANSLATE 301
# define tTRANSFORM 302
# define tTRIANGLE 303
# define tUP 304
# define tENDFILE 305
# define tTEXTURE 306
# define tCHECKER 307
# define tWOOD 308
# define tCONTRAST 309
# define tCUTOFF 310
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 686 "input_yacc.y"

/*
 * Issue error message containing filename and line number, and exit.
 */
/*VARARGS1*/
yyerror(s, pat1, pat2)
char *s, *pat1, *pat2;
{
	RSmessage("Error", "%s, line %d: ", yyfilename, yylineno);
	fprintf(stderr, s, pat1, pat2);
	fprintf(stderr,"\n");	/* yacc doesn't use newlines on syntax errors */
	exit(1);
}

/*
 * Issue warning message containing filename and line number if not in
 * Quiet mode.
 */
/*VARARGS1*/
yywarning(s, pat1, pat2)
char *s, *pat1, *pat2;
{
	extern int Quiet;

	if (!Quiet) {
		RSmessage("Warning", "%s, line %d: ",yyfilename, yylineno);
		fprintf(stderr, s, pat1, pat2);
	}
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 117
# define YYLAST 429
short yyact[]={

  39,  34,  42, 132,  69, 237,  72,  71,  79,  78,
  95,  28,  96, 100,  35,  51,  31,  49,  75,  38,
  53,  48,  29, 159,  36,  52,  55,  47,  67, 230,
  74,  94,  37, 120,  32,  68,  66,  73,  46,  33,
 119, 118, 117,  70,  30,  27, 186, 116, 115,  40,
  41,  69, 114,  72,  71, 113, 143,  77, 112, 229,
 166, 139, 167, 140,  49,  75, 173, 134,  48, 169,
 170, 138, 141,  55, 125,  67, 124,  74, 102,  89,
 168,  88,  68,  66,  73,  46,  87,  84,  83,  82,
  70,  24,  85,  86,  99,  23, 158,  22,  90,  91,
  93,  97, 108,  20, 165, 171,  19,  18,  43, 104,
  93, 106, 137,  45, 131, 144, 110,  56,  50,  65,
  64,  63,  62,  61,  60,  59,  58,  57,  54,  44,
  26,  25,  21,  17,  16, 122,  15,  14,  13,  12,
 123,  11, 101,  10,   9,   8,   7,  98, 126,   6,
 109, 127, 103,   5,   4,   3,   2,  93,   1, 164,
   0, 111,  93,  93, 127,   0,   0,   0,   0,   0,
   0, 152, 153,   0,   0,   0, 157,   0,   0, 121,
 160,   0,   0,   0, 161, 162,   0,   0, 163,   0,
   0,  93,   0,   0, 174,   0,   0,   0, 177, 178,
   0,  92, 150,   0,   0,   0, 149,  76, 148,   0,
   0, 181, 142,   0, 146, 185,   0, 147, 145,   0,
   0,   0,   0,   0, 190, 191,   0, 193, 194,   0,
  93,   0, 196,   0, 197, 198, 199,  80,  81, 200,
   0, 202, 203, 204,   0,   0,   0,   0,   0,   0,
   0, 206, 207, 208, 105, 107, 209, 210, 211,   0,
 189, 213, 214, 192, 215, 216, 217, 188, 218, 219,
   0,   0, 221, 222, 223, 224, 225, 226,   0, 228,
   0,   0, 231, 232,   0, 205, 233, 234,   0, 235,
 236,   0,   0, 238, 239,   0,   0, 240, 241, 242,
 243, 133, 128, 129, 130,   0, 135, 136,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 151,   0,   0, 154, 155, 156,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 175, 176,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 179,
 180,   0, 182, 183, 184,   0, 187,   0,   0,   0,
   0,   0,   0,   0, 195,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 201,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 212,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 220,   0,   0,   0,   0,   0,   0,   0, 227 };
short yypact[]={

-1000,-260,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-249,-249,
-249,-249,-169,-170,-249,-249,-171,-176,-1000,-178,
-249,-249,-249,-258,-1000,-1000,-246,-246,-1000,-179,
-1000,-249,-249,-249,-1000,-246,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-246,-201,-204,-207,
-211,-212,-217,-218,-219,-226,-1000,-249,-1000,-1000,
-1000,-1000,-249,-181,-183,-1000,-1000,-1000,-1000,-1000,
-249,-1000,-1000,-249,-249,-249,-249,-303,-303,-249,
-1000,-1000,-190,-303,-249,-249,-249,-1000,-230,-1000,
-213,-1000,-249,-249,-249,-249,-249,-249,-249,-1000,
-236,-230,-249,-1000,-1000,-1000,-249,-249,-1000,-1000,
-249,-1000,-203,-249,-191,-1000,-249,-1000,-249,-249,
-249,-249,-230,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-249,-249,-249,-249,-249,-249,-249,-249,-1000,
-1000,-1000,-1000,-1000,-1000,-246,-249,-249,-246,-249,
-249,-1000,-249,-1000,-249,-1000,-249,-249,-249,-1000,
-1000,-249,-249,-249,-249,-249,-1000,-1000,-230,-1000,
-246,-1000,-1000,-249,-249,-249,-1000,-1000,-249,-249,
-249,-249,-1000,-249,-249,-1000,-249,-249,-249,-1000,
-249,-249,-249,-1000,-249,-249,-249,-249,-249,-249,
-249,-249,-198,-228,-249,-249,-1000,-1000,-249,-249,
-1000,-249,-249,-1000,-254,-249,-249,-1000,-1000,-249,
-249,-249,-249,-1000 };
short yypgo[]={

   0,  57,  94, 207, 201, 159, 158, 156, 155, 154,
 153, 149, 146, 145, 144, 143, 141, 139, 138, 137,
 136, 134, 133, 107, 106, 103, 132,  97,  95,  91,
 131, 130, 129, 101, 128, 102, 127, 126, 125, 124,
 123, 122, 121, 120, 119, 118, 117, 116, 115, 114,
 113, 112, 108,  96,  46 };
short yyr1[]={

   0,   6,   6,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
   7,   7,   7,   7,   7,   7,   7,   7,  27,  28,
  23,  32,  34,  34,  34,  34,  34,  34,  34,  34,
  34,  29,  45,  46,  47,  47,  48,  48,  48,  48,
  48,  48,  33,  33,  49,   5,   5,   5,   5,   5,
   5,   5,   5,   5,  24,  50,  35,  35,  51,  51,
  51,  51,  51,   8,   9,  10,  11,  11,  16,  18,
  19,  20,  17,  12,  12,  13,  14,  15,  21,  22,
  22,  22,  52,  52,  25,  25,  44,  43,  53,  53,
  54,  41,  40,  37,  38,  39,  39,  42,  36,  26,
  31,  30,   4,   3,   1,   1,   2 };
short yyr2[]={

   0,   0,   2,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   4,
   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   2,   3,   2,   2,   0,   1,   1,   1,   1,
   1,   1,   2,   0,   3,   2,   3,   2,   1,   2,
   7,   8,   6,   1,   2,   3,   2,   0,   2,   3,
   4,  10,  13,   3,   2,   2,   3,   2,   2,   2,
   4,   2,   1,   3,   3,   2,   2,   2,   2,   3,
   3,   4,   2,   2,   9,  11,   3,   3,   0,   2,
   1,   6,   5,   4,   8,   5,   8,   9,   4,   2,
   5,   3,   3,   3,   1,   1,   1 };
short yychk[]={

-1000,  -6,  -7,  -8,  -9, -10, -11, -12, -13, -14,
 -15, -16, -17, -18, -19, -20, -21, -22, -23, -24,
 -25, -26, -27, -28, -29, -30, -31, 305, 271, 282,
 304, 276, 294, 299, 261, 274, 284, 292, 279, 260,
 309, 310, 262, -52, -32, -50, 298, 287, 281, 277,
 -45, 275, 285, 280, -34, 286, -46, -36, -37, -38,
 -39, -40, -41, -42, -43, -44, 296, 288, 295, 264,
 303, 267, 266, 297, 290, 278,  -3,  -1, 258, 257,
  -3,  -3,  -1, 257, 257,  -1,  -1, 257, 257, 257,
  -1,  -1,  -4,  -1, 289, 268, 270, -33, -33,  -2,
 259,  -2, 257, -33,  -1,  -4,  -1,  -4, -35,  -2,
 -47,  -2, 259, 259, 259, 259, 259, 259, 259, 259,
 259, -35,  -1,  -1, 257, 257,  -1,  -1,  -3,  -3,
  -3, -49, 306,  -4, 257,  -4,  -4, -51, 301, 291,
 293, 302, -35, 269, -48, -23, -25, -24, -27, -28,
 -29,  -3,  -1,  -1,  -3,  -3,  -3,  -1, -53, 259,
  -1,  -1,  -1,  -1,  -5, 307, 263, 265, 283, 272,
 273, 308,  -4, 257,  -1,  -3,  -3,  -1,  -1,  -3,
  -3,  -1,  -3,  -3,  -3,  -1, -54,  -3, -35,  -2,
  -1,  -1,  -2,  -1,  -1,  -4,  -1,  -1,  -1,  -1,
  -1,  -3,  -1,  -1,  -1,  -2,  -1,  -1,  -1,  -1,
  -1,  -1,  -3,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
  -3,  -1,  -1,  -1,  -1,  -1,  -1,  -3,  -1, 257,
 257,  -1,  -1,  -1,  -1,  -1,  -1, 259,  -1,  -1,
  -1,  -1,  -1,  -1 };
short yydef[]={

   1,  -2,   2,   3,   4,   5,   6,   7,   8,   9,
  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
  20,  21,  22,  23,  24,  25,  26,  27,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  82,   0,
   0,   0,   0,   0,  53,  53,   0,   0,  28,   0,
  53,   0,   0,   0,  67,   0,  45,  32,  33,  34,
  35,  36,  37,  38,  39,  40,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,  67,   0, 114, 115,
  74,  75,  77,   0,   0,  85,  86,  87,  78,  79,
   0,  81,  88,   0,   0,   0,   0,  30,  64,   0,
 116, 109,   0,  41,   0,   0,  92,  93,  31,  67,
   0,  43,   0,   0,   0,   0,   0,   0,   0,  98,
   0,  73,   0,  76,  83,  84,   0,   0,  89,  90,
   0,  52,   0,   0,   0, 111,   0,  66,   0,   0,
   0,   0,  65,  42,  44,  46,  47,  48,  49,  50,
  51,   0,   0,   0,   0,   0,   0,   0,  97,  96,
 113,  80, 112,  91,  67,   0,   0,   0,  58,   0,
   0,  63,   0,  29,   0,  68,   0,   0,   0, 108,
 103,   0,   0,   0,   0,   0,  99, 100,  54,  55,
   0,  57,  59,   0,   0,   0, 110,  69,   0,   0,
   0, 105, 102,   0,   0,  56,   0,   0,   0,  70,
   0,   0,   0, 101,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 104, 106,   0,   0,
  62,  94,   0, 107,  60,   0,   0,  61,  95,   0,
  71,   0,   0,  72 };
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar 1.6 88/02/08 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 28:
# line 109 "input_yacc.y"
{
			if (CurObj->data)
				CurObj->data->type = LIST;
			else
				World->type = LIST;
		} break;
case 29:
# line 117 "input_yacc.y"
{
			if (CurObj->data) {
				CurObj->data->type = GRID;
				CurXSize = yypvt[-2].i;
				CurYSize = yypvt[-1].i;
				CurZSize = yypvt[-0].i;
			} else {
				World->type = GRID;
				WorldXSize = yypvt[-2].i;
				WorldYSize = yypvt[-1].i;
				WorldZSize = yypvt[-0].i;
			}
		} break;
case 30:
# line 132 "input_yacc.y"
{
			if (LastObj)
				/* User may have botched prim. def. */
				LastObj->texture = CurText;
			CurText = (Texture *)0;
			LastObj = (Object *)0;
		} break;
case 31:
# line 141 "input_yacc.y"
{
			if (LastObj != (Object *)0) {
				/*
				 * Compute boundings box of primitive.
				 * if box's low X is > its high X,
				 * then the prim is unbounded.
				 */
				set_prim_bounds(LastObj);
				/*
				 * Add primitive to current object
				 * list.  When the obj. def. is complete
				 * make_list() will calculate the
				 * bounding box of the entire object.
				 */
				add_prim(LastObj, CurObj->data);
				if (CurTrans) {
					/*
					 * Compute the bounding box of the
					 * transformed object.
					 */
					transform_bounds(CurTrans,
							LastObj->bounds);
					invert_trans(&CurITrans, CurTrans);
					LastObj->trans = new_trans(CurTrans,
								&CurITrans);
					free((char *)CurTrans);
					CurTrans = (TransInfo *)0;
				}
			} else {
				/*
				 * There was something wrong with the def.
				 */
				if (CurTrans) {
					free((char *)CurTrans);
					CurTrans = (TransInfo *)0;
				}
			}
		} break;
case 41:
# line 191 "input_yacc.y"
{
			CurObj->data->texture = CurText;
			CurText = (Texture *)0;
			free((char *)CurObj);
			CurObj = CurObj->next;
		} break;
case 42:
# line 199 "input_yacc.y"
{
			/*
			 * Object definition.
			 */
			LastObj = (Object *)NULL;
			if (CurObj->data->data == (char *)0) {
				yywarning("Null object \"%s\" defined.\n",
					CurObj->data->name);
			} else {
				if (CurObj->data->type == GRID) {
					list2grid(CurObj->data, CurXSize,
						CurYSize, CurZSize);
				} else {
					/*
				 	 * Object is a list -- transform the
				 	 * linked list (ObjList) into a List.
				 	 */
					make_list(CurObj->data);
				}
				/*
			 	 * Add this new object to the list of
			 	 * defined objects.
			 	 */
				add_to_objects(CurObj->data);
			}
		} break;
case 43:
# line 230 "input_yacc.y"
{
			/*
			 * Once we know the bounding box of this object
			 * (and the user hasn't specified that this object
			 * is stored in a List), then we enlist everything
			 * it contains.
			 * The new object's DATA field points to an ObjList
			 * until the definition complete, when the ObjList
			 * is then turned into either a Grid or a List.
			 */
			ListTmp = (ObjList *)Malloc(sizeof(ObjList));
			ListTmp->data = new_object(yypvt[-0].c, LIST, (char *)NULL,
						(Trans *)NULL);
			ListTmp->next = CurObj;
			CurObj = ListTmp;
		} break;
case 54:
# line 261 "input_yacc.y"
{
			/*
			 * Set transformation information.
			 */
			if (CurTrans) {
				invert_trans(&CurITrans, CurTrans);
				yypvt[-1].text->trans = new_trans(CurTrans,&CurITrans);
				free((char *)CurTrans);
				CurTrans = (TransInfo *)NULL;
			}
			/*
			 * Walk to the end of list of textures and
			 * append new texture.  This is done so that
			 * textures are implied in the expected order.
			 */
			{
				Texture *tp;

				yypvt[-1].text->next = (Texture *)0;

				if (CurText) {
					for (tp=CurText;tp->next;tp=tp->next)
							;
					tp->next = yypvt[-1].text;

				} else {
					CurText = yypvt[-1].text;
				}
			}
		} break;
case 55:
# line 293 "input_yacc.y"
{
			yyval.text = NewCheckText(yypvt[-0].c);
		} break;
case 56:
# line 297 "input_yacc.y"
{
			yyval.text = NewBlotchText(yypvt[-1].d, yypvt[-0].c);
		} break;
case 57:
# line 301 "input_yacc.y"
{
			yyval.text = NewBumpText(yypvt[-0].d);
		} break;
case 58:
# line 305 "input_yacc.y"
{
			yyval.text = NewMarbleText((char *)NULL);
		} break;
case 59:
# line 309 "input_yacc.y"
{
			yyval.text = NewMarbleText(yypvt[-0].c);
		} break;
case 60:
# line 313 "input_yacc.y"
{
			yyval.text = NewfBmText(yypvt[-5].d, yypvt[-4].d, yypvt[-3].d, yypvt[-2].d, yypvt[-1].i, yypvt[-0].d, (char *)0);
		} break;
case 61:
# line 317 "input_yacc.y"
{
			yyval.text = NewfBmText(yypvt[-6].d, yypvt[-5].d, yypvt[-4].d, yypvt[-3].d, yypvt[-2].i, yypvt[-1].d, yypvt[-0].c);
		} break;
case 62:
# line 321 "input_yacc.y"
{
			yyval.text = NewfBmBumpText(yypvt[-4].d, yypvt[-3].d, yypvt[-2].d, yypvt[-1].d, yypvt[-0].i);
		} break;
case 63:
# line 325 "input_yacc.y"
{
			yyval.text = NewWoodText();
		} break;
case 64:
# line 330 "input_yacc.y"
{
			LastObj->texture = CurText;
			CurText = (Texture *)0;
			LastObj = (Object *)0;
		} break;
case 65:
# line 337 "input_yacc.y"
{
			LastObj = add_child_named(yypvt[-1].c, CurObj->data);
			if (CurTrans) {
				transform_bounds(CurTrans, LastObj->bounds);
				invert_trans(&CurITrans, CurTrans);
				if (LastObj->trans) {
					mmult(&LastObj->trans->obj2world,
						CurTrans,
						&LastObj->trans->obj2world);
					mmult(&LastObj->trans->world2obj,
						&CurITrans,
						&LastObj->trans->world2obj);
				} else
					LastObj->trans = new_trans(CurTrans,
								&CurITrans);
				free((char *)CurTrans);
				CurTrans = (TransInfo *)NULL;
			}
		} break;
case 68:
# line 361 "input_yacc.y"
{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			RS_translate(CurTrans, &(yypvt[-0].v));
		} break;
case 69:
# line 367 "input_yacc.y"
{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();

			RS_rotate(CurTrans, &(yypvt[-1].v), deg2rad(yypvt[-0].d));
		} break;
case 70:
# line 374 "input_yacc.y"
{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			RS_scale(CurTrans, yypvt[-2].d, yypvt[-1].d, yypvt[-0].d);
		} break;
case 71:
# line 382 "input_yacc.y"
{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			explicit_trans(CurTrans,
				yypvt[-8].d, yypvt[-7].d, yypvt[-6].d, yypvt[-5].d, yypvt[-4].d, yypvt[-3].d, yypvt[-2].d, yypvt[-1].d, yypvt[-0].d,
				0., 0., 0., CurTrans);
		} break;
case 72:
# line 393 "input_yacc.y"
{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			explicit_trans(CurTrans,
				yypvt[-11].d, yypvt[-10].d, yypvt[-9].d, yypvt[-8].d, yypvt[-7].d, yypvt[-6].d, yypvt[-5].d, yypvt[-4].d, yypvt[-3].d,
				yypvt[-2].d, yypvt[-1].d, yypvt[-0].d,CurTrans);
		} break;
case 73:
# line 402 "input_yacc.y"
{
			eyep = yypvt[-1].v;
			if (CurTrans) {
				transform_point(&eyep, CurTrans);
				free((char *)CurTrans);
				CurTrans = (TransInfo *)0;
			}
		} break;
case 74:
# line 412 "input_yacc.y"
{
			lookp = yypvt[-0].v;
		} break;
case 75:
# line 417 "input_yacc.y"
{
			up = yypvt[-0].v;
		} break;
case 76:
# line 422 "input_yacc.y"
{
			hfov = yypvt[-1].d; vfov = yypvt[-0].d;
		} break;
case 77:
# line 426 "input_yacc.y"
{
			hfov = yypvt[-0].d;
		} break;
case 78:
# line 431 "input_yacc.y"
{
			if (!SamplesSet)
				JitSamples = yypvt[-0].i;
		} break;
case 79:
# line 437 "input_yacc.y"
{
			if (!AdaptiveSet && !JitteredSet)
				pixel_div = yypvt[-0].i;
		} break;
case 80:
# line 443 "input_yacc.y"
{
			if (!ContrastSet) {
				RedContrast = yypvt[-2].d;
				GreenContrast = yypvt[-1].d;
				BlueContrast = yypvt[-0].d;
			}
		} break;
case 81:
# line 452 "input_yacc.y"
{
			if (!CutoffSet)
				TreeCutoff = yypvt[-0].d;
		} break;
case 82:
# line 458 "input_yacc.y"
{
			if (!AdaptiveSet)
				Jittered = TRUE;
		} break;
case 83:
# line 464 "input_yacc.y"
{
			if (!ResolutionSet) {
				Xres = yypvt[-1].i;
				Yres = yypvt[-0].i;
			}
		} break;
case 84:
# line 471 "input_yacc.y"
{
			if (!ResolutionSet) {
				Xres = yypvt[-1].i;
				Yres = yypvt[-0].i;
			}
		} break;
case 85:
# line 479 "input_yacc.y"
{
			aperture = yypvt[-0].d;
		} break;
case 86:
# line 484 "input_yacc.y"
{
			focaldist = yypvt[-0].d;
		} break;
case 87:
# line 489 "input_yacc.y"
{
			maxlevel = yypvt[-0].i;
		} break;
case 88:
# line 494 "input_yacc.y"
{
			background = yypvt[-0].col;
		} break;
case 89:
# line 499 "input_yacc.y"
{
			light[nlight].pos = yypvt[-0].v;
			light[nlight].type = LOCAL;
			nlight++;
		} break;
case 90:
# line 505 "input_yacc.y"
{
			(void)normalize(&(yypvt[-0].v));
			light[nlight].pos = yypvt[-0].v;
			light[nlight].type = DIRECTIONAL;
			nlight++;
		} break;
case 91:
# line 512 "input_yacc.y"
{
			light[nlight].pos = yypvt[-1].v;
			light[nlight].radius = yypvt[-0].d;
			light[nlight].type = EXTENDED;
			nlight++;
		} break;
case 92:
# line 520 "input_yacc.y"
{
			if (nlight == LIGHTS)
				yyerror("Too many lights.\n");
			light[nlight].color.r = yypvt[-0].d;
			light[nlight].color.g = yypvt[-0].d;
			light[nlight].color.b = yypvt[-0].d;
		} break;
case 93:
# line 528 "input_yacc.y"
{
			if (nlight == LIGHTS)
				yyerror("Too many lights.\n");
			light[nlight].color = yypvt[-0].col;
		} break;
case 94:
# line 537 "input_yacc.y"
{
			/*
			 * surface name
			 * 	amb
			 * 	diff
			 * 	spec coef reflect refract krefract
			 */
			stmp = make_surface(yypvt[-7].c, &(yypvt[-6].col), &(yypvt[-5].col), &(yypvt[-4].col), yypvt[-3].d, yypvt[-2].d,
					yypvt[-1].d, yypvt[-0].d, 0., 0.);
			Surfaces = add_surface(stmp, Surfaces);

		} break;
case 95:
# line 551 "input_yacc.y"
{
			/*
			 * surface name
			 * 	amb
			 * 	diff
			 * 	spec coef reflect refract krefract
			 */
			stmp = make_surface(yypvt[-9].c, &(yypvt[-8].col), &(yypvt[-7].col), &(yypvt[-6].col), yypvt[-5].d, yypvt[-4].d,
					yypvt[-3].d, yypvt[-2].d, yypvt[-1].d, yypvt[-0].d);
			Surfaces = add_surface(stmp, Surfaces);

		} break;
case 96:
# line 565 "input_yacc.y"
{
			LastObj = makhf(yypvt[-1].c, yypvt[-0].c);
		} break;
case 97:
# line 570 "input_yacc.y"
{
			LastObj = makpoly(yypvt[-1].c, Polypoints, Npoints);
			Polypoints = (PointList *)0;
			Npoints = 0;
		} break;
case 100:
# line 580 "input_yacc.y"
{
			Point = (PointList *)Malloc(sizeof(PointList));
			Point->vec = yypvt[-0].v;
			Point->next = Polypoints;
			Polypoints = Point;
			Npoints++;
		} break;
case 101:
# line 589 "input_yacc.y"
{
			CurTrans = new_transinfo();
			LastObj = makcone(yypvt[-4].c, &(yypvt[-3].v), &(yypvt[-2].v), yypvt[-1].d, yypvt[-0].d, CurTrans);
		} break;
case 102:
# line 595 "input_yacc.y"
{
			/*
			 * Cylinders automagically define a
			 * transformation matrix.
			 */
			CurTrans = new_transinfo();
			LastObj = makcyl(yypvt[-3].c, &(yypvt[-2].v), &(yypvt[-1].v), yypvt[-0].d, CurTrans);
		} break;
case 103:
# line 605 "input_yacc.y"
{
			LastObj = maksph(yypvt[-2].c, yypvt[-1].d, &(yypvt[-0].v));
		} break;
case 104:
# line 612 "input_yacc.y"
{
			LastObj = makbox(yypvt[-6].c, yypvt[-5].d, yypvt[-4].d, yypvt[-3].d, yypvt[-2].d, yypvt[-1].d, yypvt[-0].d);
		} break;
case 105:
# line 617 "input_yacc.y"
{
			LastObj = maktri(TRIANGLE, yypvt[-3].c, &(yypvt[-2].v), &(yypvt[-1].v), &(yypvt[-0].v),
					(Vector *)0, (Vector *)0, (Vector *)0);
		} break;
case 106:
# line 622 "input_yacc.y"
{
			LastObj = maktri(PHONGTRI, yypvt[-6].c, &(yypvt[-5].v), &(yypvt[-3].v),
					&(yypvt[-1].v), &(yypvt[-4].v), &(yypvt[-2].v), &(yypvt[-0].v));
		} break;
case 107:
# line 631 "input_yacc.y"
{
			LastObj = maksup(yypvt[-7].c, yypvt[-6].d, yypvt[-5].d, yypvt[-4].d, yypvt[-3].d, yypvt[-2].d, yypvt[-1].d, yypvt[-0].d);
		} break;
case 108:
# line 636 "input_yacc.y"
{
			LastObj = makplane(yypvt[-2].c, &(yypvt[-1].v), &(yypvt[-0].v));
		} break;
case 109:
# line 641 "input_yacc.y"
{
			if (*outfilename != (char)NULL)
				yywarning("Ignoring output file name \"%s\".\n",
							yypvt[-0].c);
			else
				strcpy(outfilename, yypvt[-0].c);
		} break;
case 110:
# line 650 "input_yacc.y"
{
			GlobalMist = (Mist *)Malloc(sizeof(Mist));
			GlobalMist->color = yypvt[-3].col;
			GlobalMist->trans = yypvt[-2].col;
			GlobalMist->zero = yypvt[-1].d;
			GlobalMist->scale = 1. / yypvt[-0].d;
		} break;
case 111:
# line 659 "input_yacc.y"
{
			GlobalFog = (Fog *)Malloc(sizeof(Fog));
			GlobalFog->trans = 1./yypvt[-1].d;
			GlobalFog->color = yypvt[-0].col;
		} break;
case 112:
# line 666 "input_yacc.y"
{
			yyval.col.r = yypvt[-2].d;
			yyval.col.g = yypvt[-1].d;
			yyval.col.b = yypvt[-0].d;
		} break;
case 113:
# line 673 "input_yacc.y"
{
			yyval.v.x = yypvt[-2].d;
			yyval.v.y = yypvt[-1].d;
			yyval.v.z = yypvt[-0].d;
		} break;
case 114:
# line 680 "input_yacc.y"
{ yyval.d = yypvt[-0].d;} break;
case 115:
# line 682 "input_yacc.y"
{ yyval.d = yypvt[-0].i;} break;
case 116:
# line 685 "input_yacc.y"
{ yyval.c = yypvt[-0].c;} break;
		}
		goto yystack;  /* stack new state and value */

	}
