#
# Makefile for rayshade, Modified for MSDOS 1/26/90 Glenn A. Emelko
#
# Rayshade 3.0 Patch level 3, Originally by Craig Kolb
#
# MSDOS version compiled 1/26/90 Glenn A. Emelko
#
# Revision 3.0  89/10/27  02:05:45  craig
# Baseline for first official release.
# 
# Note: The lines beginning with #* have no compatible form or are not generic
# in the MSDOS environment across any number of compilers, therefore I did not
# make any attempt to support (or remove the support of) those options. GAE/90
#
#* Location of Utah-raster library and include files, if appropriate.
#* If you are compiling with -DNORLE, leave these two undefined.
#
#* RLELIB = /usr/u/utah/lib/librle.a
#* RLEINC = /usr/u/utah/include
#
#* Linda compiler, if appropriate.
#
#* CC = cc
#* LCC = /homes/systems/carriero/linda/v2.2/bin/clc
#
# Temporary file directory, bin direction, and executable name.
#
#* TMPDIR = /tmp
#* BINDIR = /usr/u/craig/bin
#
#* SHADENAME = rayshade.exe
#
#* Compiler flags.
#
#* GENERIC (BSD):	CFLAGS = -I$(RLEINC) -DTMPDIR=\"$(TMPDIR)\"
#* SYSV:			add -DSYSV
#
#* Multimax (shared memory):
#*			add -DMULTIMAX
#* Linda:		add -DLINDA (and move raytrace.c to raytrace.cl)
#
#* Long ago, rayshade was compiled on the Amiga using Aztec C and:
#*			CFLAGS = +fi +C +D +L -DTMPDIR="t:" -DAZTEC
# 
#* If you are not using the Utah Raster toolkit, add -DNORLE
#* If your compiler doesn't understand the void type, add -DNOVOID
#
#* If your compiler has trouble with the definitions of
#* vecadd(), veccomb(), etc. in funcdefs.h, compile with -DDUMB_CPP
#
#* Be sure to add any necessary floating-point hardware switches.
# 
#* CFLAGS = -I$(RLEINC) -DTMPDIR=\"$(TMPDIR)\" -O -DSYSV -DNORLE
#* CFLAGS = -DNORLE -DSYSV -O
#
#* Libraries:
#* BSD:		LIBS = $(RLELIB) -lm
#* SYSV:		LIBS = $(RLELIB) -lm
#* AZTEC C (amiga):
#*		LIBS = $(RLELIB) -lUnixl32 -lmal32 -lml32 -lcl32
#*
#* Multimax:	LIBS = $(RLELIB) -lm -lpp
#
#* If you have fast versions of malloc/free available, use them
#* (e.g., -lmalloc on MIPS machines).
#
#* LIBS = $(RLELIB) -lm
#
#* Uncomment the following line if you want the
#* fast malloc routines in malloc.c to be used.
#
#* MALLOC.O = malloc.o
#
#
#* Change "raytrace.o" to "raytrace.lo" below if using Linda.
#
#* OBJ =	main.o ray_options.o setup.o input.o input_yacc.o input_lex.o \
#*		viewing.o object.o bounds.o voxels.o list.o surface.o \
#*		raymath.o matrix.o raytrace.o intersect.o grid.o box.o cone.o \
#*		cylinder.o hf.o plane.o poly.o sphere.o superq.o triangle.o \
#*		texture.o noise.o shade.o atmosphere.o light.o outputp.o \
#*		memory.o version.o $(MALLOC.O)
#
#* input_yacc.c:	input_yacc.y
#*		yacc -d input_yacc.y
#*		mv y.tab.c input_yacc.c
#
#* input_lex.c:	input_lex.l
#*		lex -t input_lex.l > input_lex.c

main.obj: main.c constant.h typedefs.h datatype.h primobj.h defaults.h
	msc -DNORLE -DSYSV -O -DMSDOS main.c;

ray_opti.obj: ray_opti.c constant.h typedefs.h datatype.h primobj.h
	msc -DNORLE -DSYSV -O -DMSDOS ray_opti.c;

setup.obj: setup.c constant.h defaults.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS setup.c;

input.obj: input.c constant.h typedefs.h datatype.h primobj.h
	msc -DNORLE -DSYSV -O -DMSDOS input.c;

input_ya.obj: input_ya.c constant.h typedefs.h datatype.h primobj.h funcdefs.h texture.h
	msc -DNORLE -DSYSV -O -DMSDOS input_ya.c;

input_le.obj: input_le.c typedefs.h datatype.h primobj.h y_tab.h
	msc -DNORLE -DSYSV -O -DMSDOS input_le.c;

viewing.obj: viewing.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS viewing.c;

object.obj: object.c constant.h typedefs.h datatype.h primobj.h funcdefs.h texture.h
	msc -DNORLE -DSYSV -O -DMSDOS object.c;

bounds.obj: bounds.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS bounds.c;

voxels.obj: voxels.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS voxels.c;

list.obj: list.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS list.c;

surface.obj: surface.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS surface.c;

raymath.obj: raymath.c typedefs.h datatype.h primobj.h constant.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS raymath.c;

matrix.obj: matrix.c typedefs.h datatype.h primobj.h constant.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS matrix.c;

raytrace.obj: raytrace.c typedefs.h datatype.h primobj.h constant.h funcdefs.h raytrace.h
	msc -DNORLE -DSYSV -O -DMSDOS raytrace.c;

intersec.obj: intersec.c typedefs.h datatype.h primobj.h funcdefs.h constant.h
	msc -DNORLE -DSYSV -O -DMSDOS intersec.c;

grid.obj: grid.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS grid.c;

box.obj: box.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS box.c;

cone.obj: cone.c typedefs.h datatype.h primobj.h funcdefs.h constant.h
	msc -DNORLE -DSYSV -O -DMSDOS cone.c;

cylinder.obj: cylinder.c typedefs.h datatype.h primobj.h funcdefs.h constant.h
	msc -DNORLE -DSYSV -O -DMSDOS cylinder.c;

hf.obj: hf.c typedefs.h datatype.h primobj.h funcdefs.h constant.h
	msc -DNORLE -DSYSV -O -DMSDOS hf.c;

plane.obj: plane.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS plane.c;

poly.obj: poly.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS poly.c;

sphere.obj: sphere.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS sphere.c;

superq.obj: superq.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS superq.c;

triangle.obj: triangle.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS triangle.c;

texture.obj: texture.c constant.h typedefs.h datatype.h primobj.h funcdefs.h texture.h
	msc -DNORLE -DSYSV -O -DMSDOS texture.c;

noise.obj: noise.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS noise.c;

shade.obj: shade.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS shade.c;

atmosphe.obj: atmosphe.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS atmosphe.c;

light.obj: light.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS light.c;

outputp.obj: outputp.c constant.h typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS outputp.c;

memory.obj: memory.c typedefs.h datatype.h primobj.h funcdefs.h
	msc -DNORLE -DSYSV -O -DMSDOS memory.c;

version.obj: version.c patchlevel.h
	msc -DNORLE -DSYSV -O -DMSDOS version.c;

rayshade.exe: main.obj ray_opti.obj setup.obj input.obj input_ya.obj \
	      input_le.obj viewing.obj object.obj bounds.obj voxels.obj \
	      list.obj surface.obj raymath.obj matrix.obj raytrace.obj \
	      intersec.obj grid.obj box.obj cone.obj cylinder.obj hf.obj \
	      plane.obj poly.obj sphere.obj superq.obj triangle.obj \
	      texture.obj noise.obj shade.obj atmosphe.obj light.obj \
	      outputp.obj memory.obj version.obj
	link @objlist
