/*
 * outputp.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: outputp.c,v 3.0.1.1 89/12/06 16:33:17 craig Exp $
 *
 * $Log:	outputp.c,v $
 * Revision 3.0.1.1  89/12/06  16:33:17  craig
 * patch2: Added calls to new error/warning routines.
 * 
 * Revision 3.0  89/10/27  02:05:58  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include "typedefs.h"
#include "constants.h"
#include "funcdefs.h"
#ifndef NORLE
#include "svfb_global.h"
unsigned char *buffer[3];	/* Output buffer */
#endif

FILE *imgfile;			/* Raster output file */
char outfilename[BUFSIZ];	/* Name of output file */
int Appending;			/* Appending to output file? */

/*
 * Convert floating-point to unsigned char (0-255).
 * This could easily be a macro, but the old SGI compilers dump core
 * on it for some reason.
 */
unsigned char
correct(x)
double x;
{
	if (x < 0)
		return 0;
	if (x > 255)
		return 255;
	return x;
}

#ifndef NORLE
/*
 * Open image file and write RLE header.
 */
startpic()
{
	extern int Xres, Yres;

	if (*outfilename) {
		if (Appending) {
			/*
			 * If we're appending, we *still* have to write
			 * the Utah Raster header to the file.  This is
			 * due to strangeness in the Utah Raster toolkit,
			 * which does some vital initialization in sv_setup().
			 */
			imgfile = fopen(outfilename, "r+");
		} else
			imgfile = fopen(outfilename, "w");
		if (imgfile == (FILE *)NULL)
			yyerror("Cannot open %s for writing.", outfilename);
	} else
		imgfile = stdout;
	sv_globals.svfb_fd = imgfile;
	sv_globals.sv_xmax = Xres -1;
	sv_globals.sv_ymax = Yres -1;
	sv_globals.sv_xmin = sv_globals.sv_ymin = 0;
	sv_globals.sv_ncolors = 3;
	sv_globals.sv_alpha = 0;
	sv_setup(RUN_DISPATCH, &sv_globals);
	/*
	 * Flush the header.  If we don't, and LINDA forks off
	 * a bunch of workers, strange things will happen (they'll
	 * all flush the buffer when they die, and you end up with
	 * lots of headers at the end of the file).
	 */
	fflush(sv_globals.svfb_fd);
	buffer[0]=(unsigned char *)Malloc(sizeof(unsigned char)*(unsigned)Xres);
	buffer[1]=(unsigned char *)Malloc(sizeof(unsigned char)*(unsigned)Xres);
	buffer[2]=(unsigned char *)Malloc(sizeof(unsigned char)*(unsigned)Xres);
	if (Appending)
		fseek(imgfile, 0L, 2);		/* Go to end of file */
}


/*
 * Write a scanline of output.
 * "buf" is an array of Color structures of size Xres.  Each color
 * component is normalized to [0, 1.].
 */
outline(buf)
Color *buf;
{
	register int i;
	extern int Xres;

	for(i = 0;i < Xres;i++) {
		/*
		 * Scale colors to fit unsigned char and check for
		 * over/underflow.
		 */
		buffer[0][i] = correct(255 * buf[i].r);
		buffer[1][i] = correct(255 * buf[i].g);
		buffer[2][i] = correct(255 * buf[i].b);
	}
	sv_putrow(buffer, Xres, &sv_globals);
}

/*
 * Close image file.
 */
endpic()
{
	sv_puteof(&sv_globals);
	fclose(imgfile);
}

#else /* NORLE */

startpic()
{
	extern int Xres, Yres;

	if (*outfilename) {
		if (Appending)
			imgfile = fopen(outfilename, "a");
		else
			imgfile = fopen(outfilename, "w");
		if (imgfile == (FILE *)NULL)
			RSerror("Cannot open %s for writing.", outfilename);
	} else
		imgfile = stdout;

	fprintf(imgfile,"%d %d\n",Xres, Yres);
	fflush(imgfile);
}

outline(buf)
Color *buf;
{
	register int i;
	extern int Xres;

	for (i = 0; i < Xres; i++) {
		fputc(correct(255.*buf[i].r), imgfile);
		fputc(correct(255.*buf[i].g), imgfile);
		fputc(correct(255.*buf[i].b), imgfile);
	}
	fflush(imgfile);
}

endpic()
{
	fclose(imgfile);
}
#endif /* NORLE */

