/*
 * ray_options.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: ray_options.c,v 3.0.1.4 89/12/06 16:33:55 craig Exp $
 *
 * $Log:	ray_options.c,v $
 * Revision 3.0.1.4  89/12/06  16:33:55  craig
 * patch2: Added calls to new error/warning routines.
 * 
 * Revision 3.0.1.3  89/12/02  16:42:16  craig
 * patch2: Added -F option.
 * 
 * Revision 3.0.1.2  89/11/20  13:02:22  craig
 * patch1: Fixed problems involving overriding values on the command line.
 * 
 * Revision 3.0.1.1  89/11/16  18:28:38  craig
 * patch1: Added -w option.
 * 
 * Revision 3.0  89/10/27  02:06:00  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif
#include "constants.h"
#include "typedefs.h"

int Verbose;			/* Blabbering flag */
int TrashBadPoly;		/* Discard even mildly bad polygons */
int Quiet;			/* Don't be so verbose flag */
char *progname;			/* argv[0] */

/*
 * Flags indicating that options were set on the command line.
 */
int ResolutionSet, ContrastSet, SamplesSet, CutoffSet, AdaptiveSet, JitteredSet;

#ifdef LINDA
int Workers;			/* # of workers */
int VerboseWorker;
#endif

parse_options(argc, argv)
int argc;
char **argv;
{
	extern char *infilename;
	extern double RedContrast, GreenContrast, BlueContrast, atof();
	extern int pixel_div, JitSamples, Xres, Yres, Jittered, Cache;
	extern int Stereo, StartLine, Appending, NoShadows, ClearShadows;
	extern int ReportFreq;
	extern double Separation, TreeCutoff;
	extern char outfilename[];
	extern FILE *fstats;

	progname = argv[0];
	fstats = stderr;

	while(--argc) {
		argv++;
		if(argv[0][0] != '-')
			break;
		switch(argv[0][1]) {
			case 'C':
				RedContrast = atof(argv[1]);
				GreenContrast = atof(argv[2]);
				BlueContrast = atof(argv[3]);
				ContrastSet = TRUE;
				argv += 3;
				argc -= 3;
				break;
			case 'c':
				ClearShadows = TRUE;
				break;
			case 'E':
				Separation = atof(argv[1]);
				argc--; argv++;
				break;
			case 'F':
				ReportFreq = atoi(argv[1]);
				if (ReportFreq < 1)
					ReportFreq = 1;
				argv++; argc--;
				break;
			case 'h':
				usage();
				exit(0);
				break;
			case 'j':
				Jittered = TRUE;
				JitteredSet = TRUE;
				break;
			case 'L':
				StartLine = atoi(argv[1]);
				Appending = TRUE;
				argc--; argv++;
				break;
			case 'l':
				Stereo = LEFT;
				break;
			case 'n':
				NoShadows = TRUE;
				break;
			case 'O':
				strcpy(outfilename, argv[1]);
				argv++;
				argc--;
				break;
			case 'P':
				pixel_div = atoi(argv[1]);
				if(pixel_div < 0)
					pixel_div = 0;
				AdaptiveSet = TRUE;
				argv++;
				argc--;
				break;
			case 'p':
				TrashBadPoly = TRUE;
				break;
			case 'q':
				Quiet = TRUE;
				break;
			case 'R':
				Xres = atoi(argv[1]);
				Yres = atoi(argv[2]);
				ResolutionSet = TRUE;
				argv += 2;
				argc -= 2;
				break;
			case 'r':
				Stereo = RIGHT;
				break;
			case 'S':
				JitSamples = atoi(argv[1]);
				if (JitSamples < 1)
					JitSamples = 1;
				SamplesSet = TRUE;
				argv++; argc--;
				break;
			case 's':
				Cache = !Cache;
				break;
			case 'T':
				TreeCutoff = atof(argv[1]);
				CutoffSet = TRUE;
				argv++; argc--;
				break;
			case 'v':
				Verbose = TRUE;
				break;
			case 'V':
				Verbose = TRUE;
				if (argv[1][0] == '-') {
					/* User probably blew it, and
					 * it's difficult to remove a file
					 * that begins with '-'...
					 */
					usage();
					exit(2);
				}
				fstats = fopen(argv[1], "w");
				if (fstats == (FILE *)0) {
					RSerror("Cannot open stats file %s.\n",
							argv[0]);
				}
				argv++; argc--;
				break;
#ifdef LINDA
			case 'W':
				Workers = atoi(argv[1]);
				if (Workers < 0 || Workers > 17) {
					RSerror("%d workers?\n",workers);
				}
				argv++; argc--;
				break;
			case 'w':
				VerboseWorker = !VerboseWorker;
				break;
#endif
			default:
				RSerror("Bad argument: %s\n", argv[0]);
		}
	}

	if(argc > 1) {
		usage();
		exit(1);
	} else if(argc == 1)
		infilename = argv[0];
	else
		infilename = (char *)NULL;

	/*
	 * Although the user may have defined the output file name
	 * in the input file, it's best to force them to give a filename
	 * on the command line if using the -L option.  This saves situations
	 * where they forget to specify an output file to append to but
	 * aren't informed of it until startpic() is called (after the
	 * entire input file is read).
	 */
	if (Appending && *outfilename == (char)NULL) {
		RSerror("The -L option requires the -O option.\n");
	}

	if (Stereo && Separation == 0.) {
		RSerror("Stereo mode requires use of -E option.\n");
	}
}

usage()
{
	fprintf(stderr,"usage: %s [options] [filename]\n", progname);
	fprintf(stderr,"Where options include:\n");
	fprintf(stderr,"\t-C r g b\t(Set contrast threshold (0. - 1.).)\n");
	fprintf(stderr,"\t-c \t\t(Trace shadow rays through clear objects.)\n");
	fprintf(stderr,"\t-E eye_sep\t(Set eye separation.)\n");
	fprintf(stderr,"\t-F freq\t\t(Frequency, in lines, of status report.)\n");
	fprintf(stderr,"\t-h \t\t(Print this message.)\n");
	fprintf(stderr,"\t-j \t\t(Antialias using jittered sampling.)\n");
	fprintf(stderr,"\t-L line#\t(Begin rendering at specified line.)\n");
	fprintf(stderr,"\t-l \t\t(Render image for left eye view.)\n");
	fprintf(stderr,"\t-n \t\t(Don't compute shadows.)\n");
	fprintf(stderr,"\t-O outfile \t(Specify output file name.)\n");
	fprintf(stderr,"\t-P pixel_divs\t(Set max depth for adaptive supersampling.)\n");
	fprintf(stderr,"\t-p \t\t(Discard polygons with degenerate edges.)\n");
	fprintf(stderr,"\t-q \t\t(Run quietly.)\n");
	fprintf(stderr,"\t-R xres yres\t(Render at given resolution.)\n");
	fprintf(stderr,"\t-r \t\t(Render image for right eye view.)\n");
	fprintf(stderr,"\t-S samples\t(Use samples^2 jittered samples.)\n");
	fprintf(stderr,"\t-s \t\t(Don't cache shadowing information.)\n");
	fprintf(stderr,"\t-T thresh\t(Set adaptive ray tree cutoff value.)\n");
	fprintf(stderr,"\t-V filename \t(Write verbose output to filename.)\n");
	fprintf(stderr,"\t-v \t\t(Verbose output.)\n");
#ifdef LINDA
	fprintf(stderr,"\t-W workers (Specify number of worker processes.)\n");
	fprintf(stderr,"\t-w \t\t(Verbose worker output.)\n");
#endif
}
