/*
 * setup.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: setup.c,v 3.0.1.1 89/12/02 16:52:33 craig Exp $
 *
 * $Log:	setup.c,v $
 * Revision 3.0.1.1  89/12/02  16:52:33  craig
 * patch2: Added code to set default value for ReportFreq.
 * 
 * Revision 3.0  89/10/27  02:06:03  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include "constants.h"
#include "defaults.h"
#include "typedefs.h"
#include "funcdefs.h"

#ifdef MULTIMAX
#include <parallel.h>
#define SHARED_BYTES	23	/* 2^23 bytes of shared memory */
#endif
/*
 * Set default parameters
 */
setup()
{
	extern int maxlevel, ReportFreq;
	extern double hfov, vfov;
	extern Vector eyep, lookp, up;
	extern Object *World;
	extern ObjList *CurObj;
#ifdef MULTIMAX
	unsigned int bytes;

	/*
	 * Initialize shared memory stuff.
	 */
	bytes = 1 << SHARED_BYTES;
	if (share_malloc_init(bytes) == -1) {
		fprintf(stderr,"Cannot share_malloc %d bytes.\n",bytes);
		exit(10);
	} else
		fprintf(stderr,"Malloced %d bytes of shared memory.\n",
				bytes);
#endif
	/*
	 * Like every other object, the objects that make up
	 * "World" are stored in a simple linked list until it
	 * has been completely defined.  Once the definition is
	 * complete we convert the linked list into a Grid or List
	 * as per the user's wishes.
	 */
	World = new_object("world", LIST, (char *)NULL, (Trans *)NULL);

	maxlevel = MAXLEVEL;
	hfov = HFOV;
	vfov = UNSET;
	eyep.x = EYEX;
	eyep.y = EYEY;
	eyep.z = EYEZ;
	lookp.x = LOOKX;
	lookp.y = LOOKY;
	lookp.z = LOOKZ;
	up.x = UPX;
	up.y = UPY;
	up.z = UPZ;
	ReportFreq = REPORTFREQ;

	/*
	 * Kinda yicky, but compatible.
	 */
	CurObj = (ObjList *)Malloc(sizeof(ObjList));
	CurObj->next = (ObjList *)0;
	CurObj->data = (Object *)0;
	InitRTable();			/* Initialize values for Noise() */
}

/*
 * cleanup()
 *
 * Initialize variables not set on command line or in input file.
 */
cleanup()
{
	int i;
	extern int nlight, maxlevel;
	extern int Xres, Yres, StartLine, Jittered, JitSamples, pixel_div;
	extern double RedContrast, GreenContrast, BlueContrast, TreeCutoff;
	extern double vfov, hfov;
	extern Light light[];
	extern FILE *fstats;

	/*
	 * Because we want the user to be able to override the input file
	 * through the command line, we have to initialize some variables to
	 * bogus values so that when the file is being parsed, it is
	 * possible to tell if a given variable has been set on the
	 * command line.
	 *
	 * If such variables are not set to legal values on the command
	 * line or in the input file, we must do it here.
	 */
	if (Xres == UNSET)
		Xres = XRESOLUTION;
	if (Yres == UNSET)
		Yres = YRESOLUTION;

	if (StartLine == UNSET)
		StartLine = Yres -1;
	else
		fprintf(fstats,"Starting on line %d\n",StartLine);

	/*
	 * If not defined in the input file, calculate VFOV
	 * by hand.  This assumes that pixels are square, which is
	 * probably a bad idea.  ("aspect" option?)
	 */
	if (vfov == UNSET)
		vfov = hfov * Yres / Xres;

	if (!Jittered && pixel_div == UNSET)
		pixel_div = PIXEL_DIV;

	if (JitSamples == UNSET)
		JitSamples = DEFLIGHTSAMPLES;

	if (Jittered && JitSamples > 5) {
		fprintf(stderr,"Sorry, %d rays/pixel not supported.\n",
						JitSamples*JitSamples);
		exit(2);
	}
	if (!Jittered && JitSamples < 3) {
		fprintf(stderr,"Samples (-S) value must be at least 3.\n");
		exit(2);
	}

	if (TreeCutoff == UNSET)
		TreeCutoff = DEFCUTOFF;

	if (RedContrast == UNSET)
		RedContrast = DEFREDCONT;
	if (GreenContrast == UNSET)
		GreenContrast = DEFGREENCONT;
	if (BlueContrast == UNSET)
		BlueContrast = DEFBLUECONT;

	/*
	 * Now that we've parsed the input file, we know what
	 * maxlevel is, so we can allocate the right amount of
	 * space for each light source's cache and related
	 * transformation.
	 */
	for (i = 0; i < nlight; i++) {
		light[i].cache = (Primitive **)Calloc(maxlevel+1,
					sizeof(Primitive *));
		light[i].trans = (TransInfo *)Malloc((maxlevel+1)*
					sizeof(TransInfo));
	}
}
