/*
 * cubes.c
 *
 * Version:  2.0 (23/07/92) Author:  Antonio Costa, INESC-Norte.
 *
 */

#include <stdio.h>
#include <math.h>
#include <memory.h>
#include "def.h"
#include "lib.h"

#define OUTPUT_FORMAT OUTPUT_CURVES

#define RADIUS1 (1.0 / 4.0)
#define RADIUS2 (1.0 / 16.0)

#define inv_level (1.0 / (double) level)
#define radius1 ((double) RADIUS1 / (double) level)
#define radius2 ((double) RADIUS2 / (double) level)

#define SET_COORD SET_COORD3

static int	level = 5;

main(argc, argv)
  int             argc;
  char           *argv[];
{
  COORD4          back_color, obj_color;
  COORD4          light;
  COORD4          from, at, up;
  COORD4          center, center1, center2;
  long            x, y, z;
  double          delta, x0, y0, z0;

  if (!lib_get_size(argc, argv, &level))
  {
    fprintf(stderr, "usage: %s [size]\n", *argv);
    exit(EXIT_FAIL);
  }

  delta = (radius1 * (1.0 - sqrt((double) RADIUS2 / (double) RADIUS1))) * 0.99;

  /* output viewpoint */
  SET_COORD(from, ((double) (level >> 1) + 0.5) * inv_level, 1.0,
	    1.0 - 1.0 / (double) (level << 1));
  SET_COORD(at, ((double) (level >> 1) + 0.5) * inv_level, 0.5,
	    0.5 - 1.0 / (double) (level << 1));
  SET_COORD(up, 0.0, 1.0, 0.0);
  lib_output_viewpoint(&from, &at, &up, 60.0, 1.0, 512, 512);

  /* output background color - UNC sky blue */
  SET_COORD(back_color, 0.078, 0.361, 0.753);
  lib_output_background_color(&back_color);

  /* output light sources */
  SET_COORD(light, 2.0, 0.5, 0.5);
  lib_output_light(&light);
  SET_COORD(light, -1.0, 0.5, 0.5);
  lib_output_light(&light);
  SET_COORD(light, 0.5, 2.0, 0.5);
  lib_output_light(&light);
  SET_COORD(light, 0.5, -1.0, 0.5);
  lib_output_light(&light);
  SET_COORD(light, 0.5, 0.5, 2.0);
  lib_output_light(&light);
  SET_COORD(light, 0.5, 0.5, -1.0);
  lib_output_light(&light);

  for (x = 0; x <= level; x++)
  {
    x0 = (double) x / (double) level;
    for (y = 0; y <= level; y++)
    {
      y0 = (double) y / (double) level;
      for (z = 0; z <= level; z++)
      {
	z0 = (double) z / (double) level;

	SET_COORD(obj_color, 0.8, 0.8, 0.2);
	lib_output_color(&obj_color, 0.5, 0.5, 3.0, 0.0, 0.0);

	SET_COORD4(center, x0, y0, z0, radius1);
	lib_output_sphere(&center, OUTPUT_FORMAT);

	if (x != level)
	{
	  SET_COORD(obj_color, 0.9, 0.1, 0.1);
	  lib_output_color(&obj_color, 0.99, 0.0, 6.0, 0.0, 0.0);

	  SET_COORD4(center1, x0 + delta, y0, z0, radius2);
	  SET_COORD4(center2, x0 + inv_level - delta, y0, z0, radius2);
	  lib_output_cylcone(&center1, &center2, OUTPUT_FORMAT);
	}
	if (y != level)
	{
	  SET_COORD(obj_color, 0.1, 0.9, 0.1);
	  lib_output_color(&obj_color, 0.99, 0.0, 6.0, 0.0, 0.0);

	  SET_COORD4(center1, x0, y0 + delta, z0, radius2);
	  SET_COORD4(center2, x0, y0 + inv_level - delta, z0, radius2);
	  lib_output_cylcone(&center1, &center2, OUTPUT_FORMAT);
	}
	if (z != level)
	{
	  SET_COORD(obj_color, 0.1, 0.1, 0.9);
	  lib_output_color(&obj_color, 0.99, 0.0, 6.0, 0.0, 0.0);

	  SET_COORD4(center1, x0, y0, z0 + delta, radius2);
	  SET_COORD4(center2, x0, y0, z0 + inv_level - delta, radius2);
	  lib_output_cylcone(&center1, &center2, OUTPUT_FORMAT);
	}
      }
    }
  }
}
