#include <stdio.h>
#include <string.h>

#define XMAX 1024
#define YMAX 1024

#define delimiter '\\'

typedef
unsigned char   byte;

#define BUFFER_SIZE (18000)

byte            image_buffer[BUFFER_SIZE][3];

#define STRING_MAX 64
char            progname[STRING_MAX];

FILE           *inimage, *outimage[3];

char            buf[3][BUFSIZ];

byte
read_byte()
{
  char            data;

  if (fread(&data, 1, 1, inimage) != 1)
  {
    fprintf(stdout, "ERROR: premature EOF\n");
    exit(1);
  }
  return ((byte) data);
}

main(argc, argv)
  int             argc;
  char           *argv[];

{
  register int    y, i;
  int             xsize, ysize, size;
  char            infile[STRING_MAX], outfile[3][STRING_MAX];

  if (strrchr(argv[0], delimiter) == 0)
    strcpy(progname, argv[0]);
  else
    strcpy(progname, strrchr(argv[0], delimiter) + 1);

  if (argc != 2)
  {
    fprintf(stdout, "PIC to RGB converter\n");
    fprintf(stdout, "ERROR: usage is '%s image (.PIC)'\n", progname);
    exit(1);
  }

  sprintf(infile, "%s.pic", argv[1]);

  if ((inimage = fopen(infile, "rb")) == NULL)
  {
    fprintf(stdout, "ERROR: cannot read %s\n", infile);
    exit(1);
  }

  sprintf(outfile[0], "%s.r8", argv[1]);

  if ((outimage[0] = fopen(outfile[0], "wb")) == NULL)
  {
    fprintf(stdout, "ERROR: cannot write %s\n", outfile);
    exit(1);
  }
  sprintf(outfile[1], "%s.g8", argv[1]);

  if ((outimage[1] = fopen(outfile[1], "wb")) == NULL)
  {
    fprintf(stdout, "ERROR: cannot write %s\n", outfile);
    exit(1);
  }
  sprintf(outfile[2], "%s.b8", argv[1]);

  if ((outimage[2] = fopen(outfile[2], "wb")) == NULL)
  {
    fprintf(stdout, "ERROR: cannot write %s\n", outfile);
    exit(1);
  }

  fprintf(stdout, "PIC to RGB converter\n");
  fprintf(stdout, "Reading PIC %s\n", infile);
  fprintf(stdout, "Writing %s (.R8 .G8 .B8)\n", argv[1]);

  xsize = (int) read_byte();
  xsize += (int) read_byte() << 8;

  ysize = (int) read_byte();
  ysize += (int) read_byte() << 8;

  setbuf(outimage[0], buf[0]);
  setbuf(outimage[1], buf[1]);
  setbuf(outimage[2], buf[2]);

  size = (int) (((long int) ysize * (long int) xsize) / BUFFER_SIZE);

  for (y = 1; y <= size; y++)
  {
    fread((char *) image_buffer, 1, 3 * BUFFER_SIZE, inimage);
    for (i = 0; i < BUFFER_SIZE; i++)
    {
      fwrite(&image_buffer[i][0], 1, 1, outimage[0]);
      fwrite(&image_buffer[i][1], 1, 1, outimage[1]);
      fwrite(&image_buffer[i][2], 1, 1, outimage[2]);
    }
  }

  size = (int) ((long int) ysize * (long int) xsize -
		(long int) size * BUFFER_SIZE);

  fread((char *) image_buffer, 1, 3 * size, inimage);
  for (i = 0; i < size; i++)
  {
    fwrite(&image_buffer[i][0], 1, 1, outimage[0]);
    fwrite(&image_buffer[i][1], 1, 1, outimage[1]);
    fwrite(&image_buffer[i][2], 1, 1, outimage[2]);
  }

  fclose(inimage);
  fclose(outimage[0]);
  fclose(outimage[1]);
  fclose(outimage[2]);

  exit(0);
}