
;
;   XIONCODE.ASM
;
;   (Simon Hern, 1994)
;
;   Assembler routine to dent part of a planet surface
;
;   The Skin array is rolled and squashed to make a sphere
;   The sphere is then sliced in half and all of the top half is lifted
;   Riff data is used to line up the slices
;
;   Called from MAKEXION.C
;   '_skin' is an array of integers (RHO by 2*RHO) filling exactly one
;       segment of memory (64k)
;   '_riff' is the riff data - an array of bytes RHO/2 by RHO/2
;



    public _fracture    ; Exported routine


RHO     EQU 128     ; Surface resolution (same as in PLANET.H)


_Text   SEGMENT BYTE PUBLIC 'Code'


; (void) Fracture( (int)rf_num, (int)blast, (int)x_start )
;   rf_num : the riff to use (RHO/2 to choose from); angles the slice
;   blast : the amount by which to displace the fractured surface
;   x_start : starting position in terms of longitude (0 to 2*RHO-1)

_fracture:
    push bp
    mov bp,sp
    push si
    push di
    push ds
    push es
    mov dx,w[bp+6]              ; blast
    mov ah,b[bp+4]              ; rf_num
    mov cl,b[bp+8]              ; x_start
    xor ch,ch

    push ds
    pop es
    xor al,al
    shr ax,1
    shr ax,1                    ; (ax = 64 * rf_num, where 64=RHO/2)
    add ax,OFFSET _riff
    mov bp,ax                   ; es:bp -> riff[rf_num][0]

    push bp
    push cx

    push SEG _skin
    pop ds
    mov di,cx
    shl di,1                    ; ds:di -> skin[0][x_start]
    dec cl
    mov si,cx
    shl si,1                    ; ds:si -> skin[0][(x_start-1) % (2*RHO)]

    xor bl,bl
    mov cl,64
f01:
    mov bh,es:b[bp]             ; fill in two quadrants of skin
    inc bp                      ;  si,di point to start of columns
    cmp bh,0                    ;  bx gives offset down column
    jz f05                      ;  cl counts
    dec bh
    jz f06
    shl bx,1
f02:
    add w[di+bx],dx
    add w[si+bx],dx
    dec bh
    dec bh
    jnz f02
f06:
    add w[di],dx
    add w[si],dx

f05:
    inc di                      ; next columns
    inc di                      ; di,si stay in range 0 to (2*RHO-1)
    and di,511                  ;  times 2 since we're using words not bytes
    dec si
    dec si
    and si,511
    dec cl
    jnz f01

    pop cx
    pop bp

    add cl,128
    mov di,cx
    shl di,1                    ; ds:di -> skin[0][(x_start+RHO) % (2*RHO)]
    dec cl
    mov si,cx
    shl si,1                    ; ds:si -> skin[0][(x_start+RHO-1) % (2*RHO)]

    xor bl,bl
    mov cl,64
f03:
    mov bh,127                  ; now do the other two quadrants
    sub bh,es:b[bp]
    inc bp
    cmp bh,0
    jz f07
    dec bh
    jz f08
    shl bx,1
f04:
    add w[di+bx],dx
    add w[si+bx],dx
    dec bh
    dec bh
    jnz f04
f08:
    add w[di],dx
    add w[si],dx

f07:
    inc di                      ; next columns
    inc di
    and di,511
    dec si
    dec si
    and si,511
    dec cl
    jnz f03

    pop es
    pop ds
    pop di
    pop si
    pop bp
    ret

_Text ENDS

