;
;
; Texture mapping coded by:
;
; Written by: John McCarthy (aka Flynn)
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; email: BRIANMCC@IDIRECT.COM
;    or: BRIAN.MCCARTHY@CANREM.COM
;    or: RY80@JECALPHA.KA.SUB.ORG
;
; Home phone,(905)831-1944, always willing to talk but don't call at 2 am eh!
;
; Send me a postcard from someplace near where you live.
;
;   Wanna help write an Operating System?  Call or write to me today!
;
;

;
;
;  "A"  /0      "B"  0\         "C" __________
;     0/ |           | \1           \        /
;     /  |           |  \            \      /
;    /   |          0|   \            \    /
;   1\   1           |   /2            \  /
;     \  |           |  /               \/
;     2\ |           | /2
;       \2            1
;
;

         .386p

vertex   struc
  vtx_x3d               dd 0 ; 3d world co-ordinates
  vtx_y3d               dd 0
  vtx_z3d               dd 0
  vtx_x2d               dd 0
  vtx_y2d               dd 0
vertex   ends

poly_connection  struc
  pc_previous_vertex    dd 0
  pc_this_vertex        dd 0
  pc_next_vertex        dd 0
  pc_texture_x          dd 0
  pc_texture_y          dd 0
  pc_next_link          dd 0
  pc_previous_link      dd 0
poly_connection  ends

polygon struc
  pg_vertex_count       dd 0 ; number of verticies in polygon
  pg_poly_list          dd 0 ; offset to first poly_connection (linked list)
polygon ends

DGROUP   GROUP _TEXT
_TEXT    SEGMENT PARA PUBLIC 'CODE'
         ASSUME CS:_TEXT,DS:DGROUP,ES:DGROUP

extrn    _virtual_video_tables:dword
extrn    _virtual_video_width:dword

;
; Triangle slopes/lengths (used by all routines)
;

_l0      dd 0
_l1      dd 0
_l2      dd 0
_s0      dd 0
_s1      dd 0
_s2      dd 0
_coarse_position_step dd 0

         public sine_
         public cosine_
         public textured_triangle_
         public textured_polygon_

;
; Textured Shaded Triangle:
;
; esi = pointer to poly_connection 1 structure
; edi = pointer to poly_connection 2 structure
; ebx = pointer to poly_connection 3 structure
;  dx = texture to plot (selector)
;
; textured_triangle(struct poly_connection *v1,
;                   struct poly_connection *v2,
;                   struct poly_connection *v3,
;                   short texture,short mask);
; flat_textured_triangle(struct poly_connection *v1,
;                        struct poly_connection *v2,
;                        struct poly_connection *v3,
;                        short texture,short mask);
; gouraud_textured_triangle(struct poly_connection *v1,
;                           struct poly_connection *v2,
;                           struct poly_connection *v3,
;                           short texture,short mask);
;
; Somewhere we need a mask, a shading xref table, and later, gouraud info.
;
; possible configurations/unrolled loops:
;
;  tile (esi)      xref (ds:)    gouraud (cx,dx)
;     no              no               no    textured_triangle
;     yes             no               no
;     no              yes              no    flat_textured_triangle
;     yes             yes              no
;     no              yes              yes   gouraud_textured_triangle
;     yes             yes              yes
;
; calculations must be done for with or without gouraud shading
; calculations must also check for negative x step with tiled textures.
;
; Note: For texture mapping, always set the segment limit to 64k more than the
;       base address of the texture, even if your texture is 32x32 or 64x64.
;       This will allow the texture routine to sample pixels outside of the map
;       without crashing.  Very large textures may be slightly innaccurate
;       in keeping track of the sample location - but they will never go
;       beyond 64k of the original texture base.  (ie mov al,gs:[bx])
;
; full intensity texture
;
;       add     ecx,edx
;       adc     ebx,ebp
;       adc     bh,dh
;*      and     ebx,esi         ; si = tile mask
;       mov     al,gs:[bx]      ; gs = texture
;       stosb                   ; es:edi = destination
;
;* = tile mask (can be removed)
;
;- For 0 = clear texture mapping, replace stosb with:
;
;         or al,al
;         jz short local ft_noplot
;         mov [edi],al
;  ft_noplot:
;         inc edi
;
;- Note: 10000 polygons     tiled = 51.08 seconds
;        10000 polygons not tiled = 44.33 seconds, ratio of 1:1.15
;
;

_pc0              dd 0                      ; poly_connection offsets
_pc1              dd 0
_pc2              dd 0
_v0               dd 0
_v1               dd 0
_v2               dd 0
_triangle_ebp     dd 0
_texture_eax      dd 0
_texture_esi      dd 0
_texture_ebp      dd 0
_texture_edx      dd 0
_texture_y_count  dd 0
_scan_slope_tx    dd 0
_scan_slope_ty    dd 0
_scan_slope_cx    db 0
_scan_slope_cy    db 0

texture_tile_     dd 0ffff3f3fh             ; "tile" for texture

textured_triangle_:
         push ebp
         push gs
         mov gs,dx
         mov edx,esi                        ; _pc0, save poly_connection offsets
         mov ebp,edi                        ; _pc1
         mov _pc2,ebx
         mov esi,[esi].pc_this_vertex       ; load vertex offsets
         mov edi,[edi].pc_this_vertex
         mov ecx,[ebx].pc_this_vertex

         mov eax,[esi].vtx_y2d              ; load vertex y in preperation for sort
         mov ebx,[ecx].vtx_y2d

         cmp eax,[edi].vtx_y2d
         jl short ft_test_next_0            ; 0 < 1
         je short ft_test_x1                ; 0 = 1

         xchg esi,edi
         xchg edx,ebp
         cmp [esi].vtx_y2d,ebx
         jl short ft_done_test              ; 1 < 2
         je short ft_test_x2                ; 1 = 2

         xchg [_pc2],edx
         xchg esi,ecx
         jmp short ft_done_test

ft_test_next_0:
         cmp eax,ebx
         jl short ft_done_test              ; 0 < 2
         je short ft_test_x2                ; 0 = 2

         xchg [_pc2],edx
         xchg esi,ecx
         jmp short ft_done_test

ft_test_x1:
         cmp eax,ebx
         jge short ft_flip_y2

         mov eax,[esi].vtx_x2d
         cmp eax,[edi].vtx_x2d
         jge short ft_done_test

         xchg edx,ebp
         xchg esi,edi
         jmp short ft_done_test

ft_test_x2:
         mov eax,[esi].vtx_x2d
         cmp eax,[ecx].vtx_x2d
         jge short ft_done_test

ft_flip_y2:
         xchg [_pc2],edx
         xchg esi,ecx

ft_done_test:
         mov _pc0,edx
         mov _pc1,ebp
         mov _v0,esi
         mov _v1,edi
         mov _v2,ecx

         mov ebp,[ecx].vtx_y2d              ; find length of long side
         sub ebp,[esi].vtx_y2d              ; _l1, length 0-2
         mov _l1,ebp
         jz short ft_dont_calculate_s1

         mov eax,[ecx].vtx_x2d              ; find slope of 0-2
         sub eax,[esi].vtx_x2d
         shl eax,16
         cdq
         idiv ebp
         mov _s1,eax
ft_dont_calculate_s1:

         mov ebp,[ecx].vtx_y2d              ; test type A or B
         sub ebp,[edi].vtx_y2d
         mov _l2,ebp                        ; result length 1-2
         jz short ft_handle_flatbottom      ; test if flatbottom (avoid divide by 0)

         mov eax,[ecx].vtx_x2d              ; find slope of top 1-2
         sub eax,[edi].vtx_x2d
         shl eax,16
         cdq
         idiv ebp
         mov _s2,eax
ft_handle_flatbottom:

         mov ebx,[edi].vtx_y2d              ; find length of 0-1 (first short side)
         sub ebx,[esi].vtx_y2d              ; ebx = _l0 from 0-1
         mov _l0,ebx
         jz short ft_is_flattop

         mov eax,[edi].vtx_x2d              ; find slope of 0-1
         sub eax,[esi].vtx_x2d
         shl eax,16
         cdq
         idiv ebx
         mov _s0,eax
         mov edx,eax
ft_is_flattop:
         or ebx,ebx                         ; test if 0-1 = 0
         jz ft_handle_flattop_0
         cmp _l1,0
         je ft_handle_flattop_1

         mov ecx,_l1
         mov eax,_s1
         cmp edx,eax
         jle short ft_ok_orientation

         neg _l2
         mov edi,_pc1
         xchg _pc2,edi
         mov _pc1,edi
         xchg edx,eax
         xchg ebx,ecx
         or ebp,ebp                         ; test if _l2 > 0
         jg ft_type_b_in

         mov _s1,eax
         mov ebp,_v2
         mov _v1,ebp
         mov _v2,edi
         mov _s0,edx
         mov _l0,ebx
         mov _l1,ecx
         xor ebp,ebp

ft_ok_orientation:
         or ebp,ebp                         ; test if _l2 < 0
         jl ft_type_b_ok

         mov edi,[esi].vtx_y2d              ; calculate start edi (from vertex 0)
         mov ecx,_virtual_video_tables
         mov edi,[edi*4+ecx]
         mov ecx,[esi].vtx_x2d
         add edi,ecx
         dec edi
         mov ecx,80000000h
         mov ebp,edx                        ; get position slope
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s1-s0
         mov esi,eax                        ; eax = slope1 - slope0
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,cx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov _triangle_ebp,ebp
         push ecx edi esi ebx
         call do_typea_texture_calculations
         pop eax esi edi ebp
         mov edx,ebp
         std                                ; type "a" are backwards fills
         mov cx,ax
ft_texture_loopa0:
         push ebx ecx ebp edx edi
         mov ax,bp
         add edi,eax
         mov ebp,_texture_ebp
         mov edx,_texture_edx
         push esi
         mov esi,texture_tile_
         call ft_text_offsets_s[eax*4]
         pop esi
         pop edi edx ebp
         xor eax,eax
         add edx,esi                        ; high esi = fine length step,   high edx = fine length count
         adc ebp,_triangle_ebp              ; high ebp = fine position step, high ecx = fine position count
         adc al,al
         add edi,_coarse_position_step
         add edi,eax
         sub ebp,eax                        ; eax = carry
         pop ecx ebx
         add ecx,_scan_slope_tx             ; add fine x, low _scan_slope_tx = 0, cx is gouraud shading hi/lo
         adc bl,_scan_slope_cx              ; add carry from fine x to coarse x
         add ebx,_scan_slope_ty             ; add fine y, coarse x, and carry from fine x
         adc bh,_scan_slope_cy              ; add carry from fine y to coarse y
         dec cx
         jnz short ft_texture_loopa0
         cmp word ptr _l2,cx
         jz ft_fastout
         push edx ebp
         mov eax,_s1
         mov edx,_s2                        ; get next position slope
         mov ebp,edx
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,0                           ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov _triangle_ebp,ebp
         pop ebp edx
         xor eax,eax
         mov cx,word ptr _l2
ft_texture_loopa1:
         push ebx ecx ebp edx edi
         mov ax,bp
         add edi,eax
         mov ebp,_texture_ebp
         mov edx,_texture_edx
         push esi
         mov esi,texture_tile_
         call ft_text_offsets_s[eax*4]
         pop esi
         pop edi edx ebp
         xor eax,eax
         add edx,esi                        ; high esi = fine length step,   high edx = fine length count
         adc ebp,_triangle_ebp              ; high ebp = fine position step, high ecx = fine position count
         adc al,al
         add edi,_coarse_position_step
         add edi,eax
         sub ebp,eax                        ; eax = carry
         pop ecx ebx
         add ecx,_scan_slope_tx             ; add fine x, low _scan_slope_tx = 0, cx is gouraud shading hi/lo
         adc bl,_scan_slope_cx              ; add carry from fine x to coarse x
         add ebx,_scan_slope_ty             ; add fine y, coarse x, and carry from fine x
         adc bh,_scan_slope_cy              ; add carry from fine y to coarse y
         dec cx
         jnz short ft_texture_loopa1
ft_fastout:
         cld
         pop gs
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

ft_type_b_in:
         mov edi,_v1
         mov ebx,_v2
         mov _v1,ebx
         mov _v2,edi
         mov edi,_l1
         mov _l0,edi
         mov _l1,ecx

ft_type_b_ok:
         mov edi,[esi].vtx_y2d              ; calculate start edi (from vertex 0)
         mov ebx,_virtual_video_tables
         mov edi,[edi*4+ebx]
         mov ebx,[esi].vtx_x2d
         add edi,ebx

         mov _s0,edx
         mov ebx,ecx
         mov ecx,80000000h
         mov ebp,edx                        ; get position slope
         shl ebp,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s1-s0
         mov esi,eax                        ; eax = slope1 - slope0
         shr eax,16
         mov bp,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,cx                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov _triangle_ebp,ebp
         push ecx edi esi ebx
         call do_typeb_texture_calculations
         pop eax esi edi ebp
         mov cx,ax
         mov edx,ebp
ft_texture_loopb0:
         push ebx ecx ebp edx edi
         mov ax,bp
         mov ebp,_texture_ebp
         mov edx,_texture_edx
         push esi
         mov esi,texture_tile_
         call ft_text_offsets_s[eax*4]
         pop esi
         pop edi edx ebp
         xor eax,eax
         add edx,esi                        ; high esi = fine length step,   high edx = fine length count
         adc ebp,_triangle_ebp              ; high ebp = fine position step, high ecx = fine position count
         adc al,al
         add edi,_coarse_position_step
         add edi,eax
         sub ebp,eax
         pop ecx ebx
         add ecx,_scan_slope_tx             ; add fine x, low _scan_slope_tx = 0, cx is gouraud shading hi/lo
         adc bl,_scan_slope_cx              ; add carry from fine x to coarse x
         add ebx,_scan_slope_ty             ; add fine y, coarse x, and carry from fine x
         adc bh,_scan_slope_cy              ; add carry from fine y to coarse y
         dec cx
         jnz short ft_texture_loopb0
         push ebp edx
         mov ebp,_s2
         mov edx,_s0                        ; get next position slope
         sub ebp,edx                        ; calculate length slope from s2-s1
         mov esi,ebp                        ; eax = slope2 - slope1
         shr ebp,16
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bp,0                           ; add bp,0
         shl esi,16                         ; fine length step
         mov word ptr _triangle_ebp,bp
         pop edx ebp
         xor eax,eax
         mov cx,word ptr _l2
ft_texture_loopb1:
         push ebx ecx ebp edx edi
         mov ax,bp
         mov ebp,_texture_ebp
         mov edx,_texture_edx
         push esi
         mov esi,texture_tile_
         call ft_text_offsets_s[eax*4]
         pop esi
         pop edi edx ebp
         xor eax,eax
         add edx,esi                        ; high esi = fine length step,   high edx = fine length count
         adc ebp,_triangle_ebp              ; high ebp = fine position step, high ecx = fine position count
         adc al,al
         add edi,_coarse_position_step
         add edi,eax
         sub ebp,eax
         pop ecx ebx
         add ecx,_scan_slope_tx             ; add fine x, low _scan_slope_tx = 0, cx is gouraud shading hi/lo
         adc bl,_scan_slope_cx              ; add carry from fine x to coarse x
         add ebx,_scan_slope_ty             ; add fine y, coarse x, and carry from fine x
         adc bh,_scan_slope_cy              ; add carry from fine y to coarse y
         inc cx
         jnz short ft_texture_loopb1
         pop gs
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

ft_handle_flattop_1:
         mov edi,ecx
         mov _s1,eax
         neg _l2
         neg ebp
         mov eax,_pc1
         xchg _pc2,eax
         mov _pc1,eax

ft_handle_flattop_0:
         or ebp,ebp
         jz ft_flat_line                    ; handle flat line.
         mov eax,[edi].vtx_y2d              ; calculate start edi (from vertex 1)
         mov ebx,_virtual_video_tables
         mov eax,[eax*4+ebx]
         mov ecx,[edi].vtx_x2d
         add eax,ecx
         mov ecx,[esi].vtx_x2d              ; calculate start length for flattop
         sub ecx,[edi].vtx_x2d
         push ecx
         push ebp
         mov edi,eax

         mov ebp,80000000h
         mov eax,_s1
         mov edx,_s2                        ; get next position slope
         mov ebx,edx
         shl ebx,16                         ; ebp = fine position step
         sub eax,edx                        ; calculate length slope from s2-s1
         mov esi,eax                        ; eax = slope2 - slope1
         shr eax,16
         mov bx,ax                          ; coarse length step
         add si,dx                          ; add in sbb reduction (see sbb in loop)
         adc bx,bp                          ; add bp,0
         shl esi,16                         ; fine length step
         sar edx,16
         add edx,_virtual_video_width       ; coarse position step (add in screen width)
         mov _coarse_position_step,edx
         mov _triangle_ebp,ebx
         push esi edi ebp
         call do_typec_texture_calculations
         pop edx edi esi eax ebp
         or ebp,edx
         mov cx,ax
ft_texture_loopc0:
         push ebx ecx ebp edx edi
         mov ax,bp
         mov ebp,_texture_ebp
         mov edx,_texture_edx
         push esi
         mov esi,texture_tile_
         call ft_text_offsets_s[eax*4]
         pop esi
         pop edi edx ebp
         xor eax,eax
         add edx,esi                        ; high esi = fine length step,   high edx = fine length count
         adc ebp,_triangle_ebp              ; high ebp = fine position step, high ecx = fine position count
         adc al,al
         add edi,_coarse_position_step
         add edi,eax
         sub ebp,eax                        ; eax = carry
         pop ecx ebx
         add ecx,_scan_slope_tx             ; add fine x, low _scan_slope_tx = 0, cx is gouraud shading hi/lo
         adc bl,_scan_slope_cx              ; add carry from fine x to coarse x
         add ebx,_scan_slope_ty             ; add fine y, coarse x, and carry from fine x
         adc bh,_scan_slope_cy              ; add carry from fine y to coarse y
         dec cx
         jnz short ft_texture_loopc0
         pop gs
         pop ebp                            ; shitty C calling can't preserve ebp
         ret

ft_flat_line:
         mov ebx,ecx
         mov edx,[esi].vtx_x2d              ; handle single flat line
         mov ebp,[edi].vtx_x2d
         mov ecx,[ebx].vtx_x2d

         cmp edx,ebp
         jg ft_flat_t3

         cmp edx,ecx
         jg ft_flat_t2

         cmp ebp,ecx
         mov ebx,_pc2
         jng short ft_flat_t0
         mov ebx,_pc1
         mov ecx,ebp
ft_flat_t0:
         mov ebp,_pc0
         jmp short ft_flat_t1

ft_flat_t2:
         mov edx,ecx
         mov ecx,ebp
         mov esi,ebx
         mov ebp,_pc2
         mov ebx,_pc1
         jmp short ft_flat_t1

ft_flat_t3:
         cmp edx,ecx
         jg short ft_flat_t4

         mov edx,ebp
         mov esi,edi
         mov ebp,_pc1
         mov ebx,_pc2
         jmp short ft_flat_t1

ft_flat_t4:
         xchg ecx,edx
         mov esi,ebx
         cmp ebp,edx
         mov eax,ebp
         mov ebp,_pc2
         mov ebx,_pc0
         jg short ft_flat_t1
         mov edx,eax
         mov esi,edi
         mov ebp,_pc1

ft_flat_t1:
         mov edi,[esi].vtx_y2d              ; calculate start edi (from vertex 0)
         mov eax,_virtual_video_tables
         mov edi,[edi*4+eax]
         add edi,edx                        ; esi = start vertex, edx = start x
         sub ecx,edx                        ; ecx = end x, start texture = ebp, end texture = ebx
         or ecx,ecx
         jz short ft_flat_t5

         mov esi,ecx

         mov eax,[ebp].pc_texture_y
         sub eax,[ebx].pc_texture_y
         cdq
         idiv esi
         mov ecx,eax

         mov eax,[ebp].pc_texture_x
         sub eax,[ebx].pc_texture_x
         cdq
         idiv esi

         rol ecx,16                         ; eax = slope.t.x
         rol eax,16                         ; ecx = slope.t.y
         mov ch,cl
         mov cl,al
         cmp cl,80h
         setae al
         sub ch,al
         xor ax,ax
         mov edx,eax
         mov ebp,ecx
         mov ecx,[esi].pc_texture_x
         mov ebx,[esi].pc_texture_y
         rol ebx,16
         rol ecx,16
         mov bh,bl
         mov bl,cl

         mov ecx,esi
         mov esi,texture_tile_
         call ft_text_offsets_s[ecx*4]

ft_flat_t5:
         pop gs
         pop ebp
         ret

;
;
;Unrolled Texture Fill:
;
; ebx = length
; edi = location
;
; high esi = fine length step,   high edx = fine length count
; high ebp = fine position step, high ecx = fine position count
; low  ebp = coarse length step, low  ecx = length
;
; Aren't unrolled loops great!
;
; Texture:
;
; Inside Loop:
;
; ]    es:edi => video buffer
;  ! * ds:eax = xref tables, where ah = intensity, and al = colour
;  ! * high edx = fine step for x of texture
; ]    high ecx = fine count for x of texture
; ]!%* low dx = dl = fine step for gouraud
; ]!%* low dx = dh = coarse step for gouraud
; ] %  low cx = cl = fine count for gouraud
; ] %  low cx = ch = coarse count for gouraud (current xref)
;  ! * high ebp = fine step for y of texture
; ]    high ebx = fine count for y of texture
; ]    low bx = current x,y of texture
;  ! * low bp = coarse step for texture (bp high byte = bp high byte - dh)
;  ! * high esi = 0ffff0000h
;  ! * low si = tile mask for texture, eg 64x128 texture, si = 7f3fh
;    * al = ?
;    * ah = ?
;    * gs: => pointer to start of texture
;
; * = same from scan line to scan line
; % = gouraud stuff
; ! = loaded from memory before texture call (constant)
; ] = used in inside texture loop and outside triangle loop
;
; Outside loop:  bx = y,x of texture. cx = y,x coarse update for texture
;
;

ft_text_flat_s:
         rept x_max
         and ebx,esi             ; esi = tile mask (must be logical mask,
         mov al,gs:[bx]          ; looks really cool with small tiles)

         stosb                   ; es:edi = destination
         add ecx,edx
         adc ebx,ebp
         adc bh,dh
         endm
ft_text_flat_s_end:
         ret

         align 4

ft_text_offsets_s label dword
         i = x_max
         rept x_max + 1
         dd offset ft_text_flat_s + i * (ft_text_flat_s_end - ft_text_flat_s)/x_max
         i = i - 1
         endm

;
; Texture calculations for type "A" triangle
;

do_typea_texture_calculations:
         mov esi,_v0
         mov edi,_v1
         mov eax,_s1
         mov ebp,_l0
         imul ebp
         mov ebx,[edi].vtx_x2d
         sub ebx,[esi].vtx_x2d
         sar eax,16
         sub ebx,eax

         mov esi,_pc0                       ; retrieve poly_connection offsets
         mov edi,_pc2

         mov eax,[edi].pc_texture_x
         sub eax,[esi].pc_texture_x
         mov ecx,_l1
         or ecx,ecx
         jnz short do_noa0
         inc ecx
do_noa0:
         cdq
         idiv ecx
         push eax
         push eax
         mov eax,[edi].pc_texture_y
         sub eax,[esi].pc_texture_y
         cdq
         idiv ecx
         pop ecx
         push eax
         rol eax,16
         rol ecx,16
         mov _scan_slope_cy,al
         mov _scan_slope_cx,cl
         xor ax,ax
         xor cx,cx
         mov _scan_slope_ty,eax             ; slope for outside loop
         mov _scan_slope_tx,ecx

         mov edi,_pc1
         pop eax
         imul ebp
         mov ecx,[esi].pc_texture_y
         sub ecx,[edi].pc_texture_y
         add eax,ecx
         or ebx,ebx
         jnz short do_noa1
         dec ebx
do_noa1:
         cdq
         idiv ebx
         mov ecx,eax
         pop eax
         imul ebp
         mov ebp,[esi].pc_texture_x
         sub ebp,[edi].pc_texture_x
         add eax,ebp
         cdq
         idiv ebx
         mov edi,eax
         mov ebp,ecx
         rol ecx,16                         ; eax = slope.t.x
         rol eax,16                         ; ecx = slope.t.y
         mov ch,cl
         mov cl,al
         cmp cl,80h
         setae al
         sub ch,al
         xor ax,ax
         mov _texture_edx,eax
         mov _texture_ebp,ecx
         mov ecx,[esi].pc_texture_x
         mov ebx,[esi].pc_texture_y
         add ecx,edi
         add ebx,ebp
         rol ebx,16
         rol ecx,16
         mov bh,bl
         mov bl,cl
         ret

;
; Texture calculations for type "B" triangle
;

do_typeb_texture_calculations:
         mov edi,_v0
         mov ebx,_v2
         mov eax,_s0
         mov ebp,_l1
         imul ebp
         mov ebx,[ebx].vtx_x2d
         sub ebx,[edi].vtx_x2d
         sar eax,16
         sub ebx,eax
         neg ebx

         mov esi,_pc0                       ; retrieve poly_connection offsets
         mov edi,_pc1

         mov eax,[edi].pc_texture_x
         sub eax,[esi].pc_texture_x
         mov ecx,_l0
         or ecx,ecx
         jnz short do_nob0
         inc ecx
do_nob0:
         cdq
         idiv ecx
         push eax
         push eax
         mov eax,[edi].pc_texture_y
         sub eax,[esi].pc_texture_y
         cdq
         idiv ecx
         pop ecx
         push eax
         rol eax,16
         rol ecx,16
         mov _scan_slope_cy,al
         mov _scan_slope_cx,cl
         xor ax,ax
         xor cx,cx
         mov _scan_slope_ty,eax             ; slope for outside loop
         mov _scan_slope_tx,ecx

         mov edi,_pc2
         pop eax
         imul ebp
         mov ecx,[esi].pc_texture_y
         sub ecx,[edi].pc_texture_y
         add eax,ecx
         or ebx,ebx
         jnz short do_nob1
         dec ebx
do_nob1:
         cdq
         idiv ebx
         mov ecx,eax
         pop eax
         imul ebp
         mov ebp,[esi].pc_texture_x
         sub ebp,[edi].pc_texture_x
         add eax,ebp
         cdq
         idiv ebx
         rol ecx,16                         ; eax = slope.t.x
         rol eax,16                         ; ecx = slope.t.y
         mov ch,cl
         mov cl,al
         cmp cl,80h
         setae al
         sub ch,al
         xor ax,ax
         mov _texture_edx,eax
         mov _texture_ebp,ecx
         mov ecx,[esi].pc_texture_x
         mov ebx,[esi].pc_texture_y
         rol ebx,16
         rol ecx,16
         mov bh,bl
         mov bl,cl
         ret

;
; Texture calculations for type "C" triangle
;

do_typec_texture_calculations:
         mov ebp,ecx
         mov esi,_pc1                       ; retrieve poly_connection offsets
         mov edi,_pc2

         mov eax,[edi].pc_texture_x
         sub eax,[esi].pc_texture_x
         mov ecx,_l2
         or ecx,ecx
         jnz short do_noc0
         inc ecx
do_noc0:
         cdq
         idiv ecx
         mov ebx,eax
         mov eax,[edi].pc_texture_y
         sub eax,[esi].pc_texture_y
         cdq
         idiv ecx
         rol eax,16
         rol ebx,16
         mov _scan_slope_cy,al
         mov _scan_slope_cx,bl
         xor ax,ax
         xor bx,bx
         mov _scan_slope_ty,eax             ; slope for outside loop
         mov _scan_slope_tx,ebx

         mov edi,_pc0
         mov eax,[edi].pc_texture_y
         sub eax,[esi].pc_texture_y
         or ebp,ebp
         jnz short do_noc1
         inc ebp
do_noc1:
         cdq
         idiv ebp
         mov ecx,eax
         mov eax,[edi].pc_texture_x
         sub eax,[esi].pc_texture_x
         cdq
         idiv ebp
         rol ecx,16                         ; eax = slope.t.x
         rol eax,16                         ; ecx = slope.t.y
         mov ch,cl
         mov cl,al
         cmp cl,80h
         setae al
         sub ch,al
         xor ax,ax
         mov _texture_edx,eax
         mov _texture_ebp,ecx
         mov ecx,[esi].pc_texture_x
         mov ebx,[esi].pc_texture_y
         rol ebx,16
         rol ecx,16
         mov bh,bl
         mov bl,cl
         ret

;
; End of Texture Mapping routine
;

;
; Textured_Polygon:
; In:
;  ESI => pointer to polygon struture
;
;

textured_polygon_:
         push ebp
         mov ebp,[esi].pg_vertex_count
         sub ebp,2
         mov ebx,[esi].pg_poly_list
         mov esi,[ebx].pc_next_link
tp_polyloop:
         mov edi,[esi].pc_next_link
         push ebx edi edx
         call textured_triangle_
         pop edx edi esi
         dec ebp
         jz short tp_outahere
         mov ebx,[esi].pc_previous_link
         push ebx edi edx
         call textured_triangle_
         pop edx esi ebx
         dec ebp
         jnz short tp_polyloop

tp_outahere:
         pop ebp
         ret

;
;
;   sine_ - 16 bit theta to 32bit sin(@)
; In:
;    EAX - theta  0 - 65536 (0-360)
; Out:
;    EAX - sin (@)   (-10000h to 10000h)
;
;
;
; cosine_ - 16 bit theta to 32bit cos(@)
; In:
;    EAX - theta  0 - 65536 (0-360)
; Out:
;    EAX - cos (@)   (-10000h to 10000h)
;
;
;
; Notes:
; calculate sin into eax, from eax
; after imul by sin, shr eax,16 to compensate for decimal factor!
;
;  eg:
;    mov eax,sin(@)
;    mov ebx,32bitnumber
;    imul ebx
;    shrd eax,edx,16
;    eax = ebx*sin(@)
;
;    mov ax,sin(@)
;    mov bx,16bitnumber
;    imul bx
;    shrd ax,dx,16
;    eax = bx*sin(@)
;
;

         align 4

         extrn _cosine_tables:dword

cosine_:
         add eax,4000h
sine_:
         push ecx
         mov ecx,eax
         shr ecx,14
         and ecx,3
         and eax,03fffh
         jmp [_sign_quads +  ecx*4]

_sign_quads dd offset _quad0
            dd offset _quad1
            dd offset _quad2
            dd offset _quad3

_quad0:
         mov ecx,_cosine_tables
         mov eax,[eax*4+ecx]
         pop ecx
         ret
_quad1:
         xor eax,00003fffh
         mov ecx,_cosine_tables
         mov eax,[eax*4+ecx]
         pop ecx
         ret
_quad2:
         mov ecx,_cosine_tables
         mov eax,[eax*4+ecx]
         neg eax
         pop ecx
         ret
_quad3:
         xor eax,00003fffh
         mov ecx,_cosine_tables
         mov eax,[eax*4+ecx]
         neg eax
         pop ecx
         ret

;
; I don't know how to get C to perform (y1 * cx) >> 16 and still use
; high edx as part of the result.
;

         public mult64_

mult64_:
         push edx
         imul edx
         shrd eax,edx,16
         pop edx
         ret

_TEXT    ends
         end
