         .386p

DGROUP   GROUP _TEXT
_TEXT    SEGMENT BYTE PUBLIC 'CODE'
         ASSUME CS:_TEXT ,DS:DGROUP,ES:DGROUP

         public set_xmode_
         public set_write_plane_
         public set_write_mode_
         public set_start_offset_

LABEL    X320Y200 word
         db 00                              ; 0e3h    ; dot clock
         db 02                              ; Number of CRTC Registers to update
         dw 00014h                          ; turn off dword mode
         dw 0e317h                          ; turn on byte mode
         dw 320                             ; width
         dw 200                             ; height

LABEL    X320Y240 word
         db 0e3h                            ; dot clock
         db 10                              ; Number of CRTC Registers to update
         dw 00d06h                          ; vertical total
         dw 03e07h                          ; overflow (bit 8 of vertical counts)
         dw 04109h                          ; cell height (2 to double-scan)
         dw 0ea10h                          ; v sync start
         dw 0ac11h                          ; v sync end and protect cr0-cr7
         dw 0df12h                          ; vertical displayed
         dw 00014h                          ; turn off dword mode
         dw 0e715h                          ; v blank start
         dw 00616h                          ; v blank end
         dw 0e317h                          ; turn on byte mode
         dw 320                             ; width
         dw 240                             ; height

LABEL    X360Y200 word
         db 0e7h                            ; dot clock
         db 08                              ; Number of CRTC Registers to update
         dw 06b00h                          ; horz total
         dw 05901h                          ; horz displayed
         dw 05a02h                          ; start horz blanking
         dw 08e03h                          ; end horz blanking
         dw 05e04h                          ; start h sync
         dw 08a05h                          ; end h sync
         dw 00014h                          ; turn off dword mode
         dw 0e317h                          ; turn on byte mode
         dw 360                             ; width
         dw 200                             ; height

LABEL    X360Y240 word
         db 0e7h                            ; dot clock
         db 16                              ; Number of CRTC Registers to update
         dw 06b00h                          ; horz total
         dw 05901h                          ; horz displayed
         dw 05a02h                          ; start horz blanking
         dw 08e03h                          ; end horz blanking
         dw 05e04h                          ; start h sync
         dw 08a05h                          ; end h sync
         dw 00d06h                          ; vertical total
         dw 03e07h                          ; overflow (bit 8 of vertical counts)
         dw 04109h                          ; cell height (2 to double-scan)
         dw 0ea10h                          ; v sync start
         dw 0ac11h                          ; v sync end and protect cr0-cr7
         dw 0df12h                          ; vertical displayed
         dw 00014h                          ; turn off dword mode
         dw 0e715h                          ; v blank start
         dw 00616h                          ; v blank end
         dw 0e317h                          ; turn on byte mode
         dw 360
         dw 240

LABEL    X320Y400 word
         db 0e3h                            ; dot clock
         db 03                              ; Number of CRTC Registers to update
         dw 04009h                          ; cell height
         dw 00014h                          ; turn off dword mode
         dw 0e317h                          ; turn on byte mode
         dw 320                             ; width
         dw 400                             ; height

LABEL    X320Y480 word
         db 0e3h                            ; dotclock
         db 10                              ; Number of CRTC Registers to update
         dw 00d06h                          ; vertical total
         dw 03e07h                          ; overflow (bit 8 of vertical counts)
         dw 04009h                          ; cell height (2 to double-scan)
         dw 0ea10h                          ; v sync start
         dw 0ac11h                          ; v sync end and protect cr0-cr7
         dw 0df12h                          ; vertical displayed
         dw 00014h                          ; turn off dword mode
         dw 0e715h                          ; v blank start
         dw 00616h                          ; v blank end
         dw 0e317h                          ; turn on byte mode
         dw 320                             ; width
         dw 480                             ; height

LABEL    X360Y400 word
         db 0e7h                            ; dot clock
         db 09                              ; Number of CRTC Registers to update
         dw 06b00h                          ; horz total
         dw 05901h                          ; horz displayed
         dw 05a02h                          ; start horz blanking
         dw 08e03h                          ; end horz blanking
         dw 05e04h                          ; start h sync
         dw 08a05h                          ; end h sync
         dw 04009h                          ; cell height
         dw 00014h                          ; turn off dword mode
         dw 0e317h                          ; turn on byte mode
         dw 360                             ; width
         dw 400                             ; height


LABEL    X360Y480 word
         db 0e7h
         db 17
         dw 06b00h                          ; horz total
         dw 05901h                          ; horz displayed
         dw 05a02h                          ; start horz blanking
         dw 08e03h                          ; end horz blanking
         dw 05e04h                          ; start h sync
         dw 08a05h                          ; end h sync
         dw 00d06h                          ; vertical total
         dw 03e07h                          ; overflow
         dw 04009h                          ; cell height
         dw 0ea10h                          ; v sync start
         dw 0ac11h                          ; v sync end and protect cr0-cr7
         dw 0df12h                          ; vertical displayed
         dw 02d13h                          ; offset
         dw 00014h                          ; turn off dword mode
         dw 0e715h                          ; v blank start
         dw 00616h                          ; v blank end
         dw 0e317h                          ; turn on byte mode
         dw 360
         dw 480

LABEL    X360Y360 word
         db 0e7h
         db 15
         dw 06b00h                          ; horz total
         dw 05901h                          ; horz displayed
         dw 05a02h                          ; start horz blanking
         dw 08e03h                          ; end horz blanking
         dw 05e04h                          ; start h sync
         dw 08a05h                          ; end h sync
         dw 04009h                          ; cell height
         dw 08810h                          ; v sync start
         dw 08511h                          ; v sync end and protect cr0-cr7
         dw 06712h                          ; vertical displayed
         dw 02d13h                          ; offset
         dw 00014h                          ; turn off dword mode
         dw 06d15h                          ; v blank start
         dw 0ba16h                          ; v blank end
         dw 0e317h                          ; turn on byte mode
         dw 360
         dw 360

LABEL    X256Y240 word
         db 0e3h                            ; dot clock
         db 16                              ; Number of CRTC Registers to update
         dw 05f00h                          ; horz total
         dw 03f01h                          ; horz displayed
         dw 04202h                          ; start horz blanking
         dw 09f03h                          ; end horz blanking
         dw 04c04h                          ; start h sync
         dw 00005h                          ; end h sync
         dw 00d06h                          ; vertical total
         dw 03e07h                          ; overflow (bit 8 of vertical counts)
         dw 04109h                          ; cell height (2 to double-scan)
         dw 0ea10h                          ; v sync start
         dw 0ac11h                          ; v sync end and protect cr0-cr7
         dw 0df12h                          ; vertical displayed
         dw 00014h                          ; turn off dword mode
         dw 0e715h                          ; v blank start
         dw 00616h                          ; v blank end
         dw 0e317h                          ; turn on byte mode
         dw 256
         dw 240

LABEL    X256Y200 word
         db 0e3h                            ; dot clock
         db 8                               ; Number of CRTC Registers to update
         dw 05f00h                          ; horz total
         dw 03f01h                          ; horz displayed
         dw 04202h                          ; start horz blanking
         dw 09f03h                          ; end horz blanking
         dw 04c04h                          ; start h sync
         dw 00005h                          ; end h sync
         dw 00014h                          ; turn off dword mode
         dw 0e317h                          ; turn on byte mode
         dw 256
         dw 200

LAST_X_MODE = 11

LABEL    modetable dword                    ; Mode X tweak table
         dd offset X320Y200
         dd offset X320Y240
         dd offset X360Y200
         dd offset X360Y240
         dd offset X320Y400
         dd offset X320Y480
         dd offset X360Y400
         dd offset X360Y480
         dd offset X360Y360
         dd offset X256Y240
         dd offset X256Y200

M320x200x256 =0                             ; constants for easy calling
M320x240x256 =1
M360x200x256 =2
M360x240x256 =3
M320x400x256 =4
M320x480x256 =5
M360x400x256 =6
M360x480x256 =7
M360x360x256 =8
M256x240x256 =9                             ; GREAT modes - ypos is upper byte, xpos is lower
M256x200x256 =10

attrib_ctrl     equ 03c0h      ; vga attribute controller
gc_index        equ 03ceh      ; vga graphics controller
sc_index        equ 03c4h      ; vga sequencer controller
sc_data         equ 03c5h      ; vga sequencer data port
crtc_index      equ 03d4h      ; vga crt controller
crtc_data       equ 03d5h      ; vga crt controller data
misc_output     equ 03c2h      ; vga misc register
input_1         equ 03dah      ; input status #1 register

dac_write_addr  equ 03c8h      ; vga dac write addr register
dac_read_addr   equ 03c7h      ; vga dac read addr register
pel_data_reg    equ 03c9h      ; vga dac/pel data register r/w

pixel_pan_reg   equ 033h       ; attrib index: pixel pan reg
map_mask        equ 002h       ; sequ index: write map mask reg
read_map        equ 004h       ; gc index: read map register
start_disp_hi   equ 00ch       ; crtc index: display start hi
start_disp_lo   equ 00dh       ; crtc index: display start lo

map_mask_plane1 equ 00102h     ; map register + plane 1
map_mask_plane2 equ 01102h     ; map register + plane 2
all_planes_on   equ 00f02h     ; map register + all bit planes

chain4_off      equ 00604h     ; chain 4 mode off
async_reset     equ 00100h     ; (a)synchronous reset
sequ_restart    equ 00300h     ; sequencer restart

latches_on      equ 00008h     ; bit mask + data from latches
latches_off     equ 0ff08h     ; bit mask + data from cpu

vert_retrace    equ 08h        ; input_1: vertical retrace bit
plane_bits      equ 03h        ; bits 0-1 of xpos = plane #
all_planes      equ 0fh        ; all bit planes selected
char_bits       equ 0fh        ; bits 0-3 of character data

_modexscanlines dd 0
_modexwidth     dd 0
_modexheight    dd 0

;
;
; Sets mode # in AX, returns ax=0 if successful, ax=-1 if failed
; cx= width of screen
;
; Set_xMode_ adapted for WATCOM by John McCarthy aka Flynn,
; mostly ripped from VLA by Draeden,
; who leached it out of XLIB04C which was
; originally written by Themie Gouthas,
; who adapted parts from M. Abrash code.
; (Talk about code reuse!)
;
;

_mode    dd 0
_scrw    dd 0

set_xmode_:
         pushad
         cld
         mov [_mode],eax
         mov [_scrw],ecx

         mov ax,13h                         ; let the BIOS set standard 256-color
         int 10h                            ;  mode (320x200 linear)

         mov dx,sc_index
         mov ax,0604h
         out dx,ax                          ; disable chain4 mode
         mov ax,0100h
         out dx,ax                          ; synchronous reset while setting Misc
                                            ;  Output for safety, even though clock unchanged
         mov ebx,[_mode]
         mov esi,modetable[ebx*4]
         lodsb

         or al,al
         jz sx_dontsetdot
         mov dx,misc_output
         out dx,al                          ; select the dot clock and Horiz
                                            ;  scanning rate
sx_dontsetdot:
         mov dx,sc_index
         mov ax,0300h
         out dx,ax                          ; undo reset (restart sequencer)

         mov dx,crtc_index                  ; reprogram the CRT Controller
         mov al,11h                         ; VSync End reg contains register write
         out dx,al                          ; protect bit
         inc dx                             ; CRT Controller Data register
         in al,dx                           ; get current VSync End register setting
         and al,07fh                        ; remove write protect on various
         out dx,al                          ; CRTC registers
         dec dx                             ; CRT Controller Index
         cld
         xor ecx,ecx
         lodsb
         mov cl,al

sx_setcrtparmsloop:
         lodsw                              ; get the next CRT Index/Data pair
         out dx,ax                          ; set the next CRT Index/Data pair
         dec cx
         jne sx_setcrtparmsloop

         xor eax,eax
         lodsw
         mov [_modexwidth],eax
         lodsw
         mov [_modexheight],eax
         cmp ax,240
         jg sx_dontdouble
         add eax,eax
sx_dontdouble:
         mov [_modexscanlines],eax

         mov dx,sc_index
         mov ax,0f02h
         out dx,ax                          ; enable writes to all four planes

         mov edi,0a0000h                    ; point ES:EDI to display memory
         xor eax,eax                        ; clear to zero-value pixels
         mov cx,4000h                       ; # of dwords in display memory
         rep stosd                          ; clear all of display memory

         mov ecx,[_scrw]                    ; mode X is set, now set the required logical page width.
         shr ecx,3                          ; divide by 8
         mov dx,crtc_index
         mov al,13h
         mov ah,cl
         out dx,ax

         popad
         ret

;
; al = plane to write to
;

set_write_plane_:
         mov ah,al
         mov dx,sc_index
         mov al,2
         and ah,1111b
         out dx,ax
         ret

;
; initalize write mode
;

set_write_mode_:
         mov dx,gc_index
         mov al,5
         out dx,al
         inc dx
         in  al,dx
         and al,11111100b                   ; clear out write mode bits
         and ah,00000011b
         or  al,ah
         out dx,al
         ret

;
; bx = start offset (/4)
;

set_start_offset_:
         mov dx,crtc_index
         mov al,0ch
         mov ah,bh                          ; write the HIGH byte
         out dx,ax
         inc al
         mov ah,bl                          ; write the LOW byte
         out dx,ax
         ret

_TEXT    ends
         end
