


/* From PAL.C */
void GL_SetColor(int index,int r,int g,int b);
void GL_GetColor(int index,int *r,int *g,int *b);
void GL_SetPal(unsigned char *pal,int start,int numcols);
void GL_GetPal(unsigned char *pal,int start,int numcols);
void GL_FadeInPal(unsigned char *npal,int speed);
void GL_CyclePal(unsigned char *pal,int numcols,int direction);
int  GL_FindColor(unsigned char *pal,int r,int g,int b,int spr);
void GL_ReIndexPal(unsigned char *index,
                                unsigned char *opal,unsigned char *npal);


/* From SCR.C */
void GL_InitMode13(void);
void GL_TextMode(void);
void GL_ClearScreen(void);
void GL_ClearScreenColor(int color);
void GL_SetPixel(int x,int y,int color);
int  GL_GetPixel(int x,int y);
void GL_FillBox(int x1,int y1,int x2,int y2,int color);
void GL_FilledBox(int x1,int y1,int w,int h,int color);
void GL_Rectangle(int x1,int y1,int x2,int y2,int color);
void GL_Line(int x1,int y1,int x2,int y2,int color);
void GL_HLine(int x1,int x2,int y,int color);
void GL_VLine(int x,int y1,int y2,int color);
void GL_Circle(int x,int y,int radius);

void GL_SetDrawingBuffer(unsigned char *buffer);
unsigned char *GL_MakeDrawingBuffer(void);
void GL_FreeDrawingBuffer(unsigned char *buffer);
void GL_UpdateScreen(unsigned char *buffer);

void GL_WaitVBL(void);

void GL_PutImage(int x,int y,struct image_s *image);
void GL_GetImage(int x,int y,struct image_s *image);
void GL_PutSprite(int x,int y,int sx,int sy,unsigned char *image);


void GL_Putc( int c );
void GL_Puts( char *str);
int GL_TextXSize(char *str);
int GL_LoadFont( char* font );
void GL_ItalicsOn(void);
void GL_ItalicsOff(void);
void GL_GotoXY( int x, int y );
int GL_GetX(void);
int GL_GetY(void);
void GL_BoldOff(void);
void GL_BoldOn(void);
void GL_PutText(int x,int y,char *str);
void GL_TextColor(int color);
void GL_TextShadow(int color,int offsetx,int offsety);
void GL_TextUnderline(int color,int offsety);
void GL_TextBold(int thickness);










void GL_PutText(int x,int y,char *str);
void GL_TextColor(int color);
void GL_TextShadow(int color,int offsetx,int offsety);
void GL_TextUnderline(int color,int offsety);
void GL_TextBold(int thickness);
int  GL_TextXSize(char *str);
int  GL_TextYSize(char *str);
int  GL_LoadFontFile(char *fname);
void GL_UseFont(int fontID);

/* ACTIVE FOR MODE X ONLY (no effect in Mode 13H): */
void GL_SetVisualPage(int page);
void GL_SetActivePage(int page);
int  GL_GetVisualPage(void);
int  GL_GetActivePage(void);


/* image.c */
int GL_Gif( char* file, char * buffer, char * pal, int* width, int* height );


/* glkey.c */
void GL_AddKey(int down,int up);
void GL_TrapKeys(void);
void GL_ReleaseKeys(void);

struct GL_KEYMAP                        /* This holds a list of key scan   */
{                                       /* codes that we want to trap.     */
   unsigned char downcode;              /* Code when key is pressed        */
   unsigned char upcode;                /* Code when key is released       */
};

extern unsigned char *ScrBuffer;
extern struct GL_KEYMAP GL_Keys[32];
extern char   GL_NumKeys;
extern char   GL_KeyStat[32];           /* You can test if a given key is   */

#define random(num)(int)(((long)rand()*(num))/(RAND_MAX+1))
#define randomize()     srand((unsigned)time(NULL))

void disable(void);
void enable(void);


#pragma aux disable =  "cli"
#pragma aux enable =   "sti"




