#include <wgt4.h>
#include <math.h>


tpolypoint mypoints[4];
tpolypoint rotpoints[4];

color pal[256];
block text;
long isin[360],icos[360];

int rot;
int i, px,py;
int zdir=0;
int xzoom=0;
int yzoom=0;

int rotspeed = 2, rotdir=1;


void make_sin_cos_tables(void)
{
int i;

 for (i=0; i<360; i++)
 {
 isin[i]=sin(3.1415*((double)i/180.0))*1024;
 icos[i]=cos(3.1415*((double)i/180.0))*1024;
 }
}

void rotatetext(int centx, int centy, tpolypoint *mypoly, tpolypoint *mypoly2,
                int rot)
{
int i;
int x,y;
int x2,y2;

for (i=0; i<4; i++)
  {
   x=mypoly[i].x-centx;
   y=mypoly[i].y-centy;

  x2 = ((long)x * icos[rot] - (long)y * isin[rot])>>10;
  y2 = ((long)x * isin[rot] + (long)y * icos[rot])>>10;
  mypoly2[i].x=x2+centx;
  mypoly2[i].y=y2+centy;
  }
}


void main(void)
{

vga256();

make_sin_cos_tables();

mypoints[0].x = 0;
mypoints[0].y = 0;
mypoints[1].x = 128;
mypoints[1].y = 0;
mypoints[2].x = 128;
mypoints[2].y = 128;
mypoints[3].x = 0;
mypoints[3].y = 128;

mypoints[0].sx = 0;
mypoints[0].sy = 0;
mypoints[1].sx = 319;
mypoints[1].sy = 0;
mypoints[2].sx = 319;
mypoints[2].sy = 199;
mypoints[3].sx = 0;
mypoints[3].sy = 199;

minit();
msetbounds(0,0,191,119);

wsetpalette(0,255,pal);
text = wloadblock("wgt1.blk");
wloadpalette("wgt1.pal",pal);
wputblock(0,0,text,0);
wfreeblock(text);

text = wnewblock(0,0,319,199);
wcls(0);
wsetpalette(0,255,pal);

rot = 0;
minit();
do {

 if (but == 1)
   {
    rot -=rotspeed;
    if (rot < 0)
      rot +=360;
   }
 if (but == 2)
   {
    rot +=rotspeed;
    if (rot >359)
      rot -=360;
   }

 rotatetext(64,64, mypoints, rotpoints, rot);

 for (i = 0; i < 4; i++)
   {
   rotpoints[i].sx = mypoints[i].sx;
   rotpoints[i].sy = mypoints[i].sy;
   }
 wtexturedpoly(rotpoints, 4, mx-32, my-32, text, 0);

 } while (!kbhit());

wfreeblock(text);
wsetmode(3);

}
