#include <wgt5.h>
#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <malloc.h>

#define MAXCOL 128L
#define NUMFRAMES 16L

int oldmode;

block picture1;
block picture2;
block destination;
color pal[256];

block work1;  /* Textured mesh of of picture1 */
block work2;  /* Textured mesh of of picture1 */

unsigned char *fade_table;


/* Morphing mesh */
typedef struct {
 int x, y;
 } vertex;

#define SIZE 6          /* Size of mesh */

vertex mesh1[SIZE][SIZE];
vertex mesh2[SIZE][SIZE];
vertex tempmesh[SIZE][SIZE];
vertex dirs[SIZE][SIZE];

vertex source1[200][3];
vertex source2[200][3];
/* Maximum 200 triangle per mesh */

tpoint tri[3];          /* A single triangle */

unsigned char c;

/* Fade table creation routines */
/* ------------------------------------------------------------------------ */
unsigned char closest_match (int red, int green, int blue, color *pal)
{
int colnum;                     /* Color number to compare */
int delta_r, delta_g, delta_b;  /* Difference between new and existing */
float distance;                 /* Distance from new color */
float lowest_distance;          /* Lowest distance found */
int closest_color;              /* Color with the lowest distance */


   lowest_distance = 33333;
   /* Set to a high number, higher than anything possible.
      The highest distance we can have is sqrt (64*64 + 64*64 + 64*64)
      which is 110.85 */

   for  (colnum = 0; colnum < MAXCOL; colnum++)
   /* Compare each color from the existing palette */
     {

      delta_r = (pal[colnum].r - red);
      delta_g = (pal[colnum].g - green);
      delta_b = (pal[colnum].b - blue);

      distance = sqrt (delta_r*delta_r*30 + delta_g*delta_g*59 + delta_b*delta_b*11);

      if  (distance < lowest_distance)
        {
         lowest_distance = distance;
         closest_color = colnum;
        }
     }

 return (closest_color);
}



void create_fade_table (int frame, int maxframe,
                        unsigned char *fadetable, color *pal)
{

float lightlevel1;      /* Percentage of color 1 */
float lightlevel2;      /* Percentage of color 2 */

float fr, fg, fb;       /* Floating point RGB values of color 1 */
float fr2, fg2, fb2;    /* Floating point RGB values of color 2 */
int   ir,  ig,  ib;     /* Integer RGB values after combing the two above */

int col1, col2;

unsigned char bestcolor; /* Best match */

 lightlevel1 = (float)frame / (float)maxframe;
 /* Calculate the percentage of color 1 */

 lightlevel2 = 1.0 - lightlevel1;
 /* Percentage of color 2 is the 100% - lightlevel1 */


 for (col2 = 0; col2 < MAXCOL; col2++)
   for (col1 = 0; col1 < MAXCOL; col1++)
     {
      
      fr = (float)pal[col1].r * lightlevel1;
      fg = (float)pal[col1].g * lightlevel1;
      fb = (float)pal[col1].b * lightlevel1;

      fr2= (float)pal[col2].r * lightlevel2;
      fg2= (float)pal[col2].g * lightlevel2;
      fb2= (float)pal[col2].b * lightlevel2;

      /* Calculate the two new colors */

      ir = (fr + fr2);
      ig = (fg + fg2);
      ib = (fb + fb2);
      /* Combine the percentage of color 1 with the percentage of color 2
         to form a new color */

      bestcolor = closest_match (ir, ig, ib, pal);

      fadetable[frame * (MAXCOL*MAXCOL) + col2 * MAXCOL + col1] = bestcolor;
      wsetcolor (bestcolor);
      wputpixel (col1, col2);
      /* Store the color at fadetable[frame][col2][col1] */

  }

}



void create_all_frames (int numframes, unsigned char *fadetable,
                        color *pal)
{
int i;

 wtextcolor (255);  /* White color */
 wtexttransparent (TEXTFGBG);

 for (i = 0; i < numframes/2; i++)
  { 
   wgtprintf (160, 0, NULL, "Frame: %hi/%hi", i, (numframes/2-1));
   create_fade_table (i, numframes, fadetable, pal);
  }
}




/* Frame creation routines */
/* ------------------------------------------------------------------------ */

void fade_frame_asm (block pic1, block pic2, block table, block dest, int length);
#pragma aux fade_frame_asm = \
 "push ebp" \
 "mov ebp, edx" \
 "mov ebx, 0" \
 "fadeloop: mov bl, 0" \
 "mov bh, [esi]" \
 "shr bx, 1" \
 "add bl, [edi]" \
 "mov dl, [ebp + ebx]" \
 "inc esi" \
 "inc edi" \
 "mov bl, 0" \
 "mov bh, [esi]" \
 "shr bx, 1" \
 "add bl, [edi]" \
 "mov dh, [ebp + ebx]" \
 "inc esi" \
 "inc edi" \
 "mov [eax], dx" \
 "add eax, 2" \
 "dec ecx" \
 "jnz fadeloop" \
 "pop ebp"\
parm [esi] [edi] [edx] [eax] [ecx] \
modify exact [eax ebx ecx edx esi edi] nomemory;


void fade_frame (block pic1, block pic2, block dest, block fade_table,
                 int frame)
{
 fade_table += frame * (MAXCOL * MAXCOL);
 pic1 += 4;
 pic2 += 4;
 dest += 4;

 fade_frame_asm (pic1, pic2, fade_table, dest, 25600);
 /* Length is 256*200 / 2 because we're moving words */
}



void save_table (char *filename, block table, long size)
{
FILE *out;
int i;

 out = fopen (filename, "wb");
 fwrite (table, size, 1, out);
 fclose (out);
}


block load_table (char *filename, long size)
{
FILE *in;
int i;
block table;

 if  ((in = fopen (filename, "rb")) == NULL)
     return NULL;

 table = (unsigned char *)malloc (size);
 fread (table, size, 1, libf);
 fclose (libf);
 return table;
}


/* Mesh Routines */
/* ------------------------------------------------------------------------ */

void init_mesh (vertex mesh[SIZE][SIZE])
{
int x, y;

 for (y = 0; y < SIZE; y++)
  for (x = 0; x < SIZE; x++)
    { 
     mesh[y][x].x = x * (256 / (SIZE-1));
     mesh[y][x].y = y * (200 / (SIZE-1));

     if (mesh[y][x].x > 255)
         mesh[y][x].x = 255;
     if (mesh[y][x].y > 199)
         mesh[y][x].y = 199;
    }
}


void draw_hollow_tri (tpoint *tri, int xofs)
/* Draws a hollow triangle in the mesh construction mode */
{
 wline (tri[0].x/2 + xofs, tri[0].y, tri[1].x/2 + xofs, tri[1].y);
 wline (tri[1].x/2 + xofs, tri[1].y, tri[2].x/2 + xofs, tri[2].y);
 wline (tri[2].x/2 + xofs, tri[2].y, tri[0].x/2 + xofs, tri[0].y);
}


void draw_mesh (vertex mesh[SIZE][SIZE], block picture, int xofs)
{
int x, y;
int xm, ym;  /* ranges between 0 and 1 for each, tells which triangle to
                draw */
 
 moff (); 

 wresize (xofs, 0, xofs + 127, 199, picture, 0);
 /* Draw a half sized picture in the background */

 wsetcolor (255);

 for (y = 0; y < SIZE-1; y++)
   for (x = 0; x < SIZE-1; x++)
     {
      xm = x % 2;
      ym = y % 2;

      if ( ((xm == 0) && (ym == 0)) || ((xm == 1) && (ym == 1)) )
        {
         tri[0].x = mesh[y][x].x;
         tri[0].y = mesh[y][x].y;
         tri[1].x = mesh[y+1][x+1].x;
         tri[1].y = mesh[y+1][x+1].y;
         tri[2].x = mesh[y+1][x].x;
         tri[2].y = mesh[y+1][x].y;
         draw_hollow_tri (tri, xofs);

         tri[0].x = mesh[y][x].x;
         tri[0].y = mesh[y][x].y;
         tri[1].x = mesh[y][x+1].x;
         tri[1].y = mesh[y][x+1].y;
         tri[2].x = mesh[y+1][x+1].x;
         tri[2].y = mesh[y+1][x+1].y;
         draw_hollow_tri (tri, xofs);
        }
   
      else 
        {
         tri[0].x = mesh[y][x].x;
         tri[0].y = mesh[y][x].y;
         tri[1].x = mesh[y][x+1].x;
         tri[1].y = mesh[y][x+1].y;
         tri[2].x = mesh[y+1][x].x;
         tri[2].y = mesh[y+1][x].y;
         draw_hollow_tri (tri, xofs);

         tri[0].x = mesh[y][x+1].x;
         tri[0].y = mesh[y][x+1].y;
         tri[1].x = mesh[y+1][x+1].x;
         tri[1].y = mesh[y+1][x+1].y;
         tri[2].x = mesh[y+1][x].x;
         tri[2].y = mesh[y+1][x].y;
         draw_hollow_tri (tri, xofs);
        }
     }

 mon ();
}


void save_mesh (char *filename, vertex *mesh)
{
FILE *out;

 out = fopen (filename, "wb");
 
 fwrite (mesh, sizeof (vertex), SIZE*SIZE, out);
 fclose (out);
}


void load_mesh (char *filename, vertex *mesh)
{
FILE *in;

 in = fopen (filename, "rb");
 
 fread (mesh, sizeof (vertex), SIZE*SIZE, in);
 fclose (in);
}



void drag_point (int screenx, int screeny)
/* Finds the closest vertex to (screenx, screeny) and drags it to a new
   position */
{
vertex *v1, *v2;                /* Temporary pointers to vertices */
int smallest_distance;          /* Distance between screen coord and vertex */

int tmapx, tmapy;               /* Actual position of vertex on texture
                                   image */

int distx, disty;               /* Delta X,Y values */
int distance;                   /* Distance between two vertices */
int gridx, gridy;               /* Stores which vertex in mesh is closest */
int x, y;


 /* Based on where you click, we want to find out the coordinates on the
    texture image, which range from (0-255, 0-199). */
 tmapy = screeny;       /* Y value requires no adjustment */

 if (screenx < 160)                /* If you clicked on the first picture */
   { 
    v1 = mesh1;                    /* Point to the first mesh */
    tmapx = screenx * 2;           /* Double the screen x coordinate */
   } 
 else                              /* If you clicked on the second picture */
   { 
    v1 = mesh2;                    /* Point to the first mesh */
    tmapx = (screenx - 160) * 2;   /* Double the screen x coordinate */
  }


 smallest_distance = 30000;
 /* Dummy large value */

 v2 = v1;
 for (y = 0; y < SIZE; y++)
  for (x = 0; x < SIZE; x++)
    {   
     distx = abs (v2->x - tmapx);
     disty =  abs (v2->y - tmapy);
     distance = sqrt (distx * distx + disty * disty);
    
     if (distance < smallest_distance)
       {
        smallest_distance = distance;
        gridx = x;              /* Keep track of the closest x,y value */
        gridy = y;
       }
     v2++;      /* Advance to the next vertex */
    }

 noclick ();

 do {
  wretrace ();
 } while (mouse.but == 0);

 v2 = &v1[gridy * SIZE + gridx];
 /* Make a pointer to the closest vertex */

 if (screenx < 160)
   v2->x = mouse.mx * 2;
 else 
   v2->x = (mouse.mx - 160) * 2;
 v2->y = mouse.my;
 /* Set the new coordinate */


 if (screenx < 160)
   draw_mesh (mesh1, picture1, 0);
 else
   draw_mesh (mesh2, picture2, 160);

 noclick ();
}



void draw_textured_mesh (vertex mesh[SIZE][SIZE])
{
int x, y;
int xm, ym;
int poly;

int x1, y1, x2, y2, x3, y3, x4, y4;
 
 poly = 0;

 for (y = 0; y < SIZE-1; y++)
  for (x = 0; x < SIZE-1; x++)
    {
     xm = x % 2;
     ym = y % 2;

     x1 = mesh[y][x].x >> 8;
     y1 = mesh[y][x].y >> 8;
     x2 = mesh[y][x+1].x >> 8;
     y2 = mesh[y][x+1].y >> 8;
     x3 = mesh[y+1][x+1].x >> 8;
     y3 = mesh[y+1][x+1].y >> 8;
     x4 = mesh[y+1][x].x >> 8;
     y4 = mesh[y+1][x].y >> 8;
   

     if ( ((xm == 0) && (ym == 0)) || ((xm == 1) && (ym == 1)) )
       {

        /* Draw the triangle from picture1 */
        tri[0].x = x1;
        tri[0].y = y1;
        tri[1].x = x3;
        tri[1].y = y3;
        tri[2].x = x4;
        tri[2].y = y4;
        /* Set the screen coordinates */

        tri[0].sx = source1[poly][0].x;
        tri[0].sy = source1[poly][0].y;
        tri[1].sx = source1[poly][1].x;
        tri[1].sy = source1[poly][1].y;
        tri[2].sx = source1[poly][2].x;
        tri[2].sy = source1[poly][2].y;
        /* Set the texture coordinates */

        wsetscreen (work1);
        wtriangle_texture (tri, picture1);
        
        /* Draw the triangle from picture2 */
        tri[0].sx = source2[poly][0].x;
        tri[0].sy = source2[poly][0].y;
        tri[1].sx = source2[poly][1].x;
        tri[1].sy = source2[poly][1].y;
        tri[2].sx = source2[poly][2].x;
        tri[2].sy = source2[poly][2].y;
     
        wsetscreen (work2);
        wtriangle_texture (tri, picture2);
        poly++;        



        /* Draw the second triangle from picture1 */
        tri[0].x = x1;
        tri[0].y = y1;
        tri[1].x = x2;
        tri[1].y = y2;
        tri[2].x = x3;
        tri[2].y = y3;
     
        tri[0].sx = source1[poly][0].x;
        tri[0].sy = source1[poly][0].y;
        tri[1].sx = source1[poly][1].x;
        tri[1].sy = source1[poly][1].y;
        tri[2].sx = source1[poly][2].x;
        tri[2].sy = source1[poly][2].y;
     
        wsetscreen (work1);
        wtriangle_texture (tri, picture1);
     

        /* Draw the second triangle from picture2 */
        tri[0].sx = source2[poly][0].x;
        tri[0].sy = source2[poly][0].y;
        tri[1].sx = source2[poly][1].x;
        tri[1].sy = source2[poly][1].y;
        tri[2].sx = source2[poly][2].x;
        tri[2].sy = source2[poly][2].y;
     
        wsetscreen (work2);
        wtriangle_texture (tri, picture2);
        poly++;        
       }
   
     else 
       {
        tri[0].x = x1;
        tri[0].y = y1;
        tri[1].x = x2;
        tri[1].y = y2;
        tri[2].x = x4;
        tri[2].y = y4;
      
        tri[0].sx = source1[poly][0].x;
        tri[0].sy = source1[poly][0].y;
        tri[1].sx = source1[poly][1].x;
        tri[1].sy = source1[poly][1].y;
        tri[2].sx = source1[poly][2].x;
        tri[2].sy = source1[poly][2].y;
     
        wsetscreen (work1);
        wtriangle_texture (tri, picture1);
     
        tri[0].sx = source2[poly][0].x;
        tri[0].sy = source2[poly][0].y;
        tri[1].sx = source2[poly][1].x;
        tri[1].sy = source2[poly][1].y;
        tri[2].sx = source2[poly][2].x;
        tri[2].sy = source2[poly][2].y;
       
        wsetscreen (work2);
        wtriangle_texture (tri, picture2);
        poly++;        
     
        tri[0].x = x2;
        tri[0].y = y2;
        tri[1].x = x3;
        tri[1].y = y3;
        tri[2].x = x4;
        tri[2].y = y4;
       
        tri[0].sx = source1[poly][0].x;
        tri[0].sy = source1[poly][0].y;
        tri[1].sx = source1[poly][1].x;
        tri[1].sy = source1[poly][1].y;
        tri[2].sx = source1[poly][2].x;
        tri[2].sy = source1[poly][2].y;
     
        wsetscreen (work1);
        wtriangle_texture (tri, picture1);
     
        tri[0].sx = source2[poly][0].x;
        tri[0].sy = source2[poly][0].y;
        tri[1].sx = source2[poly][1].x;
        tri[1].sy = source2[poly][1].y;
        tri[2].sx = source2[poly][2].x;
        tri[2].sy = source2[poly][2].y;
      
        wsetscreen (work2);
        wtriangle_texture (tri, picture2);
        poly++;        
       }
    }
}



void calculate_mesh_movement (void)
{
int x, y;
int xm, ym;
int poly;

 for (y = 0; y < SIZE; y++)
  for (x = 0; x < SIZE; x++)
    {
     tempmesh[y][x].x = mesh1[y][x].x * 256;
     tempmesh[y][x].y = mesh1[y][x].y * 256;

     dirs[y][x].x = ((mesh2[y][x].x - mesh1[y][x].x) * 256) / NUMFRAMES;
     dirs[y][x].y = ((mesh2[y][x].y - mesh1[y][x].y) * 256) / NUMFRAMES;
    }

 poly = 0;
 for (y = 0; y < SIZE-1; y++)
  for (x = 0; x < SIZE-1; x++)
    {
     xm = x % 2;
     ym = y % 2;
  
     if ( ((xm == 0) && (ym == 0)) || ((xm == 1) && (ym == 1)) )
       {
        source1[poly][0].x = mesh1[y][x].x;
        source1[poly][0].y = mesh1[y][x].y;
        source1[poly][1].x = mesh1[y+1][x+1].x;
        source1[poly][1].y = mesh1[y+1][x+1].y;
        source1[poly][2].x = mesh1[y+1][x].x;
        source1[poly][2].y = mesh1[y+1][x].y;
       
        source2[poly][0].x = mesh2[y][x].x;
        source2[poly][0].y = mesh2[y][x].y;
        source2[poly][1].x = mesh2[y+1][x+1].x;
        source2[poly][1].y = mesh2[y+1][x+1].y;
        source2[poly][2].x = mesh2[y+1][x].x;
        source2[poly][2].y = mesh2[y+1][x].y;
        poly++;     
  
        source1[poly][0].x = mesh1[y][x].x;
        source1[poly][0].y = mesh1[y][x].y;
        source1[poly][1].x = mesh1[y][x+1].x;
        source1[poly][1].y = mesh1[y][x+1].y;
        source1[poly][2].x = mesh1[y+1][x+1].x;
        source1[poly][2].y = mesh1[y+1][x+1].y;
       
        source2[poly][0].x = mesh2[y][x].x;
        source2[poly][0].y = mesh2[y][x].y;
        source2[poly][1].x = mesh2[y][x+1].x;
        source2[poly][1].y = mesh2[y][x+1].y;
        source2[poly][2].x = mesh2[y+1][x+1].x;
        source2[poly][2].y = mesh2[y+1][x+1].y;
        poly++;
       }
     else 
       {
        source1[poly][0].x = mesh1[y][x].x;
        source1[poly][0].y = mesh1[y][x].y;
        source1[poly][1].x = mesh1[y][x+1].x;
        source1[poly][1].y = mesh1[y][x+1].y;
        source1[poly][2].x = mesh1[y+1][x].x;
        source1[poly][2].y = mesh1[y+1][x].y;
       
        source2[poly][0].x = mesh2[y][x].x;
        source2[poly][0].y = mesh2[y][x].y;
        source2[poly][1].x = mesh2[y][x+1].x;
        source2[poly][1].y = mesh2[y][x+1].y;
        source2[poly][2].x = mesh2[y+1][x].x;
        source2[poly][2].y = mesh2[y+1][x].y;
        poly++;

        source1[poly][0].x = mesh1[y][x+1].x;
        source1[poly][0].y = mesh1[y][x+1].y;
        source1[poly][1].x = mesh1[y+1][x+1].x;
        source1[poly][1].y = mesh1[y+1][x+1].y;
        source1[poly][2].x = mesh1[y+1][x].x;
        source1[poly][2].y = mesh1[y+1][x].y;
     
        source2[poly][0].x = mesh2[y][x+1].x;
        source2[poly][0].y = mesh2[y][x+1].y;
        source2[poly][1].x = mesh2[y+1][x+1].x;
        source2[poly][1].y = mesh2[y+1][x+1].y;
        source2[poly][2].x = mesh2[y+1][x].x;
        source2[poly][2].y = mesh2[y+1][x].y;
        poly++;
       }
    }
}



void draw_morph (void)
{
int frame;
int x, y;

 moff ();
 wcls (0);

 calculate_mesh_movement ();

 for (frame = 0; frame < NUMFRAMES; frame++)
   {
    /* Loop through each vertex in the temporary mesh, and move it */
    for (y = 0; y < SIZE; y++)
      for (x = 0; x < SIZE; x++)
        {
         tempmesh[y][x].x += dirs[y][x].x;
         tempmesh[y][x].y += dirs[y][x].y;
        }

    draw_textured_mesh (tempmesh);
   
    if (frame < NUMFRAMES / 2)    
      fade_frame (work1, work2, destination, fade_table, frame);
    else
      fade_frame (work2, work1, destination, fade_table,
                  (NUMFRAMES - 1) - frame);

    wnormscreen ();
    wputblock (32, 0, destination, 0);
   }
 mon ();
}



void edit_loop (void)
{
int x, y; 

 c = ' ';
 if (kbhit ())
  c = getch ();

 if ((c == 'S') || (c == 's'))
   {
    save_mesh ("mesh1.dat", mesh1);
    save_mesh ("mesh2.dat", mesh2);
   }

 if ((c == 'L') || (c == 'l'))
   { 
    load_mesh ("mesh1.dat", mesh1);
    draw_mesh (mesh1, picture1, 0);

    load_mesh ("mesh2.dat", mesh2);
    draw_mesh (mesh2, picture2, 160);
   }
 
 if ((c == 'M') || (c == 'm'))
   { 
    draw_morph ();
    wcls (0);
    draw_mesh (mesh1, picture1, 0);
    draw_mesh (mesh2, picture2, 160);
   }
 
 if (mouse.but)
   {
    x = mouse.mx;
    y = mouse.my;
    drag_point (x, y);
   }

}






void main (void)
{
int frame;
int framedir;

 oldmode = wgetmode ();

 vga256 ();
 minit ();

 picture1 = wloadpcx ("amber.pcx", pal);
 picture2 = wloadpcx ("termnate.pcx", pal);
 destination = wallocblock (256, 200);

 work1 = wallocblock (256, 200);
 work2 = wallocblock (256, 200);
 /* Allocate 2 work screens for texture mapping each mesh */

 wsetrgb (255, 63, 63, 63, pal);
 /* Create a white color for text */

 wsetpalette (0, 255, pal);


 fade_table = load_table ("fade2.tab", MAXCOL * MAXCOL * (NUMFRAMES / 2));
 if (fade_table == NULL)
   {

    wresize (0, 140, 50, 190, picture1, 0);
    wresize (100, 140, 150, 190, picture2, 0);
    /* Show some thumbnail versions of the pictures to fade */

    fade_table = malloc (MAXCOL * MAXCOL * (NUMFRAMES / 2));
    create_all_frames (NUMFRAMES, fade_table, pal);
    save_table ("fade2.tab", fade_table, MAXCOL * MAXCOL * (NUMFRAMES / 2));
   }

 wcls (0);

 winit_triangle_renderer (200);
 /* Initialize WGT's rendering system to 200 scanlines */

 init_mesh (mesh1);
 init_mesh (mesh2);
 /* Set up the original mesh for both pictures */

 draw_mesh (mesh1, picture1, 0);
 draw_mesh (mesh2, picture2, 160);
 /* Draws both meshes on the screen, side by side */

 mon ();

 do {
  edit_loop ();
 } while ((c != 'q') && (c != 27));


/* framedir = 1;
 frame = 0;

 do
   {
    if (frame < NUMFRAMES / 2)    
      fade_frame (picture1, picture2, destination, fade_table, frame);
    else
      fade_frame (picture2, picture1, destination, fade_table,
                  (NUMFRAMES - 1) - frame);
    wputblock (32, 0, destination, 0);

    frame += framedir;
    if (frame == NUMFRAMES - 1)
      framedir = -1;
    if (frame == 0)
      framedir = 1;
   } while (!kbhit ());     
*/

 mdeinit ();
 free (fade_table);
 wfreeblock (picture1);
 wfreeblock (picture2);
 wfreeblock (destination);
 wfreeblock (work1);
 wfreeblock (work2);
 wdeinit_triangle_renderer ();
 wsetmode (oldmode);
}


