#include <alloc.h>
#include <math.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <time.h>
#include <io.h>
#include <wgt4.h>
#include <wgt3d.h>

#include "d:\dsik\bc\sound.h"
#include "d:\dsik\bc\ts.h"

/*
ͻ
 Gooroo Nation   by Chris Egerter, April 1994                    
 --------------------------------------------------------------- 
 The demo is made of the following parts:                        
  -Introduction: Color fading                                    
  -Title screen:  Texture Warper                                 
  -Transforming Vector Balls                                     
  -Wormhole Starfield                                            
  -Magnifying Lens                                               
  -Dual Plasma                                                   
  -Shadebob Scrollers                                            
  -Voxel Landscape                                               
  -3D cubes (with texture mapping)                               
  -Credits:  Gummi Scroller                                      
                                                                 
 Some parts of the code are commented, others are not.           
                                                                 
 Turbo C++ v1.0 was used to compile the demo.  Borland C++ has   
 not been tested, so there may be some parts which need changes. 
 The WordUp Graphics Toolkit v4.0 is required for linking.  This 
 library was used to handle the basic graphics functions for     
 loading in pictures, sprites, and palettes.                     
 WGT4 is available on the Internet at the following FTP sites:   
  -oak.oakland.edu   in pub/msdos/cpluspls                       
  -nic.funet.fi      in pub/msdos/games/programming              
  -ftp.wustl.edu     in pub/MSDOS_UPLOADS/programming            
                                                                 
 A few parts have been optimized in assembly, however a large    
 portion of the demo remains in C.  If this demo was for a       
 competition I might have actually used assembly.  Don't complain
 if it is too slow on your computer.  I recommend a 486DX and    
 if you don't have one, BUY ONE NOW!                             
                                                                 
 Finally, don't even try to run this demo on your ancient 286.   
                                                                 
 *** Send any comments to chris.egerter@homebase.com ***         
                                                                 
ͼ
*/

/* The following variables are used by all parts of the demo. */
block virt;  /* Virtual screen used for background work */
block virt2;
block virt3;
block virt4; 
int i;
color pal1[256];	/* A few different palettes for fading, etc */
color pal2[256];
color pal3[256];
color pal4[256];
color pal5[256];
color blackpal[256];	/* Full of 0's */
block sprites[128];

int shaker = 0;

/* Gummi letters */
#define TEXTPOS 75
int skullx[10];
char let;
int skullpos[10];
int ypos[400];
int x,y;
char skullmessage[] = "THE CREDITS....  CODING AND GRAPHICS BY GOOROO   FIRST TUNE BY FALCON   SECOND TUNE BY GRAND VERBALIZER   THIRD TUNE BY GOOROO   ENDING ANSI BY PYROMANIAX                    ";
int donegummiscroll = 0;

int music_on;

void calc_sin (void);
void start_intro (void);
void start_gummi_scroller (void);
void draw_gummi (void);
void calculate_gummi (void);
void draw_letters (void);
void calc_sinus (void);

void start_vector_balls (void);
void run_vector_balls (void);

void start_starfield (void);
void start_lens (void);
void start_plasma (void);

void draw_land_plasma(void);
void start_landscape (void);

void start_firecube (void);

void startmusic(char *filename);
void stopmusic(int fade);

void fade_in(int start, int end, int speed, color *pal);
void fade_out(int start, int end, int speed, color *pal);

void show_end_text (void);

void start_warper (void);

long ems_free;
int status;

/* DSIK Sound System */
DSMCard Card;
DSM *Module;
DSMMusicInfo *Music;
int MVol = 255;



long memleft=999999;
int lowest = 0;

int gravis = 0;

void shut_down (char *str)
{
 printf ("\n\n%s\n\n",str);
 exit (1);
}

int c_break(void)
{
return 1;
}


void main (void)
{
 extern void showmem(void);
 ctrlbrk(c_break);
 clrscr ();
 printf ("Gooroo Nation - Startup\n\n");
 delay (400);
 printf ("Initializing Sound System\n");
 delay (400);
 setlib ("gn.dmo");
 setpassword ("voodoo");

 startmusic ("gn.crn");

 printf ("Checking for VGA\n");
  if (!vgadetected())
    shut_down ("No VGA card found!");
 printf ("Checking for 386\n");
  if (wdetectcpu () < 3)
    shut_down ("This demo requires a 386 or better.");
 
 printf ("Checking Free memory\n");
  if (farcoreleft() < 200000L)
    shut_down ("Not enough memory to run demo.");
  
 printf ("Starting Demo...\n");

 
 wreadpalette (0,255,pal2);
 fade_out (0, 16, 4, pal2);
 vga256 ();

  if (music_on)
  {
   DSMPlayMusic(Module);
   DSMSetMusicVolume(MVol);
  }
 vga256 ();
 wsetpalette (0, 255, pal1);        /* Set to a black palette */
 calc_sin ();

 start_intro ();
 start_warper ();
 start_vector_balls ();
 start_starfield ();
 start_lens ();
 start_plasma ();
 start_greets ();
 start_landscape ();
 if (music_on)
 {
  for (i = 0; i < 64; i++)	/* Fade out volume and colors */
  {
    if (MVol > 4)
    {
      MVol -= 4;
      DSMSetMusicVolume (MVol);
    }
    wretrace ();		/* DELAY doesn't work with Interrupts */
    wretrace ();		/* Use several retrace commands instead */
    wretrace ();
  }
  MVol = 252;
  DSMStopMusic();
  DSMFree(Module);

  Module = DSMLoad("yoursong.dsm",0L);

  DSMPlayMusic(Module);
  DSMSetMusicVolume (MVol);
 }
 start_firecube ();
 start_gummi_scroller ();
 start_lightedcube ();

 wsetmode (3);
 show_end_text ();
}



/*************************************************************
* Introduction screen:                                       *
*   Uses color fading to smoothly fade in and out some fonts.* 
**************************************************************/

/* Returns the x coordinate of the centred string */
int centre_string (char *string)
{
int slen;  /* String length (in characters) */
int plen;  /* String length (in pixels) */
char ch;
int i;

 slen = strlen (string);
 plen = 0;

 for (i = 0; i < slen; i++)
  {
   ch = string[i]-65;
   if ((ch >= 0) && (sprites[ch] != NULL))  /* don't display spaces */
     plen += wgetblockwidth (sprites[ch])+3;
   else
     plen += 20;
  }

  return (160 - plen/2);
}

/* Draws a single letter on the screen */
void addletter (int x, int y, block let)
{
int w,h;
int i,j;
block rowptr;
block ptr;

 w = wgetblockwidth (let);
 h = wgetblockheight (let);
 let += 4;

 rowptr = abuf+ y*320 + x;

 for (i = 0; i < h; i++)
  {
   ptr = rowptr;
   for (j = 0; j < w; j++)
    {
     *ptr = *ptr + (*let) * 2;
     let++;
     ptr++;
    }
   rowptr += 320;
  }
}


/* Displays a string using sprites, centred on the string */
void displaystring (char *string, int y, int mode)
{
int len;
int i;
int ch;
int x;

 x = centre_string (string);
 len = strlen (string);

 for (i = 0; i < len; i++)
  {
   ch = string[i] - 65;
   if ((ch >= 0) & (sprites[ch] != NULL))  /* don't display spaces */
    {
     if (mode == 0)
       wputblock (x, y, sprites[ch], 0);
     else
       addletter (x,y, sprites[ch]);
     x += wgetblockwidth (sprites[ch]) + 3;
    }
   else x += 20; /* Skip over blank spaces */
  }
}


void start_intro (void)
{
 wloadsprites (pal4, "monolet.spr", sprites, 0, 127);

 wcls (0);
 wsetrgb (0, 0,   0,  0, pal1);
 wsetrgb (1, 63, 63, 63, pal1);
 wsetrgb (2, 0,   0,  0, pal1);
 wsetrgb (3, 63, 63, 63, pal1);

 wsetrgb (0, 0, 0,  0, pal2);
 wsetrgb (1, 0, 0,  0, pal2);
 wsetrgb (2, 0, 0, 63, pal2);
 wsetrgb (3, 0, 0, 63, pal2);

 wsetpalette  (0, 255, pal1);
 wreadpalette (0, 255, pal3);

 virt = wnewblock (0, 0, 319, 199);

 wsetscreen (virt);
 displaystring ("WELCOME",     25, 0);
 displaystring ("TO A",        65, 0);
 displaystring ("NEW",        105, 0);
 displaystring ("DEMO",       145, 0);
 displaystring ("FROM",         25, 1);
 displaystring ("STARRY",       65, 1);
 displaystring ("KNIGHTS",     105, 1);
 displaystring ("PRODUCTIONS", 145, 1);

 wcopyscreen (0, 0, 319, 199, virt, 0, 0, NULL);

 for (i = 0; i < 60; i++)
   wretrace ();
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 3, pal3, pal2);
   wsetpalette(0,3,pal3);
   wretrace();
 }

 /* Set 2 */
 wsetrgb (1, 63, 0, 0, pal1);
 wsetrgb (3, 63, 0, 0, pal1);

 wsetscreen (virt);
 wcls (0);
 displaystring ("THIS",         25, 0);
 displaystring ("DEMO",         65, 0);
 displaystring ("WAS",         105, 0);
 displaystring ("MADE",        145, 0);
 displaystring ("FROM",         25, 1);
 displaystring ("STARRY",       65, 1);
 displaystring ("KNIGHTS",     105, 1);
 displaystring ("PRODUCTIONS", 145, 1);
 
 wcopyscreen (0, 0, 319, 199, virt, 0, 0, NULL);
 
 for (i = 0; i < 60; i++)
   wretrace ();
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 3, pal3, pal1);
   wsetpalette(0,3,pal3);
   wretrace();
 }
 
 /* Set 3 */
 wsetrgb (2, 0, 63, 0, pal2);
 wsetrgb (3, 0, 63, 0, pal2);
 
 wsetscreen (virt);
 wcls (0);
 displaystring ("THIS",      25, 0);
 displaystring ("DEMO",      65, 0);
 displaystring ("WAS",      105, 0);
 displaystring ("MADE",     145, 0);
 displaystring ("IN",        25, 1);
 displaystring ("THE GREAT", 65, 1);
 displaystring ("WHITE",    105, 1);
 displaystring ("NORTH",    145, 1);
 
 wcopyscreen (0, 0, 319, 199, virt, 0, 0, NULL);
 
 for (i = 0; i < 60; i++)
   wretrace ();
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 3, pal3, pal2);
   wsetpalette(0,3,pal3);
   wretrace();
 }

 /* Set 4 */
 wsetrgb (1, 63, 63, 63, pal1);
 wsetrgb (3, 63, 63, 63, pal1);

 wsetscreen (virt);
 wcls (0);
 displaystring ("OTHERWISE", 25, 0);
 displaystring ("KNOWN",    65, 0);
 displaystring ("AS",       105, 0);
 displaystring ("IN",        25, 1);
 displaystring ("THE GREAT", 65, 1);
 displaystring ("WHITE",    105, 1);
 displaystring ("NORTH",    145, 1);
 
 wcopyscreen (0, 0, 319, 199, virt, 0, 0, NULL);

 for (i = 0; i < 60; i++)
   wretrace ();
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 3, pal3, pal1);
   wsetpalette(0,3,pal3);
   wretrace();
 }
   
 for (i = 0; i < 60; i++)
   wretrace ();
 
 /* Show da flag */
 for (i = 0; i < 256; i++)
  wsetrgb (i, 0, 0, 0, pal4);
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 10, pal3, pal4);
   wsetpalette(0,10,pal3);
   wretrace();
 }
 
 wcls (0);
 wnormscreen ();
 wfreeblock (virt);
 virt = wloadpak ("flag.pak");
 wloadpalette ("flag.pal", pal1);   /* working palette */
 wsetpalette (0, 255, pal3);        /* set to black */
 wputblock (0, 0, virt, 0);
 
 fade_in (0, 255, 3, pal1);         /* fade into normal palette */
 wreadpalette (0, 255, pal2);       /* store duplicate into pal2 */

 wsetrgb (6, 0, 0, 48, pal2);
 wsetrgb (7, 0, 0, 48, pal2);
 wsetrgb (8, 0, 0, 48, pal2);     /* Set Canada word colors to blue */
 wsetrgb (9, 0, 0, 48, pal2);
 wsetrgb (10, 0, 0, 48, pal2);
 
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 10, pal1, pal2);
   wsetpalette(0,10,pal1);
   wretrace();
 }

 wsetrgb (1, 0, 0, 0, pal2);
 wsetrgb (2, 0, 0, 0, pal2);
 wsetrgb (3, 0, 0, 0, pal2);      /* Set flag colors to black */
 wsetrgb (4, 0, 0, 0, pal2);
 wsetrgb (5, 0, 0, 0, pal2);
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 10, pal1, pal2);
   wsetpalette(0,10,pal1);
   wretrace();
 }
 
 wsetrgb (6, 0, 0, 0, pal2);
 wsetrgb (7, 0, 0, 0, pal2);
 wsetrgb (8, 0, 0, 0, pal2);      /* Word colors to black */
 wsetrgb (9, 0, 0, 0, pal2);
 wsetrgb (10, 0, 0, 0, pal2);
 for (i=0; i<64; i++)
  {
   wfade_between_once(0, 10, pal1, pal2);
   wsetpalette(0,10,pal1);
   wretrace();
 }
 
 wfreeblock (virt);
 wnormscreen();
 wcls(0);
 for (i = 0; i < 60; i++)
   wretrace ();
 wfreesprites (sprites, 0, 127);
}


/*************************************************************
* Gummi scroller:                                            *
*   Uses a large data table to create a scroller with        *
*   perspective.                                             *
**************************************************************/
void start_gummi_scroller (void)
{
 wnormscreen ();
 wcls (0);
 calc_sinus ();
 calc_sin ();

 virt3 = wnewblock (0, 0, 319, 199);
 if (virt3 == NULL)
   { wsetmode(3);  printf("Error 1"); exit(1); }  

 wloadsprites (pal1, "firelet.spr", sprites, 1, 30);
    /* Load the letter images */

 for (i = 0; i < 256; i++)
   wsetrgb (0, 0, 0, 0, blackpal);
 wsetpalette (0, 255, blackpal);

 calculate_gummi ();              /* Calculate the table */

 virt = wloadpak ("planet.pak");  /* Load a background pic */
 if (virt == NULL)
   { wsetmode(3);  printf("Error 3"); exit(1); }  

 wnormscreen ();
 wclip (0, 0, 319, 199);
 wputblock (0, 0, virt, 0);          /* Display it */
 wcopyscreen (0, TEXTPOS, 319, TEXTPOS+99, virt, 0, 0, virt);
 wcopyscreen (0, 0, 319, 99, virt, 0, 100, virt);

 for (i = 0; i < 9; i++)
  {
   skullx[i] = 320 + i * 43;
   skullpos[i] = i;
  }
 /* Set the initial positions of the letters on the screen. */

 wnormscreen ();

 fade_in (0, 255, 3, pal1);

 do
  {
   draw_gummi ();
//   wsetscreen (virt3);	/* Can't use this since it isn't 320x200 */
   abuf = virt3+4;
   draw_letters ();
   wnormscreen ();
   if (kbhit ())
     donegummiscroll = 1;

  } while (!donegummiscroll);

 while (kbhit ()) getch ();
 fade_out (0, 255, 2, pal1);
 wfreeblock (virt);
 wfreeblock (virt2);
 wfreeblock (virt3);
 wfreeblock (virt4);
 wfreesprites (sprites, 1, 30);
}



/* A gummi screen is created by making a table of screen offsets.  Each pixel
in the destination has a corresponding pixel in the source, however they
are not the same offsets.  If the offsets where exactly the same, we'd end
up with the source image.  By using some formula to calculate the offsets,
we can generate interesting effects, like a magnifying lens, rounded
letters, etc.  This routine uses a distance formula, that is, the source
pixel is based upon the distance between the destination (x,y) offset and
a point.  In this case, the point has an x coordinate of 389 so you cannot
see the hole and the other side.  Try changing the 389 to 159 to put the
center point in the middle of the screen.

The virt4 block is used to store the data table. */
void calculate_gummi (void)
{
FILE *gummidata;
int x, y;                /* Destination point */
int sx, sy;              /* Source point */
unsigned int ofs;       /* unsigned offset of destination in table */
int source_ofs;         /* unsigned offset of source point  (y*320+x) */
float d;                /* Distance between destination point and centre */
int *gumptr;            /* Makes accessing table easier */
int *gumptr2;

/*
ofs = 0;
for (y = 0; y < 100; y++)       /* Go through each destination pixel */
 for (x = 0; x < 320; x++)
  {
   sx = x;
   sy = y;
   d = sqrt((long)(sx-389) * (long)(sx-389) + (long)(2*sy-36) * (long)(2*sy-36));
   /* Get the distance */

   if (d < 1) d = 1;
   sx = (long)(x * 62) / d;
   sy = (long)(2 * y * 84) / d;

   /* Experimental values (play around until you like the pattern!) */

   if (sy < 0) sy = 0;    /* Make sure the source point is within range */
   if (sy > 199) sy = 199;
   if (sx < 0) sx = 0;
   if (sx > 319) sx = 319;

   source_ofs = sy*320+sx;       /* Calculate the source offset */
   memcpy (&virt4[ofs], &source_ofs, 2); /* Copy the offset into the table */
   ofs += 2;           /* Advance to next integer in table */
  }

gumptr = &virt4[0];     /* Points to the first offset */
gumptr2= &virt4[2];     /* Points to the second offset */
*gumptr = *gumptr2;
gumptr++;
gumptr2++;

for (x = 2; x < 32000; x++)       /* Go through each offset and find the
    difference between each.  This way we can simply add to the offset
    when drawing each pixel in sequence. */
  {
   *gumptr = *gumptr2 - *gumptr;
   gumptr++; /* Advance ptrs */
   gumptr2++;
  }

 /* Writes the gummi data to disk */
 gummidata = fopen ("gn.005", "wb");
 fwrite (virt4, 64000L, 1, gummidata);
 fclose (gummidata);
 */

 /* Reads the gummi data into memory. */
   virt4 = lib2buf("gn.005");
}


/* Goes through each pixel in the destination, gets the offset of the
corresponding source pixel from the table, and plots the same colored point
in the destination.   Only non-zero colors are copied. */
void draw_gummi (void)
{
int x, y;
int sx;
block dest;
block src;
int *gumptr;

wsetscreen (virt);
//wputblock (0, TEXTPOS, virt2, 0);  /* Erase the previous frame */
wcopyscreen(0,100, 319, 199, virt, 0, 0, virt);

dest = virt + 4;   /* Calculate the destination ptr */
gumptr = virt4;                    /* Make a ptr to our data table */
src = virt3 + 4;                   /* Source image */

asm {
    .386
    push ds
    mov cx, 32000                 /* Loop for 32000 pixels */ 
    lds si, src                   /* Load ds:si with ptr to source */
    les di, dest                  /* Load es:di with ptr to dest */
    lgs bx, gumptr                /* Load gs:bx with ptr to data table */
    }
   gumloop:
   ;
   asm  mov al, [ds:si]            /* Get pixel color from source */
   asm  or al, al                  /* Is it 0? */
   asm  je nogummicopy             /* Yes, don't copy */
   asm  mov es:di,al               /* Move it into dest */
   nogummicopy:                    
   ;
   asm inc di;                     /* Increase destination pixel */
asm {
    mov ax, [gs:bx]               /* Get integer from table */
    add si, ax                    /* Add to source offset */
    add  bx, 2                    /* Go to next int in table */
    loop gumloop
    pop ds
    }

 wretrace ();
 wcopyscreen (0, 0, 319, 99, virt, 0, TEXTPOS, NULL); 
 /* Copy the frame to the visual screen */
}


/* Draws the letters scrolling across the screen.
  Note the letters erase themselves as they scroll because the letter images
  are bounded by a small amount of black pixels. */
void draw_letters (void)
{

 wclip(0,0,319,46);
 for (i = 0; i < 9; i++)
  {
   skullx[i] -= 4;         /* Moves left */
   if (skullx[i] < -43)  /* Wrap around this letter */
    {
     skullx[i] = 344;
     skullpos[i] += 9;  /* Increase the letter used in the image */
     if (skullpos[i] > 165) /* Finish scroller */
	donegummiscroll = 1;
    }

   let = skullmessage[skullpos[i]] - 64; /* Get the sprite number of the
					    letter in the message */

   if (let == -18) 
       let = 27; /* Period is stored in slot 27 */
   x = skullx[i];
   if ((let > 0) && (sprites[let] !=NULL) && (x+43 >= 0) && (x+43 < 400))
     {
      wputblock (x, ypos[x+43], sprites[let], 0); /* Display the letter */
      if (lowest < ypos[x+43] + wgetblockheight (sprites[let]))
	lowest = ypos[x+43] + wgetblockheight (sprites[let]);
     }
  }
 wclip(0,0,319,199);
}


/* Calculates the sin wave for the letters as they scroll across the
   screen. */
void calc_sinus (void)
{
 int i;

 for (i = -43; i < 320; i++)                                  
   ypos[i + 43] = sin (3.1415 * ((double)i * 3.2 / (double)180)) * 5 + 5;
		  /* Converts degrees to radians */

}



/* Vector Balls
   By Chris Egerter  March 17, 1994

*/
#define ZRAD 150
#define XRAD 150
#define YRAD 150

typedef struct {	 /* Used to keep track what portion of the */
  int x1,y1,x2,y2;	 /* screen has been changed, so we can update */
  } rect;		 /* the least amount of video memory */
rect lastrect,thisrect;

int transform_object;            /* Which object to transform into */
int transform_time;             /* How many frames left in transform */
point3d *transform_ptr;         /* Pointer to the destination object */
color *transform_pal;           /* Pointer to the destination palette */

int curx, cury, curz;
int zdir;
int object_size;
int sprite_xsize[20];           /* Dimensions of ball images */
int sprite_ysize[20];

int slidey=-200;

int size;
block moon;

point3d *carpet;                /* These are lists of points that make up */
point3d *tornado;               /* the objects.  They are allocated */
point3d *sinwave;               /* dynamically as needed to save memory. */
point3d *flower; 
point3d *thing; 

point3d curobject[50];          /* The current object being displayed */
point3d rotated[50];            /* The current object after rotation */

int sortlist[50];


/* These objects were calculated beforehand, since they needed some 
   adjustments or couldn't be created with a simple formula. */
point3d cube[50] = {
   {-100, -100, -100}, {-34, -100, -100}, {34, -100, -100}, {100, -100, -100},
   {-100, -34, -100}, {-100, 34, -100}, {100, -34, -100}, {100, 34, -100},
   {-100, 100, -100}, {-34, 100, -100}, {34, 100, -100}, {100, 100, -100},

   {-100, -100, -34}, {-34, -100, -34}, {34, -100, -34}, {100, -100, -34},
   {-100, -34, -34}, {-100, 34, -34}, {100, -34, -34}, {100, 34, -34},
   {-100, 100, -34}, {-34, 100, -34}, {34, 100, -34}, {100, 100, -34},

   {-100, -100, 34}, {-34, -100, 34}, {34, -100, 34}, {100, -100, 34},
   {-100, -34, 34}, {-100, 34, 34}, {100, -34, 34}, {100, 34, 34},
   {-100, 100, 34}, {-34, 100, 34}, {34, 100, 34}, {100, 100, 34},

   {-100, -100, 100}, {-34, -100, 100}, {34, -100, 100}, {100, -100, 100},
   {-100, -34, 100}, {-100, 34,  100}, {100, -34, 100}, {100, 34,  100},
   {-100, 100,  100}, {-34, 100,  100}, {34, 100,  100}, {100, 100,  100}};

point3d sphere[50] = { 
    {146, 0, 32},     {73, 126, 32},    {-73, 126, 32},  {-146, 0, 32},
    {-73, -126, 32},  {73, -126, 32},   {146, 0, 32},    {118, 0, 91},
    {59, 102, 91},    {-59, 102, 91},   {-118, 0, 91},   {-59, -102, 91},
    {59, -102, 91},   {118, 0, 91},     {68, 0, 133},    {34, 58, 133},
    {-34, 58, 133},   {-68, 0, 133},    {-34, -58, 133}, {34, -58, 133},
    {68, 0, 133},     {146, 0, -32},    {73, 126, -32},  {-73, 126, -32},
    {-146, 0, -32},   {-73, -126, -32}, {73, -126, -32}, {146, 0, -32},
    {118, 0, -91},    {59, 102, -91},   {-59, 102, -91}, {-118, 0, -91},
    {-59, -102, -91}, {59, -102, -91},  {118, 0, -91},   {68, 0, -133},
    {34, 58, -133},   {-34, 58, -133},  {-68, 0, -133},  {-34, -58, -133},
    {34, -58, -133},  {68, 0, -133},    {34, 58, -133},   {-34, 58, -133},
    {34, 58, -133},   {-34, 58, -133},  {-68, 0, -133},  {-34, -58, -133}};
  
point3d spider[50] = { 
    {26, 0, 20},     {33, 96, 20},   {-33, 96, 20},  {-26, 0, 20},
    {-43, -96, 20},  {43, -96, 20},  
    {66, 0, 60},     {73, 106, 60},   {-53, 106, 60},  {-66, 0, 60},
    {-53, -106, 60},  {53, -106, 60},  
    {106, 0, 100},     {63, 116, 100},   {-63, 116, 100},  {-106, 0, 100},
    {-63, -116, 100},  {63, -116, 100},  
    {146, 0, 140},     {73, 126, 140},   {-73, 126, 140},  {-146, 0, 140},
    {-73, -126, 140},  {73, -126, 140},

    {26, 0, -20},     {33, 96, -20},   {-33, 96, -20},  {-26, 0, -20},
    {-43, -96, -20},  {43, -96, -20},  
    {66, 0, -60},     {73, 106, -60},   {-53, 106, -60},  {-66, 0, -60},
    {-53, -106, -60},  {53, -106, -60},  
    {106, 0, -100},     {63, 116, -100},   {-63, 116, -100},  {-106, 0, -100},
    {-63, -116, -100},  {63, -116, -100},  
    {146, 0, -140},     {73, 126, -140},   {-73, 126, -140},  {-146, 0, -140},
    {-73, -126, -140},  {73, -126, -140}};


point3d ball[50] = { 
    {205,0,0}, {198,53,0}, {177,102,0},
    {144,144,0}, {102,177,0}, {53,198,0},
    {0,204,0}, {-53, 198, 0}, {-102,177,0},
    {-144,144,0}, {-177,102,0}, {-198,53,0},
    {-204, 0,0}, {-198,-53, 0}, {-177,-102,0},
    {-144, -144, 0}, {-102, -177,0}, {-53, -198,0},
    {0, -204, 0}, {53, -198, 0}, {102, -177, 0},
    {144, -144, 0}, {177, -102, 0}, {198,-53,0},
    {0,0, 205} ,{0,53, 198}, {0, 102, 177}, 
    {0, 144, 144}, {0, 177, 102}, {0, 198,53},
    {0, 204, 0}, {0, 198, -53}, {0, 177, -102},
    {0, 144, -144}, {0, 102, -177}, {0, 53, -198}, {0, 0, -204},
    {0, -53, -198}, {0, -102, -177}, {0, -144, -144},
    {0, -177, -102}, {0, -198, -53}, {0, -204, 0},
    {0, -198, 53}, {0, -177, 102}, {0,-144, 144},
    {0, -102, 177}, {0,-53, 198}};



void start_vector_balls (void)
{
 /* Allocate space for these objects */
 carpet  = farmalloc (sizeof (point3d) * 50);
 tornado = farmalloc (sizeof (point3d) * 50);
 sinwave = farmalloc (sizeof (point3d) * 50);
 flower  = farmalloc (sizeof (point3d) * 50);
 thing   = farmalloc (sizeof (point3d) * 50);

 run_vector_balls ();

 /* Free the space from the allocated objects */
 farfree (carpet);
 farfree (tornado);
 farfree (sinwave);
 farfree (flower);
 farfree (thing);
}


void calc_carpet(void)
/* Calculates points on a sine wave 'carpet' */
{
 int x, y, z;
 int pt;

 for (pt = 0; pt < 48; pt++)
  {
   carpet[pt].x = ((pt % 6)-2.5) * 72;
   carpet[pt].y = ((pt / 8)-3.5) * 60;
   carpet[pt].z = sin (3.1415 * (pt % 6) * 72 / 180) * 55 - 
		  sin (3.1415 * (pt / 8) * 72 / 180) * 25;
  /* This gives the z value a bumpy pattern */
 }
}


void calc_tornado (void)
/* This one is pretty simple, but looks nice.  We use sin and cos to get
   the two dimension position on a circle.  These are used as the x and
   y coordinates.  The z coordinate is increased constantly to make the
   path spiral down. */
{
int x, y, z;
int pt;

for (pt = 0; pt < 48; pt++)
 {
  tornado[pt].x = cos (3.1415 * (pt) * 30 / 180) * (150 - pt * 2);
  tornado[pt].y = sin (3.1415 * (pt) * 30 / 180) * (150 - pt * 2);
  tornado[pt].z = (pt - 24) * 15;
 }
}

void calc_sinwave (void)
/* Yer basic sine wave */
{
int x, y, z;
int pt;

 for (pt = 0; pt < 48; pt++)
  {
   sinwave[pt].x = (pt-24) * 8;
   sinwave[pt].y = sin (3.1415 * (pt) * 10 / 180) * 100;
   sinwave[pt].z = sin (3.1415 * (pt) * 10 / 180) * 100;
  }
}


void calc_flower (void)
/* A bunch of circles with decreasing radii */
{
int x, y, z;
int pt;

for (pt = 0; pt < 48; pt++)
 {
  flower[pt].x = cos (3.1415 * (pt) * 30 / 180) * (200 - pt * 2);
  flower[pt].y = sin (3.1415 * (pt) * 30 / 180) * (200 - pt * 2);
  flower[pt].z = 0;
 }
}


void calc_thing(void)
/* A couple of parabolas at right angles to each other */
{
int x, y, z;
int pt;

for (pt = 0; pt < 24; pt++)
 {
  thing[pt].x = (pt - 12) * 15;
  thing[pt].y = (pt - 12) * (pt - 12) * 2 - 144;
  thing[pt].z = 0;

  thing[pt+24].x = 0;
  thing[pt+24].y = (pt - 12) * (pt - 12) * 2 - 144;
  thing[pt+24].z = (pt - 12) * 15;
 }

}

/*void calc_sphere(void)
/* This is code to generate the original sphere 
   It was tough to figure out! */

{
int x, y, z;
int pt;

 pt = 0;

 for (z = 7; z <= 40; z += 14)
   for (x = 0; x <= 360; x += 60)
       {
        sphere[pt].z = ZRAD * sin(3.1415*((double)(z*1.8)/180.0));
        sphere[pt].x = XRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * cos(3.1415*((double)x/180.0));
        sphere[pt].y = YRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * sin(3.1415*((double)x/180.0));
        pt++;
       }
 for (z = 7; z <= 40; z += 14)
   for (x = 0; x <= 360; x += 60)
       {
        sphere[pt].z = ZRAD - ZRAD * sin(3.1415*((double)(z*1.8)/180.0))-ZRAD;
        sphere[pt].x = XRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * cos(3.1415*((double)x/180.0));
        sphere[pt].y = YRAD * sin(3.1415*((double)(z*1.8+90)/180.0)) * sin(3.1415*((double)x/180.0));
        
        pt++;
       }
}*/



void clear_last (void)
/* This clears out the last vector ball frame by copying the background moon
picture over the dirty rectangle area. */
{
 /* Do clipping for smallest area update */
 if (lastrect.x1 < 0)
    lastrect.x1 = 0;
 if (lastrect.x2 > 319)
    lastrect.x2 = 319;
 if (lastrect.y1 < 0)
    lastrect.y1 = 0;
 if (lastrect.y2 > 199)
    lastrect.y2 = 199;
 wsetcolor (0);
 wcopyscreen (lastrect.x1, lastrect.y1, lastrect.x2, lastrect.y2, moon,
	      lastrect.x1, lastrect.y1, virt);
   /* Clear out the area that was drawn in last frame */
}


void update_screen(void)
/* Copies the dirty rectangle area from the background screen to the
   visual screen. */
{
 if (lastrect.x1 > thisrect.x1)
    lastrect.x1 = thisrect.x1;
 if (lastrect.x2 < thisrect.x2)
    lastrect.x2 = thisrect.x2;
 if (lastrect.y1 > thisrect.y1)
    lastrect.y1 = thisrect.y1;
 if (lastrect.y2 < thisrect.y2)
    lastrect.y2 = thisrect.y2;
 /* See if the previous frame was larger in any direction. If it is, enlarge
 the area so it will copy black over the previous frame. */

 /* Do clipping */
 if (lastrect.x1 < 0)
    lastrect.x1 = 0;
 if (lastrect.x2 > 319)
    lastrect.x2 = 319;
 if (lastrect.y1 < 0)
    lastrect.y1 = 0;
 if (lastrect.y2 > 199)
    lastrect.y2 = 199;
 
 wcopyscreen (lastrect.x1, lastrect.y1, lastrect.x2, lastrect.y2, virt,
	      lastrect.x1, lastrect.y1, NULL);
 /* Copy from our second page to the visual page. */

 lastrect.x1 = thisrect.x1;
 lastrect.y1 = thisrect.y1;
 lastrect.x2 = thisrect.x2;
 lastrect.y2 = thisrect.y2;
 /* Make the last rectangle = current rectangle */
}



int sort_function (const void *a, const void *b)
/* Sorts the vector balls */
{
  if (rotated[*(int *)a].z < rotated[*(int *)b].z)
     return -1;
  else return 1;
}


void create_object (point3d *object, int obj_size)
/* Loads the first object into the curobject array and initializes
   the ball image dimensions. */
{
 int i;

 for (i = 0; i < obj_size; i++)
   memcpy (&curobject[i], &object[i], sizeof (point3d));

 object_size = obj_size;
 /* All objects have the same size so we can transform them easily. */

 for (i = 0;  i < 20; i++)
   if (sprites[i] != NULL)
    {
     sprite_xsize[i] = wgetblockwidth (sprites[i]);
     sprite_ysize[i] = wgetblockheight (sprites[i]);
    }
}


void do_transform (void)
/* Move each 3D point from its current position in 3D space to a new 
   coordinate.  */
{
 int i;
 int dx,dy,dz;

 for (i = 0; i < object_size; i++)
  {
   dx = transform_ptr[i].x - curobject[i].x;
   dy = transform_ptr[i].y - curobject[i].y;
   dz = transform_ptr[i].z - curobject[i].z;


   /* Limit the movement to 2 at a time */
   if (dx > 2) dx = 2;
   else if (dx < -2) dx = -2;

   if (dy > 2) dy = 2;
   else if (dy < -2) dy = -2;

   if (dz > 2) dz = 2;
   else if (dz < -2) dz = -2;

  curobject[i].x +=dx;
  curobject[i].y +=dy;
  curobject[i].z +=dz;
  }

  wfade_between_once (61, 183, pal4, transform_pal);
  wsetpalette (61, 183, pal4);
  if (transform_time == 0)
    wreadpalette (61, 183, pal4);
}


void rotate_loop (void)
/* Rotates the vector balls and updates the screen. */
{
int i;
int x, y, z;
int sorted;
int spritenum;
int xsize, ysize;
int spr;

 wsetscreen (virt);
 zdir = -4;
 Music = DSMGetMusicInfo();

 do 
  {
   if (slidey < 0)
      slidey++;

   if (music_on)
   {
    for (i = 0; i < 8; i++)
      wsetrgb(i+244, Music->Tracks[i].EQBar/2, 0, 0, pal1);
    wsetpalette(244, 251, pal1);
   }
   curx += 1;
   cury += 2;        /* Increase the rotation of each axis */
   curz += 3;
   if (curx > 359) curx -= 360;      /* Loop if needed */
   if (cury > 359) cury -= 360;
   if (curz > 359) curz -= 360;

   move_z += zdir;    /* Bounce the z distance. */
   if (move_z < 0)
     zdir = 4;
   if (move_z > 700)
   /* Start a new transform every time we get at the top of the bounce. */
    {
     zdir = -4;
     transform_time = 200;
     transform_object++;
     if (transform_object > 8)
	 transform_object = -1;
  
  /* Assign a new object and palette to be transformed into. */
  switch (transform_object)
   {
    case 0: transform_ptr = cube; 
            transform_pal = pal1; break;
    case 1: transform_ptr = sphere;
            transform_pal = pal2; break;
    case 2: transform_ptr = carpet; 
            transform_pal = pal3; break;
    case 3: transform_ptr = spider; 
            transform_pal = pal1; break;
    case 4: transform_ptr = ball; 
            transform_pal = pal2; break;
    case 5: transform_ptr = tornado; 
            transform_pal = pal3; break;
    case 6: transform_ptr = flower; 
            transform_pal = pal1; break;
    case 7: transform_ptr = sinwave; 
            transform_pal = pal2; break;
    case 8: transform_ptr = thing; 
            transform_pal = pal3; break;
   }
 }

 /* Reset the dirty rectangle */
 thisrect.x1 = 319; thisrect.y1 = 199; thisrect.x2 = 0; thisrect.y2 = 0;
 clear_last ();

 /* Rotate the balls */
 wsetrotation (curx, cury, curz);
 wrotatepoints (curobject, rotated, object_size);

 /* Set up an initial list of balls for sorting */
 for (i = 0; i < object_size; i++)
   sortlist[i] = i;

 qsort ((int *)sortlist, object_size, 2, sort_function);


 /* Ball drawing loop */
 for (i = 0; i < object_size; i++)
  { 
   sorted = sortlist[i];
   x = rotated[sorted].x;
   y = rotated[sorted].y + slidey;
   z = rotated[sorted].z + move_z*2;

   if (z > -1000) spr = 0;          /* Find out what size of ball to show. */
   else if (z > -1100) spr = 1;     /* This took a little playing around */
   else if (z > -1200) spr = 2;     /* I found distances that looked good. */
   else if (z > -1300) spr = 3;
   else if (z > -1400) spr = 4;
   else spr = 5;
  
   y-=20; /* Quick hack to move all the balls up a bit */
   wputblock (x, y, sprites[spr], XRAY);
   /* Show the image with xray mode */

   xsize = sprite_xsize[spr];
   ysize = sprite_ysize[spr];

   /* See if the vectorsprite is larger than the current area to update.
      If it is, enlarge the area so all sprites fit inside. 
      (dirty rectangle expansion) */
   if (x < thisrect.x1)
      thisrect.x1 = x;
   if (x + xsize > thisrect.x2)
      thisrect.x2 = x + xsize;
 
   if (y < thisrect.y1)
      thisrect.y1 = y;
   if (y + ysize > thisrect.y2)
      thisrect.y2 = y + ysize;
  }

 update_screen ();

 if (transform_time > 0)
  {
   transform_time--;
   do_transform ();
  }

if (kbhit ())
  transform_object = -1;

} while (transform_object != -1);
while (kbhit()) getch();
}


void run_vector_balls(void)
/* Sets everything up that is needed for the vector balls */
{
 int i,y;

 wcls (0);
 moon = wloadpak ("moon.pak");
 wloadsprites (pal1, "vect.spr", sprites, 0, 20);
 for (i = 244; i <= 251; i++)
   wsetrgb (i, 0, 0, 0, pal1);
 wsetrgb (1, 0, 0, 0, pal1);
 wsetpalette (0, 255, pal1);
 wreadpalette (0, 255, pal4);
 wloadpalette ("vect2.pal", pal2);
 wloadpalette ("vect3.pal", pal3);
 calc_carpet ();
 calc_tornado ();
 calc_sinwave ();
 calc_flower ();
 calc_thing ();

wsetpalette (0,255,pal1);
for (i = 0; i < 16; i++)
 {
  wclip(i*20, 0, i*20+19, 199);
  for (y = 199; y >= 0; y -= 10)
   {
    wputblock (0, y, moon, 0);
    wretrace ();
   }
  wputblock (0, 0, moon, 0);
 }

 wclip (0,0,319,199);

//wputblock(0,0,moon,0);
virt = wnewblock (0, 0, 319, 199);
create_object (&cube, 48);
winit3d ();
origin_z = -1200;
transform_object = 0;

rotate_loop ();

wfreeblock (virt);
wfreeblock (moon);
wfreesprites (sprites, 0,20);
fade_out (0,255,2,pal4);
}




/* Starfield Code:  Written by Chris Egerter */

#define NUM_STARS 900
typedef struct {
    int ox,oy;            /* Old coordinate of star */
    unsigned col;         /* Colour of star */
    int cx,cy;            /* Center point of origin */
 } star;

star *stars;
int cenx,ceny;
int xsin, ysin;

int rad, raddir;
int rad2, raddir2;
int SPEED=15;

int i,j;
star *stptr;
unsigned char scol;
int ctr;

void calc_sin(void)
{
 for (i = 0; i < 360; i++)
 {
  isin[i] = sin(3.1415 * ((double)i / 180.0)) * 1024;
  icos[i] = cos(3.1415 * ((double)i / 180.0)) * 1024;
 }
} 


void start_starfield (void)
{
int tox, toy, toc;	/* old x, y and color */
float yinc,ypos;

 calc_sin ();		/* Recalculate isin and icos since winit3d changes 
			   the values to (*16384) */

stars = farmalloc(sizeof(star)*NUM_STARS);
wnormscreen();
wcls(0);

randomize();
wloadpalette("plas2.pal",pal1);
wsetpalette(0,255,blackpal);

for (i=0; i < NUM_STARS; i++)
 {
  stars[i].col = random(25) + 5;
  stars[i].ox = random(80) <<6;
  stars[i].oy = random(199) <<6;
  if (stars[i].ox == 159<<6) 
      stars[i].ox++;
  if (stars[i].oy == 99<<6) 
      stars[i].oy++;
  stars[i].cx = 159 << 6;
  stars[i].cy = 99 << 6; 
 }

cenx = 159;
ceny = 99;


xsin = 0;
ysin =  50;
rad = 130;
raddir = 1;
rad2 = 130;
raddir2= -1;
scol = 0;
ctr = 0;

do {
ctr++;
xsin+=3;
ysin+=1;
if (xsin > 359) 
  xsin -=360;
if (ysin > 359) 
  ysin -=360;
cenx = 159 + isin[xsin] / 15;
ceny = 100 + isin[ysin] / 20; 

if ((ctr > 64) && (ctr < 128))
  {
   wfade_between_once(0,255,blackpal,pal1);
   wsetpalette(0,255,blackpal);
  }

if ((ctr > 800) && (ctr < 1500))
{
rad+=raddir;
if (rad < 20)
  raddir = 1;
else if (rad > 40)
  raddir = -1;

rad2+=raddir2;
if (rad2 < 15)
  raddir2 = 3;
else if (rad2 > 70)
  raddir2 = -3;
}

if (ctr == 400)
  scol = 1;

if (ctr == 1400)
  scol = 2;

if (ctr == 1500)
 {
  rad = 140;
  rad2= 140;
 }

if (ctr == 1600)
  SPEED = 25;  
if (ctr == 1675)
  SPEED = 35;  
if (ctr == 1750)
  SPEED = 45;  
if (ctr == 1825)
  SPEED = 55;  
if (ctr == 1900)
  SPEED = 65;  
if (ctr == 1975)
  SPEED = 75;  
if (ctr == 2175)
  SPEED = 55;  
if (ctr == 2275)
  SPEED = 35;  
if (ctr == 2375)
  SPEED = 23;  
if (ctr == 2475)
  SPEED = 15;  
if (ctr == 2575)
  SPEED = 9;  
if (ctr == 2875)
  {
  scol = 3;
  SPEED = 12;
  }
if (ctr == 3175)
  scol = 4;

stptr = stars;
for (i=0; i<NUM_STARS; i++)
 {
/*  wsetcolor(0);
  if (scol < 4)
  wfastputpixel(stptr->ox >>6, stptr->oy >>6);
  if (scol == 3)
     {
     wfastputpixel(stptr->ox>>5, stptr->oy>>5);
     wfastputpixel(stptr->ox>>7, stptr->oy>>7);
     }
  */
  tox = stptr->ox;
  toy = stptr->oy;
  asm push ds
  asm mov al, 0		/* Stores the color */
  asm mov ah,scol	/* Puts the effect number */
  asm lds si, abuf	/* PTR to visual screen */
  asm mov cx, tox	/* CX contains the x coordinate */
  asm mov bx, toy	/* BX contains the y coordinate */
  asm shr cx, 6		/* Find center coord */
  asm shr bx, 6	
  asm cmp ah, 4		/* If effect is no erase, skip all this */
  asm jge noerase
  asm mov dx, bx	/* Multiply y by 320 */
  asm shl dx, 6
  asm mov si, dx	/* (1<<8) + (1<<6) = 320*/
  asm shl dx, 2
  asm add si, dx        
  asm add si, cx        /* Add the X coordinate */
  asm mov [ds:si], al	/* Draw the pixel */
  
  asm cmp ah, 3		/* Triple pixel effect */
  asm jne notriple
  asm mov cx, tox
  asm mov bx, toy
  asm shr cx, 5
  asm shr bx, 5

  asm mov dx, bx
  asm shl dx, 6
  asm mov si, dx
  asm shl dx, 2
  asm add si, dx
  asm add si, cx
  asm mov [ds:si], al

  asm shr cx, 2
  asm shr bx, 2
  asm mov dx, bx
  asm shl dx, 6
  asm mov si, dx
  asm shl dx, 2
  asm add si, dx
  asm add si, cx
  asm mov [ds:si], al

  noerase:
  ;
  notriple:
  ;
  asm pop ds

  stptr->ox -= (stptr->cx - stptr->ox) / SPEED;
  stptr->oy -= (stptr->cy - stptr->oy) / SPEED;

  if (stptr->ox > 20416 || stptr->ox < 0 || stptr->oy > 12736 || stptr->oy < 0)
    /* x > 319<<6, y> 199<<6 */
    {
     j = random(359);
     switch (scol)
     {
     case 0: stars[i].col = random(25) + 5; break;
     case 1: stars[i].col = j % 255; break;
     default: stars[i].col = ctr % 255;
     }

     stars[i].ox = (icos[j] / rad + cenx);
     stars[i].oy = (isin[j] / rad2 + ceny);
     if (stars[i].ox == cenx) 
         stars[i].ox++;
//     else if (stars[i].oy == ceny)  
//         stars[i].oy++;

     stars[i].ox <<= 6;
     stars[i].oy <<= 6;
     stars[i].cx =  cenx << 6;
     stars[i].cy =  ceny << 6;
    }
  else
    {
/*     wsetcolor(stptr->col);
     wfastputpixel(stptr->ox>>6, stptr->oy>>6);
     if (scol >= 3)
      {
      wfastputpixel(stptr->ox>>5, stptr->oy>>5);
      wfastputpixel(stptr->ox>>7, stptr->oy>>7);
      }*/
  tox = stptr->ox;
  toy = stptr->oy;
  toc = stptr->col;
  asm push ds
  asm mov al, toc		/* Stores the color */
  asm mov ah, scol	/* Puts the effect number */
  asm lds si, abuf	/* PTR to visual screen */
  asm mov cx, tox	/* CX contains the x coordinate */
  asm mov bx, toy	/* BX contains the y coordinate */
  asm shr cx, 6		/* Find center coord */
  asm shr bx, 6	
  asm mov dx, bx	/* Multiply y by 320 */
  asm shl dx, 6
  asm mov si, dx	/* (1<<8) + (1<<6) = 320*/
  asm shl dx, 2
  asm add si, dx        
  asm add si, cx        /* Add the X coordinate */
  asm mov [ds:si], al	/* Draw the pixel */
  
  asm cmp ah, 3		/* Triple pixel effect */
  asm jl notriple2
  asm mov cx, tox
  asm mov bx, toy
  asm shr cx, 5
  asm shr bx, 5

  asm mov dx, bx
  asm shl dx, 6
  asm mov si, dx
  asm shl dx, 2
  asm add si, dx
  asm add si, cx
  asm mov [ds:si], al

  asm shr cx, 2
  asm shr bx, 2
  asm mov dx, bx
  asm shl dx, 6
  asm mov si, dx
  asm shl dx, 2
  asm add si, dx
  asm add si, cx
  asm mov [ds:si], al

  notriple2:
  ;
  asm pop ds

    }
  stptr++;
 }
if (kbhit())
 ctr = 3575;

wretrace();
} while (ctr < 3575);
while (kbhit()) getch();
farfree(stars);

ypos = 0;
yinc = 200.0 / 320.0;
wsetcolor (0);

for (tox = 0; tox < 370; tox += 2)
 {
  ypos += yinc*2;
  wline (tox, 0, tox, 319);
  wline (tox-69, 0, tox-69, 319);
  wline (0, ypos, 319, ypos);
  wline (0, ypos-69, 319, ypos-69);
  wretrace ();
 }

for (i = 0; i < 256; i++)
  wsetrgb(i, 0, 0, 0, pal1);
wsetpalette (0, 255, pal1);
wreadpalette (0, 255, blackpal); /* Restore the black palette */
}



/* Lens code:  Originally designed by Jeff Lawson of JL Enterprises
				      haroldf@rcf.usc.edu
   Optimized, translated (into C) and generally improved by Chris Egerter */


#define LENS_SIZE 140
#define LENS_SIZEM 139 /* Lens size minus 1 */
#define LENS_MEM LENS_SIZE*LENS_SIZE
#define MAG_FACTOR 27.0;
#define MAXX 320-LENS_SIZE-5
#define MAXY 200-LENS_SIZE-5

int fadectr;
int fadesize=0;

unsigned long counter=0;
extern int bx,by,tx,ty;

void drawlens(void);

int i;

typedef struct {
   int dx,dy;
   int x,y;
   int xmove, ymove;
   block source;
   } lens_pos;

lens_pos mylens; 

block backpic, virt, dest;
block lens;
void calculate_lens(void);

void rainscreen(block back)
/* Draws the screen using a rain effect */
{
int ypos[320];
int i,temp;
int num_at_bottom;

num_at_bottom = 0;
for (i = 0; i < 320; i++)
 ypos[i] = -1;

wnormscreen ();

do {

  for (i = 0; i < 320; i++)
   {
    if (ypos[i] == -1) /* Not on the screen yet */
     {
      temp = random(20);
      if (temp == 1)
        ypos[i] = 0;
     }
   if (ypos[i] >= 0)
    {
     wsetscreen (back);
     wsetcolor (wgetpixel(i, ypos[i]));
     wnormscreen ();
     wputpixel (i,ypos[i]);
     ypos[i]++;
     if (ypos[i] > 319)
      {
       ypos[i] = -2;  /* Done rain for this column */
       num_at_bottom++;
      }
    }
   }
 wretrace ();
 } while (num_at_bottom != 320);
}


void start_lens (void)
{
float x,y;
int ctr;

randomize();
wcls(0);

backpic=wloadpcx256("skul.pcx",pal1);
wsetpalette(0,255,pal1);
rainscreen (backpic); /* Bring in the background */

//lens = farmalloc(LENS_SIZE*LENS_SIZE*2L);
dest=wnewblock(0,0,LENS_SIZEM,LENS_SIZEM);
//virt=wnewblock(0,0,319,199);

mylens.x=10;
mylens.y=10;
mylens.dx=2;
mylens.dy=1;

//wsetscreen(virt);
calculate_lens();
ctr=0;
do {

mylens.x+=mylens.dx;
mylens.y+=mylens.dy/4;
mylens.dy+=1;

if (mylens.x>MAXX) mylens.dx*=-1;
if (mylens.x<5) mylens.dx*=-1;
if (mylens.y>MAXY) { mylens.dy*=-1; mylens.dy++; }
if (mylens.y<5) mylens.dy*=-1;
mylens.xmove=mylens.dx;
mylens.ymove=mylens.dy/4;


drawlens();
ctr++;
if (kbhit())
  ctr = 600;
} while (ctr <600);
while (kbhit()) getch();

wfreeblock(dest);
wfreeblock(backpic);
wfreeblock(mylens.source);
//wfreeblock(virt);
farfree(lens);

wnormscreen();		
virt = wnewblock(0,0,319,199);
x = 320;	/* Resizes the screen and fades out */
y = 200;
ctr = 0;
wsetcolor (0);
wbar (0,198, 319, 199);


for (ctr = 0; ctr < 64; ctr++)
 {
  x *= 1.04;
  y *= 1.04;
  wresize (0, 0, x, y, virt, 0);

  if (ctr > 32)
   {
    wfade_between_once (0, 255, pal1, blackpal);
    wsetpalette(0, 255, pal1);
   }
 }
wfreeblock(virt);
}

void drawlens(void)
{
register block orig;
register block lensed;
int a,b;
int x,y;
int olens;
int *lptr;

int xsafety, ysafety;

x=mylens.x;
y=mylens.y;

wfreeblock(mylens.source);
wsetscreen(backpic);
mylens.source=wnewblock(x,y,x+LENS_SIZEM,y+LENS_SIZE);

lensed=dest+4;
wsetscreen(backpic);
orig=mylens.source+4;


lptr = lens;

asm {
  .386
  push ds
  mov cx, LENS_MEM
  lds si, orig
  les di, lensed
  lgs bx, lptr
  mov dx, si
  }
gumloop:
;
asm  mov ax, [gs:bx]
asm  add ax, dx
asm  mov si, ax
asm  mov al, [ds:si]
asm  mov es:di,al
asm inc di;
asm add  bx, 2
asm loop gumloop
asm pop ds


wnormscreen();
//wretrace();
wputblock(x,y,dest,0);
}


void calculate_lens(void)
{
int d,r;
int a,b;
double z,m;
double s;
int x,y;

FILE *lensdata;  /* File containing lens precalculated data table */


int *lptr;

/*
d=LENS_SIZE;
r=d / 2;
m=MAG_FACTOR;
s = sqrt((double)r*r - m*m);

lptr=lens;

for (y=-r; y<-r+d; y++)
 for (x=-r; x<-r+d; x++)
   {
    if ((long)x*x + (long)y*y >= s*s)
        {
          a=x;
          b=y;
          *lptr = (long)(y+r)*d + (x+r);
          lptr++;
      }
        else
        {
          z = sqrt((long)r*r - (long)x*x - (long)y*y);
          a = ((x * m) / z + 0.5);
          b = ((y * m) / z + 0.5);
          *lptr =  (long)(b+r)*d + (a+r);
          lptr++;
        }
     }

 /* Writes the lens data to disk */
 lensdata = fopen ("gn.001", "wb");
 fwrite (lens, LENS_SIZE * LENS_SIZE * 2L, 1, lensdata);
 fclose (lensdata);
*/

 /* Reads the lens data into memory. */
  lens = lib2buf("gn.001");
}



/* Plasma code: Originally by Thomas Hagen (RFVDEMO)
		thomash@edb.tih.no
   Dual plasma technique created by Chris Egerter */

#define DIF 2000

unsigned char *data;
int r,i;
float teller;
float teller2;

unsigned int mixerofs=0;
void panquick(unsigned panofs);

int pans[4] = {0x0,0x2,0x4,0x6};

unsigned char rr,g,b;

int plasmatype;


void start_plasma (void)
{
  int pl1, pl2;
  int blackctr;
  FILE *plasmadata;

  wcls(0);

  shaker = 1;

  randomize();
//  data=(unsigned char*)farmalloc(65535l);
/*
  /* Calculate plasma data */
   for (x=0; x<256; x++)
    for (y=0; y<256; y++)
     data[x+256*y] = (unsigned char) (( x-88) * (y-88) * 0.22 
			* sin(x * 0.015) * 0.42 * cos(y * 0.040));

 /* Writes the plasma data to disk */
 plasmadata = fopen ("gn.002", "wb");
 fwrite (data, 65535L, 1, plasmadata);
 fclose (plasmadata);
*/

 /* Reads the plasma data into memory. */
 data = lib2buf("gn.002");

 wcls(0);
 memset(abuf,0,64320);	/* get rid of junk below screen */

 wloadpalette("plaspal1.pal",pal1);
 wloadpalette("plaspal2.pal",pal2);
 wloadpalette("plaspal3.pal",pal3);
 wloadpalette("plaspal4.pal",pal4);
 wloadpalette("plaspal5.pal",pal5);

  for (i=252; i<256; i++)
    wsetrgb(i,0,0,0,pal1);
  wsetrgb(1,0,0,0,pal1);
  for (i=252; i<256; i++)
    wsetrgb(i,0,0,0,pal2);
  wsetrgb(1,0,0,0,pal2);
  for (i=252; i<256; i++)
    wsetrgb(i,0,0,0,pal3);
  wsetrgb(1,0,0,0,pal3);
  for (i=252; i<256; i++)
    wsetrgb(i,0,0,0,pal4);
  wsetrgb(1,0,0,0,pal4);
  for (i=252; i<256; i++)
    wsetrgb(i,0,0,0,pal5);
  wsetrgb(1,0,0,0,pal5);

  wsetpalette(0,255,blackpal);


	wnormscreen();
        virt = wnewblock(0,0,319,199);
	blackctr = 64;

	teller = 0;
	while (blackctr > 0)
	{
		teller++;
		pl1=48+cos(teller/37)*47.0+256*(int)(48+47*(sin(teller/31)));
		pl2=48+sin(teller/84)*47.0+256*(int)(48+47*(cos(teller/19)))-pl1;
                asm .386
                asm les di,virt
                asm add di,4
		asm push ds
		asm lds si,data
		asm add si,pl1
		asm mov bx,pl2
		asm mov cl,80
l1: asm mov dx,80
l2: asm lodsb
		asm add al,[si+bx]
		asm mov ah,al
		asm stosw
		asm stosw
		asm dec dx
		asm jnz l2
		asm add si,256-80
		asm add di,320
		asm dec cl
		asm jnz l1
		asm pop ds

		pl1=48+cos((teller+DIF)/37)*47.0+256*(int)(48+47*(sin((teller+DIF)/31)));
		pl2=48+sin((teller+DIF)/84)*47.0+256*(int)(48+47*(cos((teller+DIF)/19)))-pl1;
                asm .386
                asm les di,virt
                asm add di,4+320
		asm push ds
		asm lds si,data
		asm add si,pl1
		asm mov bx,pl2
		asm mov cl,80
l3: asm mov dx,80
l4: asm lodsb
		asm add al,[si+bx]
		asm mov ah,al
		asm stosw
		asm stosw
		asm dec dx
		asm jnz l4
		asm add si,256-80
		asm add di,320
		asm dec cl
		asm jnz l3
		asm pop ds
		if ( ((kbhit()) && (blackctr == 64)) || (teller == 1000))
		 {
		  while (kbhit()) getch();
		  blackctr = 63;
		  wreadpalette(0,255,pal1);
		  for (i=0; i<256; i++)
		    wsetrgb(i,0,0,0,blackpal);
		 }
	wcopyscreen(0,0,319,159,virt,0,20,NULL);

	if (blackctr < 64)
	 {
	  wfade_between_once(0,255,pal1,blackpal);
	  wsetpalette(0,255,pal1);
	  blackctr--;
	 }
	else
	{

	if (teller <65)
	  {
	   wfade_between_once(0,255,blackpal,pal1);
	   wsetpalette(0,255,blackpal);
	  }
	if ((teller > 200) && (teller < 264))
	  {
	   wfade_between_once(0,255,pal1,pal2);
	   wsetpalette(0,255,pal1);
	  }
	if ((teller > 400) && (teller < 464))
	  {
	   wfade_between_once(0,255,pal2,pal3);
	   wsetpalette(0,255,pal2);
	  }
	if ((teller > 600) && (teller < 664))
	  {
	   wfade_between_once(0,255,pal3,pal4);
	   wsetpalette(0,255,pal3);
	  }
	if ((teller > 800) && (teller < 864))
	  {
	   wfade_between_once(0,255,pal4,pal5);
	   wsetpalette(0,255,pal4);
	  }                     
	}


	}
	wfreeblock(virt);
	while (kbhit()) getch();

	shaker = 0;
	farfree(data);
	panquick(0);
}


void interrupt mixer (void)
{
 mixerofs+=320;
 if (mixerofs == 640)
   mixerofs = 0;
 panquick (mixerofs);
}


void panquick (unsigned panofs)
{
    int vport;

    vport = peek (0x000, 0x463);
    panofs = panofs >> 2;              /* Divide panoffs by 4         */
    outport (vport, (panofs & 0xFF00 | 0xC));
    outport (vport, (panofs << 0x8 | 0xD));
}


void PollIt()
{
 if (shaker)
   mixer ();

  DSMPoll ();
}


void startmusic (char *filename)
{
int Error;
FILE *cfg;

    if (DSMLoadSetup(&Card)) {
	printf("Please run GNSETUP.EXE to configure.\n");
	exit(1);
    }
    if (DSMInit(&Card)) {
        printf("Error Initializing the Sound System.\n");
	exit(1);
    }

  cfg = fopen ("sound.cfg","rb");
  if (!cfg)
   {
    printf ("\nPlease run GNSETUP to configure.\n");
    exit (1);
   }
  Error = filelength (fileno (cfg));
  if (Error < 5)
    music_on = 0;
  else music_on = 1;
  fclose (cfg);


  if (music_on)
  {
   TSInit();
   TSSetRate(70);
   TSSetRoutine(PollIt);

    if ((Module = DSMLoad("yoursong.dsm",0L)) == NULL) {
	switch (DSMStatus) {
	case ERR_NORAM:  printf("Not enough system memory.\n"); break;
	case ERR_NODRAM: printf("Not enough card memory.\n"); break;
	case ERR_NOFILE: printf("File not found.\n"); break;
	case ERR_FORMAT: printf("Invalid file format.\n"); break;
	case ERR_ACCESS: printf("File damaged.\n"); break;
	}
	DSMDone();
	exit(1);
    }

  DSMSetupVoices(Module->Song.NumChannels,192);
  DSMPlayMusic(Module);

  if (DSMTypeOfRAM () == RAM_CARD)
      gravis = 1;
  else gravis = 0;
 }
}


void stopmusic (int fadetrue)
{
int i;

  if (fadetrue)
  for (i = 0; i < 64; i++)	/* Fade out volume and colors */
  {
    if (MVol > 4)
    {
      MVol -= 4;
      DSMSetMusicVolume (MVol);
    }
    wretrace ();		/* DELAY doesn't work with Interrupts */
    wretrace ();		/* Use several retrace commands instead */
    wretrace ();
  }

  DSMStopMusic();
  DSMFree(Module);
  TSDone();
  TSRestoreTime();
  DSMDone();

}


void fade_in(int start, int end, int speed, color *pal)
{
color black[256];
int i;
long j;

for (i=0; i<256; i++)
  wsetrgb(i,0,0,0,black);

for (i=0; i<64; i++)
 {
  wfade_between_once(start, end, black, pal);
  wsetpalette(start,end,black);
  for (j = 0; j < speed; j++)
   wretrace();
 }
}



void fade_out(int start, int end, int speed, color *pal)
/* The sound system doesn't work when we call a delay command since the
IRQ has been reprogrammed.  Since the color fading routines in WGT use
delay, I've redone them here with a simple "for loop" delay which is
really bad, but is good enough this this demo. */
{
color black[256];
int i;
long j;

for (i = 0; i < 256; i++)
  wsetrgb (i, 0, 0, 0, black);
for (i = 0; i < 64; i++)
 {
  wfade_between_once (start, end, pal, black);
  wsetpalette (start,end,pal);
  for (j = 0; j < speed; j++)
   wretrace ();
 }
}

block textscreen;
int lastvolume[8];	/* Keep track of volume levels each channel */

void drawtextbar (int barnum, int vol)
{
block temp;
int x, y;

for (y = 41 - vol; y < 41-lastvolume[barnum]; y++)
 {
  temp = textscreen + barnum * 20 * 2 + y*160;
  for (x = 0; x < 20; x++)
   {
    if (*temp == 32)
    {
      *temp = 254;
      temp++;
      *temp = 34;
      temp++;
    }
    else temp+=2;
   }
 }
}

void droptextbar (int barnum, int vol)
{
block temp;
int x, y;

y = 41 - vol;

temp = textscreen + barnum * 20 * 2 + y*160;

for (x = 0; x < 20; x++)
   {
    if (*temp == 254)
     {
      *temp = 32;
      temp++;
      *temp = 0;
      temp++;
     }
    else temp+=2;
   }
}


color bigpal[384];

void show_end_text (void)
{
struct BYTEREGS reg;
block ansibuffer;
int curvol;		/* Current volume of channel */
color *barpal;
int cyclecol, cycledir;


reg.ah = 17;
reg.al = 18;
reg.bl = 0;
intr (16, &reg);

_setcursortype(_NOCURSOR);

cyclecol=0;
cycledir=1;
for (i=0; i<384; i++)
{
 bigpal[i].r = 0;
 bigpal[i].g = cyclecol;
 bigpal[i].b = 32;
 cyclecol+=cycledir;
 if (cyclecol>31)
   cycledir=-1;
 else if (cyclecol<1)
   cycledir=1;
}


wsetrgb(3, 60, 0, 0, pal1);
wsetpalette (3, 3, pal1);

wsetrgb(2, 32, 0, 32, pal1);
wsetpalette (2, 2, pal1);

if (music_on)
{
  for (i = 0; i < 64; i++)	/* Fade out volume and colors */
  {
    if (MVol > 4)
    {
      MVol -= 4;
      DSMSetMusicVolume (MVol);
    }
    wretrace ();		/* DELAY doesn't work with Interrupts */
    wretrace ();		/* Use several retrace commands instead */
    wretrace ();
  }
  MVol = 252;

  DSMStopMusic();
  DSMFree(Module);

  Module = DSMLoad("yoursong.dsm",0L);
}
textscreen = MK_FP (0xB800, 0x0000);
ansibuffer = lib2buf ("ansi.bin");
memcpy (textscreen, ansibuffer, 8000);
farfree (ansibuffer);

if (music_on)
 {
  DSMPlayMusic(Module);
  DSMSetMusicVolume (MVol);
 }

if (music_on)
 {
 Music = DSMGetMusicInfo();
 do {
    for(i = 0; i < 4; i++)	/* For every channel in song */
     {
      curvol = Music->Tracks[i].EQBar/2;
      if (curvol < 0) curvol = 0;

      if (curvol > lastvolume[i])
       {
	drawtextbar (i, curvol);
	lastvolume[i] = curvol;
       }
      if (curvol < lastvolume[i])
       {
	droptextbar (i, lastvolume[i]);
	lastvolume[i]--;
	if (lastvolume[i] < 1)
	 lastvolume[i] = 0;
       }

     }

  if (gravis)
  {
   barpal = &bigpal[cyclecol];
   cyclecol+=2;
   if (cyclecol>63) 
     cyclecol-=64;

   asm cli			 /* Turn off interrupts */
   asm mov cx,300         	 /* Set up to change the palette 384 times */
   asm lds si,barpal      	 /* (for 400 scan lines) */

   asm  mov     dx,03dah           /* set up Input Status 1 reg */
   VRetrace:;
   asm in al,dx
   asm test al,00001000b           /* test bit 3, vertical retrace */
   asm jnz VRetrace                /* if active, go back */

   VNoRetrace:;
   asm in al,dx
   asm test al,00001000b           /* test bit 3, vertical retrace */
   asm jz VNoRetrace               /* if active, go back */

   doit:;
   asm mov al,2                    /* Change color 2 */
   asm mov dx,03c8h                /* set color register */
   asm out dx,al                         
   asm inc dx
   asm outsb                       /* dump out the red */
   asm outsb                       /* and green values */
   asm mov dx,03dah	

   puck1:;
   asm in al,dx
   asm test al,00000001b
   asm jz puck1                    /* Wait for the horizontal retrace */

   asm mov dx,03c9h                /* Now output the last blue value to */
   asm outsb                       /* set the color */

   asm mov dx,03dah                /* set up Input Status 1 reg */

   hretrace:;
   asm in al,dx
   asm test al,00000001b           /* test bit 1, horiz retrace */
   asm jnz hretrace                /* if not active, go back */

   asm loop doit
   asm sti
  }
   if (kbhit())
   {
    if (MVol > 4)
     {
      MVol -= 4;
      DSMSetMusicVolume (MVol);
     }
   }
  
 } while (MVol > 4);
}
 else getch();
if (music_on)
 stopmusic (0);
_setcursortype(_NORMALCURSOR);
wsetmode(3);
while (kbhit()) getch();

}

