#!/usr/bin/perl

# Define path and name of the config file:
$config_file='blackboard.cnf';

# Print HTML header : "Content-type: text/html\n\n"
print &PrintHeader;

# Read the configuration file in @configdata...
open(CONFIGFILE,$config_file);
@configdata = <CONFIGFILE>;
close(CONFIGFILE);

# ... and set $mes_file, $header_file and $profile
$query="";
foreach $line (@configdata) {
  if ($line =~ /^\[/) {
    $_ = $line;
    s/^(\[)(.*)(])$/\2/ge;
    chop $_;
    $query = $_;
  }

  if ($query eq $ENV{'QUERY_STRING'}) {
    if ($line =~ /^(header)/) {
      $_ = $line;
      s/^(header=)(.*)/\2/ge;
      chop $_;
      $header_file = $_;
    }
    if ($line =~ /^(messages=)/) {
      $_ = $line;
      s/^(messages=)(.*)/\2/ge;
      chop $_;
      $mes_file = $_;
    }
    if ($line =~ /^(profile=)/) {
      $_ = $line;
      s/^(profile=)(.*)/\2/ge;
      chop $_;
      $profile = $_;
    }
    if ($line =~ /^(footer=)/) {
      $_ = $line;
      s/^(footer=)(.*)/\2/ge;
      chop $_;
      $footer_file = $_;
    }
    if ($line =~ /^(begin_msg=)/) {
      $_ = $line;
      s/^(begin_msg=)(.*)/\2/ge;
      chop $_;
      $begin_msg = $_;
    }
    if ($line =~ /^(submit_msg=)/) {
      $_ = $line;
      s/^(submit_msg=)(.*)/\2/ge;
      chop $_;
      $submit_msg = $_;
    }
  }
}

if ($header_file) {
  # Print header of the page
  open(HEADERFILE,$header_file);
  @headdata = <HEADERFILE>;
  close(HEADERFILE);
  print @headdata;
}

# Get message profile
open (PROFILE,$profile);
@mes_format = <PROFILE>;
close(PROFILE);

# If there's no input (just called from a link) then just show an appropriate message.
# Otherwise show another appropriate message and write the data to $mes_file.
if (&ReadParse(*input))
     {   #&ParseProfile(*mes_format);

         if ($submit_msg) { print $submit_msg }

         # protect against < HTML > codes and convert \n to <BR>
         &StripShit(*input);

         # get the date and time
         local ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdat) = localtime;
         local (@day_of_week) = ("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
         local (@month) = ("Januari", "Februari", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
         ($min < 10) && ($min = '0' . $min);

         if ($profile) {
           %time = ("weekday", $day_of_week[$wday],
                    "year"   , $year,
                    "mon"    , $month[$mon],
                    "month"  , $mon+1,
                    "day"    , $mday,
                    "hour"   , $hour,
                    "min"    , $min,
                    "sec"    , $sec);
  
           local (%user_vars) = (%time, %input);
  
           foreach $line (0 .. $#mes_format) { $mes_format[$line] =~ s/(__)(\S+)(__)/$user_vars{\2}/ge }
  
           # open messaages file for appending and write the new (formatted) message
           open(DATAFILE,">>$mes_file");
           print DATAFILE @mes_format;
         }
         else {
           # open messaages file for appending
           open(DATAFILE,">>$mes_file");
                                        print DATAFILE '<HR><BR>';
           if ($input{'name'} ne "")  { print DATAFILE '<FONT SIZE=+2><B><I>', $input{'name'}, '</I></B> </FONT>'; }
              else                    { print DATAFILE '<FONT SIZE=+2><B><I>no one</I></B> </FONT>'; }
           if ($input{'email'} ne "") { print DATAFILE '(<A HREF="mailto:', $input{'email'}, '">', $input{'email'}, '</A>)<FONT SIZE=+2><B><I> :</I></B> </FONT>'; }
              else                    { print DATAFILE '<FONT SIZE=+2><B><I> :</I></B> </FONT>'; }
           if ($input{'text'} ne "")  { print DATAFILE '<BR><BR><B>', $input{'text'}, '</B>'; }
              else                    { print DATAFILE '<BR><BR><B>This person had nothing to say.', '</B>'; }
           if ($input{'link'} ne "")  { print DATAFILE '<BR><BR><B>..... By the way, go see <A HREF="', $input{'link'}, '">', $input{'link'}, '</A> !', '</B>'; }
                                        print DATAFILE '<BR><BR><I>(', $date, ')</I>', '<BR><BR>', "\n";
         }
         close(DATAFILE);
     }
else {   if ($begin_msg) { print $begin_msg }
     }

# Show all messages in $mes_file.
open(MESFILE,$mes_file);
@mesdata = <MESFILE>;
close(MESFILE);
print @mesdata;

# Print a "name" tag to jump to the last message from the header
print '<A NAME="lastmessage"> </A>';

if ($footer_file) {
  # Get footer of the page
  open (FOOTERFILE,$footer_file);
  @footer_data = <FOOTERFILE>;
  close(FOOTERFILE);
  # Print footer
  print @footer_data;
}

# Print end of HTML
print '<HR><BR><FONT SIZE=-1>This blackboard perl script was written by <A HREF="mailto:s.wieman@student.utwente.nl">S.Wieman</A>.</FONT></BODY></HTML>';

# End of script







# This sub makes sure that HTML codes become visible as text (add &lt; and &gt; codes).
# It also replaces \n by the HTML <BR> tag.
sub StripShit {
  local (*in) = @_ if @_;
  local ($i);

  foreach $i (%in)
  {
  # replace all "<" by "(" and all ">" by ")" to avoid HTML interference:
  $in{$i} =~ s/</&lt;/g;
  $in{$i} =~ s/>/&gt;/g;

  # and convert all \n to "<BR>"
  $in{$i} =~ s/\n/<BR>/g;
  }
}

# Following sub's are copied from cgi-lib.pl from
# S.E.Brenner@bioc.cam.ac.uk
# Copyright 1994 Steven E. Brenner

# I commented out lines 6,7,8 and 10 of sub ReadParse !!

sub ReadParse {
  local (*in) = @_ if @_;
  local ($i, $key, $val);

  # Read in text
#  if (&MethGet) {
#    $in = $ENV{'QUERY_STRING'};
#  } elsif ($ENV{'REQUEST_METHOD'} eq "POST") {
    read(STDIN,$in,$ENV{'CONTENT_LENGTH'});
#  }

  @in = split(/&/,$in);

  foreach $i (0 .. $#in) {
    # Convert plus's to spaces
    $in[$i] =~ s/\+/ /g;

    # Split into key and value.  
    ($key, $val) = split(/=/,$in[$i],2); # splits on the first =.

    # Convert %XX from hex numbers to alphanumeric
    $key =~ s/%(..)/pack("c",hex($1))/ge;
    $val =~ s/%(..)/pack("c",hex($1))/ge;

    # Associate key and value
    $in{$key} .= "\0" if (defined($in{$key})); # \0 is the multiple separator
    $in{$key} .= $val;

  }

  return length($in); 
}

sub PrintHeader {
  return "Content-type: text/html\n\n";
}

sub MethGet {
  return ($ENV{'REQUEST_METHOD'} eq "GET");
}

