/*****************************************************************************/
/***                        Gestion des channels                           ***/
/*****************************************************************************/

#include <stdio.h>
#include "robot.h"
#include "channels.h"

extern chan *channels;
extern char *p[1024];
extern char master[256];
extern char myname[256];

/*****************************************************************************/

char *ChanMode (char *channel) {
  chan *tmp1=channels;

  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,channel));
  if (!tmp1) return (channels->mode);
  return (tmp1->mode);
}

/*****************************************************************************/

void DelChannel (char *channel) {
  chan *tmp1=channels,*tmp2=channels;

  while ((tmp2=(tmp1=tmp2)->next) && strcasecmp(tmp2->channel,channel));
  if (tmp2) {
    tmp1->next=tmp2->next;
    FreeWho (tmp2->channel);
    FreeBans (tmp2->channel);
    FreeProt (tmp2->channel);
    free (tmp2->channel);
    free (tmp2->mode);
    free (tmp2);
  }
}

/*****************************************************************************/

void AddChannel (char *channel,char *mode) {
  chan *tmp1=channels,*tmp2=channels;

  while ((tmp2=(tmp1=tmp2)->next) && strcasecmp(tmp2->channel,channel));
  if (tmp2) return;
  tmp1=tmp1->next=(chan*)malloc(sizeof(chan));
  tmp1->channel=(char*)strdup(channel);
  tmp1->mode=(char*)strdup(mode);
  tmp1->nops=0;
  tmp1->who=(who*)malloc(sizeof(who));
  tmp1->who->nick=(char*)strdup("");
  tmp1->who->login=(char*)strdup("");
  tmp1->who->host=(char*)strdup("");
  tmp1->who->isop=0;
  tmp1->who->next=(who*)NULL;
  tmp1->bans=(ban*)malloc(sizeof(ban));
  tmp1->bans->pattern=(char*)strdup("");
  tmp1->bans->next=NULL;
  tmp1->protect=(prot*)malloc(sizeof(prot));
  tmp1->protect->name=(char*)strdup("");
  tmp1->protect->pattern=(char*)strdup("");
  tmp1->protect->next=(prot*)malloc(sizeof(prot));
  tmp1->protect->next->name=(char*)strdup(myname);
  tmp1->protect->next->pattern=(char*)strdup("*!geek@*.york.cuny.edu");
  tmp1->protect->next->next=(prot*)NULL;
  tmp1->next=NULL;
}

/*****************************************************************************/

void AddBan (char *channel,char *pattern) {
  chan *tmp1=channels;
  ban *tmp2;

  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,channel));
  if (!tmp1) return;
  tmp2=tmp1->bans;
  while ((tmp2=tmp2->next) && strcasecmp(tmp2->pattern,pattern));
  if (tmp2) return;
  tmp2=(ban*)malloc(sizeof(ban));
  tmp2->pattern=(char*)strdup(pattern);
  tmp2->next=tmp1->bans->next;
  tmp1->bans->next=tmp2;
}

/*****************************************************************************/

void DelBan (char *channel,char *pattern) {
  chan *tmp1=channels;
  ban *tmp2,*tmp3;

  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,channel));
  if (!tmp1) return;
  tmp3=tmp2=tmp1->bans;
  while ((tmp2=(tmp3=tmp2)->next) && strcasecmp(tmp2->pattern,pattern));
  if (!tmp2) return;
  tmp3->next=tmp2->next;
  free(tmp2->pattern);
  free(tmp2);
}

/*****************************************************************************/

void FreeBans (char *channel) {
  chan *tmp3=channels;
  ban *tmp1,*tmp2;

  while ((tmp3=tmp3->next) && strcasecmp(tmp3->channel,channel));
  if (!tmp3) return;
  tmp2=tmp3->bans->next;
  while (tmp1=tmp2) {
    tmp2=tmp1->next;
    free (tmp1->pattern);
    free(tmp1);
  }
  tmp3->bans->next=(ban*)NULL;
}

/*****************************************************************************/

void AddUser (char *chann,char *nick,char *login,char *host,int isop) {
  chan *tmp1=channels;
  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,chann));
  if (tmp1) {
    who *tmp2,*tmp3=tmp1->who;
    while ((tmp3=(tmp2=tmp3)->next) && strcasecmp(tmp3->nick,nick));
    if (!tmp3) {
      tmp2=tmp2->next=(who*)malloc(sizeof(who));
      tmp2->nick=(char*)strdup(nick);
      tmp2->login=(char*)strdup(login);
      tmp2->host=(char*)strdup(host);
      tmp2->isop=isop;
      tmp2->next=(who*)NULL;
      tmp1->who->isop++;
    }
  }
}

/*****************************************************************************/

void DelUser (char *chann,char *nick) {
  chan *tmp1=channels;
  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,chann));
  if (tmp1) {
    who *tmp2,*tmp3=tmp1->who;
    while ((tmp3=(tmp2=tmp3)->next) && strcasecmp(tmp3->nick,nick));
    if (tmp3) {
      tmp2->next=tmp3->next;
      free (tmp3->nick);
      free (tmp3->login);
      free (tmp3->host);
      free (tmp3);
      tmp1->who->isop--;
    }
  }
}

/*****************************************************************************/

void NickUser (char *onick,char *nnick) {
  chan *tmp1=channels;
  who *tmp2;

  while (tmp1=tmp1->next) {
    tmp2=tmp1->who;
    while ((tmp2=tmp2->next) && strcasecmp(tmp2->nick,onick));
    if (tmp2) {
      free (tmp2->nick);
      tmp2->nick=(char*)strdup(nnick);
    }
  }
}

/*****************************************************************************/

void OpUser (char *chann,char *nick,int isop) {
  chan *tmp1=channels;
  who *tmp2,*tmp3;

  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,chann));
  if (!tmp1) return;
  tmp3=tmp1->who;
  while ((tmp3=(tmp2=tmp3)->next) && strcasecmp(tmp3->nick,nick));
  if (!tmp3) return;
  tmp3->isop=isop;
}

/*****************************************************************************/

void FreeWho (char *chann) {
  chan *tmp1=channels;
  who *tmp2,*tmp3;

  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,chann));
  if (!tmp1) return;
  tmp3=tmp1->who->next;
  while (tmp2=tmp3) {
    tmp3=tmp2->next;
    free (tmp2->nick);
    free (tmp2->login);
    free (tmp2->host);
    free (tmp2);
  }
  tmp1->who->next=(who*)NULL;
  tmp1->who->isop=0;
}

/*****************************************************************************/

void AddProtect (char *channel) {
  chan *tmp1=channels;
  prot *tmp2,*tmp3;
  char tmp4[256],tmp5[256],mess[256];

  sprintf (tmp4,"%s!%s@%s",p[3],p[4],p[5]);
  sprintf (tmp5,"*!%s@*.%s",p[4],UserDomain(p[5]));
  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,channel));
  if (!tmp1) return;
  tmp2=tmp1->protect;
  while ((tmp2=(tmp3=tmp2)->next) && strcasecmp(tmp2->name,tmp4));
  if (tmp2) return;
  tmp3=tmp3->next=(prot*)malloc(sizeof(prot));
  tmp3->name=(char*)strdup(tmp4);
  tmp3->pattern=(char*)strdup(tmp5);
  tmp3->next=(prot*)NULL;
  sprintf (mess," %s now protected on channel %s.",tmp4,channel);
  HelpNotice (master,mess);
  HelpNotice (p[3],mess);
}

/*****************************************************************************/

void FreeProt (char *chann) {
  chan *tmp1=channels;
  prot *tmp2,*tmp3;

  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,chann));
  if (!tmp1) return;
  tmp3=tmp1->protect->next;
  while (tmp2=tmp3) {
    tmp3=tmp2->next;
    free (tmp2->name);
    free (tmp2->pattern);
    free (tmp2);
  }
  tmp1->protect->next=(prot*)NULL;
}

/*****************************************************************************/

void LoadChannels() {
  chan *tmp1;
  char channel[20],mode[20];
  FILE *fichier=fopen(CHANSFILE,"r");

  if (!fichier) {
    fprintf(stderr,"*** Error : Cannot open %s\n",CHANSFILE);
    exit(1);
  }

  while (fscanf (fichier,"%s%s",channel,mode)>0)
    AddChannel (channel,mode);
}

/*****************************************************************************/

void GetOp (char *channel) {
  chan *tmp1=channels;
  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,channel));
  if (tmp1 && tmp1->who->isop==1 && !tmp1->who->next->isop) {
    char tmp2[256];
    FreeWho (tmp1->channel);
    FreeBans (tmp1->channel);
    ServerPart (tmp1->channel);
    ServerJoin (tmp1->channel);
   /* sprintf (tmp2,"###  Getting Op on channel %s.",tmp1->channel);
    HelpNotice (master,tmp2);*/
  }
}

/*****************************************************************************/

void ReJoin () {
  chan *tmp1=channels;

  while (tmp1=tmp1->next) {
    ServerJoin (tmp1->channel);
    }
}

/*****************************************************************************/
