/*****************************************************************************/
/***                           Commandes                                   ***/
/*****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include "robot.h"
#include "actions.h"
#include "commandes.h"
#include "users.h"
#include "channels.h"
#include "help.h"

extern user *users;
extern chan *channels;
extern wis  *wislist,*wwslist;
extern char *p[1024];
extern int  np;
extern char server[256];
extern char username[20];
extern char hostname[80];
extern char mynick[10];
extern char myname[256];
extern char by[256];
extern char LastKicked[256];
extern char master[10];
extern user *CurrUsr;
int lev = 0;
extern int secure;
extern char securedby[256];
char stringtmp[256];


/*****************************************************************************/

int DoCkSecure()
{
  if(secure) {
    if(DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth < secure) {
       sprintf(stringtmp,"I am secured at level %d.",secure);
       ServerNotice(UserNick(p[0]),stringtmp);
       return(0); /* 0 if secured */
    }
  }
  return(1); /* 1 if not */
}


/*****************************************************************************/

void DoTopic() {
    char tmp1[256];
    int i;
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=TOPIC) && DoCkSecure()) {
    
    if (*p[2]=='#') {
      if (np>4) {
	strcpy (tmp1,p[4]);
	for (i=5;i<np;i++) sprintf (tmp1,"%s %s",tmp1,p[i]);
	ServerTopic (p[2],tmp1);
      }
      else
	ServerTopic (p[2],"");
    }
    else if (np>4 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      if (np>5) {
	strcpy (tmp1,p[5]);
	for (i=6;i<np;i++) sprintf (tmp1,"%s %s",tmp1,p[i]);
	ServerTopic (p[4],tmp1);
      }
      else
	ServerTopic (p[4],"");
    }
  }
}

/*****************************************************************************/

void DoMe() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=ME) && DoCkSecure()) {
    char tmp1[256];
    chan *tmp2=channels;

    sprintf (tmp1,"+o %s",UserNick(p[0]));
    if (*p[2]=='#') {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[2]));
      if (tmp2 && !tmp2->nops) {
	who *tmp3=tmp2->who;
	while ((tmp3=tmp3->next) && strcasecmp(tmp3->nick,UserNick(p[0])));
	if (tmp3 && !tmp3->isop) ServerMode (p[2],tmp1);
      }
    } else if (np>4) {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[4]));
      if (tmp2 && !tmp2->nops) {
	who *tmp3=tmp2->who;
	while ((tmp3=tmp3->next) && strcasecmp(tmp3->nick,UserNick(p[0])));
	if (tmp3 && !tmp3->isop) ServerMode (p[2],tmp1);
      }
    }
  }
}

/*****************************************************************************/

void DoOp() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=OP)  && DoCkSecure()){
    chan *tmp2=channels;
    char chaine[256];

    if (*p[2]=='#' && np>4) {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[2]));
      if (tmp2 && !tmp2->nops) {
	sprintf (chaine,"+ooo %s %s %s",
		 p[4]?p[4]:"",p[5]?p[5]:"",p[6]?p[6]:"");
	ServerMode (p[2],chaine);
      }
    }
    else if (np>5 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[4]));
      if (tmp2 && !tmp2->nops) {
	while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[4]));
	sprintf (chaine,"+ooo %s %s %s",
		 p[5]?p[5]:"",p[6]?p[6]:"",p[7]?p[7]:"");
	ServerMode (p[4],chaine);
      }
    }
  }
}

/*****************************************************************************/

void DoDop() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=DOP)  && DoCkSecure()){
    char chaine[256];

    if (*p[2]=='#' && np>4) {
      sprintf (chaine,"-ooo %s %s %s",
	       (p[4]&&strcasecmp(mynick,p[4]))?p[4]:"",
	       (p[5]&&strcasecmp(mynick,p[5]))?p[5]:"",
	       (p[6]&&strcasecmp(mynick,p[6]))?p[6]:"");
      ServerMode (p[2],chaine);
    }
    else if (*p[2]!='#' && np>5 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      sprintf (chaine,"-ooo %s %s %s",
	       (p[5]&&strcasecmp(mynick,p[5]))?p[5]:"",
	       (p[6]&&strcasecmp(mynick,p[6]))?p[6]:"",
	       (p[7]&&strcasecmp(mynick,p[7]))?p[7]:"");
      ServerMode (p[4],chaine);
    }
  }
}

/*****************************************************************************/

void DoSecure() {
  int i;
  char tmpstr[256];
  char tmpstr2[256];
  if(np <= 4) {
     sprintf(tmpstr,"%s has me secured at level %d",securedby,secure); 
     ServerNotice(UserNick(p[0]),tmpstr);
     return;
  }
  sscanf (p[4],"%d",&i); 
  if(DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth >= secure) {
     if(DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth >= i) {
        if(i > 1000) i = 1000;
        secure = i;
        strcpy(securedby,p[0]);
        sprintf(tmpstr,"Now Secured at level %d and above",secure);
     }
     else {
        sprintf(tmpstr,"%s, You cannot secure me higher than your access level",UserNick(p[0]));
     }
  }
  else {
        sprintf(tmpstr,"I am currently secured at level %d",secure);
  }
  ServerNotice(UserNick(p[0]),tmpstr);
  sprintf(tmpstr2,"%s - %s",UserNick(p[0]),tmpstr);
  ServerNotice(master,tmpstr2);
}

/*****************************************************************************/
void DoStat() {
  int i;
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=STAT)  && DoCkSecure()){
    sprintf(stringtmp,"Last Kicked by: %s",LastKicked);
    ServerNotice(UserNick(p[0]),stringtmp);
    sprintf(stringtmp,"Secured at level: %d",secure);
    ServerNotice(UserNick(p[0]),stringtmp);
  }
}

/*****************************************************************************/
void DoKick() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=KICK) && DoCkSecure()){
    int i;

    if (*p[2]=='#' && np>4) {
      for (i=4;i<np;i++) if (strcasecmp(mynick,p[i])) ServerKick (p[2],p[i],"Weenie");
    }
    else if (*p[2]!='#' && np>5 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      for (i=5;i<np;i++) if (strcasecmp(mynick,p[i])) ServerKick (p[4],p[i],"Weenie");
    }
  }
}

/*****************************************************************************/

void DoBan() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=BAN)  && DoCkSecure()){
    if (*p[2]=='#' && np>4) {
      if (strchr(p[4],'!')) {
	if (!Rmatch(p[4],myname)) {
	  char banpat[256];
	  sprintf (banpat,"+b %s",p[4]);
	  ServerMode (p[2],banpat);
	}
      }
      else if (strcasecmp(mynick,p[4]) && !strchr(p[4],'*')) {
	chan *tmp1=channels;
	while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[2]));
	if (tmp1) {
	  who *tmp2=tmp1->who;
	  while ((tmp2=tmp2->next) && strcasecmp(tmp2->nick,p[4]));
	  if (tmp2) {
	    char tmp3[256];
	    if (isdigit(tmp2->host[0]))
	      sprintf (tmp3,"-o+b %s *!*%s*@%s.*",
		       tmp2->nick,*tmp2->login=='#'?tmp2->login+1:tmp2->login
		       ,UserDomain(tmp2->host));
	    else
	      sprintf (tmp3,"-o+b %s *!*%s*@*.%s",
		       tmp2->nick,*tmp2->login=='#'?tmp2->login+1:tmp2->login,
		       UserDomain(tmp2->host));
	    ServerMode (p[2],tmp3);
	  }
	  else DoWhois (p[4],p[2],ToBan);
	}
      }
    }
    else if (*p[2]!='#' && np>5 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      if (strchr(p[5],'!')) {
	if (!Rmatch(p[5],myname)) {
	  char banpat[256];
	  sprintf (banpat,"+b %s",p[5]);
	  ServerMode (p[4],banpat);
	}
      }
      else if (strcasecmp(mynick,p[5]) && !strchr(p[5],'*')) {
	chan *tmp1=channels;
	while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[4]));
	if (tmp1) {
	  who *tmp2=tmp1->who;
	  while ((tmp2=tmp2->next) && strcasecmp(tmp2->nick,p[5]));
	  if (tmp2) {
	    char tmp3[256];
	    if (isdigit(*tmp2->host))
	      sprintf (tmp3,"-o+b %s *!*%s*@%s.*",
		       tmp2->nick,*tmp2->login=='#'?tmp2->login+1:tmp2->login,
		       UserDomain(tmp2->host));
	    else
	      sprintf (tmp3,"-o+b %s *!*%s*@*.%s",
		       tmp2->nick,*tmp2->login=='#'?tmp2->login+1:tmp2->login,
		       UserDomain(tmp2->host));
	    ServerMode (p[4],tmp3);
	  }
	  else DoWhois (p[5],p[4],ToBan);
	}
      }
    }
  }
}

/*****************************************************************************/

void ToBan (char *channel) {
  char tmp1[256];
  if (isdigit(p[5][0]))
    sprintf (tmp1,"-o+b %s *!*%s*@%s.*",
	     p[3],*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  else
    sprintf (tmp1,"-o+b %s *!*%s*@*.%s",
	     p[3],*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  ServerMode (channel,tmp1);
}

/*****************************************************************************/
void ToAcc (char *channel) {
  char savetmp[256], pattern[256];
  user *tmp2,*tmp1=users;
  if(*p[4] == '~') *p[4] = '#';
  if (isdigit(p[5][0]))
    sprintf (pattern,"*!*%s@%s.*",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  else
    sprintf (pattern,"*!*%s@*.%s",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  while (tmp1 && (strcasecmp(tmp1->pattern,pattern)))
    tmp1=(tmp2=tmp1)->next;
  if(!tmp1)
  {
    sprintf (savetmp,"User %s (%s) is level 0.",p[3],pattern);
    ServerNotice(master,savetmp);
    ServerNotice(UserNick(by),savetmp);
  }
  else
  {
    sprintf (savetmp,"User %s (%s) is level %d.",p[3],pattern,tmp1->auth);
    ServerNotice(master,savetmp);
    ServerNotice(UserNick(by),savetmp);
  }
}

/*****************************************************************************/
void ToAdd (char *channel) {
  char savetmp[256], pattern[256];
  user *tmp2,*tmp1=users;
  if(lev == 0) sscanf ("20","%d",&lev);

  if (isdigit(p[5][0]))
    sprintf (pattern,"*!*%s@%s.*",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  else
    sprintf (pattern,"*!*%s@*.%s",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  while (tmp1 && (strcasecmp(tmp1->pattern,pattern)))
    tmp1=(tmp2=tmp1)->next;
  if(!tmp1)
  {
    user *tmp3=(user*)malloc(sizeof(user));
    tmp3->nick=(char*)strdup(p[3]);
    tmp3->pattern=(char*)strdup(pattern);
    tmp3->channel=(char*)strdup("#*");
    tmp3->auth=lev;
    tmp3->next=users->next;
    users->next=tmp3;
    sprintf (savetmp,"User %s (%s) Added, Lvl %d",p[3],pattern,tmp3->auth);
    SaveUsers();
    printf("%s\n",savetmp); 
    ServerNotice(master,savetmp);
    ServerNotice(p[3],savetmp);
  }
  else
  {
    sprintf (savetmp,"User %s (%s) Already exists, Lvl %d",tmp1->nick,tmp1->pattern,tmp1->auth);
    ServerNotice(master,savetmp);
    tmp1->auth=lev;
    sprintf (savetmp,"User %s (%s) Updated, Lev %d",p[3],pattern,tmp1->auth);
    SaveUsers();
    printf("%s\n",savetmp);
    ServerNotice(master,savetmp);
  }
  lev = 0;
}

/*****************************************************************************/
void ToKB (char *channel) {
  char savetmp[256], pattern[256];
  user *tmp2,*tmp1=users;
  int lev;
  sscanf ("-1","%d",&lev);

  if (isdigit(p[5][0]))
    sprintf (pattern,"*!*%s@%s.*",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  else
    sprintf (pattern,"*!*%s@*.%s",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  while (tmp1 && (strcasecmp(tmp1->pattern,pattern)))
    tmp1=(tmp2=tmp1)->next;
  if(!tmp1)
  {
    user *tmp3=(user*)malloc(sizeof(user));
    tmp3->nick=(char*)strdup(p[3]);
    tmp3->pattern=(char*)strdup(pattern);
    tmp3->channel=(char*)strdup("#*");
    tmp3->auth=lev;
    tmp3->next=users->next;
    users->next=tmp3;
    sprintf (savetmp,"-User %s (%s) added to KB list...",p[3],pattern);
    SaveUsers();
    printf("%s\n",savetmp);
    ServerNotice(master,savetmp);
    ServerNotice(p[3],savetmp);
  }
}

/*****************************************************************************/
void ToRM (char *channel) {
  char savetmp[256], pattern[256];
  user *tmp2,*tmp1=users;

  if (isdigit(p[5][0]))
    sprintf (pattern,"*!*%s@%s.*",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  else
    sprintf (pattern,"*!*%s@*.%s",*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  while (tmp1 && (strcasecmp(tmp1->pattern,pattern)))
    tmp1=(tmp2=tmp1)->next;
  if(tmp1)
  {
    tmp2->next=tmp1->next;
    free (tmp1->nick);
    free (tmp1->pattern);
    free (tmp1->channel);
    free (tmp1);
    sprintf (savetmp,"-User %s (%s) Removed from ALL lists",p[3],pattern);
    SaveUsers();
    printf("%s\n",savetmp);
    ServerNotice(master,savetmp);
    ServerNotice(p[3],savetmp);
  }
}

/*****************************************************************************/

void DoFuck() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=FUCK)  && DoCkSecure()){
    int i;

    if (*p[2]=='#' && np>4 && !strchr(p[4],'*')) {
      for (i=4;i<np;i++) {
	if (strcasecmp(mynick,p[i])) {
	  chan *tmp1=channels;
	  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[2]));
	  if (tmp1) {
	    who *tmp2=tmp1->who;
	    while ((tmp2=tmp2->next) && strcasecmp(tmp2->nick,p[i]));
	    if (tmp2) {
	      char tmp3[256];
	      if (isdigit(*tmp2->host))
		sprintf (tmp3,"-o+b %s *!*%s*@%s.*",
			 tmp2->nick,
			 *tmp2->login=='#'?tmp2->login+1:tmp2->login,
			 UserDomain(tmp2->host));
	      else
		sprintf (tmp3,"-o+b %s *!*%s*@*.%s",
			 tmp2->nick,
			 *tmp2->login=='#'?tmp2->login+1:tmp2->login,
			 UserDomain(tmp2->host));
	      ServerMode (p[2],tmp3);
	      ServerKick (p[2],p[i],"Go Away");
	      ServerMode (p[2],tmp3);
	      ServerKick (p[2],p[i],"Go Away asshole!");
	    }
	    else DoWhois (p[i],p[2],ToFuck);
	  }
	}
      }
    }
    else if (*p[2]!='#' && np>5 && DoAuth(p[0],p[4])->auth>=OKMSG &&
	     !strchr(p[5],'*')) {
      for (i=5;i<np;i++)
	if (strcasecmp(mynick,p[i])) {
	  chan *tmp1=channels;
	  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[4]));
	  if (tmp1) {
	    who *tmp2=tmp1->who;
	    while ((tmp2=tmp2->next) && strcasecmp(tmp2->nick,p[i]));
	    if (tmp2) {
	      char tmp3[256];
	      if (isdigit(*tmp2->host))
		sprintf (tmp3,"-o+b %s *!*%s*@%s.*",
			 tmp2->nick,
			 *tmp2->login=='#'?tmp2->login+1:tmp2->login,
			 UserDomain(tmp2->host));
	      else
		sprintf (tmp3,"-o+b %s *!*%s*@*.%s",
			 tmp2->nick,
			 *tmp2->login=='#'?tmp2->login+1:tmp2->login,
			 UserDomain(tmp2->host));
	      ServerMode (p[4],tmp3);
	      ServerKick (p[4],p[i],"Go Away buttlick");
	      ServerMode (p[4],tmp3);
	      ServerKick (p[4],p[i],"Please go away");
	    }
	    else DoWhois (p[i],p[4],ToFuck);
	  }
	}
    }
  }
}

/*****************************************************************************/

void ToFuck (char *channel) {
  char tmp1[256];
  if (isdigit(p[5][0]))
    sprintf (tmp1,"-o+b %s *!*%s*@%s.*",
	     p[3],*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  else
    sprintf (tmp1,"-o+b %s *!*%s*@*.%s",
	     p[3],*p[4]=='#'?p[4]+1:p[4],UserDomain(p[5]));
  ServerMode (channel,tmp1);
  ServerKick (channel,p[3],"Really do not want you here");
  ServerMode (channel,tmp1);
  ServerKick (channel,p[3],"Really do not want you here");
}

/*****************************************************************************/

void ToWeenie (char *channel) {
  ServerKick (channel,p[3],"This is a weenie kick");
}

/*****************************************************************************/

void DoDban() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=DBAN) && DoCkSecure()) {
    if (*p[2]=='#' && np>4) {
      if (strchr(p[4],'*'))
	DoDbanAll (p[2]);
      else
	DoWhois (p[4],p[2],ToDban);
    }
    else if (*p[2]!='#' && np>5 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      if (strchr(p[5],'*'))
	DoDbanAll (p[4]);
      else
	DoWhois (p[5],p[4],ToDban);
    }
  }
}

/*****************************************************************************/

void DoDbanAll (char *channel) {
  chan *tmp1=channels;
  ban *tmp2;
  int nbans=0;
  char modes[256],banspat[256];

  sprintf (modes,"");
  sprintf (banspat,"");
  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,channel));
  if (!tmp1) return;
  tmp2=tmp1->bans;
  while (tmp2=tmp2->next) {
    sprintf (modes,"%s-b",modes);
    sprintf (banspat,"%s %s",banspat,tmp2->pattern);
    if (++nbans>2) {
      sprintf (modes,"%s %s",modes,banspat);
      ServerMode (channel,modes);
      sprintf (modes,"");
      sprintf (banspat,"");
      nbans=0;
    }
  }
  if (nbans) {
    sprintf (modes,"%s %s",modes,banspat);
    ServerMode (channel,modes);
  }
}

/*****************************************************************************/

void ToDban (char *channel) {
  chan *tmp1=channels;
  ban *tmp2;
  char tmp4[256];
  int nbans=0;
  char modes[256],banspat[256];

  sprintf (modes,"");
  sprintf (banspat,"");
  sprintf (tmp4,"%s!%s@%s",p[3],p[4],p[5]);
  while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,channel));
  if (!tmp1) return;
  tmp2=tmp1->bans;
  while (tmp2=tmp2->next)
    if (Rmatch(tmp2->pattern,tmp4)) {
      sprintf (modes,"%s-b",modes);
      sprintf (banspat,"%s %s",banspat,tmp2->pattern);
      if (++nbans>2) {
	sprintf (modes,"%s %s",modes,banspat);
	ServerMode (channel,modes);
	sprintf (modes,"");
	sprintf (banspat,"");
	nbans=0;
      }
    }
  if (nbans) {
    sprintf (modes,"%s %s",modes,banspat);
    ServerMode (channel,modes);
  }
}

/*****************************************************************************/

void DoFree () {
  if (DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=FREE) {
    chan *tmp1=channels;
    ban *tmp2,*tmp3;
    char modes[256],banspat[256];
    int nbans=0;

    sprintf (modes,"");
    sprintf (banspat,"");
    if (*p[2]=='#')
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[2]));
    else if (*p[2]!='#' && np>4 && DoAuth(p[0],p[4])->auth>=OKMSG)
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[4]));
    else return;
    if (!tmp1) return;
    tmp2=tmp1->bans;
    while (tmp2=(tmp3=tmp2)->next)
      if (Rmatch(tmp2->pattern,p[0])) {
	sprintf (modes,"%s-b",modes);
	sprintf (banspat,"%s %s",banspat,tmp2->pattern);
	if (++nbans>2) {
	  sprintf (modes,"%s %s",modes,banspat);
	  if (*p[2]=='#')
	    ServerMode (p[2],modes);
	  else
	    ServerMode (p[4],modes);
	  sprintf (modes,"");
	  sprintf (banspat,"");
	  nbans=0;
	}
      }
    if (nbans) {
      sprintf (modes,"%s %s",modes,banspat);
      if (*p[2]=='#')
	ServerMode (p[2],modes);
      else
	ServerMode (p[4],modes);
    }
  }
}

/*****************************************************************************/

void DoMassOp() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=MASSOP) && DoCkSecure()) {
    chan *tmp1=channels;
    who *tmp2;
    char toop[256],tmp3[256];
    int nbop=0;

    DoOps();
    sprintf (toop,"+ooo");
    if (*p[2]=='#')
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[2]));
    else if (*p[2]!='#' && np>4 && DoAuth(p[0],p[4])->auth>=OKMSG)
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[4]));
    else return;
    if (!tmp1) return;
    tmp2=tmp1->who;
    while (tmp2=tmp2->next) {
      sprintf (tmp3,"%s!%s@%s",tmp2->nick,tmp2->login,tmp2->host);
      if (!tmp2->isop && (DoAuth(tmp3,p[(*p[2]=='#')?2:4])->auth>=ME)) {
	sprintf (toop,"%s %s",toop,tmp2->nick);
	if (++nbop>2) {
	  if (*p[2]=='#')
	    ServerMode (p[2],toop);
	  else
	    ServerMode (p[4],toop);
	  strcpy (toop,"+ooo");
	  nbop=0;
	}
      }
    }
    if (nbop) {
      if (*p[2]=='#')
	ServerMode (p[2],toop);
      else
	ServerMode (p[4],toop);
    }
  }
}

/*****************************************************************************/

void DoMassDop() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=MASSDOP) && DoCkSecure()) {
    chan *tmp1=channels;
    who *tmp2,*tmp3;
    char toop[256];
    int nbop=0;

    DoNops();
    sprintf (toop,"-ooo");
    if (*p[2]=='#')
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[2]));
    else if (*p[2]!='#' && np>4 && DoAuth(p[0],p[4])->auth>=OKMSG)
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[4]));
    else return;
    if (!tmp1) return;
    tmp2=tmp1->who;
    while (tmp2=(tmp3=tmp2)->next)
      if (tmp2->isop && strcasecmp(tmp2->nick,mynick)
	  && strcasecmp(tmp2->nick,UserNick(p[0]))) {
	sprintf (toop,"%s %s",toop,tmp2->nick);
	if (++nbop>2) {
	  if (*p[2]=='#')
	    ServerMode (p[2],toop);
	  else
	    ServerMode (p[4],toop);
	  sprintf (toop,"-ooo");
	  nbop=0;
	}
      }
    if (nbop) {
      if (*p[2]=='#')
	ServerMode (p[2],toop);
      else
	ServerMode (p[4],toop);
    }
  }
}

/*****************************************************************************/

void DoNops() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=NOPS) && DoCkSecure()) {
    chan *tmp2=channels;
    char nick[10],tmp1[100];

    strcpy (nick,UserNick(p[0]));
    if (*p[2]=='#') {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[2]));
      if (!tmp2) return;
      tmp2->nops=1;
      sprintf (tmp1,"--No More Ops Mode Activated On %s",p[2]);
      HelpNotice (nick,tmp1);
    } else if (*p[2]!='#' && np>4 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[4]));
      if (!tmp2) return;
      tmp2->nops=1;
      sprintf (tmp1,"--No More Ops Mode Activated On %s",p[4]);
      HelpNotice (nick,tmp1);
    }
  }
}

/*****************************************************************************/

void DoOps() {
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=OPS) && DoCkSecure()) {
    chan *tmp2=channels;
    char nick[10],tmp1[100];

    strcpy (nick,UserNick(p[0]));
    if (*p[2]=='#') {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[2]));
      if (!tmp2) return;
      tmp2->nops=0;
      sprintf (tmp1,"--No More Ops Mode Deactivated On %s",p[2]);
      HelpNotice (nick,tmp1);
    } else if (*p[2]!='#' && np>4 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      while ((tmp2=tmp2->next) && strcasecmp(tmp2->channel,p[4]));
      if (!tmp2) return;
      tmp2->nops=0;
      sprintf (tmp1,"--No More Ops Mode Deactivated On %s",p[4]);
      HelpNotice (nick,tmp1);
    }
  }
}

/*****************************************************************************/

void DoSay() {
  if (((np>5) && (DoAuth(p[0],0)->auth>=SAY)) && DoCkSecure()) {
    char tmp1[256];
    int i;

    strcpy (tmp1,p[5]);
    for (i=6;i<np;i++) sprintf (tmp1,"%s %s",tmp1,p[i]);
    ServerSay (p[4],tmp1);
  }
}

/*****************************************************************************/

void DoNotice() {
  if (((np>5) && (DoAuth(p[0],0)->auth>=NOTICE)) && DoCkSecure()) {
    char tmp1[256];
    int i;

    strcpy (tmp1,p[5]);
    for (i=6;i<np;i++) sprintf (tmp1,"%s %s",tmp1,p[i]);
    ServerNotice (p[4],tmp1);
  }
}

/*****************************************************************************/

void DoAction() {
  if (((np>4) && (DoAuth(p[0],0)->auth>=ACTION))  && DoCkSecure()){
    char tmp1[256];
    int i;

    sprintf (tmp1,"%cACTION",'\001');
    for (i=5;i<np;i++) sprintf (tmp1,"%s %s",tmp1,p[i]);
    sprintf (tmp1,"%s %c",tmp1,'\001');
    ServerSay (p[4],tmp1);
  }
}

/*****************************************************************************/

void DoJoin() {
  if (((np>4) && (DoAuth(p[0],p[4])->auth>=JOIN)) && DoCkSecure()) {
    int i;
    for (i=4;i<np;i++) {
      AddChannel (p[i],"+");
      ServerJoin (p[i]);
    }
  } else if (DoAuth(p[0],0)->auth>=JOIN) {
    ReJoin ();
  }
}

/*****************************************************************************/

void DoPart() {
  char tmp1[256];
  int i;

  if ((np>4 && DoAuth(p[0],p[4])->auth>=PART) && DoCkSecure()) {
    for (i=4;i<np;i++) {
      DelChannel (p[i]);
      ServerPart (p[i]);
      sprintf (tmp1,"***Leaving channel %s.",p[i]);
      HelpNotice (master,tmp1);
    }
  } else if ((*p[2]=='#' && DoAuth(p[0],p[2])->auth>=PART) && DoCkSecure()) {
    DelChannel (p[2]);
    ServerPart (p[2]);
    sprintf (tmp1,"***Leaving channel %s.",p[2]);
    HelpNotice (master,tmp1);
  }
}

/*****************************************************************************/

void DoCycle() {
  char tmp1[256];

  if ((np>4 && DoAuth(p[0],p[4])->auth>=PART) && DoCkSecure()) {
    FreeWho (p[4]);
    FreeBans (p[4]);
    ServerPart (p[4]);
    ServerJoin (p[4]);
    sprintf (tmp1,"-Cycling channel %s.",p[4]);
    HelpNotice (master,tmp1);
  } else if ((*p[2]=='#' && DoAuth(p[0],p[2])->auth>=PART) && DoCkSecure()) {
    FreeWho (p[2]);
    FreeBans (p[2]);
    ServerPart (p[2]);
    ServerJoin (p[2]);
    sprintf (tmp1,"-Cycling channel %s.",p[2]);
    HelpNotice (master,tmp1);
  }
}

/*****************************************************************************/

void DoInvite() {
  if ((np>4 && DoAuth(p[0],p[4])->auth>=INVITE) && DoCkSecure()) {
    char nick[10];

    strcpy (nick,UserNick(p[0]));
    ServerInvite (nick,p[4]);
  }
}

/*****************************************************************************/

void DoNick() {
  if (((np>4) && (DoAuth(p[0],0)->auth>=NICK)) && DoCkSecure()) {
    ServerNick (p[4]);
  }
}

/*****************************************************************************/

void DoMode() {
    chan *tmp1=channels;
    char mode[256];
    int i;
  if ((DoAuth(p[0],p[(*p[2]=='#')?2:4])->auth>=MODE) && DoCkSecure()) {

    if (*p[2]=='#' && np>4) {
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[2]));
      if (!tmp1) return;
      free (tmp1->mode);
      tmp1->mode=(char*)strdup(p[4]);
      ServerMode (p[2],p[4]);
    } else if (*p[2]!='#' && np>5 && DoAuth(p[0],p[4])->auth>=OKMSG) {
      while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[4]));
      if (!tmp1) return;
      free (tmp1->mode);
      tmp1->mode=(char*)strdup(p[5]);
      ServerMode (p[4],p[5]);
    }
  }
}

/*****************************************************************************/

void DoProtect() {
  int i;
  if ((*p[2]=='#' && np>4 && DoAuth(p[0],p[2])->auth>=PROTECT) && DoCkSecure()) {
    for (i=4;i<np;i++) {
      if (!strchr(p[i],'*') && !strchr(p[i],'?'))
	DoWhois (p[i],p[2],AddProtect);
    }
  } else if ((*p[2]!='#' && np>5 && DoAuth(p[0],p[4])->auth>=PROTECT) && DoCkSecure()) {
    for (i=5;i<np;i++) {
      if (!strchr(p[i],'*') && !strchr(p[i],'?'))
	DoWhois (p[i],p[4],AddProtect);
    }
  }
}

/*****************************************************************************/

void DoShowProtect() {
  int i;
  char nick[10];
  chan *tmp1=channels;

  strcpy (nick,UserNick(p[0]));

  if ((*p[2]=='#' && np<=4 && DoAuth(p[0],p[2])->auth>=PROTECT) && DoCkSecure()) {
    while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[2]));
    if (tmp1) {
      prot *tmp2=tmp1->protect;
      while (tmp2=tmp2->next) {
	char tmp3[256];
	sprintf (tmp3,"- %s: %s",tmp1->channel,tmp2->name);
	HelpNotice (nick,tmp3);
      }
      HelpNotice (nick,"End of Protetion List");
    }
  } else if ((np>4 && DoAuth(p[0],p[4])->auth>=PROTECT) && DoCkSecure()) {
    while ((tmp1=tmp1->next) && strcasecmp(tmp1->channel,p[4]));
    if (tmp1) {
      prot *tmp2=tmp1->protect;
      while (tmp2=tmp2->next) {
	char tmp3[256];
	sprintf (tmp3,"- %s: %s",tmp1->channel,tmp2->name);
	HelpNotice (nick,tmp3);
      }
      HelpNotice (nick,"-End of List.");
    }
  }
}

/*****************************************************************************/

void DoServer() {
    chan *tmp1=channels;
  if ((np>4 && DoAuth(p[0],0)->auth>=SERVER) && DoCkSecure()) {

    while (tmp1=tmp1->next) {
      FreeBans (tmp1->channel);
      FreeWho (tmp1->channel);
    }
    ServerQuit ("Switching Servers...");
    sleep (2);
    CloseSocket();
    if (CallSocket(p[4])>0)
      strcpy(server,p[4]);
    else
      CallSocket(server);
    ServerUser (username,hostname,server,IRCNAME);
    ServerNick (mynick);
    ReJoin ();
  }
}

/*****************************************************************************/

void DoAcc() {
  char ttmp[256];
  if(np <= 4) strcpy(ttmp,UserNick(p[0]));
  else strcpy(ttmp,p[4]);
  if (((DoAuth(p[0],0)->auth>=ACCESS) || (!strcasecmp(UserNick(p[0]),ttmp)))  && DoCkSecure()){
      strcpy(by,p[0]);
      DoWhois(ttmp,p[2],ToAcc);
  }
}
/*****************************************************************************/

void DoAdd() {
  if(DoAuth(p[0],0)->auth>=ADD) {
      strcpy(by,p[0]);
      if(np >= 6) sscanf(p[5],"%d",&lev);
      DoWhois(p[4],p[2],ToAdd);
  }
}

/*****************************************************************************/
 
void DoAKB() {
  if ((DoAuth(p[0],0)->auth>=ADD) && DoCkSecure()) {
      strcpy(by,p[0]);
      DoWhois(p[4],p[2],ToKB);
  }
}

/*****************************************************************************/

void DoRM() {
  if(DoAuth(p[0],0)->auth>=ADD) {
      strcpy(by,p[0]);
      DoWhois(p[4],p[2],ToRM);
  }
}

/*****************************************************************************/

void DoRehash() {
  if (DoAuth(p[0],0)->auth>=REHASH) {
    char nick[10];
    strcpy(nick,UserNick(p[0]));
    HelpNotice (nick,"-Rehashing Users File.");
    FreeUsers(users);
    LoadUsers(USERSFILE);
  }
}

/*****************************************************************************/

void DoDie() {
    char tmp1[256];
      int i;
  if ((DoAuth(p[0],0)->auth>=DIE) && DoCkSecure()) {
    if (np>4) {
      strcpy (tmp1,p[4]);
      for (i=5;i<np;i++) sprintf (tmp1,"%s %s",tmp1,p[i]);
    } else strcpy (tmp1,IRCQUIT);
    ServerQuit (tmp1);
    sleep (5);
    CloseSocket ();
    exit (0);
  }
}

/*****************************************************************************/

void DoMaster() {
  if (np>4 && DoAuth(p[0],0)->auth>=MASTER) strcpy(master,p[4]);
}

/*****************************************************************************/

void DoWhois (char *nick,char *dhan,void (*fonc)(char*)) {
  wis *tmp1=(wis*)malloc(sizeof(wis));

  ServerWhois (nick);
  tmp1->nick=(char*)strdup(nick);
  tmp1->chan=(char*)strdup(dhan);
  tmp1->fonc=fonc;
  tmp1->next=wislist->next;
  wislist->next=tmp1;
}

/*****************************************************************************/

void DoWhoWas (char *nick,char *dhan,void (*fonc)(char*)) {
  wis *tmp1=(wis*)malloc(sizeof(wis));

  ServerWhoWas (nick);
  tmp1->nick=(char*)strdup(nick);
  tmp1->chan=(char*)strdup(dhan);
  tmp1->fonc=fonc;
  tmp1->next=wwslist->next;
  wwslist->next=tmp1;
}

/*****************************************************************************/

void DoDebug() {
  chan *tmp1=channels;
  while (tmp1=tmp1->next) {
    char tmp2[256];
    sprintf (tmp2,"  Channel : %s  ; Users : %d",
	     tmp1->channel,tmp1->who->isop);
    HelpNotice (master,tmp2);
  }
}

/*****************************************************************************/
