/*****************************************************************************/
/***                          Service de Notes                             ***/
/*****************************************************************************/

#include <stdio.h>
#include <time.h>
#include "robot.h"
#include "notes.h"

/*****************************************************************************/

extern note *notes;
extern char *p[1024];
extern int np;

/*****************************************************************************/

void NoteTo (char *name) {
  note *tmp2,*tmp1=notes;

  while (tmp1=(tmp2=tmp1)->next) {
    if (Rmatch(tmp1->to,name)) {
      char mess[512],nick[20];
      strcpy (nick,UserNick(name));
      sprintf (mess,"Note from [%s] [%s] : %s",
	       tmp1->from,tmp1->date,tmp1->msg);
      mess[255]='\0';
      ServerNotice (nick,mess);
      tmp2->next=tmp1->next;
      free (tmp1->to);
      free (tmp1->from);
      free (tmp1->msg);
      free (tmp1);
      tmp1=tmp2;
    }
  }
  SaveNotes();
}

/*****************************************************************************/

void AddNote (char *to,char *from,char *msg) {
  note *tmp1=notes;
  char dow[4],mon[4],dom[3],tim[9],yea[5];
  time_t heure;

  while (tmp1->next) tmp1=tmp1->next;
  heure=time(NULL);
  sscanf (ctime(&heure),"%s%s%s%s%s",dow,mon,dom,tim,yea);
  tmp1=tmp1->next=(note*)malloc(sizeof(note));
  tmp1->to=(char*)strdup(to);
  tmp1->from=(char*)strdup(from);
  sprintf (tmp1->date,"%s %s %s",dom,mon,tim);
  tmp1->msg=(char*)strdup(msg);
  tmp1->next=(note*)NULL;
  SaveNotes();
}

/*****************************************************************************/

void DoNote() {
  if (np>6 && !strcasecmp(p[4],"SEND")) {
    char tmp1[512],to[100],from[20],nick[20],login[20],domain[60],name[100];
    int i;

    strcpy (nick,UserNick(p[0]));
    strcpy (login,UserLogin(p[0]));
    strcpy (domain,UserDomain(p[0]));
    sprintf (name,"%s!%s@%s",nick,login,domain);
    strcpy (tmp1,p[6]);
    for (i=7;i<np;i++) sprintf (tmp1,"%s %s",tmp1,p[i]);
    if (!strchr(p[5],'!'))
      if (!strchr(p[5],'@')) sprintf (to,"%s!*@*",p[5]);
      else sprintf (to,"*!%s",p[5]);
    else if (!strchr(p[5],'@')) sprintf (to,"%s@*",p[5]);
    else strcpy (to,p[5]);
    AddNote (to,name,tmp1);
    sprintf (tmp1,"Note for %s added to Notes list.",to);
    strcpy (from,UserNick(p[0]));
    ServerNotice (from,tmp1);
  }
  else if (np>4 && !strcasecmp(p[4],"READ"))
    NoteTo (p[0]);
}

/*****************************************************************************/

void LoadNotes() {
  note *tmp1=notes;
  char to[80],from[80],date[17],msg[256];
  FILE *fichier=fopen(NOTESFILE,"r");

  if (!fichier) {
    fprintf(stderr,"***  Error : Cannot open %s\n",NOTESFILE);
    exit(1);
  }

  while (fscanf(fichier,"%s%s\n%[^\n]\n%[^\n]\n",to,from,date,msg)>0) {
    tmp1=tmp1->next=(note*)malloc(sizeof(note));
    tmp1->to=(char*)strdup(to);
    tmp1->from=(char*)strdup(from);
    strcpy (tmp1->date,date);
    tmp1->msg=(char*)strdup(msg);
    tmp1->next=(note*)NULL;
  }
  fclose (fichier);
}

/*****************************************************************************/

void SaveNotes() {
  note *tmp1=notes;
  FILE *fichier=fopen(NOTESFILE,"w");

  if (!fichier) {
    fprintf(stderr,"***  Error : Cannot open %s\n",NOTESFILE);
    exit(1);
  }

  while (tmp1=tmp1->next)
    fprintf (fichier,"%s\n%s\n%s\n%s\n",
	     tmp1->to,tmp1->from,tmp1->date,tmp1->msg);

  fclose (fichier);
}

/*****************************************************************************/
