#include <stdio.h>
#include <time.h>
#include "robot.h"
#include "server.h"
#include "actions.h"
#include "commandes.h"
#include "users.h"
#include "channels.h"
#include "notes.h"

int  sockfd;
int  helpfd;
user *users;
chan *channels;
wis  *wislist,*wwslist;
note *notes;
char server[256];
char username[20];
char hostname[80];
char mynick[10];
char myname[256];
char master[10];
char by[256];
char LastKicked[256];
char *p[1024];
int  np;
FILE *log;
char tmp[1024];
user *CurrUsr;
char lastkick[256];
char lastflood[256];
int secure = 0; 
char securedby[256];

/*****************************************************************************/
/***                      Decoupe le message en mots                       ***/
/*****************************************************************************/

void BrkMsg()
{
  char *q1,*q2;
  int fin=1;

  np=0;
  q1=tmp;
  do {
    q2 = ++q1;
    while(*q1 && *q1!=' ' && *q1!='\n' && *q1!='\r') q1++;
    if(!*q1 || *q1=='\n' || *q1=='\r') fin=0;
    *q1='\0';
    p[np++]=(char*)strdup(q2);
  } while (fin);
}


/*****************************************************************************/
/***                     Libere la place des msg                           ***/
/*****************************************************************************/

void FreeMsg()
{
  int i;
  for(i=0;i<np;i++) {
    free(p[i]);
    p[i]=NULL;
  }
/*  free(message); */
}


/*****************************************************************************/
/***                    Comparaison de chaine et RE                        ***/
/*****************************************************************************/

int Rmatch (char* pattern,char* string) {
  int ret=0;
  char *tmp1,tmp2[256];

  tmp1=(char*)strcpy(tmp2,string);
  while(*tmp1++=toupper(*tmp1));
  tmp1=tmp2;
  while (*pattern||*tmp1)  {
    if (*pattern=='*') {
      while ((*++pattern=='*') || (*pattern=='?'))
        if (*pattern=='?') tmp1++;
      if (!*pattern) return (1);
      while (tmp1=(char*)index(tmp1,toupper(*pattern))) {
        ret+=Rmatch(pattern+1,tmp1+1);
        tmp1++;
      }
      return (ret);
    } else if ((*pattern=='?') || (toupper(*pattern)==*tmp1)) {
      pattern++; tmp1++;
    } else return 0;
  }
  if (*pattern||*tmp1) return (0); else return (1);
}

/*****************************************************************************/
/***                        Initialisations                                ***/
/*****************************************************************************/

void Init () {
  channels=(chan*)malloc(sizeof(chan));
  channels->channel=(char*)strdup("");
  channels->mode=(char*)strdup("-iws");
  channels->nops=0;
  channels->who=(who*)malloc(sizeof(who));
  channels->who->nick=(char*)strdup("");
  channels->who->login=(char*)strdup("");
  channels->who->host=(char*)strdup("");
  channels->who->next=(who*)NULL;
  channels->bans=(ban*)malloc(sizeof(ban));
  channels->bans->pattern=(char*)strdup("");
  channels->bans->next=(ban*)NULL;
  channels->protect=(prot*)malloc(sizeof(prot));
  channels->protect->name=(char*)strdup("");
  channels->protect->pattern=(char*)strdup("");
  channels->protect->next=(prot*)NULL;
  channels->next=(chan*)NULL;

  wislist=(wis*)malloc(sizeof(wis));
  wislist->nick=(char*)strdup("");
  wislist->chan=(char*)strdup("");
  wislist->fonc=(void*)NULL;
  wislist->next=(wis*)NULL;

  wwslist=(wis*)malloc(sizeof(wis));
  wwslist->nick=(char*)strdup("");
  wwslist->chan=(char*)strdup("");
  wwslist->fonc=(void*)NULL;
  wwslist->next=(wis*)NULL;

  users=(user*)malloc(sizeof(user));
  users->pattern=(char*)strdup("");
  users->auth=0;
  users->next=(user*)NULL;

  notes=(note*)malloc(sizeof(note));
  notes->to=(char*)strdup("");
  notes->from=(char*)strdup("");
  notes->msg=(char*)strdup("");
  notes->next=(note*)NULL;

  strcpy (master,IRCMASTER);

  LoadUsers();
  LoadNotes();
  LoadChannels();
}

/*****************************************************************************/
/***                          Boucle Principale                            ***/
/*****************************************************************************/

void main (int argc, char **argv) {
  int sok;
  int retry;

  gethostname (hostname,60);
  /*strcat (hostname,".york.cuny.edu");*/

  if (argc>1) strcpy(mynick,argv[1]);
  else strcpy(mynick,IRCNICK);

  if (argc>2) strcpy(server,argv[2]);
  else strcpy(server,IRCSERVER);

  if (argc>3) strcpy(username,argv[3]);
  else strcpy(username,IRCUSER);

  sprintf(myname,"%s!%s@%s",mynick,username,hostname);
  strcpy(securedby,myname);
  strcpy(LastKicked,"Noone.");

  Init();
  retry = 0;
  for (;;) {
    if (((sockfd=CallSocket(server))==-1)) {
      if(retry > 25) {
         printf ("###  Unable to connect to %s.\n",server);
         exit (1);
      }
      else {
        retry++;
        sleep(15);
      }
    }

    ServerUser (username,IRCSERVER,hostname,IRCNAME);
    ServerNick (mynick);

    ReJoin ();

    while (GetServer (tmp)) {
      if (!strncmp(tmp,"PING ",5)) Pong();
      fflush (stdout);
      BrkMsg ();
      Analyse ();
      FreeMsg();
    }

    {
      chan *tmp1=channels;
      while (tmp1=tmp1->next) {
	FreeBans (tmp1->channel);
	FreeWho (tmp1->channel);
      }
    }

    CloseSocket();
    sleep (2);
  }
}

/*****************************************************************************/
