/*****************************************************************************/
/***          server.c : Fonctions de gestion du serveur                   ***/
/*****************************************************************************/

#include <stdio.h>
#include <netdb.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "server.h"
#include "robot.h"

extern int sockfd;
extern int helpfd;

/*****************************************************************************/
/***                       Ouverture de la Socket                          ***/
/*****************************************************************************/

int CallSocket (char *server) {
  struct sockaddr_in sa;
  struct hostent *hp;
  int a,s;

  if ((hp=(struct hostent*)gethostbyname(server))==NULL) return (-1);
  bzero (&sa,sizeof(sa));
  bcopy (hp->h_addr, &sa.sin_addr, hp->h_length);
  sa.sin_family = hp->h_addrtype;
  sa.sin_port = htons(IRCPORT);
  if((s=socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0) return(-1);
  if(connect(s, &sa, sizeof(sa)) < 0) {
    close(s);
    return(-1);
  }
  return(s);
}

/*****************************************************************************/
/***                   Fermeture de la Socket                              ***/
/*****************************************************************************/

void CloseSocket() {
  close (sockfd);
}

/*****************************************************************************/
/***                  Lecture de la Socket                                 ***/
/*****************************************************************************/

int GetServer (char *tmp) {
  int i;
  while ((i=read(sockfd,tmp,1)>0) && (*tmp++!='\n'));
  *tmp=0;
  return (i);
}

/*****************************************************************************/
/***                  Ecriture sur la Socket                               ***/
/*****************************************************************************/

void PutServer (char *tmp) {
  fflush (stdout);
  write (sockfd,tmp,strlen(tmp));
}

/*****************************************************************************/

void ServerUser (char *user, char *host, char *server, char *name) {
  char tmp[256];

  sprintf (tmp,"USER %s %s %s :%s\n",user,host,server,name);
  PutServer (tmp);
  sprintf (tmp,"USER %s +sw . :%s\n",user,name);
  PutServer(tmp);
}

/*****************************************************************************/

void ServerQuit (char *message) {
  char tmp[256];

  sprintf (tmp,"QUIT :%s\n",message);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerNick (char *nick) {
  char tmp[256];

  sprintf (tmp,"NICK %s\n",nick);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerJoin (char *channel) {
  char tmp[256];

  sprintf (tmp,"JOIN %s\n",channel);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerPart (char *channel) {
  char tmp[256];

  sprintf (tmp,"PART %s\n",channel);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerKick (char *channel,char *nick,char *reason) {
  char tmp[256];

  sprintf (tmp,"KICK %s %s :%s\n",channel,nick,reason);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerSay (char *channel,char *message) {
  char tmp[512];

  sprintf (tmp,"PRIVMSG %s :%s\n",channel,message);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerNotice (char *channel,char *message) {
  char tmp[512];

  sprintf (tmp,"NOTICE %s :%s\n",channel,message);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerMode (char *channel,char *mode) {
  char tmp[256];

  sprintf (tmp,"MODE %s %s\n",channel,mode);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerTopic (char *channel,char *topic) {
  char tmp[256];

  sprintf (tmp,"TOPIC %s :%s\n",channel,topic);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerWho (char *channel) {
  char tmp[256];

  sprintf (tmp,"WHO %s\n",channel);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerWhois (char *nick) {
  char tmp[256];

  sprintf (tmp,"WHOIS %s\n",nick);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerWhoWas (char *nick) {
  char tmp[256];

  sprintf (tmp,"WHOWAS %s\n",nick);
  PutServer (tmp);
}

/*****************************************************************************/

void ServerInvite (char *nick,char *channel) {
  char tmp[256];

  sprintf (tmp,"INVITE %s %s\n",nick,channel);
  PutServer (tmp);
}

/*****************************************************************************/
/*****************************************************************************/

void HelpUser (char *user, char *host, char *server, char *name) {
  char tmp[256];

  sprintf (tmp,"USER %s %s %s :%s\n",user,host,server,name);
  PutHelp (tmp);
}

/*****************************************************************************/

void HelpNick (char *nick) {
  char tmp[256];

  sprintf (tmp,"NICK %s\n",nick);
  PutHelp (tmp);
}

/*****************************************************************************/

void HelpNotice (char *channel,char *message) {
  char tmp[512];

  sprintf (tmp,"NOTICE %s :%s\n",channel,message);
  PutHelp (tmp);
}

/*****************************************************************************/

void PutHelp (char *tmp) {
  fflush (stdout);
  write (sockfd,tmp,strlen(tmp));
}

/*****************************************************************************/
